/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.tool;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DLightConfigurationManager {
    private static DLightConfigurationManager instance = null;
    private String selectedConfigurationName = null;

    private DLightConfigurationManager() {
    }

    private final FileObject getToolsFSRoot() {
        FileObject fileObject = FileUtil.getConfigRoot();
        return fileObject.getFileObject(this.getToolsFSRootPath());
    }

    private final String getToolsFSRootPath() {
        return "DLight/Configurations";
    }

    void selectConfiguration(String string) {
        this.selectedConfigurationName = string;
    }

    public DLightConfiguration getConfigurationByName(String string) {
        List<DLightConfiguration> list = this.getDLightConfigurations();
        for (DLightConfiguration dLightConfiguration : list) {
            if (!dLightConfiguration.getConfigurationName().equals(string)) continue;
            return dLightConfiguration;
        }
        return null;
    }

    List<DLightConfiguration> getDLightConfigurations() {
        ArrayList<DLightConfiguration> arrayList = new ArrayList<DLightConfiguration>();
        FileObject fileObject = this.getToolsFSRoot();
        if (fileObject == null) {
            return arrayList;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        if (fileObjectArray == null || fileObjectArray.length == 0) {
            return arrayList;
        }
        for (FileObject fileObject2 : fileObjectArray) {
            arrayList.add(DLightConfiguration.create(fileObject2));
        }
        return arrayList;
    }

    DLightConfiguration getSelectedDLightConfiguration() {
        if (this.selectedConfigurationName != null) {
            return this.getConfigurationByName(this.selectedConfigurationName);
        }
        List<DLightConfiguration> list = this.getDLightConfigurations();
        if (list == null || list.size() == 0) {
            return DLightConfiguration.createDefault();
        }
        return list.get(0);
    }

    public static final synchronized DLightConfigurationManager getInstance() {
        if (instance == null) {
            instance = new DLightConfigurationManager();
        }
        return instance;
    }
}

