/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.tool;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationOptions;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.api.tool.ToolsConfiguration;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DLightConfiguration {
    private static final String CONFIGURATION_OPTIONS = "ConfigurationOptions";
    private final FileObject rootFolder;
    private final ToolsConfiguration toolsConfiguration;
    private final DLightConfigurationOptions configurationOptions;

    static DLightConfiguration create(FileObject fileObject) {
        return new DLightConfiguration(fileObject);
    }

    static DLightConfiguration createDefault() {
        FileObject fileObject = FileUtil.getConfigRoot();
        FileObject fileObject2 = fileObject.getFileObject("DLight/ToolConfigurationProviders");
        return new DLightConfiguration(fileObject.getFileObject("DLight"), ToolsConfiguration.createDefault(fileObject2));
    }

    private DLightConfiguration(FileObject fileObject) {
        this(fileObject, ToolsConfiguration.create(fileObject));
    }

    private DLightConfiguration(FileObject fileObject, ToolsConfiguration toolsConfiguration) {
        this.toolsConfiguration = toolsConfiguration;
        this.rootFolder = fileObject;
        this.configurationOptions = this.getConfigurationOptions();
    }

    public List<DLightTool> getToolsSet() {
        return this.toolsConfiguration.getToolsSet();
    }

    public List<Indicator> getIndicators() {
        ArrayList<Indicator> arrayList = new ArrayList<Indicator>();
        List<DLightTool> list = this.getToolsSet();
        for (DLightTool dLightTool : list) {
            arrayList.addAll(dLightTool.getIndicators());
        }
        return arrayList;
    }

    public DLightTool getToolByName(String string) {
        if (string == null) {
            return null;
        }
        List<DLightTool> list = this.toolsConfiguration.getToolsSet();
        for (DLightTool dLightTool : list) {
            if (!string.equals(dLightTool.getName())) continue;
            return dLightTool;
        }
        return null;
    }

    public DLightConfigurationOptions getConfigurationOptions(boolean bl) {
        if (bl) {
            this.getConfigurationOptions();
        }
        return this.configurationOptions;
    }

    private DLightConfigurationOptions getConfigurationOptions() {
        FileObject fileObject = this.rootFolder.getFileObject(CONFIGURATION_OPTIONS);
        if (fileObject == null) {
            return new DefaultConfigurationOption();
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        if (fileObjectArray == null || fileObjectArray.length == 0) {
            return new DefaultConfigurationOption();
        }
        for (FileObject fileObject2 : fileObjectArray) {
            Object object;
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fileObject2);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Logger.getLogger(ToolsConfiguration.class.getName()).log(Level.SEVERE, null, dataObjectNotFoundException);
            }
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            if (instanceCookie == null) {
                object = "D-Light options configuration " + fileObject2.getName() + " not found";
                Logger.getLogger(ToolsConfiguration.class.getName()).log(Level.SEVERE, (String)object, new Exception((String)object));
                continue;
            }
            try {
                object = instanceCookie.instanceClass();
                DLightConfigurationOptions dLightConfigurationOptions = (DLightConfigurationOptions)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
                return dLightConfigurationOptions;
            }
            catch (InstantiationException instantiationException) {
                Exceptions.printStackTrace((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Exceptions.printStackTrace((Throwable)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Exceptions.printStackTrace((Throwable)noSuchMethodException);
            }
            catch (SecurityException securityException) {
                Exceptions.printStackTrace((Throwable)securityException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
            }
        }
        return null;
    }

    public String getConfigurationName() {
        return this.rootFolder.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultConfigurationOption
    implements DLightConfigurationOptions {
        private boolean turnState = false;

        private DefaultConfigurationOption() {
        }

        @Override
        public void turnCollectorsState(boolean bl) {
            this.turnState = bl;
        }

        @Override
        public boolean areCollectorsTurnedOn() {
            return this.turnState;
        }

        public List<DLightTool> getToolsSet() {
            return DLightConfiguration.this.toolsConfiguration.getToolsSet();
        }

        @Override
        public List<DataCollector<?>> getCollectors(DLightTool dLightTool) {
            return dLightTool.getCollectors();
        }

        @Override
        public List<IndicatorDataProvider<?>> getIndicatorDataProviders(DLightTool dLightTool) {
            return dLightTool.getIndicatorDataProviders();
        }

        @Override
        public boolean validateToolsRequiredUserInteraction() {
            return false;
        }

        @Override
        public boolean profileOnRun() {
            return false;
        }

        @Override
        public Collection<String> getActiveToolNames() {
            return null;
        }
    }
}

