/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.indicator;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.dlight.api.impl.IndicatorConfigurationAccessor;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndicatorConfiguration {
    private IndicatorMetadata metadata;
    private final int position;
    private final List<VisualizerConfiguration> visualizerConfigurations;

    public IndicatorConfiguration(IndicatorMetadata indicatorMetadata, int n) {
        this.metadata = indicatorMetadata;
        this.position = n;
        this.visualizerConfigurations = new ArrayList<VisualizerConfiguration>();
    }

    public IndicatorConfiguration(IndicatorMetadata indicatorMetadata) {
        this(indicatorMetadata, 0);
    }

    public abstract String getID();

    public final void addVisualizerConfiguration(VisualizerConfiguration visualizerConfiguration) {
        if (visualizerConfiguration != null && !this.visualizerConfigurations.contains(visualizerConfiguration)) {
            this.visualizerConfigurations.add(visualizerConfiguration);
        }
    }

    protected final IndicatorMetadata getIndicatorMetadata() {
        return this.metadata;
    }

    protected final int getIndicatorPosition() {
        return this.position;
    }

    protected final List<VisualizerConfiguration> getVisualizerConfigurations() {
        return this.visualizerConfigurations;
    }

    static {
        IndicatorConfigurationAccessor.setDefault(new IndicatorConfigurationAccessorImpl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IndicatorConfigurationAccessorImpl
    extends IndicatorConfigurationAccessor {
        private IndicatorConfigurationAccessorImpl() {
        }

        @Override
        public IndicatorMetadata getIndicatorMetadata(IndicatorConfiguration indicatorConfiguration) {
            return indicatorConfiguration.getIndicatorMetadata();
        }

        @Override
        public int getIndicatorPosition(IndicatorConfiguration indicatorConfiguration) {
            return indicatorConfiguration.getIndicatorPosition();
        }

        @Override
        public List<VisualizerConfiguration> getVisualizerConfigurations(IndicatorConfiguration indicatorConfiguration) {
            return indicatorConfiguration.getVisualizerConfigurations();
        }
    }
}

