/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.execution;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.netbeans.modules.dlight.api.execution.DLightSessionContext;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.impl.DLightSessionHandlerAccessor;
import org.netbeans.modules.dlight.api.impl.DLightSessionInternalReference;
import org.netbeans.modules.dlight.api.impl.DLightToolkitManager;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DLightToolkitManagement {
    private static DLightToolkitManagement instance;
    private static DLightToolkitManager toolkitManager;

    private DLightToolkitManagement() {
        Collection collection = Lookup.getDefault().lookupAll(DLightToolkitManager.class);
        toolkitManager = (DLightToolkitManager)Lookup.getDefault().lookup(DLightToolkitManager.class);
    }

    public static final DLightToolkitManagement getInstance() {
        if (instance == null) {
            instance = new DLightToolkitManagement();
        }
        return instance;
    }

    public Future<DLightSessionHandler> createSession(DLightTarget dLightTarget, String string) {
        return this.createSession(dLightTarget, string, null);
    }

    public Future<DLightSessionHandler> createSession(final DLightTarget dLightTarget, final String string, final String string2) {
        return DLightExecutorService.submit((Callable)new Callable<DLightSessionHandler>(){

            @Override
            public DLightSessionHandler call() throws Exception {
                return toolkitManager.createSession(dLightTarget, string, string2);
            }
        }, (String)("DLight [" + string + "] Session Creation for " + dLightTarget));
    }

    public Future<DLightSessionHandler> createSession(DLightTarget dLightTarget, DLightConfiguration dLightConfiguration) {
        return this.createSession(dLightTarget, dLightConfiguration, null);
    }

    public Future<DLightSessionHandler> createSession(final DLightTarget dLightTarget, final DLightConfiguration dLightConfiguration, final String string) {
        return DLightExecutorService.submit((Callable)new Callable<DLightSessionHandler>(){

            @Override
            public DLightSessionHandler call() throws Exception {
                return toolkitManager.createSession(dLightTarget, dLightConfiguration, string);
            }
        }, (String)("DLight [" + dLightConfiguration.getConfigurationName() + "] Session Creation for " + dLightTarget));
    }

    public void startSession(DLightSessionHandler dLightSessionHandler) {
        toolkitManager.startSession(dLightSessionHandler);
    }

    public void stopSession(DLightSessionHandler dLightSessionHandler) {
        toolkitManager.stopSession(dLightSessionHandler);
    }

    private DLightSessionHandler create(DLightSessionInternalReference dLightSessionInternalReference) {
        return new DLightSessionHandler(dLightSessionInternalReference);
    }

    static {
        DLightSessionHandlerAccessor.setDefault(new DLightSessionHandlerAccessorImpl());
        instance = null;
    }

    private static final class DLightSessionHandlerAccessorImpl
    extends DLightSessionHandlerAccessor {
        private DLightSessionHandlerAccessorImpl() {
        }

        public DLightSessionHandler create(DLightSessionInternalReference dLightSessionInternalReference) {
            return DLightToolkitManagement.getInstance().create(dLightSessionInternalReference);
        }

        public DLightSessionInternalReference getSessionReferenceImpl(DLightSessionHandler dLightSessionHandler) {
            return dLightSessionHandler.getSessionReferenceImpl();
        }
    }

    public final class DLightSessionHandler {
        private DLightSessionInternalReference ref;

        private DLightSessionHandler(DLightSessionInternalReference dLightSessionInternalReference) {
            this.ref = dLightSessionInternalReference;
        }

        public DLightSessionContext getSessionContext() {
            return this.ref.getSessionContext();
        }

        DLightSessionInternalReference getSessionReferenceImpl() {
            return this.ref;
        }
    }
}

