/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.modules.options.keymap.ActionHolder;
import org.netbeans.modules.options.keymap.KeymapPanel;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.ShortcutCell;
import org.netbeans.modules.options.keymap.ShortcutTextField;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonCellEditor
extends DefaultCellEditor {
    private Object action;
    private KeymapViewModel model;
    private String orig;
    private KeyAdapter escapeAdapter = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                JTable jTable = (JTable)ButtonCellEditor.this.cell.getParent();
                jTable.getCellEditor().cancelCellEditing();
                KeymapPanel.getModel().update();
            }
        }
    };
    private ShortcutCell cell = new ShortcutCell();

    public ButtonCellEditor(KeymapViewModel keymapViewModel) {
        super(new ShortcutTextField());
        this.model = keymapViewModel;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    private void removeConflictingShortcut(ShortcutAction shortcutAction, String string) {
        if (string.contains(" ")) {
            string = string.substring(0, string.indexOf(32));
        }
        String[] stringArray = this.model.getShortcuts(shortcutAction);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            this.model.removeShortcut(shortcutAction, stringArray[i]);
        }
    }

    @Override
    public boolean stopCellEditing() {
        String string = this.cell.toString();
        ShortcutAction shortcutAction = (ShortcutAction)this.action;
        Set<ShortcutAction> set = this.model.findActionForShortcutPrefix(string);
        set.remove(shortcutAction);
        if (!set.isEmpty()) {
            Object object = this.overrride(set);
            if (object.equals(DialogDescriptor.YES_OPTION)) {
                for (ShortcutAction shortcutAction2 : set) {
                    this.removeConflictingShortcut(shortcutAction2, string);
                }
                this.getComponent().requestFocus();
            } else {
                if (object.equals(DialogDescriptor.NO_OPTION)) {
                    JComponent jComponent = (JComponent)this.getComponent();
                    jComponent.setBorder(new LineBorder(Color.red));
                    jComponent.requestFocus();
                    return false;
                }
                this.cell.getTextField().setText(this.orig);
                this.fireEditingCanceled();
                this.setBorderEmpty();
                return true;
            }
        }
        this.model.removeShortcut((ShortcutAction)this.action, this.orig);
        if (string.length() != 0) {
            this.model.addShortcut((ShortcutAction)this.action, string);
        }
        this.fireEditingStopped();
        this.setBorderEmpty();
        this.model.update();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.cell.getTextField().setText(this.orig);
        this.fireEditingCanceled();
        this.setBorderEmpty();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.cell = (ShortcutCell)object;
        this.orig = this.cell.toString();
        this.action = ((ActionHolder)jTable.getValueAt(n, 0)).getAction();
        JTextField jTextField = this.cell.getTextField();
        jTextField.addActionListener(this.delegate);
        jTextField.setBorder(new LineBorder(Color.BLACK));
        if (!Arrays.asList(jTextField.getKeyListeners()).contains(this.escapeAdapter)) {
            jTextField.addKeyListener(this.escapeAdapter);
        }
        return this.cell;
    }

    @Override
    public Object getCellEditorValue() {
        return this.cell;
    }

    @Override
    public Component getComponent() {
        return this.cell.getTextField();
    }

    private Object overrride(Set<ShortcutAction> set) {
        ShortcutAction shortcutAction2;
        StringBuffer stringBuffer = new StringBuffer();
        for (ShortcutAction shortcutAction2 : set) {
            stringBuffer.append(" '" + shortcutAction2.getDisplayName() + "'<br>");
        }
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(NbBundle.getMessage(ButtonCellEditor.class, (String)"Override_Shortcut", (Object)stringBuffer)));
        shortcutAction2 = new DialogDescriptor((Object)jPanel, NbBundle.getMessage(ButtonCellEditor.class, (String)"Conflicting_Shortcut_Dialog"), true, 1, null, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)shortcutAction2);
        return shortcutAction2.getValue();
    }

    private void setBorderEmpty() {
        ((JComponent)this.getComponent()).setBorder(new EmptyBorder(0, 0, 0, 0));
    }
}

