/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.text.MessageFormat;
import java.util.List;
import javax.swing.Icon;
import org.netbeans.lib.profiler.heap.ArrayItemValue;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.lib.profiler.heap.Value;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.ArrayNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.ClassNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.ObjectArrayFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.ObjectArrayNode;
import org.netbeans.modules.profiler.heapwalk.model.ObjectFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.ObjectNode;
import org.netbeans.modules.profiler.heapwalk.model.PrimitiveArrayFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.PrimitiveArrayNode;
import org.netbeans.modules.profiler.heapwalk.model.PrimitiveFieldNode;
import org.netbeans.modules.profiler.ui.Utils;
import org.openide.util.NbBundle;

public class HeapWalkerNodeFactory {
    private static final String NONE_STRING = NbBundle.getMessage(HeapWalkerNodeFactory.class, (String)"HeapWalkerNodeFactory_NoneString");
    private static final String NO_FIELDS_STRING = NbBundle.getMessage(HeapWalkerNodeFactory.class, (String)"HeapWalkerNodeFactory_NoFieldsString");
    private static final String NO_REFERENCES_STRING = NbBundle.getMessage(HeapWalkerNodeFactory.class, (String)"HeapWalkerNodeFactory_NoReferencesString");
    private static final String NO_ITEMS_STRING = NbBundle.getMessage(HeapWalkerNodeFactory.class, (String)"HeapWalkerNodeFactory_NoItemsString");
    private static final String SEARCHING_STRING = NbBundle.getMessage(HeapWalkerNodeFactory.class, (String)"HeapWalkerNodeFactory_SearchingString");
    private static final String OUT_OF_MEMORY_STRING = NbBundle.getMessage(HeapWalkerNodeFactory.class, (String)"HeapWalkerNodeFactory_OutOfMemoryString");
    private static final String ARRAY_CONTAINER_NAME_STRING = NbBundle.getMessage(HeapWalkerNodeFactory.class, (String)"HeapWalkerNodeFactory_ArrayContainerNameString");
    private static final String ARRAY_CONTAINER_VALUE_STRING = NbBundle.getMessage(HeapWalkerNodeFactory.class, (String)"HeapWalkerNodeFactory_ArrayContainerValueString");
    public static int ITEMS_COLLAPSE_UNIT_SIZE = 500;
    public static int ITEMS_COLLAPSE_THRESHOLD = 2000;
    public static int ITEMS_COLLAPSE_UNIT_THRESHOLD = 5000;

    public static HeapWalkerNode createArrayItemContainerNode(final ArrayNode arrayNode, final int n, final int n2) {
        return new AbstractHeapWalkerNode(arrayNode){

            protected String computeName() {
                return MessageFormat.format(ARRAY_CONTAINER_NAME_STRING, n, n2);
            }

            protected String computeType() {
                return BrowserUtils.getArrayItemType(arrayNode.getType());
            }

            protected String computeValue() {
                return MessageFormat.format(ARRAY_CONTAINER_VALUE_STRING, n2 - n + 1);
            }

            protected String computeSize() {
                return "-";
            }

            protected String computeRetainedSize() {
                return "-";
            }

            protected Icon computeIcon() {
                return null;
            }

            public boolean isLeaf() {
                return false;
            }

            protected HeapWalkerNode[] computeChildren() {
                return BrowserUtils.lazilyCreateChildren(this, this.getChildrenComputer());
            }

            protected ChildrenComputer getChildrenComputer() {
                return new ChildrenComputer(){

                    public HeapWalkerNode[] computeChildren() {
                        int n = n2 - n + 1;
                        HeapWalkerNode[] heapWalkerNodeArray = new HeapWalkerNode[n];
                        boolean bl = arrayNode instanceof PrimitiveArrayNode;
                        List list = bl ? ((PrimitiveArrayInstance)arrayNode.getInstance()).getValues() : ((ObjectArrayInstance)arrayNode.getInstance()).getValues();
                        for (int i = 0; i < n; ++i) {
                            heapWalkerNodeArray[i] = bl ? HeapWalkerNodeFactory.createPrimitiveArrayItemNode((PrimitiveArrayNode)arrayNode, n + i, (String)list.get(n + i)) : HeapWalkerNodeFactory.createObjectArrayItemNode((ObjectArrayNode)arrayNode, n + i, (Instance)list.get(n + i));
                        }
                        return heapWalkerNodeArray;
                    }
                };
            }
        };
    }

    public static ClassNode createClassNode(JavaClass javaClass, String string, HeapWalkerNode heapWalkerNode) {
        return new ClassNode(javaClass, string, heapWalkerNode, heapWalkerNode == null ? 1 : heapWalkerNode.getMode());
    }

    public static HeapWalkerFieldNode createFieldNode(FieldValue fieldValue, HeapWalkerNode heapWalkerNode) {
        if (fieldValue instanceof ObjectFieldValue) {
            Instance instance = ((ObjectFieldValue)fieldValue).getInstance();
            if (instance instanceof PrimitiveArrayInstance) {
                return new PrimitiveArrayFieldNode((ObjectFieldValue)fieldValue, heapWalkerNode);
            }
            if (instance instanceof ObjectArrayInstance) {
                return new ObjectArrayFieldNode((ObjectFieldValue)fieldValue, heapWalkerNode);
            }
            return new ObjectFieldNode((ObjectFieldValue)fieldValue, heapWalkerNode);
        }
        return new PrimitiveFieldNode(fieldValue, heapWalkerNode);
    }

    public static HeapWalkerInstanceNode createInstanceNode(Instance instance, String string, HeapWalkerNode heapWalkerNode) {
        int n;
        int n2 = n = heapWalkerNode == null ? 1 : heapWalkerNode.getMode();
        if (instance instanceof PrimitiveArrayInstance) {
            return new PrimitiveArrayNode((PrimitiveArrayInstance)instance, string, heapWalkerNode, n);
        }
        if (instance instanceof ObjectArrayInstance) {
            return new ObjectArrayNode((ObjectArrayInstance)instance, string, heapWalkerNode, n);
        }
        return new ObjectNode(instance, string, heapWalkerNode, n);
    }

    public static HeapWalkerNode createNoFieldsNode(HeapWalkerNode heapWalkerNode) {
        return new AbstractHeapWalkerNode(heapWalkerNode){

            protected String computeName() {
                return NO_FIELDS_STRING;
            }

            protected String computeType() {
                return NONE_STRING;
            }

            protected String computeValue() {
                return NONE_STRING;
            }

            protected String computeSize() {
                return "-";
            }

            protected String computeRetainedSize() {
                return "-";
            }

            protected Icon computeIcon() {
                return null;
            }
        };
    }

    public static boolean isNoFieldsNode(HeapWalkerNode heapWalkerNode) {
        return NO_FIELDS_STRING.equals(heapWalkerNode.getName());
    }

    public static HeapWalkerNode createNoItemsNode(HeapWalkerNode heapWalkerNode) {
        return new AbstractHeapWalkerNode(heapWalkerNode){

            protected String computeName() {
                return NO_ITEMS_STRING;
            }

            protected String computeType() {
                return NONE_STRING;
            }

            protected String computeValue() {
                return NONE_STRING;
            }

            protected String computeSize() {
                return "-";
            }

            protected String computeRetainedSize() {
                return "-";
            }

            protected Icon computeIcon() {
                return null;
            }
        };
    }

    public static boolean isNoItemsNode(HeapWalkerNode heapWalkerNode) {
        return NO_ITEMS_STRING.equals(heapWalkerNode.getName());
    }

    public static HeapWalkerNode createNoReferencesNode(HeapWalkerNode heapWalkerNode) {
        return new AbstractHeapWalkerNode(heapWalkerNode){

            protected String computeName() {
                return NO_REFERENCES_STRING;
            }

            protected String computeType() {
                return NONE_STRING;
            }

            protected String computeValue() {
                return NONE_STRING;
            }

            protected String computeSize() {
                return "-";
            }

            protected String computeRetainedSize() {
                return "-";
            }

            protected Icon computeIcon() {
                return null;
            }
        };
    }

    public static boolean isNoReferencesNode(HeapWalkerNode heapWalkerNode) {
        return NO_REFERENCES_STRING.equals(heapWalkerNode.getName());
    }

    public static HeapWalkerNode createOOMNode(HeapWalkerNode heapWalkerNode) {
        return new AbstractHeapWalkerNode(heapWalkerNode){

            protected String computeName() {
                return OUT_OF_MEMORY_STRING;
            }

            protected String computeType() {
                return "";
            }

            protected String computeValue() {
                return "";
            }

            protected String computeSize() {
                return "";
            }

            protected String computeRetainedSize() {
                return "";
            }

            protected Icon computeIcon() {
                return Utils.ERROR_ICON;
            }
        };
    }

    public static boolean isOOMNode(HeapWalkerNode heapWalkerNode) {
        return OUT_OF_MEMORY_STRING.equals(heapWalkerNode.getName());
    }

    public static HeapWalkerNode createObjectArrayItemNode(ObjectArrayNode objectArrayNode, int n, Instance instance) {
        if (instance instanceof PrimitiveArrayInstance) {
            return new PrimitiveArrayNode.ArrayItem(n, (PrimitiveArrayInstance)instance, (HeapWalkerNode)objectArrayNode);
        }
        if (instance instanceof ObjectArrayInstance) {
            return new ObjectArrayNode.ArrayItem(n, (ObjectArrayInstance)instance, (HeapWalkerNode)objectArrayNode);
        }
        return new ObjectNode.ArrayItem(n, instance, (HeapWalkerNode)objectArrayNode);
    }

    public static HeapWalkerNode createPrimitiveArrayItemNode(PrimitiveArrayNode primitiveArrayNode, int n, String string) {
        return new PrimitiveFieldNode.ArrayItem(n, BrowserUtils.getArrayItemType(primitiveArrayNode.getType()), string, primitiveArrayNode);
    }

    public static HeapWalkerNode createProgressNode(HeapWalkerNode heapWalkerNode) {
        return new AbstractHeapWalkerNode(heapWalkerNode){

            protected String computeName() {
                return SEARCHING_STRING;
            }

            protected String computeType() {
                return "";
            }

            protected String computeValue() {
                return "";
            }

            protected String computeSize() {
                return "";
            }

            protected String computeRetainedSize() {
                return "";
            }

            protected Icon computeIcon() {
                return BrowserUtils.ICON_PROGRESS;
            }
        };
    }

    public static boolean isProgressNode(HeapWalkerNode heapWalkerNode) {
        return SEARCHING_STRING.equals(heapWalkerNode.getName());
    }

    public static HeapWalkerNode createReferenceNode(Value value, HeapWalkerNode heapWalkerNode) {
        if (value instanceof ObjectFieldValue) {
            return new ObjectFieldNode((ObjectFieldValue)value, heapWalkerNode);
        }
        if (value instanceof ArrayItemValue) {
            ArrayItemValue arrayItemValue = (ArrayItemValue)value;
            return new ObjectArrayNode.ArrayItem(arrayItemValue.getIndex(), (ObjectArrayInstance)arrayItemValue.getDefiningInstance(), heapWalkerNode);
        }
        return null;
    }

    public static ClassNode createRootClassNode(JavaClass javaClass, String string, final Runnable runnable, int n, final Heap heap) {
        return new ClassNode.RootNode(javaClass, string, null, n){

            public void refreshView() {
                runnable.run();
            }

            public GCRoot getGCRoot(Instance instance) {
                return heap.getGCRoot(instance);
            }

            public JavaClass getJavaClassByID(long l) {
                return heap.getJavaClassByID(l);
            }
        };
    }

    public static HeapWalkerInstanceNode createRootInstanceNode(Instance instance, String string, final Runnable runnable, int n, final Heap heap) {
        if (instance instanceof PrimitiveArrayInstance) {
            return new PrimitiveArrayNode.RootNode((PrimitiveArrayInstance)instance, string, null, n){

                public void refreshView() {
                    runnable.run();
                }

                public GCRoot getGCRoot(Instance instance) {
                    return heap.getGCRoot(instance);
                }

                public JavaClass getJavaClassByID(long l) {
                    return heap.getJavaClassByID(l);
                }
            };
        }
        if (instance instanceof ObjectArrayInstance) {
            return new ObjectArrayNode.RootNode((ObjectArrayInstance)instance, string, null, n){

                public void refreshView() {
                    runnable.run();
                }

                public GCRoot getGCRoot(Instance instance) {
                    return heap.getGCRoot(instance);
                }

                public JavaClass getJavaClassByID(long l) {
                    return heap.getJavaClassByID(l);
                }
            };
        }
        return new ObjectNode.RootNode(instance, string, null, n){

            public void refreshView() {
                runnable.run();
            }

            public GCRoot getGCRoot(Instance instance) {
                return heap.getGCRoot(instance);
            }

            public JavaClass getJavaClassByID(long l) {
                return heap.getJavaClassByID(l);
            }
        };
    }

    public static boolean isMessageNode(HeapWalkerNode heapWalkerNode) {
        return HeapWalkerNodeFactory.isNoFieldsNode(heapWalkerNode) || HeapWalkerNodeFactory.isNoItemsNode(heapWalkerNode) || HeapWalkerNodeFactory.isNoReferencesNode(heapWalkerNode) || HeapWalkerNodeFactory.isNoReferencesNode(heapWalkerNode) || HeapWalkerNodeFactory.isOOMNode(heapWalkerNode) || HeapWalkerNodeFactory.isProgressNode(heapWalkerNode);
    }
}

