/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.results.cpu.CPUCallGraphBuilder;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.MethodInfoMapper;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTNodeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTraceSnapshotBuilder {
    final List<Long> threadIds = new ArrayList<Long>();
    final List<String> threadNames = new ArrayList<String>();
    final List<byte[]> threadCompactData = new ArrayList<byte[]>();
    final List<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
    final MethodInfoMapper mapper = new MethodInfoMapper(){

        public String getInstrMethodClass(int n) {
            return StackTraceSnapshotBuilder.this.methodInfos.get((int)n).className;
        }

        public String getInstrMethodName(int n) {
            return StackTraceSnapshotBuilder.this.methodInfos.get((int)n).methodName;
        }

        public String getInstrMethodSignature(int n) {
            return StackTraceSnapshotBuilder.this.methodInfos.get((int)n).signature;
        }

        public int getMaxMethodId() {
            return StackTraceSnapshotBuilder.this.methodInfos.size();
        }

        public int getMinMethodId() {
            return 0;
        }
    };
    final CPUCallGraphBuilder ccgb = new CPUCallGraphBuilder(){
        {
            this.setFactory(new CPUCCTNodeFactory(false));
            this.setFilter(InstrumentationFilter.getDefault());
        }

        protected boolean isCollectingTwoTimeStamps() {
            return false;
        }

        protected boolean isReady() {
            return true;
        }

        protected long getDumpAbsTimeStamp() {
            return StackTraceSnapshotBuilder.this.currentDumpTimeStamp.get();
        }
    };
    final ReadWriteLock lock = new ReentrantReadWriteLock();
    final AtomicLong currentDumpTimeStamp = new AtomicLong(-1L);
    final AtomicLong firstDumpTimeStamp = new AtomicLong(-1L);
    final AtomicReference<Map<Thread, StackTraceElement[]>> lastStackTrace = new AtomicReference<Map>(Collections.EMPTY_MAP);
    int stackTraceCount = 0;
    final Map<Thread, Thread.State> lastThreadStates = new WeakHashMap<Thread, Thread.State>();
    final Set<String> ignoredThreadNames = new HashSet<String>();

    public StackTraceSnapshotBuilder() {
        this.ccgb.setMethodInfoMapper(this.mapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setIgnoredThreads(Set<String> set) {
        try {
            this.lock.writeLock().lock();
            this.ignoredThreadNames.clear();
            this.ignoredThreadNames.addAll(set);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addStacktrace(Map<Thread, StackTraceElement[]> map, long l) throws IllegalStateException {
        long l2 = Math.min(l, this.currentDumpTimeStamp.get());
        if (this.currentDumpTimeStamp.compareAndSet(l2, l)) {
            try {
                Thread thread;
                this.lock.writeLock().lock();
                HashMap<Thread, Thread.State> hashMap = new HashMap<Thread, Thread.State>();
                l2 = l;
                for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                    thread = entry.getKey();
                    if (this.ignoredThreadNames.contains(thread.getName())) continue;
                    long l3 = thread.getId();
                    if (!this.threadIds.contains(l3)) {
                        this.threadIds.add(l3);
                        this.threadNames.add(thread.getName());
                        this.ccgb.newThread((int)l3, thread.getName(), thread.getClass().getName());
                    }
                    StackTraceElement[] stackTraceElementArray = entry.getValue();
                    StackTraceElement[] stackTraceElementArray2 = this.lastStackTrace.get().get(thread);
                    Thread.State state = this.lastThreadStates.get(thread);
                    Thread.State state2 = thread.getState();
                    hashMap.put(thread, state2);
                    this.processDiffs((int)l3, stackTraceElementArray2, stackTraceElementArray, l2, state != null ? state : Thread.State.NEW, state2 != null ? state2 : Thread.State.TERMINATED);
                }
                for (Map.Entry<Thread, StackTraceElement[]> entry : this.lastStackTrace.get().entrySet()) {
                    thread = entry.getKey();
                    if (this.ignoredThreadNames.contains(thread.getName()) || map.containsKey(thread)) continue;
                    Thread.State state = thread.getState();
                    Thread.State state3 = (Thread.State)((Object)hashMap.get(thread));
                    this.processDiffs((int)thread.getId(), entry.getValue(), new StackTraceElement[]{}, l2, state != null ? state : Thread.State.NEW, state3 != null ? state3 : Thread.State.TERMINATED);
                }
                this.lastStackTrace.set(map);
                this.currentDumpTimeStamp.set(l);
                this.firstDumpTimeStamp.compareAndSet(-1L, l);
                ++this.stackTraceCount;
                this.lastThreadStates.clear();
                this.lastThreadStates.putAll(hashMap);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        } else {
            throw new IllegalStateException("Adding stacktrace with timestamp " + l + " is not allowed after a stacktrace with timestamp " + this.currentDumpTimeStamp.get() + " has been added");
        }
    }

    private final void processDiffs(int n, StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2, long l, Thread.State state, Thread.State state2) throws IllegalStateException {
        if (state2 == Thread.State.NEW) {
            throw new IllegalStateException("Invalid thread state " + Thread.State.NEW.name() + " for taking a stack trace");
        }
        if (state == Thread.State.TERMINATED && state2 != Thread.State.TERMINATED) {
            throw new IllegalStateException("Thread has already been set to " + Thread.State.TERMINATED.name() + " - stack trace can not be taken");
        }
        block0 : switch (state) {
            case RUNNABLE: 
            case NEW: {
                this.processDiffs(n, stackTraceElementArray, stackTraceElementArray2, l);
                switch (state2) {
                    case BLOCKED: {
                        this.ccgb.monitorEntry(n, l, 0L);
                        break;
                    }
                    case WAITING: 
                    case TIMED_WAITING: {
                        this.ccgb.waitEntry(n, l, 0L);
                    }
                }
                break;
            }
            case WAITING: 
            case TIMED_WAITING: {
                switch (state2) {
                    case RUNNABLE: {
                        this.ccgb.waitExit(n, l, 0L);
                        this.processDiffs(n, stackTraceElementArray, stackTraceElementArray2, l);
                        break;
                    }
                    case WAITING: 
                    case TIMED_WAITING: {
                        this.ccgb.waitExit(n, l, 0L);
                        this.processDiffs(n, stackTraceElementArray, stackTraceElementArray2, l);
                        this.ccgb.waitEntry(n, l, 0L);
                        break;
                    }
                    case BLOCKED: {
                        this.ccgb.waitExit(n, l, 0L);
                        this.processDiffs(n, stackTraceElementArray, stackTraceElementArray2, l);
                        this.ccgb.monitorEntry(n, l, 0L);
                    }
                }
                break;
            }
            case BLOCKED: {
                switch (state2) {
                    case RUNNABLE: {
                        this.ccgb.monitorExit(n, l, 0L);
                        this.processDiffs(n, stackTraceElementArray, stackTraceElementArray2, l);
                        break block0;
                    }
                    case WAITING: 
                    case TIMED_WAITING: {
                        this.ccgb.monitorExit(n, l, 0L);
                        this.processDiffs(n, stackTraceElementArray, stackTraceElementArray2, l);
                        this.ccgb.waitEntry(n, l, 0L);
                        break block0;
                    }
                    case BLOCKED: {
                        this.ccgb.monitorExit(n, l, 0L);
                        this.processDiffs(n, stackTraceElementArray, stackTraceElementArray2, l);
                        this.ccgb.monitorEntry(n, l, 0L);
                    }
                }
            }
        }
    }

    private final void processDiffs(int n, StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2, long l) throws IllegalStateException {
        if (!(stackTraceElementArray != null && stackTraceElementArray.length != 0 || stackTraceElementArray2 != null && stackTraceElementArray2.length != 0)) {
            return;
        }
        int n2 = stackTraceElementArray2 != null ? stackTraceElementArray2.length - 1 : -1;
        int n3 = stackTraceElementArray != null ? stackTraceElementArray.length - 1 : -1;
        int n4 = Math.max(n3, n2);
        ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
        ArrayList<StackTraceElement> arrayList2 = new ArrayList<StackTraceElement>();
        for (int i = 0; i <= n4; ++i) {
            StackTraceElement stackTraceElement;
            StackTraceElement stackTraceElement2 = n3 >= i ? stackTraceElementArray[n3 - i] : null;
            StackTraceElement stackTraceElement3 = stackTraceElement = n2 >= i ? stackTraceElementArray2[n2 - i] : null;
            if (stackTraceElement2 != null && stackTraceElement != null) {
                if (stackTraceElement2.equals(stackTraceElement)) continue;
                arrayList.addAll(Arrays.asList(stackTraceElementArray2).subList(0, n2 - i + 1));
                arrayList2.addAll(Arrays.asList(stackTraceElementArray).subList(0, n3 - i + 1));
                break;
            }
            if (stackTraceElement2 == null && stackTraceElement != null) {
                arrayList.addAll(Arrays.asList(stackTraceElementArray2).subList(0, n2 - i + 1));
                break;
            }
            if (stackTraceElement2 == null || stackTraceElement != null) continue;
            arrayList2.addAll(Arrays.asList(stackTraceElementArray).subList(0, n3 - i + 1));
            break;
        }
        this.addMethodExits(n, arrayList2, l, stackTraceElementArray2 == null || stackTraceElementArray2.length == 0);
        this.addMethodEntries(n, arrayList, l, stackTraceElementArray == null || stackTraceElementArray.length == 0);
    }

    private final void addMethodEntries(int n, List<StackTraceElement> list, long l, boolean bl) throws IllegalStateException {
        boolean bl2 = false;
        Collections.reverse(list);
        for (StackTraceElement stackTraceElement : list) {
            int n2;
            MethodInfo methodInfo = new MethodInfo(stackTraceElement);
            if (!this.methodInfos.contains(methodInfo)) {
                this.methodInfos.add(methodInfo);
            }
            if ((n2 = this.methodInfos.indexOf(methodInfo)) == -1) {
                System.err.println("*** Not found: " + methodInfo);
                throw new IllegalStateException();
            }
            if (bl && !bl2) {
                bl2 = true;
                this.ccgb.methodEntry(n2, n, 2, l, 0L);
                continue;
            }
            this.ccgb.methodEntry(n2, n, 1, l, 0L);
        }
    }

    private final void addMethodExits(int n, List<StackTraceElement> list, long l, boolean bl) throws IllegalStateException {
        int n2 = list.size();
        for (StackTraceElement stackTraceElement : list) {
            MethodInfo methodInfo = new MethodInfo(stackTraceElement);
            int n3 = this.methodInfos.indexOf(methodInfo);
            if (n3 == -1) {
                System.err.println("*** Not found: " + methodInfo);
                throw new IllegalStateException();
            }
            if (bl && --n2 == 0) {
                this.ccgb.methodExit(n3, n, 2, l, 0L);
                continue;
            }
            this.ccgb.methodExit(n3, n, 1, l, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CPUResultsSnapshot createSnapshot(long l, long l2) throws CPUResultsSnapshot.NoDataAvailableException {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        int n;
        if (this.stackTraceCount < 1) {
            throw new CPUResultsSnapshot.NoDataAvailableException();
        }
        try {
            this.lock.readLock().lock();
            n = this.methodInfos.size();
            stringArray3 = new String[this.methodInfos.size()];
            stringArray2 = new String[this.methodInfos.size()];
            stringArray = new String[this.methodInfos.size()];
            int n2 = 0;
            for (MethodInfo methodInfo : this.methodInfos) {
                stringArray3[n2] = methodInfo.className;
                stringArray2[n2] = methodInfo.methodName;
                stringArray[n2] = methodInfo.signature;
                ++n2;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.addStacktrace(Collections.EMPTY_MAP, l2);
        return new CPUResultsSnapshot(l, System.currentTimeMillis(), this.ccgb, false, stringArray3, stringArray2, stringArray, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        try {
            this.lock.writeLock().lock();
            this.ccgb.reset();
            this.methodInfos.clear();
            this.threadIds.clear();
            this.threadNames.clear();
            this.firstDumpTimeStamp.set(-1L);
            this.currentDumpTimeStamp.set(-1L);
            this.stackTraceCount = 0;
            this.lastThreadStates.clear();
            this.lastStackTrace.set(Collections.EMPTY_MAP);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    static class MethodInfo {
        public final String className;
        public final String methodName;
        public final String signature;

        public MethodInfo(String string, String string2, String string3) {
            this.className = string;
            this.methodName = string2;
            this.signature = string3;
        }

        public MethodInfo(StackTraceElement stackTraceElement) {
            this.className = stackTraceElement.getClassName();
            this.methodName = stackTraceElement.getMethodName() + (stackTraceElement.isNativeMethod() ? "[native]" : "");
            this.signature = stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MethodInfo methodInfo = (MethodInfo)object;
            if (this.className == null ? methodInfo.className != null : !this.className.equals(methodInfo.className)) {
                return false;
            }
            return !(this.methodName == null ? methodInfo.methodName != null : !this.methodName.equals(methodInfo.methodName));
        }

        public int hashCode() {
            int n = 5;
            n = 29 * n + (this.className != null ? this.className.hashCode() : 0);
            n = 29 * n + (this.methodName != null ? this.methodName.hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.className + "." + this.methodName + "(" + this.signature + ")";
        }
    }
}

