/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.spi.impl.TableDataProvider;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.ImageLoader;
import org.netbeans.modules.dlight.visualizers.OnTimerRefreshVisualizerHandler;
import org.netbeans.modules.dlight.visualizers.OnTimerTask;
import org.netbeans.modules.dlight.visualizers.TableSorter;
import org.netbeans.modules.dlight.visualizers.VisualizerTopComponentTopComponent;
import org.netbeans.modules.dlight.visualizers.api.TableVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.impl.TableVisualizerConfigurationAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TableVisualizer
extends JPanel
implements Visualizer<TableVisualizerConfiguration>,
OnTimerTask,
ComponentListener {
    private TableDataProvider provider;
    private volatile boolean isShown = true;
    private TableVisualizerConfiguration configuration;
    private final List<DataRow> data = new ArrayList<DataRow>();
    private JToolBar buttonsToolbar;
    private JButton refresh;
    private AbstractTableModel tableModel;
    private JTable table;
    private TableSorter tableSorterModel = new TableSorter();
    private OnTimerRefreshVisualizerHandler timerHandler;
    private boolean isEmptyContent;

    TableVisualizer(TableDataProvider tableDataProvider, TableVisualizerConfiguration tableVisualizerConfiguration) {
        this.provider = tableDataProvider;
        this.configuration = tableVisualizerConfiguration;
        this.setEmptyContent();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addComponentListener(this);
        VisualizerTopComponentTopComponent.findInstance().addComponentListener(this);
        this.asyncFillModel();
        if (this.timerHandler != null && this.timerHandler.isSessionRunning()) {
            this.timerHandler.startTimer();
            return;
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.timerHandler != null) {
            this.timerHandler.stopTimer();
        }
        this.removeComponentListener(this);
        VisualizerTopComponentTopComponent.findInstance().removeComponentListener(this);
    }

    private void setEmptyContent() {
        this.isEmptyContent = true;
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        this.table = null;
        if (this.tableSorterModel != null) {
            this.tableSorterModel = null;
        }
        JLabel jLabel = new JLabel(this.timerHandler != null && this.timerHandler.isSessionAnalyzed() ? TableVisualizerConfigurationAccessor.getDefault().getEmptyAnalyzeMessage(this.configuration) : TableVisualizerConfigurationAccessor.getDefault().getEmptyRunningMessage(this.configuration));
        jLabel.setAlignmentX(0.5f);
        this.add(jLabel);
        this.repaint();
        this.revalidate();
    }

    private void setContent(boolean bl) {
        if (this.isEmptyContent && bl) {
            return;
        }
        if (this.isEmptyContent && !bl) {
            this.setNonEmptyContent();
            return;
        }
        if (!this.isEmptyContent && bl) {
            this.setEmptyContent();
            return;
        }
    }

    private void setNonEmptyContent() {
        this.isEmptyContent = false;
        this.removeAll();
        this.tableModel = new AbstractTableModel(){

            public int getRowCount() {
                return TableVisualizer.this.data.size();
            }

            public int getColumnCount() {
                return TableVisualizer.this.configuration.getMetadata().getColumnsCount();
            }

            public Class getColumnClass(int n) {
                return ((DataTableMetadata.Column)TableVisualizer.this.configuration.getMetadata().getColumns().get(n)).getColumnClass();
            }

            public Object getValueAt(int n, int n2) {
                Object e = ((DataRow)TableVisualizer.this.data.get(n)).getData().get(n2);
                return e;
            }

            public String getColumnName(int n) {
                return ((DataTableMetadata.Column)TableVisualizer.this.configuration.getMetadata().getColumns().get(n)).getColumnUName();
            }
        };
        this.tableSorterModel = new TableSorter(this.tableModel);
        this.table = new JTable(this.tableSorterModel);
        this.tableSorterModel.addMouseListenerToHeaderInTable(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.table), "Center");
        this.buttonsToolbar = new JToolBar();
        this.refresh = new JButton();
        this.buttonsToolbar.setFloatable(false);
        this.buttonsToolbar.setOrientation(1);
        this.buttonsToolbar.setRollover(true);
        this.refresh.setIcon(ImageLoader.loadIcon("refresh.png"));
        this.refresh.setFocusable(false);
        this.refresh.setHorizontalTextPosition(0);
        this.refresh.setVerticalTextPosition(3);
        this.refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableVisualizer.this.asyncFillModel();
            }
        });
        this.buttonsToolbar.add(this.refresh);
        this.add((Component)this.buttonsToolbar, "Before");
        this.repaint();
        this.validate();
    }

    public VisualizerContainer getDefaultContainer() {
        return VisualizerTopComponentTopComponent.findInstance();
    }

    @Override
    public int onTimer() {
        if (!this.isShown || !this.isShowing()) {
            return 0;
        }
        this.syncFillModel();
        return 0;
    }

    public void refresh() {
        this.asyncFillModel();
    }

    protected final void asyncFillModel() {
        DLightExecutorService.submit((Runnable)new Runnable(){

            public void run() {
                TableVisualizer.this.syncFillModel();
            }
        }, (String)("Async TableVisualizer model fill " + this.configuration.getID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFillModel() {
        boolean bl;
        List list = this.provider.queryData(this.configuration.getMetadata());
        List<DataRow> list2 = this.data;
        synchronized (list2) {
            this.data.clear();
            this.data.addAll(list);
            bl = this.data.isEmpty();
        }
        final boolean bl2 = bl;
        UIThread.invoke((Runnable)new Runnable(){

            public void run() {
                if (TableVisualizer.this.tableModel != null) {
                    TableVisualizer.this.tableModel.fireTableDataChanged();
                }
                TableVisualizer.this.setContent(bl2);
            }
        });
    }

    public TableVisualizerConfiguration getVisualizerConfiguration() {
        return this.configuration;
    }

    public JComponent getComponent() {
        return this;
    }

    @Override
    public void timerStopped() {
        if (this.isEmptyContent) {
            this.setEmptyContent();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.isShown) {
            return;
        }
        this.isShown = this.isShowing();
        if (this.isShown) {
            this.asyncFillModel();
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.isShown = false;
    }
}

