/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.netbeans.spi.project.ActionProvider;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public final class FileCommandAction
extends ProjectAction {
    private String presenterName;

    public FileCommandAction(String string, String string2, String string3, Lookup lookup) {
        this(string, string2, (Icon)ImageUtilities.loadImageIcon((String)string3, (boolean)false), lookup);
    }

    public FileCommandAction(String string, String string2, Icon icon, Lookup lookup) {
        super(string, string2, icon, lookup);
        assert (string2 != null) : "Name patern must not be null";
        this.presenterName = ActionsUtil.formatName(this.getNamePattern(), 0, "");
        this.setDisplayName(this.presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)this.presenterName));
    }

    protected void refresh(Lookup lookup) {
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, this.getCommand());
        if (projectArray.length != 1) {
            this.setEnabled(false);
            this.presenterName = ActionsUtil.formatName(this.getNamePattern(), 0, "");
        } else {
            FileObject[] fileObjectArray = ActionsUtil.getFilesFromLookup(lookup, projectArray[0]);
            this.setEnabled(true);
            this.presenterName = ActionsUtil.formatName(this.getNamePattern(), fileObjectArray.length, fileObjectArray.length > 0 ? fileObjectArray[0].getNameExt() : "");
        }
        this.putValue("menuText", this.presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)this.presenterName));
    }

    protected void actionPerformed(Lookup lookup) {
        Project[] projectArray = ActionsUtil.getProjectsFromLookup(lookup, this.getCommand());
        if (projectArray.length == 1) {
            ActionProvider actionProvider = (ActionProvider)projectArray[0].getLookup().lookup(ActionProvider.class);
            actionProvider.invokeAction(this.getCommand(), lookup);
        }
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new FileCommandAction(this.getCommand(), this.getNamePattern(), (Icon)this.getValue("SmallIcon"), lookup);
    }
}

