/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.InvalidStateException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeNodeDecl;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.spec.ConditionalSection;
import org.netbeans.tax.spec.DTD;
import org.netbeans.tax.spec.DocumentType;
import org.netbeans.tax.spec.ParameterEntityReference;

public class TreeEntityDecl
extends TreeNodeDecl
implements DTD.Child,
ParameterEntityReference.Child,
DocumentType.Child,
ConditionalSection.Child {
    public static final String PROP_PARAMETER = "parameter";
    public static final String PROP_NAME = "name";
    public static final String PROP_TYPE = "type";
    public static final String PROP_INTERNAL_TEXT = "internalText";
    public static final String PROP_PUBLIC_ID = "publicId";
    public static final String PROP_SYSTEM_ID = "systemId";
    public static final String PROP_NOTATION_NAME = "notationName";
    public static final short TYPE_INTERNAL = 1;
    public static final short TYPE_EXTERNAL = 2;
    public static final short TYPE_UNPARSED = 3;
    public static final boolean GENERAL_DECL = false;
    public static final boolean PARAMETER_DECL = true;
    private boolean parameter;
    private String name;
    private short type;
    private String internalText;
    private String publicId;
    private String systemId;
    private String notationName;

    private TreeEntityDecl(boolean bl, String string) throws InvalidArgumentException {
        this.checkName(string);
        this.name = string;
        this.parameter = bl;
    }

    public TreeEntityDecl(boolean bl, String string, String string2) throws InvalidArgumentException {
        this(bl, string);
        this.checkInternalText(string2);
        this.type = 1;
        this.internalText = string2;
        this.publicId = null;
        this.systemId = null;
        this.notationName = null;
    }

    public TreeEntityDecl(String string, String string2) throws InvalidArgumentException {
        this(false, string, string2);
    }

    public TreeEntityDecl(boolean bl, String string, String string2, String string3) throws InvalidArgumentException {
        this(bl, string);
        this.checkExternalDecl(string2, string3);
        this.type = (short)2;
        this.internalText = null;
        this.publicId = string2;
        this.systemId = string3;
        this.notationName = null;
    }

    public TreeEntityDecl(String string, String string2, String string3) throws InvalidArgumentException {
        this(false, string, string2, string3);
    }

    public TreeEntityDecl(String string, String string2, String string3, String string4) throws InvalidArgumentException {
        this(false, string);
        this.checkUnparsedDecl(string2, string3, string4);
        this.type = (short)3;
        this.internalText = null;
        this.publicId = string2;
        this.systemId = string3;
        this.notationName = string4;
    }

    protected TreeEntityDecl(TreeEntityDecl treeEntityDecl) {
        super(treeEntityDecl);
        this.parameter = treeEntityDecl.parameter;
        this.name = treeEntityDecl.name;
        this.type = treeEntityDecl.type;
        this.internalText = treeEntityDecl.internalText;
        this.publicId = treeEntityDecl.publicId;
        this.systemId = treeEntityDecl.systemId;
        this.notationName = treeEntityDecl.notationName;
    }

    public Object clone() {
        return new TreeEntityDecl(this);
    }

    public boolean equals(Object object, boolean bl) {
        if (!super.equals(object, bl)) {
            return false;
        }
        TreeEntityDecl treeEntityDecl = (TreeEntityDecl)object;
        if (!Util.equals(this.getName(), treeEntityDecl.getName())) {
            return false;
        }
        if (this.isParameter() != treeEntityDecl.isParameter()) {
            return false;
        }
        if (this.getType() != treeEntityDecl.getType()) {
            return false;
        }
        if (!Util.equals(this.getPublicId(), treeEntityDecl.getPublicId())) {
            return false;
        }
        if (!Util.equals(this.getSystemId(), treeEntityDecl.getSystemId())) {
            return false;
        }
        if (!Util.equals(this.getInternalText(), treeEntityDecl.getInternalText())) {
            return false;
        }
        return Util.equals(this.getNotationName(), treeEntityDecl.getNotationName());
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeEntityDecl treeEntityDecl = (TreeEntityDecl)treeObject;
        this.setNameImpl(treeEntityDecl.getName());
        this.setParameterImpl(treeEntityDecl.isParameter());
        short s = treeEntityDecl.getType();
        switch (s) {
            case 2: {
                this.setExternalDeclImpl(treeEntityDecl.getPublicId(), treeEntityDecl.getSystemId());
                break;
            }
            case 1: {
                this.setInternalTextImpl(treeEntityDecl.getInternalText());
                break;
            }
            case 3: {
                this.setUnparsedDeclImpl(treeEntityDecl.getPublicId(), treeEntityDecl.getSystemId(), treeEntityDecl.getNotationName());
            }
        }
    }

    public final boolean isParameter() {
        return this.parameter;
    }

    private final void setParameterImpl(boolean bl) {
        boolean bl2 = this.parameter;
        this.parameter = bl;
        this.firePropertyChange(PROP_PARAMETER, bl2 ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public final void setParameter(boolean bl) throws ReadOnlyException, InvalidStateException, InvalidArgumentException {
        if (this.parameter == bl) {
            return;
        }
        this.checkReadOnly();
        if (bl && this.type == 3) {
            throw new InvalidStateException(Util.THIS.getString("EXC_ted_parameter_unparsed"));
        }
        this.setParameterImpl(bl);
    }

    public final String getName() {
        return this.name;
    }

    private final void setNameImpl(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChange(PROP_NAME, string2, string);
    }

    public final void setName(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.name, string)) {
            return;
        }
        this.checkReadOnly();
        this.checkName(string);
        this.setNameImpl(string);
    }

    protected final void checkName(String string) throws InvalidArgumentException {
        TreeUtilities.checkEntityDeclName(string);
    }

    public final short getType() {
        return this.type;
    }

    public final String getInternalText() {
        return this.internalText;
    }

    private final void setInternalTextImpl(String string) {
        short s = this.type;
        String string2 = this.internalText;
        String string3 = this.publicId;
        String string4 = this.systemId;
        String string5 = this.notationName;
        this.type = 1;
        this.internalText = string;
        this.publicId = null;
        this.systemId = null;
        this.notationName = null;
        this.firePropertyChange(PROP_TYPE, new Short(s), new Short(this.type));
        this.firePropertyChange(PROP_INTERNAL_TEXT, string2, string);
        this.firePropertyChange(PROP_PUBLIC_ID, string3, this.publicId);
        this.firePropertyChange(PROP_SYSTEM_ID, string4, this.systemId);
        this.firePropertyChange(PROP_NOTATION_NAME, string5, this.notationName);
    }

    public final void setInternalText(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.internalText, string)) {
            return;
        }
        this.checkReadOnly();
        this.checkInternalText(string);
        this.setInternalTextImpl(string);
    }

    protected final void checkInternalText(String string) throws InvalidArgumentException {
        TreeUtilities.checkEntityDeclInternalText(string);
    }

    public final String getPublicId() {
        return this.publicId;
    }

    private final void setPublicIdImpl(String string) {
        String string2 = this.publicId;
        this.publicId = string;
        this.firePropertyChange(PROP_PUBLIC_ID, string2, string);
    }

    public final void setPublicId(String string) throws ReadOnlyException, InvalidStateException, InvalidArgumentException {
        if (Util.equals(this.publicId, string)) {
            return;
        }
        this.checkReadOnly();
        if (this.type == 1) {
            throw new InvalidStateException(Util.THIS.getString("EXC_ted_internal_public"));
        }
        this.checkPublicId(string);
        this.setPublicIdImpl(string);
    }

    protected final void checkPublicId(String string) throws InvalidArgumentException {
        TreeUtilities.checkEntityDeclPublicId(string);
        this.checkExternalId(string, this.systemId);
    }

    public final String getSystemId() {
        return this.systemId;
    }

    private final void setSystemIdImpl(String string) {
        String string2 = this.systemId;
        this.systemId = string;
        this.firePropertyChange(PROP_SYSTEM_ID, string2, string);
    }

    public final void setSystemId(String string) throws ReadOnlyException, InvalidStateException, InvalidArgumentException {
        if (Util.equals(this.systemId, string)) {
            return;
        }
        this.checkReadOnly();
        if (this.type == 1) {
            throw new InvalidStateException(Util.THIS.getString("EXC_ted_internal_system"));
        }
        this.checkSystemId(string);
        this.setSystemIdImpl(string);
    }

    protected final void checkSystemId(String string) throws InvalidArgumentException {
        TreeUtilities.checkEntityDeclSystemId(string);
        this.checkExternalId(this.publicId, string);
    }

    private final void setExternalDeclImpl(String string, String string2) {
        short s = this.type;
        String string3 = this.internalText;
        String string4 = this.publicId;
        String string5 = this.systemId;
        String string6 = this.notationName;
        this.type = (short)2;
        this.internalText = null;
        this.publicId = string;
        this.systemId = string2;
        this.notationName = null;
        this.firePropertyChange(PROP_TYPE, new Short(s), new Short(this.type));
        this.firePropertyChange(PROP_INTERNAL_TEXT, string3, this.internalText);
        this.firePropertyChange(PROP_PUBLIC_ID, string4, string);
        this.firePropertyChange(PROP_SYSTEM_ID, string5, string2);
        this.firePropertyChange(PROP_NOTATION_NAME, string6, this.notationName);
    }

    public final void setExternalDecl(String string, String string2) throws ReadOnlyException, InvalidArgumentException {
        boolean bl;
        boolean bl2 = !Util.equals(this.publicId, string);
        boolean bl3 = bl = !Util.equals(this.systemId, string2);
        if (!bl2 && !bl) {
            return;
        }
        this.checkReadOnly();
        this.checkExternalDecl(string, string2);
        this.setExternalDeclImpl(string, string2);
    }

    protected final void checkExternalDecl(String string, String string2) throws InvalidArgumentException {
        TreeUtilities.checkEntityDeclPublicId(string);
        TreeUtilities.checkEntityDeclSystemId(string2);
        this.checkExternalId(string, string2);
    }

    public final String getNotationName() {
        return this.notationName;
    }

    private final void setNotationNameImpl(String string) {
        short s = this.type;
        String string2 = this.notationName;
        this.type = string == null ? (short)2 : (short)3;
        this.notationName = string;
        this.firePropertyChange(PROP_TYPE, new Short(s), new Short(this.type));
        this.firePropertyChange(PROP_NOTATION_NAME, string2, string);
    }

    public final void setNotationName(String string) throws ReadOnlyException, InvalidStateException, InvalidArgumentException {
        if (Util.equals(this.notationName, string)) {
            return;
        }
        this.checkReadOnly();
        if (this.type == 1) {
            throw new InvalidStateException(Util.THIS.getString("EXC_internal_notation"));
        }
        if (this.parameter) {
            throw new InvalidStateException(Util.THIS.getString("EXC_ted_parameter_unparsed"));
        }
        this.checkNotationName(string);
        this.setNotationNameImpl(string);
    }

    protected final void checkNotationName(String string) throws InvalidArgumentException {
        TreeUtilities.checkEntityDeclNotationName(string);
    }

    private final void setUnparsedDeclImpl(String string, String string2, String string3) {
        short s = this.type;
        String string4 = this.internalText;
        String string5 = this.publicId;
        String string6 = this.systemId;
        String string7 = this.notationName;
        this.type = (short)3;
        this.internalText = null;
        this.publicId = string;
        this.systemId = string2;
        this.notationName = string3;
        this.firePropertyChange(PROP_TYPE, new Short(s), new Short(this.type));
        this.firePropertyChange(PROP_INTERNAL_TEXT, string4, this.internalText);
        this.firePropertyChange(PROP_PUBLIC_ID, string5, string);
        this.firePropertyChange(PROP_SYSTEM_ID, string6, string2);
        this.firePropertyChange(PROP_NOTATION_NAME, string7, string3);
    }

    public final void setUnparsedDecl(String string, String string2, String string3) throws ReadOnlyException, InvalidStateException, InvalidArgumentException {
        boolean bl;
        boolean bl2 = !Util.equals(this.publicId, string);
        boolean bl3 = !Util.equals(this.systemId, string2);
        boolean bl4 = bl = !Util.equals(this.notationName, string3);
        if (!(bl2 || bl3 || bl)) {
            return;
        }
        this.checkReadOnly();
        if (this.parameter) {
            throw new InvalidStateException(Util.THIS.getString("EXC_ted_parameter_unparsed"));
        }
        this.checkUnparsedDecl(string, string2, string3);
        this.setUnparsedDeclImpl(string, string2, string3);
    }

    protected final void checkUnparsedDecl(String string, String string2, String string3) throws InvalidArgumentException {
        TreeUtilities.checkEntityDeclPublicId(string);
        TreeUtilities.checkEntityDeclSystemId(string2);
        this.checkExternalId(string, string2);
        TreeUtilities.checkEntityDeclNotationName(string3);
        if (string3 == null) {
            throw new InvalidArgumentException(Util.THIS.getString("EXC_ted_unparsed_must_notation"), new NullPointerException());
        }
    }

    protected final void checkExternalId(String string, String string2) throws InvalidArgumentException {
        if (string2 == null) {
            if (string == null) {
                throw new InvalidArgumentException(Util.THIS.getString("EXC_ted_system_required"), new NullPointerException());
            }
            throw new InvalidArgumentException(Util.THIS.getString("EXC_ted_system_required"), new NullPointerException());
        }
    }
}

