/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DOMHelper {
    private static final int TIME_TO_WAIT = 300;
    private static final String IDENT = "    ";
    private FileObject fobj;
    private Document document;

    public DOMHelper(FileObject fileObject) {
        this.fobj = fileObject;
        this.document = this.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDocument() {
        if (this.document == null) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            if (documentBuilder == null) {
                return null;
            }
            FileLock fileLock = null;
            InputStream inputStream = null;
            try {
                fileLock = this.fobj.lock();
                inputStream = this.fobj.getInputStream();
                this.document = documentBuilder.parse(inputStream);
            }
            catch (SAXException sAXException) {
                Exceptions.printStackTrace((Throwable)sAXException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }
        return this.document;
    }

    public Element findElement(String string, String string2) {
        NodeList nodeList = this.document.getElementsByTagName(string);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            if (!this.containsValue(element, string2)) continue;
            return element;
        }
        return null;
    }

    public Element findElement(String string) {
        NodeList nodeList = this.document.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public NodeList findElements(String string) {
        return this.document.getElementsByTagName(string);
    }

    public Element findElementById(String string) {
        return this.document.getElementById(string);
    }

    public void appendChild(Element element) {
        this.document.getDocumentElement().appendChild(element);
    }

    public Element createElement(String string) {
        return this.document.createElement(string);
    }

    public Element createElement(String string, String string2) {
        Element element = this.document.createElement(string);
        Text text = this.document.createTextNode(string2);
        element.appendChild(text);
        return element;
    }

    public boolean containsValue(Element element, String string) {
        Node node = element.getFirstChild();
        if (node instanceof Text) {
            return ((Text)node).getWholeText().equals(string);
        }
        return false;
    }

    public String getValue(Element element) {
        Node node = element.getFirstChild();
        if (node instanceof Text) {
            return ((Text)node).getWholeText();
        }
        return "";
    }

    public void setValue(Element element, String string) {
        Node node = element.getFirstChild();
        if (node instanceof Text) {
            ((Text)node).setData(string);
        }
    }

    public void save() {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                FileLock fileLock = null;
                OutputStream outputStream = null;
                try {
                    DocumentType documentType = DOMHelper.this.document.getDoctype();
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource dOMSource = new DOMSource(DOMHelper.this.document);
                    fileLock = DOMHelper.this.fobj.lock();
                    outputStream = DOMHelper.this.fobj.getOutputStream(fileLock);
                    StreamResult streamResult = new StreamResult(outputStream);
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.transform(dOMSource, streamResult);
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        }, 300);
    }

    private DocumentBuilder getDocumentBuilder() {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        documentBuilderFactory.setIgnoringComments(false);
        documentBuilderFactory.setIgnoringElementContentWhitespace(false);
        documentBuilderFactory.setCoalescing(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setValidating(false);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Exceptions.printStackTrace((Throwable)parserConfigurationException);
        }
        return documentBuilder;
    }

    private void beautify() {
        this.beautify(this.document.getDocumentElement(), "\n");
    }

    private void beautify(Node node, String string) {
        int n;
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (n = 0; n < n2; ++n) {
            arrayList.add(nodeList.item(n));
        }
        for (n = 0; n < n2; ++n) {
            Node node2 = (Node)arrayList.get(n);
            if (node2 instanceof Text) continue;
            node.insertBefore(this.document.createTextNode(string + IDENT), node2);
            this.beautify(node2, string + IDENT);
            if (n + 1 != n2) continue;
            node.appendChild(this.document.createTextNode(string));
        }
    }
}

