/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.websvc.rest.codegen.AbstractGenerator;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.GenericResourceBean;
import org.netbeans.modules.websvc.rest.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.rest.support.AbstractTask;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericResourceGenerator
extends AbstractGenerator {
    public static final String RESOURCE_TEMPLATE = "Templates/WebServices/GenericResource.java";
    public static final String COMMENT_END_OF_GET = "TODO return proper representation object";
    private FileObject destDir;
    private GenericResourceBean bean;
    private String template;

    public GenericResourceGenerator(FileObject fileObject, GenericResourceBean genericResourceBean) {
        this.destDir = fileObject;
        this.bean = genericResourceBean;
        this.template = RESOURCE_TEMPLATE;
    }

    public FileObject getDestDir() {
        return this.destDir;
    }

    public GenericResourceBean getBean() {
        return this.bean;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String string) {
        this.template = string;
    }

    @Override
    public Set<FileObject> generate(ProgressHandle progressHandle) throws IOException {
        this.initProgressReporting(progressHandle, false);
        this.reportProgress(NbBundle.getMessage(GenericResourceGenerator.class, (String)"MSG_GeneratingClass", (Object)(this.bean.getPackageName() + "." + this.bean.getName())));
        JavaSource javaSource = JavaSourceHelper.createJavaSource(this.getTemplate(), this.getDestDir(), this.bean.getPackageName(), this.bean.getName());
        if (this.bean.getInputParameters().size() > 0) {
            this.addInputParamFields(javaSource);
            this.addConstructorWithInputParams(javaSource);
        }
        this.modifyResourceClass(javaSource);
        return new HashSet<FileObject>(javaSource.getFileObjects());
    }

    private void addInputParamFields(JavaSource javaSource) throws IOException {
        ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                List<ParameterInfo> list = GenericResourceGenerator.this.bean.getInputParameters();
                JavaSourceHelper.addFields(workingCopy, GenericResourceGenerator.this.getParamNames(list), GenericResourceGenerator.this.getParamTypeNames(list), GenericResourceGenerator.this.getParamValues(list));
            }
        });
        modificationResult.commit();
    }

    private void addConstructorWithInputParams(JavaSource javaSource) throws IOException {
        ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassTree classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                List<ParameterInfo> list = GenericResourceGenerator.this.bean.getInputParameters();
                String string = "{";
                for (ParameterInfo parameterInfo : list) {
                    String string2 = parameterInfo.getName();
                    string = string + "if (" + string2 + " != null) {" + "this." + string2 + " = " + string2 + ";" + "}\n";
                }
                ClassTree classTree2 = JavaSourceHelper.addConstructor(workingCopy, classTree, Constants.PUBLIC, GenericResourceGenerator.this.getParamNames(list), GenericResourceGenerator.this.getParamTypeNames(list), string, null);
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
            }
        });
        modificationResult.commit();
    }

    private void modifyResourceClass(JavaSource javaSource) {
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    JavaSourceHelper.addImports(workingCopy, GenericResourceGenerator.getJsr311AnnotationImports(GenericResourceGenerator.this.bean));
                    if (GenericResourceGenerator.this.bean.isGenerateUriTemplate()) {
                        JavaSourceHelper.addClassAnnotation(workingCopy, new String[]{"Path"}, new Object[]{GenericResourceGenerator.this.bean.getUriTemplate()});
                    }
                    ClassTree classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                    ClassTree classTree2 = GenericResourceGenerator.this.addMethods(workingCopy, classTree);
                    for (GenericResourceBean genericResourceBean : GenericResourceGenerator.this.bean.getSubResources()) {
                        classTree2 = GenericResourceGenerator.this.addSubResourceLocatorMethod(workingCopy, classTree2, genericResourceBean);
                    }
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            });
            modificationResult.commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public static String[] getJsr311AnnotationImports(GenericResourceBean genericResourceBean) {
        HashSet<String> hashSet = new HashSet<String>();
        if (genericResourceBean.isGenerateUriTemplate()) {
            hashSet.add("javax.ws.rs.Path");
        }
        if (genericResourceBean.getUriParams().length > 0) {
            hashSet.add("javax.ws.rs.PathParam");
        }
        for (Constants.HttpMethodType httpMethodType : genericResourceBean.getMethodTypes()) {
            hashSet.add(httpMethodType.getAnnotationType());
            if (httpMethodType == Constants.HttpMethodType.GET) {
                hashSet.add("javax.ws.rs.Produces");
            }
            if (httpMethodType != Constants.HttpMethodType.POST && httpMethodType != Constants.HttpMethodType.PUT) continue;
            hashSet.add("javax.ws.rs.Consumes");
        }
        if (genericResourceBean.getQueryParameters().size() > 0) {
            hashSet.add("javax.ws.rs.QueryParam");
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    protected ClassTree addMethods(WorkingCopy workingCopy, ClassTree classTree) {
        Constants.MimeType[] mimeTypeArray = this.bean.getMimeTypes();
        String[] stringArray = this.bean.getRepresentationTypes();
        for (int i = 0; i < mimeTypeArray.length; ++i) {
            Constants.MimeType mimeType = mimeTypeArray[i];
            String string = stringArray[i];
            classTree = this.addGetMethod(mimeType, string, workingCopy, classTree);
            if (this.bean.getMethodTypes().contains((Object)Constants.HttpMethodType.POST)) {
                classTree = this.addPostMethod(mimeType, string, workingCopy, classTree);
            }
            if (!this.bean.getMethodTypes().contains((Object)Constants.HttpMethodType.PUT)) continue;
            classTree = this.addPutMethod(mimeType, string, workingCopy, classTree);
        }
        if (this.bean.getMethodTypes().contains((Object)Constants.HttpMethodType.DELETE)) {
            classTree = this.addDeleteMethod(workingCopy, classTree);
        }
        return classTree;
    }

    private ClassTree addGetMethod(Constants.MimeType mimeType, String string, WorkingCopy workingCopy, ClassTree classTree) {
        Modifier[] modifierArray = Constants.PUBLIC;
        String[] stringArray = new String[]{"GET", "Produces"};
        Object[] objectArray = new Object[]{null, mimeType.value()};
        if (string == null) {
            string = String.class.getName();
        }
        String string2 = "{ //TODO return proper representation object\n";
        string2 = string2 + "throw new UnsupportedOperationException(); }";
        List<ParameterInfo> list = this.bean.getQueryParameters();
        String[] stringArray2 = this.getGetParamNames(list);
        Object[] objectArray2 = this.getGetParamTypes(list);
        String[][] stringArray3 = this.getGetParamAnnotations(list);
        Object[][] objectArray3 = this.getGetParamAnnotationAttrs(list);
        String string3 = "Retrieves representation of an instance of " + this.bean.getQualifiedClassName() + "\n";
        for (String string4 : stringArray2) {
            string3 = string3 + "@param $PARAM$ resource URI parameter\n".replace("$PARAM$", string4);
        }
        string3 = string3 + "@return an instance of " + string;
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, this.getMethodName(Constants.HttpMethodType.GET, mimeType), string, stringArray2, objectArray2, (Object[])stringArray3, (Object[])objectArray3, string2, string3);
    }

    private ClassTree addPostMethod(Constants.MimeType mimeType, String string, WorkingCopy workingCopy, ClassTree classTree) {
        Modifier[] modifierArray = Constants.PUBLIC;
        String[] stringArray = new String[]{"POST", "Consumes", "Produces"};
        Object[] objectArray = new Object[]{null, mimeType.value(), mimeType.value()};
        String string2 = "{ //TODO\n return Response.created(context.getAbsolutePath()).build(); }";
        String[] stringArray2 = this.getPostPutParams();
        Object[] objectArray2 = this.getPostPutParamTypes(string);
        if (string != null) {
            objectArray2[objectArray2.length - 1] = string;
        }
        Object[] objectArray3 = this.getParamAnnotations(stringArray2.length);
        Object[] objectArray4 = this.getParamAnnotationAttributes(stringArray2.length);
        String string3 = "POST method for creating an instance of " + this.bean.getName() + "\n";
        for (int i = 0; i < stringArray2.length - 1; ++i) {
            string3 = string3 + "@param $PARAM$ resource URI parameter\n".replace("$PARAM$", stringArray2[i]);
        }
        string3 = string3 + "@param $PARAM$ representation for the new resource\n".replace("$PARAM$", stringArray2[stringArray2.length - 1]);
        string3 = string3 + "@return an HTTP response with content of the created resource";
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, this.getMethodName(Constants.HttpMethodType.POST, mimeType), "javax.ws.rs.core.Response", stringArray2, objectArray2, objectArray3, objectArray4, string2, string3);
    }

    private ClassTree addPutMethod(Constants.MimeType mimeType, String string, WorkingCopy workingCopy, ClassTree classTree) {
        Modifier[] modifierArray = Constants.PUBLIC;
        String[] stringArray = new String[]{"PUT", "Consumes"};
        Object[] objectArray = new Object[]{null, mimeType.value(), mimeType.value()};
        String string2 = "void";
        String string3 = "{ //TODO }";
        String[] stringArray2 = this.getPostPutParams();
        Object[] objectArray2 = this.getPostPutParamTypes(string);
        if (string != null) {
            objectArray2[objectArray2.length - 1] = string;
        }
        Object[] objectArray3 = this.getParamAnnotations(stringArray2.length);
        Object[] objectArray4 = this.getParamAnnotationAttributes(stringArray2.length);
        String string4 = "PUT method for updating or creating an instance of " + this.bean.getName() + "\n";
        for (int i = 0; i < stringArray2.length - 1; ++i) {
            string4 = string4 + "@param $PARAM$ resource URI parameter\n".replace("$PARAM$", stringArray2[i]);
        }
        string4 = string4 + "@param $PARAM$ representation for the resource\n".replace("$PARAM$", stringArray2[stringArray2.length - 1]);
        string4 = string4 + "@return an HTTP response with content of the updated or created resource.";
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, this.getMethodName(Constants.HttpMethodType.PUT, mimeType), string2, stringArray2, objectArray2, objectArray3, objectArray4, string3, string4);
    }

    private ClassTree addDeleteMethod(WorkingCopy workingCopy, ClassTree classTree) {
        Modifier[] modifierArray = Constants.PUBLIC;
        String[] stringArray = new String[]{"DELETE"};
        Object[] objectArray = new Object[]{null};
        String string = "void";
        String string2 = "{ //TODO implement }";
        String[] stringArray2 = this.bean.getUriParams();
        Object[] objectArray2 = this.getUriParamTypes();
        Object[] objectArray3 = this.getParamAnnotations(stringArray2.length);
        Object[] objectArray4 = this.getParamAnnotationAttributes(stringArray2.length);
        String string3 = "DELETE method for resource " + this.bean.getName() + "\n";
        for (String string4 : stringArray2) {
            string3 = string3 + "@param $PARAM$ resource URI parameter\n".replace("$PARAM$", string4);
        }
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, "delete", string, stringArray2, objectArray2, objectArray3, objectArray4, string2, string3);
    }

    private ClassTree addSubResourceLocatorMethod(WorkingCopy workingCopy, ClassTree classTree, GenericResourceBean genericResourceBean) {
        Modifier[] modifierArray = Constants.PUBLIC;
        String string = "get" + genericResourceBean.getName();
        String[] stringArray = new String[]{"Path"};
        Object[] objectArray = new Object[]{genericResourceBean.getUriTemplate()};
        String string2 = genericResourceBean.getName();
        String string3 = "{ return new " + string2 + "(); }";
        String string4 = "Sub-resource locator method for  " + genericResourceBean.getUriTemplate() + "\n";
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, string, string2, null, null, null, null, string3, string4);
    }

    public String getPostPutMethodBodyText(Constants.MimeType mimeType) {
        return "{//TODO \n return new HttpResponse(201, new Representation(content, \"" + mimeType.value() + "\"); }";
    }

    private String[] getUriParamTypes() {
        return GenericResourceGenerator.getUriParamTypes(this.bean);
    }

    public static String[] getUriParamTypes(GenericResourceBean genericResourceBean) {
        String string = String.class.getName();
        String[] stringArray = new String[genericResourceBean.getUriParams().length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string;
        }
        return stringArray;
    }

    private String[] getGetParamNames(List<ParameterInfo> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(this.bean.getUriParams()));
        arrayList.addAll(Arrays.asList(this.getParamNames(list)));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getGetParamTypes(List<ParameterInfo> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(this.getUriParamTypes()));
        arrayList.addAll(Arrays.asList(this.getParamTypeNames(list)));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private Object[] getParamAnnotationAttributes(int n) {
        int n2;
        String[] stringArray = this.bean.getUriParams();
        int n3 = stringArray.length;
        if (n < n3) {
            throw new IllegalArgumentException("allParamCount=" + n);
        }
        Object[] objectArray = new String[n];
        for (n2 = 0; n2 < n3; ++n2) {
            objectArray[n2] = stringArray[n2];
        }
        for (n2 = n3; n2 < n; ++n2) {
            objectArray[n2] = null;
        }
        return objectArray;
    }

    private String[] getParamAnnotations(int n) {
        int n2;
        int n3 = this.bean.getUriParams().length;
        if (n < n3) {
            throw new IllegalArgumentException("allParamCount=" + n);
        }
        String[] stringArray = new String[n];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = "PathParam";
        }
        for (n2 = n3; n2 < n; ++n2) {
            stringArray[n2] = null;
        }
        return stringArray;
    }

    private String[][] getGetParamAnnotations(List<ParameterInfo> list) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (String string : this.bean.getUriParams()) {
            arrayList.add(new String[]{"PathParam"});
        }
        String[] stringArray = null;
        for (ParameterInfo parameterInfo : list) {
            stringArray = parameterInfo.getDefaultValue() != null ? new String[]{"QueryParam", "DefaultValue"} : new String[]{"QueryParam"};
            arrayList.add(stringArray);
        }
        return (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
    }

    private Object[][] getGetParamAnnotationAttrs(List<ParameterInfo> list) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (String string : this.bean.getUriParams()) {
            arrayList.add(new Object[]{string});
        }
        Object[] objectArray = null;
        for (ParameterInfo parameterInfo : list) {
            objectArray = parameterInfo.getDefaultValue() != null ? new Object[]{parameterInfo.getName(), parameterInfo.getDefaultValue().toString()} : new Object[]{parameterInfo.getName()};
            arrayList.add(objectArray);
        }
        return (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
    }

    private String[] getPostPutParams() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.bean.getUriParams()));
        arrayList.add("content");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getPostPutParamTypes(String string) {
        String string2 = String.class.getName();
        String[] stringArray = new String[this.bean.getUriParams().length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string2;
        }
        stringArray[stringArray.length - 1] = string;
        return stringArray;
    }

    private String getMethodName(Constants.HttpMethodType httpMethodType, Constants.MimeType mimeType) {
        return httpMethodType.prefix() + mimeType.suffix();
    }

    public static String getNounForMethodName(Constants.HttpMethodType httpMethodType) {
        String string = httpMethodType.toString().toLowerCase();
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.setCharAt(0, Character.toUpperCase(string.charAt(0)));
        return stringBuilder.toString();
    }

    private String[] getParamNames(List<ParameterInfo> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ParameterInfo parameterInfo : list) {
            arrayList.add(parameterInfo.getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getParamTypeNames(List<ParameterInfo> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ParameterInfo parameterInfo : list) {
            arrayList.add(parameterInfo.getTypeName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private Object[] getParamValues(List<ParameterInfo> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ParameterInfo parameterInfo : list) {
            Object object = null;
            if (!parameterInfo.isQueryParam()) {
                object = parameterInfo.getDefaultValue();
            }
            arrayList.add(object);
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }
}

