/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.bridge;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.FileConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.bridge.ProjectBridge;
import org.netbeans.modules.cnd.discovery.wizard.checkedtree.AbstractRoot;
import org.netbeans.modules.cnd.discovery.wizard.checkedtree.UnusedFactory;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryProjectGenerator {
    private static boolean DEBUG = Boolean.getBoolean("cnd.discovery.trace.project_update");
    private ProjectBridge projectBridge;
    private DiscoveryDescriptor wizard;
    private String baseFolder;
    private String level;

    public DiscoveryProjectGenerator(DiscoveryDescriptor discoveryDescriptor) throws IOException {
        this.wizard = discoveryDescriptor;
        this.baseFolder = discoveryDescriptor.getRootFolder();
        Project project = discoveryDescriptor.getProject();
        this.projectBridge = project != null ? new ProjectBridge(project) : new ProjectBridge(this.baseFolder);
    }

    public void process() {
        List<ProjectConfiguration> list = this.wizard.getConfigurations();
        Folder folder = this.projectBridge.getRoot();
        this.level = this.wizard.getLevel();
        HashSet<Item> hashSet = new HashSet<Item>();
        for (ProjectConfiguration projectConfiguration : list) {
            this.setupCompilerConfiguration(projectConfiguration);
            this.addConfiguration(folder, projectConfiguration, hashSet);
        }
        this.addAdditional(folder, this.baseFolder, hashSet);
        if ("file".equals(this.level)) {
            this.upConfiguration(folder, true);
            this.upConfiguration(folder, false);
            this.downConfiguration(folder, true);
            this.downConfiguration(folder, false);
        }
        this.projectBridge.save();
    }

    private void downConfiguration(Folder folder, boolean bl) {
        CCCCompilerConfiguration cCCCompilerConfiguration = this.projectBridge.getFolderConfiguration(bl, folder);
        if (cCCCompilerConfiguration != null) {
            List list = cCCCompilerConfiguration.getIncludeDirectories().getValue();
            List list2 = cCCCompilerConfiguration.getPreprocessorConfiguration().getValue();
            this.projectBridge.setupProject(list, list2, bl);
            this.projectBridge.setupFolder(Collections.<String>emptyList(), true, Collections.<String>emptyList(), true, bl, folder);
            this.downConfiguration(folder, bl, list, list2);
        }
    }

    private void downConfiguration(Folder folder, boolean bl, List<String> list, List<String> list2) {
        for (Folder folder2 : folder.getFoldersAsArray()) {
            CCCCompilerConfiguration cCCCompilerConfiguration = this.projectBridge.getFolderConfiguration(bl, folder2);
            if (cCCCompilerConfiguration == null) continue;
            ArrayList<String> arrayList = new ArrayList<String>(list);
            ArrayList<String> arrayList2 = new ArrayList<String>(list2);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            for (String string : cCCCompilerConfiguration.getIncludeDirectories().getValue()) {
                if (arrayList.contains(string)) continue;
                arrayList3.add(string);
                arrayList.add(string);
            }
            for (String string : cCCCompilerConfiguration.getPreprocessorConfiguration().getValue()) {
                if (arrayList2.contains(string)) continue;
                arrayList4.add(string);
                arrayList2.add(string);
            }
            this.projectBridge.setupFolder(arrayList3, true, arrayList4, true, bl, folder2);
            this.downConfiguration(folder2, bl, arrayList, arrayList2);
        }
    }

    private Folder getOrCreateFolder(Folder folder, String string, AbstractRoot abstractRoot) {
        Folder folder2 = folder.findFolderByName(string);
        if (folder2 == null) {
            folder2 = this.projectBridge.createFolder(folder, string);
            folder.addFolder(folder2);
        } else if (folder2.isDiskFolder()) {
            String string2 = abstractRoot.getFolder();
            String string3 = IpeUtils.toAbsolutePath((String)folder.getConfigurationDescriptor().getBaseDir(), (String)folder2.getRootPath());
            Folder folder3 = null;
            if (!string2.equals(string3)) {
                for (Folder folder4 : folder.getFolders()) {
                    if (folder4.isDiskFolder()) {
                        string3 = IpeUtils.toAbsolutePath((String)folder.getConfigurationDescriptor().getBaseDir(), (String)folder4.getRootPath());
                        if (!string2.equals(string3)) continue;
                        folder2 = folder4;
                        break;
                    }
                    if (folder3 != null || !folder4.getName().equals(string)) continue;
                    folder3 = folder4;
                }
            }
            if (!string2.equals(string3)) {
                if (folder3 == null) {
                    folder2 = this.projectBridge.createFolder(folder, string);
                    folder.addFolder(folder2);
                } else {
                    folder2 = folder3;
                }
            }
        }
        return folder2;
    }

    private boolean upConfiguration(Folder folder, boolean bl) {
        CCCCompilerConfiguration cCCCompilerConfiguration;
        Item item;
        int n;
        Object object2;
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        boolean bl2 = false;
        for (Object object2 : folder.getFolders()) {
            CCCCompilerConfiguration cCCCompilerConfiguration2;
            if (!this.upConfiguration((Folder)object2, bl)) continue;
            if (!bl2) {
                cCCCompilerConfiguration2 = this.projectBridge.getFolderConfiguration(bl, (Folder)object2);
                if (cCCCompilerConfiguration2 == null) continue;
                hashSet.addAll(cCCCompilerConfiguration2.getIncludeDirectories().getValue());
                hashSet2.addAll(cCCCompilerConfiguration2.getPreprocessorConfiguration().getValue());
                bl2 = true;
                continue;
            }
            if (hashSet.size() > 0 && (cCCCompilerConfiguration2 = this.projectBridge.getFolderConfiguration(bl, (Folder)object2)) != null) {
                hashSet.retainAll(cCCCompilerConfiguration2.getIncludeDirectories().getValue());
            }
            if (hashSet2.size() <= 0 || (cCCCompilerConfiguration2 = this.projectBridge.getFolderConfiguration(bl, (Folder)object2)) == null) continue;
            hashSet2.retainAll(cCCCompilerConfiguration2.getPreprocessorConfiguration().getValue());
        }
        HashSet hashSet3 = new HashSet();
        object2 = new HashSet();
        boolean bl3 = true;
        if (bl2) {
            hashSet3 = new HashSet(hashSet);
            object2 = new HashSet(hashSet2);
            bl3 = false;
        }
        CCCCompilerConfiguration cCCCompilerConfiguration3 = folder.getItemsAsArray();
        int n2 = ((Item[])cCCCompilerConfiguration3).length;
        for (n = 0; n < n2; ++n) {
            item = cCCCompilerConfiguration3[n];
            if (item.isExcluded()) continue;
            cCCCompilerConfiguration = this.projectBridge.getItemConfiguration(item);
            if (!bl ? !(cCCCompilerConfiguration instanceof CCompilerConfiguration) : !(cCCCompilerConfiguration instanceof CCCompilerConfiguration)) continue;
            if (bl3) {
                hashSet3.addAll(cCCCompilerConfiguration.getIncludeDirectories().getValue());
                object2.addAll(cCCCompilerConfiguration.getPreprocessorConfiguration().getValue());
                bl3 = false;
                continue;
            }
            if (hashSet3.size() > 0) {
                hashSet3.retainAll(cCCCompilerConfiguration.getIncludeDirectories().getValue());
            }
            if (object2.size() <= 0) continue;
            object2.retainAll(cCCCompilerConfiguration.getPreprocessorConfiguration().getValue());
        }
        if (hashSet3.size() > 0 || object2.size() > 0) {
            cCCCompilerConfiguration3 = folder.getItemsAsArray();
            n2 = ((Item[])cCCCompilerConfiguration3).length;
            for (n = 0; n < n2; ++n) {
                ArrayList arrayList;
                item = cCCCompilerConfiguration3[n];
                cCCCompilerConfiguration = this.projectBridge.getItemConfiguration(item);
                if (!bl ? !(cCCCompilerConfiguration instanceof CCompilerConfiguration) : !(cCCCompilerConfiguration instanceof CCCompilerConfiguration)) continue;
                if (hashSet3.size() > 0) {
                    arrayList = new ArrayList(cCCCompilerConfiguration.getIncludeDirectories().getValue());
                    arrayList.removeAll(hashSet3);
                    cCCCompilerConfiguration.getIncludeDirectories().setValue(arrayList);
                }
                if (object2.size() <= 0) continue;
                arrayList = new ArrayList(cCCCompilerConfiguration.getPreprocessorConfiguration().getValue());
                arrayList.removeAll((Collection<?>)object2);
                cCCCompilerConfiguration.getPreprocessorConfiguration().setValue(arrayList);
            }
        }
        if (hashSet3.size() > 0 && (cCCCompilerConfiguration3 = this.projectBridge.getFolderConfiguration(bl, folder)) != null) {
            cCCCompilerConfiguration3.getIncludeDirectories().setValue(new ArrayList(hashSet3));
        }
        if (object2.size() > 0 && (cCCCompilerConfiguration3 = this.projectBridge.getFolderConfiguration(bl, folder)) != null) {
            cCCCompilerConfiguration3.getPreprocessorConfiguration().setValue(new ArrayList(object2));
        }
        return !bl3;
    }

    public Set makeProject() {
        if (this.projectBridge.isValid()) {
            this.process();
            return this.projectBridge.getResult();
        }
        return Collections.emptySet();
    }

    private Set<String> getSourceFolders() {
        HashSet<String> hashSet = new HashSet<String>();
        List<ProjectConfiguration> list = this.wizard.getConfigurations();
        for (ProjectConfiguration projectConfiguration : list) {
            for (FileConfiguration fileConfiguration : projectConfiguration.getFiles()) {
                int n;
                String string = fileConfiguration.getFilePath();
                if (Utilities.isWindows()) {
                    string = string.replace('\\', '/');
                }
                if ((n = string.lastIndexOf(47)) > 0) {
                    string = string.substring(0, n + 1);
                }
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private Map<String, Folder> prefferedFolders() {
        HashMap<String, Folder> hashMap = new HashMap<String, Folder>();
        for (Item item : this.projectBridge.getAllSources()) {
            int n;
            String string = item.getAbsPath();
            if (Utilities.isWindows()) {
                string = string.replace('\\', '/');
            }
            if (string.indexOf("/../") >= 0 || string.indexOf("/./") >= 0) {
                string = CndFileUtils.normalizeFile((File)new File(string)).getAbsolutePath();
            }
            if ((n = string.lastIndexOf(47)) < 0) continue;
            String string2 = string.substring(0, n);
            hashMap.put(string2, item.getFolder());
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    private void addAdditional(Folder folder, String string, Set<Item> set) {
        List<ProjectConfiguration> list;
        Object object;
        Set<String> set2 = this.getSourceFolders();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        HashSet<String> hashSet4 = new HashSet<String>();
        List<String> list2 = this.wizard.getIncludedFiles();
        Map<String, Folder> map = this.prefferedFolders();
        for (String hashSet5 : list2) {
            hashSet2.add(hashSet5);
            String string2 = this.projectBridge.getRelativepath(hashSet5);
            Item item = this.projectBridge.getProjectItem(string2);
            if (item == null) {
                String string3;
                int n;
                void var12_18;
                String string4 = hashSet5;
                if (Utilities.isWindows()) {
                    String string5 = string4.replace('\\', '/');
                }
                boolean bl = false;
                if (var12_18.startsWith(string)) {
                    bl = true;
                } else {
                    for (String string6 : set2) {
                        if (!var12_18.startsWith(string6)) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl && (n = var12_18.lastIndexOf(47)) >= 0 && (object = map.get(string3 = var12_18.substring(0, n))) != null) {
                    Item item3 = this.projectBridge.createItem(hashSet5);
                    item3 = object.addItem(item3);
                    if (!MIMENames.isCppOrC((String)item3.getMIMEType())) {
                        hashSet4.add((String)var12_18);
                    }
                    bl = false;
                }
                if (!bl) continue;
                hashSet4.add((String)var12_18);
                hashSet3.add(hashSet5);
                continue;
            }
            if (!set.contains(item)) {
                ProjectBridge.setExclude(item, false);
                this.projectBridge.setHeaderTool(item);
                continue;
            }
            if (MIMENames.isCppOrC((String)item.getMIMEType())) continue;
            hashSet4.add(string2);
        }
        if (hashSet3.size() > 0) {
            list = UnusedFactory.createRoot(hashSet3);
            this.addAdditionalFolder(folder, (AbstractRoot)((Object)list));
        }
        list = this.wizard.getConfigurations();
        for (ProjectConfiguration projectConfiguration : list) {
            for (FileConfiguration fileConfiguration : projectConfiguration.getFiles()) {
                hashSet2.add(fileConfiguration.getFilePath());
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string7 : hashSet2) {
            hashSet.add(this.projectBridge.getRelativepath(string7));
        }
        TreeMap<String, Item> treeMap = new TreeMap<String, Item>();
        for (Item item : this.projectBridge.getAllSources()) {
            if (set.contains(item)) continue;
            treeMap.put(item.getPath(), item);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            String string8 = (String)entry.getKey();
            Item item = (Item)entry.getValue();
            object = item.getNormalizedFile().getAbsolutePath();
            if (hashSet.contains(string8) || hashSet2.contains(string8) || hashSet.contains(object) || hashSet2.contains(object)) continue;
            if (DEBUG) {
                System.out.println("Exclude Item " + string8);
            }
            ProjectBridge.setExclude(item, true);
        }
        if (hashSet4.size() > 0) {
            this.projectBridge.checkForNewExtensions(hashSet4);
        }
    }

    private void addAdditionalFolder(Folder folder, AbstractRoot abstractRoot) {
        String string = abstractRoot.getName();
        Folder folder2 = this.getOrCreateFolder(folder, string, abstractRoot);
        if (folder2 == null) {
            folder2 = this.projectBridge.createFolder(folder, string);
            folder.addFolder(folder2);
        }
        for (AbstractRoot object : abstractRoot.getChildren()) {
            this.addAdditionalFolder(folder2, object);
        }
        List<String> list = abstractRoot.getFiles();
        if (list != null) {
            for (String string2 : list) {
                String string3 = this.projectBridge.getRelativepath(string2);
                Item item = this.projectBridge.getProjectItem(string3);
                if (item != null) {
                    if (item.getFolder() != folder2) {
                        Object object = this.projectBridge.getAuxObject(item);
                        item.getFolder().removeItem(item);
                        item = folder2.addItem(item);
                        if (object != null) {
                            this.projectBridge.setAuxObject(item, object);
                        }
                    }
                    ProjectBridge.setExclude(item, false);
                    this.projectBridge.setHeaderTool(item);
                    continue;
                }
                item = this.projectBridge.createItem(string2);
                item = folder2.addItem(item);
                ProjectBridge.setExclude(item, false);
                this.projectBridge.setHeaderTool(item);
            }
        }
    }

    private void setupCompilerConfiguration(ProjectConfiguration projectConfiguration) {
        if ("project".equals(this.level)) {
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (FileConfiguration object2 : projectConfiguration.getFiles()) {
                this.reConsolidatePaths(hashSet, object2);
                hashMap.putAll(object2.getUserMacros());
            }
            ArrayList arrayList = new ArrayList(hashSet);
            List<String> list = this.buildMacrosString(hashMap);
            this.projectBridge.setupProject(arrayList, list, projectConfiguration.getLanguageKind() == ItemProperties.LanguageKind.CPP);
        } else {
            List<String> list = Collections.emptyList();
            List<String> list2 = Collections.emptyList();
            this.projectBridge.setupProject(list, list2, projectConfiguration.getLanguageKind() == ItemProperties.LanguageKind.CPP);
        }
    }

    private List<String> buildMacrosString(Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() != null) {
                arrayList.add(entry.getKey() + "=" + entry.getValue());
                continue;
            }
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    private void setupFile(FileConfiguration fileConfiguration, Item item, boolean bl) {
        this.projectBridge.setSourceTool(item, bl);
        if ("file".equals(this.level)) {
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            this.reConsolidatePaths(hashSet, fileConfiguration);
            hashMap.putAll(fileConfiguration.getUserMacros());
            ArrayList<String> arrayList = new ArrayList<String>(hashSet);
            List<String> list = this.buildMacrosString(hashMap);
            this.projectBridge.setupFile(fileConfiguration.getCompilePath(), arrayList, !fileConfiguration.overrideIncludes(), list, !fileConfiguration.overrideMacros(), item);
        } else {
            List<String> list = Collections.emptyList();
            List<String> list2 = Collections.emptyList();
            this.projectBridge.setupFile(fileConfiguration.getCompilePath(), list, true, list2, true, item);
        }
    }

    private void reConsolidatePaths(Set<String> set, FileConfiguration fileConfiguration) {
        String string = fileConfiguration.getCompilePath();
        for (String string2 : fileConfiguration.getUserInludePaths()) {
            if (!(string2.startsWith("/") || string2.length() > 1 && string2.charAt(1) == ':')) {
                string2 = string2.equals(".") ? string : string + File.separator + string2;
                File file = new File(string2);
                string2 = CndFileUtils.normalizeFile((File)file).getAbsolutePath();
            }
            set.add(this.projectBridge.getRelativepath(string2));
        }
        if (this.isDifferentCompilePath(fileConfiguration.getFilePath(), string)) {
            set.add(this.projectBridge.getRelativepath(string));
        }
    }

    private boolean isDifferentCompilePath(String string, String string2) {
        int n;
        if (Utilities.isWindows()) {
            string = string.replace('\\', '/');
        }
        return (n = string.lastIndexOf(47)) > 0 && !(string = string.substring(0, n)).equals(string2);
    }

    private void addConfiguration(Folder folder, ProjectConfiguration projectConfiguration, Set<Item> set) {
        Object object;
        Object object2;
        Object object32;
        Object object5;
        boolean bl = projectConfiguration.getLanguageKind() == ItemProperties.LanguageKind.CPP;
        Map<String, Set<Pair>> map = this.analyzeConfigurationStructure(projectConfiguration.getFiles(), bl);
        List<Pair> list = this.detectOrphan(map, bl);
        if (list.size() > 0) {
            this.createOrphan(folder, list, bl);
        }
        if ("folder".equals(this.level)) {
            Collection<Object> collection;
            object5 = new HashMap();
            for (Map.Entry<String, Set<Pair>> entry : map.entrySet()) {
                object32 = entry.getValue();
                for (Object object4 : object32) {
                    if (((Pair)object4).item != null) {
                        object2 = ((Pair)object4).item.getFolder();
                        collection = (Set)object5.get(object2);
                        if (collection == null) {
                            collection = new HashSet<FileConfiguration>();
                            object5.put(object2, collection);
                        }
                        collection.add(((Pair)object4).fileConfiguration);
                        continue;
                    }
                    if (!DEBUG) continue;
                    System.err.println("Cannot find pair by path " + ((Pair)object4).fileConfiguration.getFilePath());
                }
            }
            for (Map.Entry entry : object5.entrySet()) {
                Object object6;
                Object object4;
                object32 = (Folder)entry.getKey();
                object = (Set)entry.getValue();
                object4 = new HashSet();
                object2 = new HashMap();
                collection = object.iterator();
                while (collection.hasNext()) {
                    object6 = (FileConfiguration)collection.next();
                    this.reConsolidatePaths((Set<String>)object4, (FileConfiguration)object6);
                    object2.putAll(object6.getUserMacros());
                }
                collection = this.buildMacrosString((Map<String, String>)object2);
                object6 = new ArrayList(object4);
                this.projectBridge.setupFolder((List<String>)object6, false, (List<String>)collection, false, projectConfiguration.getLanguageKind() == ItemProperties.LanguageKind.CPP, (Folder)object32);
            }
        } else {
            object5 = new HashSet();
            for (Map.Entry<String, Set<Pair>> entry : map.entrySet()) {
                object32 = entry.getValue();
                for (Object object4 : object32) {
                    if (((Pair)object4).item == null) continue;
                    object2 = ((Pair)object4).item.getFolder();
                    object5.add(object2);
                }
            }
            Iterator iterator = object5.iterator();
            while (iterator.hasNext()) {
                Folder folder2 = (Folder)iterator.next();
                object32 = Collections.emptyList();
                object = Collections.emptyList();
                this.projectBridge.setupFolder((List<String>)object, true, (List<String>)object32, true, projectConfiguration.getLanguageKind() == ItemProperties.LanguageKind.CPP, folder2);
            }
        }
        for (Set set2 : map.values()) {
            for (Object object32 : set2) {
                if (((Pair)object32).item == null) continue;
                set.add(((Pair)object32).item);
            }
        }
    }

    private void createOrphan(Folder folder, List<Pair> list, boolean bl) {
        HashMap<String, Pair> hashMap = new HashMap<String, Pair>();
        for (Pair pair : list) {
            String string = pair.fileConfiguration.getFilePath();
            hashMap.put(string, pair);
        }
        AbstractRoot abstractRoot = UnusedFactory.createRoot(hashMap.keySet());
        this.addFolder(folder, abstractRoot, hashMap, bl);
    }

    private void addFolder(Folder folder, AbstractRoot abstractRoot, Map<String, Pair> map, boolean bl) {
        String string = abstractRoot.getName();
        Folder folder2 = this.getOrCreateFolder(folder, string, abstractRoot);
        for (AbstractRoot object : abstractRoot.getChildren()) {
            this.addFolder(folder2, object, map, bl);
        }
        for (String string2 : abstractRoot.getFiles()) {
            Pair pair = map.get(string2);
            if (pair != null) {
                String string3 = this.projectBridge.getRelativepath(string2);
                Item item = this.projectBridge.getProjectItem(string3);
                if (item == null) {
                    item = this.projectBridge.createItem(string2);
                    folder2.addItem(item);
                } else if (DEBUG) {
                    System.err.println("Orphan pair found by path " + string2);
                }
                pair.item = item;
                this.setupFile(pair.fileConfiguration, pair.item, bl);
                continue;
            }
            if (!DEBUG) continue;
            System.err.println("Cannot find pair by path " + string2);
        }
    }

    private List<Pair> detectOrphan(Map<String, Set<Pair>> map, boolean bl) {
        Map<String, Folder> map2 = this.prefferedFolders();
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        for (Map.Entry<String, Set<Pair>> entry : map.entrySet()) {
            String string;
            Object object;
            Set<Pair> set = entry.getValue();
            Folder folder = null;
            ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
            for (Pair pair : set) {
                int n;
                object = pair.item;
                if (object != null) {
                    if (folder == null) continue;
                    folder = object.getFolder();
                    continue;
                }
                string = pair.fileConfiguration.getFilePath();
                if (Utilities.isWindows()) {
                    string = string.replace('\\', '/');
                }
                if ((n = string.lastIndexOf(47)) >= 0) {
                    string = string.substring(0, n);
                    folder = map2.get(string);
                }
                arrayList2.add(pair);
            }
            if (folder != null) {
                for (Pair pair : arrayList2) {
                    object = this.projectBridge.getRelativepath(pair.fileConfiguration.getFilePath());
                    string = this.projectBridge.getProjectItem((String)object);
                    if (string == null) {
                        string = this.projectBridge.createItem(pair.fileConfiguration.getFilePath());
                        pair.item = (Item)string;
                        folder.addItem((Item)string);
                    }
                    this.setupFile(pair.fileConfiguration, (Item)string, bl);
                }
                continue;
            }
            for (Pair pair : arrayList2) {
                arrayList.add(pair);
            }
        }
        return arrayList;
    }

    private Map<String, Set<Pair>> analyzeConfigurationStructure(List<FileConfiguration> list, boolean bl) {
        HashMap<String, Set<Pair>> hashMap = new HashMap<String, Set<Pair>>();
        for (FileConfiguration fileConfiguration : list) {
            String string;
            Item item;
            int n;
            String string2 = fileConfiguration.getFilePath();
            if (Utilities.isWindows()) {
                string2 = string2.replace('\\', '/');
            }
            if ((n = string2.lastIndexOf(47)) < 0) continue;
            String string3 = string2.substring(0, n);
            HashSet<Pair> hashSet = (HashSet<Pair>)hashMap.get(string3);
            if (hashSet == null) {
                hashSet = new HashSet<Pair>();
                hashMap.put(string3, hashSet);
            }
            if ((item = this.projectBridge.getProjectItem(string = this.projectBridge.getRelativepath(string2))) != null) {
                this.setupFile(fileConfiguration, item, bl);
            }
            hashSet.add(new Pair(fileConfiguration, item));
        }
        return hashMap;
    }

    private static class Pair {
        private FileConfiguration fileConfiguration;
        private Item item;

        private Pair(FileConfiguration fileConfiguration, Item item) {
            this.fileConfiguration = fileConfiguration;
            this.item = item;
        }
    }
}

