/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.QmakeConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QtInfoProvider {
    private static final QtInfoProvider DEFAULT = new Default();

    private QtInfoProvider() {
    }

    public static QtInfoProvider getDefault() {
        return DEFAULT;
    }

    public abstract List<String> getQtIncludeDirectories(MakeConfiguration var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Default
    extends QtInfoProvider {
        private static final String FAKE_DIR = "FAKE_DIR";
        private final Map<String, String> cache = new HashMap<String, String>();

        private Default() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> getQtIncludeDirectories(MakeConfiguration makeConfiguration) {
            String string;
            Object object = this.cache;
            synchronized (object) {
                string = this.cache.get(makeConfiguration.getDevelopmentHost().getHostKey());
                if (string == null) {
                    string = this.queryQtIncludeDir(makeConfiguration);
                    this.cache.put(makeConfiguration.getDevelopmentHost().getHostKey(), string);
                }
            }
            if (string != null && !string.equals(FAKE_DIR)) {
                String string2;
                object = new ArrayList();
                object.add(string);
                QmakeConfiguration qmakeConfiguration = makeConfiguration.getQmakeConfiguration();
                if (qmakeConfiguration.isCoreEnabled().getValue()) {
                    object.add(string + File.separator + "QtCore");
                }
                if (qmakeConfiguration.isGuiEnabled().getValue()) {
                    object.add(string + File.separator + "QtGui");
                }
                if (qmakeConfiguration.isNetworkEnabled().getValue()) {
                    object.add(string + File.separator + "QtNetwork");
                }
                if (qmakeConfiguration.isOpenglEnabled().getValue()) {
                    object.add(string + File.separator + "QtOpenGL");
                }
                if (qmakeConfiguration.isPhononEnabled().getValue()) {
                    object.add(string + File.separator + "phonon");
                }
                if (qmakeConfiguration.isQt3SupportEnabled().getValue()) {
                    object.add(string + File.separator + "Qt3Support");
                }
                if (qmakeConfiguration.isSqlEnabled().getValue()) {
                    object.add(string + File.separator + "QtSql");
                }
                if (qmakeConfiguration.isSvgEnabled().getValue()) {
                    object.add(string + File.separator + "QtSvq");
                }
                if (qmakeConfiguration.isXmlEnabled().getValue()) {
                    object.add(string + File.separator + "QtXml");
                }
                if (qmakeConfiguration.isWebkitEnabled().getValue()) {
                    object.add(string + File.separator + "QtWebKit");
                }
                if (IpeUtils.isPathAbsolute((String)(string2 = qmakeConfiguration.getUiDir().getValue()))) {
                    object.add(string2);
                } else {
                    object.add(makeConfiguration.getBaseDir() + File.separator + string2);
                }
                return object;
            }
            return Collections.emptyList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String queryQtIncludeDir(MakeConfiguration makeConfiguration) {
            if (!makeConfiguration.getDevelopmentHost().getExecutionEnvironment().isLocal()) return FAKE_DIR;
            try {
                Process process = Runtime.getRuntime().exec("qmake -query QT_INSTALL_HEADERS");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    String string = bufferedReader.readLine().trim();
                    if (0 >= string.length()) return FAKE_DIR;
                    String string2 = string;
                    return string2;
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return FAKE_DIR;
        }
    }
}

