/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenList {
    private CompilationInfo info;
    private SourcePositions sourcePositions;
    private Document doc;
    private AtomicBoolean cancel;
    private boolean topLevelIsJava;
    private TokenSequence topLevel;
    private TokenSequence ts;

    public TokenList(CompilationInfo compilationInfo, final Document document, AtomicBoolean atomicBoolean) {
        this.info = compilationInfo;
        this.doc = document;
        this.cancel = atomicBoolean;
        this.sourcePositions = compilationInfo.getTrees().getSourcePositions();
        document.render(new Runnable(){

            public void run() {
                if (TokenList.this.cancel.get()) {
                    return;
                }
                TokenList.this.topLevel = TokenHierarchy.get((Document)document).tokenSequence();
                TokenList.this.topLevelIsJava = TokenList.this.topLevel.language() == JavaTokenId.language();
                if (TokenList.this.topLevelIsJava) {
                    TokenList.this.ts = TokenList.this.topLevel;
                    TokenList.this.ts.moveStart();
                    TokenList.this.ts.moveNext();
                }
            }
        });
    }

    public void moveToOffset(long l) {
        final int n = this.info.getPositionConverter().getOriginalPosition((int)l);
        if (n < 0) {
            return;
        }
        this.doc.render(new Runnable(){

            public void run() {
                if (TokenList.this.cancel.get()) {
                    return;
                }
                if (TokenList.this.ts != null && !TokenList.this.ts.isValid()) {
                    TokenList.this.cancel.set(true);
                    return;
                }
                if (TokenList.this.topLevelIsJava) {
                    while (TokenList.this.ts.offset() < n) {
                        if (TokenList.this.ts.moveNext()) continue;
                        return;
                    }
                } else {
                    Object object;
                    Iterator iterator = null;
                    if (TokenList.this.ts == null) {
                        object = new ArrayList(TokenList.embeddedTokenSequences((TokenHierarchy<Document>)TokenHierarchy.get((Document)TokenList.this.doc), n));
                        Collections.reverse(object);
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            TokenSequence tokenSequence = (TokenSequence)iterator.next();
                            if (tokenSequence.language() != JavaTokenId.language()) continue;
                            TokenList.this.ts = tokenSequence;
                            break;
                        }
                    }
                    block2: while (TokenList.this.ts != null && TokenList.this.ts.offset() < n) {
                        if (TokenList.this.ts.moveNext()) continue;
                        TokenList.this.ts = null;
                        if (iterator == null) {
                            object = new ArrayList(TokenList.embeddedTokenSequences((TokenHierarchy<Document>)TokenHierarchy.get((Document)TokenList.this.doc), n));
                            Collections.reverse(object);
                            iterator = object.iterator();
                        }
                        while (iterator.hasNext()) {
                            object = (TokenSequence)iterator.next();
                            if (object.language() != JavaTokenId.language()) continue;
                            TokenList.this.ts = (TokenSequence)object;
                            continue block2;
                        }
                    }
                }
            }
        });
    }

    public void moveToEnd(Tree tree) {
        if (tree == null) {
            return;
        }
        long l = this.sourcePositions.getEndPosition(this.info.getCompilationUnit(), tree);
        if (l == -1L) {
            return;
        }
        if (tree.getKind() == Tree.Kind.ARRAY_TYPE) {
            this.moveToEnd(((ArrayTypeTree)tree).getType());
            return;
        }
        this.moveToOffset(l);
    }

    public void moveToEnd(Collection<? extends Tree> collection) {
        if (collection == null) {
            return;
        }
        for (Tree tree : collection) {
            this.moveToEnd(tree);
        }
    }

    public void firstIdentifier(final TreePath treePath, final String string, final Map<Tree, Token> map) {
        this.doc.render(new Runnable(){

            public void run() {
                if (TokenList.this.cancel.get()) {
                    return;
                }
                if (TokenList.this.ts != null && !TokenList.this.ts.isValid()) {
                    TokenList.this.cancel.set(true);
                    return;
                }
                if (TokenList.this.ts == null) {
                    return;
                }
                boolean bl = true;
                while (TokenList.this.ts.token().id() != JavaTokenId.IDENTIFIER && (bl = TokenList.this.ts.moveNext())) {
                }
                if (bl && string.equals(((Object)TokenList.this.ts.token().text()).toString())) {
                    map.put(treePath.getLeaf(), TokenList.this.ts.token());
                }
            }
        });
    }

    public void identifierHere(final IdentifierTree identifierTree, final Map<Tree, Token> map) {
        this.doc.render(new Runnable(){

            public void run() {
                if (TokenList.this.cancel.get()) {
                    return;
                }
                if (TokenList.this.ts != null && !TokenList.this.ts.isValid()) {
                    TokenList.this.cancel.set(true);
                    return;
                }
                if (TokenList.this.ts == null) {
                    return;
                }
                Token token = TokenList.this.ts.token();
                if (token.id() == JavaTokenId.IDENTIFIER && identifierTree.getName().toString().equals(((Object)token.text()).toString())) {
                    map.put(identifierTree, TokenList.this.ts.token());
                }
            }
        });
    }

    public void moveBefore(final List<? extends Tree> list) {
        this.doc.render(new Runnable(){

            public void run() {
                if (TokenList.this.cancel.get()) {
                    return;
                }
                if (TokenList.this.ts != null && !TokenList.this.ts.isValid()) {
                    TokenList.this.cancel.set(true);
                    return;
                }
                if (TokenList.this.ts == null) {
                    return;
                }
                if (!list.isEmpty()) {
                    int n = (int)TokenList.this.info.getTrees().getSourcePositions().getStartPosition(TokenList.this.info.getCompilationUnit(), (Tree)list.get(0));
                    n = TokenList.this.info.getPositionConverter().getOriginalPosition(n);
                    if (n < 0) {
                        return;
                    }
                    while (TokenList.this.ts.offset() >= n) {
                        if (TokenList.this.ts.movePrevious()) continue;
                        return;
                    }
                }
            }
        });
    }

    public void moveNext() {
        this.doc.render(new Runnable(){

            public void run() {
                if (TokenList.this.cancel.get()) {
                    return;
                }
                if (TokenList.this.ts != null && !TokenList.this.ts.isValid()) {
                    TokenList.this.cancel.set(true);
                    return;
                }
                if (TokenList.this.ts == null) {
                    return;
                }
                TokenList.this.ts.moveNext();
            }
        });
    }

    private static List<TokenSequence<?>> embeddedTokenSequences(TokenHierarchy<Document> tokenHierarchy, int n) {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        ArrayList arrayList = new ArrayList();
        do {
            TokenSequence tokenSequence2 = tokenSequence;
            tokenSequence = null;
            tokenSequence2.move(n);
            if (!tokenSequence2.moveNext()) continue;
            arrayList.add(tokenSequence2);
            tokenSequence = tokenSequence2.embedded();
        } while (tokenSequence != null);
        return arrayList;
    }
}

