/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreakNode
extends Node {
    private final Node valueNode;

    public BreakNode(ISourcePosition iSourcePosition, Node node) {
        super(iSourcePosition, NodeType.BREAKNODE);
        assert (node != null) : "valueNode is not null";
        this.valueNode = node;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitBreakNode(this);
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    @Override
    public List<Node> childNodes() {
        return BreakNode.createList(this.valueNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = this.valueNode.interpret(ruby, threadContext, iRubyObject, block);
        return RuntimeHelpers.breakJump(threadContext, iRubyObject2);
    }
}

