/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.tools.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.CancellationException;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.tools.ProcDataProviderConfiguration;
import org.netbeans.modules.dlight.tools.impl.ProcDataProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

public class ProcDataProviderSolaris
implements ProcDataProvider.Engine {
    private final ProcDataProvider provider;
    private final int cpuCount;
    private final ServiceInfoDataStorage serviceInfoStorage;

    public ProcDataProviderSolaris(ProcDataProvider procDataProvider, ServiceInfoDataStorage serviceInfoDataStorage, ExecutionEnvironment executionEnvironment) {
        this.provider = procDataProvider;
        this.serviceInfoStorage = serviceInfoDataStorage;
        int n = 1;
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment);
            n = hostInfo.getCpuNum();
        }
        catch (IOException iOException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        this.cpuCount = n;
    }

    public String getCommand(int n) {
        return "while od -v -t x4 -N 64 /proc/" + n + "/usage && ls /proc/" + n + "/lwp | wc -l; do sleep 1; done";
    }

    public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
        return InputProcessors.bridge((LineProcessor)new SolarisProcLineProcessor());
    }

    private static long parseHex(String string) {
        return Long.parseLong(string, 16);
    }

    private static double time(long l, long l2) {
        return (double)l + (double)l2 / 1.0E9;
    }

    private static float percent(double d, double d2) {
        if (0.0 < d2) {
            if (d <= 0.0) {
                return 0.0f;
            }
            if (d2 <= d) {
                return 100.0f;
            }
            return (float)(100.0 * d / d2);
        }
        return 0.0f;
    }

    private class SolarisProcLineProcessor
    implements LineProcessor {
        private double prevTime;
        private double currTime;
        private double prevUsrTime;
        private double currUsrTime;
        private double prevSysTime;
        private double currSysTime;

        private SolarisProcLineProcessor() {
        }

        public void processLine(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            try {
                String string2 = stringTokenizer.nextToken();
                if ("0000000".equals(string2)) {
                    this.prevTime = this.currTime;
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    long l = ProcDataProviderSolaris.parseHex(stringTokenizer.nextToken());
                    long l2 = ProcDataProviderSolaris.parseHex(stringTokenizer.nextToken());
                    this.currTime = ProcDataProviderSolaris.time(l, l2);
                } else if ("0000040".equals(string2)) {
                    this.prevUsrTime = this.currUsrTime;
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    long l = ProcDataProviderSolaris.parseHex(stringTokenizer.nextToken());
                    long l3 = ProcDataProviderSolaris.parseHex(stringTokenizer.nextToken());
                    this.currUsrTime = ProcDataProviderSolaris.time(l, l3);
                } else if ("0000060".equals(string2)) {
                    this.prevSysTime = this.currSysTime;
                    long l = ProcDataProviderSolaris.parseHex(stringTokenizer.nextToken());
                    long l4 = ProcDataProviderSolaris.parseHex(stringTokenizer.nextToken());
                    this.currSysTime = ProcDataProviderSolaris.time(l, l4);
                } else if (string2.length() < 7 && !stringTokenizer.hasMoreTokens()) {
                    int n = Integer.parseInt(string2);
                    if (0.0 < this.prevTime) {
                        double d = (this.currTime - this.prevTime) * (double)ProcDataProviderSolaris.this.cpuCount;
                        float f = ProcDataProviderSolaris.percent(this.currUsrTime - this.prevUsrTime, d);
                        float f2 = ProcDataProviderSolaris.percent(this.currSysTime - this.prevSysTime, d);
                        DataRow dataRow = new DataRow(Arrays.asList(ProcDataProviderConfiguration.USR_TIME.getColumnName(), ProcDataProviderConfiguration.SYS_TIME.getColumnName(), ProcDataProviderConfiguration.THREADS.getColumnName()), Arrays.asList(Float.valueOf(f), Float.valueOf(f2), n));
                        ProcDataProviderSolaris.this.provider.notifyIndicators(dataRow);
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void reset() {
        }

        public void close() {
        }
    }
}

