/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.tools.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.tools.ProcDataProviderConfiguration;
import org.netbeans.modules.dlight.tools.impl.ProcDataProviderLinux;
import org.netbeans.modules.dlight.tools.impl.ProcDataProviderSolaris;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcDataProvider
extends IndicatorDataProvider<ProcDataProviderConfiguration> {
    private static final String NAME = "ProcReader";
    private static final DataTableMetadata TABLE = new DataTableMetadata("ProcReader", Arrays.asList(ProcDataProviderConfiguration.SYS_TIME, ProcDataProviderConfiguration.USR_TIME, ProcDataProviderConfiguration.THREADS), null);
    private List<ValidationListener> validationListeners = new CopyOnWriteArrayList<ValidationListener>();
    private ValidationStatus validationStatus = ValidationStatus.initialStatus();
    private Future<Integer> procReaderTask;

    public ProcDataProvider(ProcDataProviderConfiguration procDataProviderConfiguration) {
    }

    public Collection<DataTableMetadata> getDataTablesMetadata() {
        return Collections.singletonList(TABLE);
    }

    public String getName() {
        return NAME;
    }

    public void targetStateChanged(DLightTargetChangeEvent dLightTargetChangeEvent) {
        switch (dLightTargetChangeEvent.state) {
            case RUNNING: {
                this.targetStarted(dLightTargetChangeEvent.target);
                break;
            }
            case DONE: 
            case FAILED: 
            case STOPPED: 
            case TERMINATED: {
                this.targetFinished(dLightTargetChangeEvent.target);
            }
        }
    }

    public synchronized ValidationStatus validate(DLightTarget dLightTarget) {
        if (this.validationStatus.isValid()) {
            return this.validationStatus;
        }
        ValidationStatus validationStatus = this.validationStatus;
        ValidationStatus validationStatus2 = this.doValidation(dLightTarget);
        this.notifyStatusChanged(validationStatus, validationStatus2);
        this.validationStatus = validationStatus2;
        return validationStatus2;
    }

    private ValidationStatus doValidation(DLightTarget dLightTarget) {
        ExecutionEnvironment executionEnvironment = dLightTarget.getExecEnv();
        if (!ConnectionManager.getInstance().isConnectedTo(executionEnvironment)) {
            AsynchronousAction asynchronousAction = ConnectionManager.getInstance().getConnectToAction(executionEnvironment, new Runnable(){

                public void run() {
                    DLightManager.getDefault().revalidateSessions();
                }
            });
            return ValidationStatus.unknownStatus((String)ProcDataProvider.getMessage("ValidationStatus.HostNotConnected"), (AsynchronousAction)asynchronousAction);
        }
        HostInfo.OSFamily oSFamily = HostInfo.OSFamily.UNKNOWN;
        try {
            oSFamily = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment).getOSFamily();
        }
        catch (IOException iOException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        if (oSFamily != HostInfo.OSFamily.LINUX && oSFamily != HostInfo.OSFamily.SUNOS) {
            return ValidationStatus.invalidStatus((String)ProcDataProvider.getMessage("ValidationStatus.ProcReader.OSNotSupported"));
        }
        try {
            if (!HostInfoUtils.fileExists((ExecutionEnvironment)executionEnvironment, (String)"/proc")) {
                return ValidationStatus.invalidStatus((String)ProcDataProvider.getMessage("ValidationStatus.ProcNotFound"));
            }
        }
        catch (IOException iOException) {
            return ValidationStatus.invalidStatus((String)iOException.getMessage());
        }
        return ValidationStatus.validStatus();
    }

    public synchronized void invalidate() {
        this.validationStatus = ValidationStatus.initialStatus();
    }

    public synchronized ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public void addValidationListener(ValidationListener validationListener) {
        if (!this.validationListeners.contains(validationListener)) {
            this.validationListeners.add(validationListener);
        }
    }

    public void removeValidationListener(ValidationListener validationListener) {
        this.validationListeners.remove(validationListener);
    }

    private void notifyStatusChanged(ValidationStatus validationStatus, ValidationStatus validationStatus2) {
        if (validationStatus.equals((Object)validationStatus2)) {
            return;
        }
        for (ValidationListener validationListener : this.validationListeners) {
            validationListener.validationStateChanged((Validateable)this, validationStatus, validationStatus2);
        }
    }

    private synchronized void targetStarted(DLightTarget dLightTarget) {
        Engine engine;
        ExecutionEnvironment executionEnvironment = dLightTarget.getExecEnv();
        HostInfo hostInfo = null;
        try {
            hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment);
        }
        catch (IOException iOException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        if (hostInfo == null) {
            return;
        }
        NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)executionEnvironment);
        nativeProcessBuilder.setExecutable(hostInfo.getShell());
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor();
        executionDescriptor = executionDescriptor.inputOutput(InputOutput.NULL);
        int n = ((AttachableTarget)dLightTarget).getPID();
        switch (hostInfo.getOSFamily()) {
            case LINUX: {
                engine = new ProcDataProviderLinux(this, this.getServiceInfoDataStorage());
                break;
            }
            case SUNOS: {
                engine = new ProcDataProviderSolaris(this, this.getServiceInfoDataStorage(), executionEnvironment);
                break;
            }
            default: {
                DLightLogger.instance.severe("Called ProcDataProvider.targetStarted() on unsupported OS");
                return;
            }
        }
        nativeProcessBuilder = nativeProcessBuilder.setArguments(new String[]{"-c", engine.getCommand(n)});
        executionDescriptor = executionDescriptor.outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)engine);
        ExecutionService executionService = ExecutionService.newService((Callable)nativeProcessBuilder, (ExecutionDescriptor)executionDescriptor, (String)"procreader");
        this.procReaderTask = executionService.run();
    }

    private synchronized void targetFinished(DLightTarget dLightTarget) {
        if (this.procReaderTask != null) {
            if (!this.procReaderTask.isDone()) {
                this.procReaderTask.cancel(true);
            }
            this.procReaderTask = null;
        }
    }

    public void dataFiltersChanged(List<DataFilter> list) {
    }

    void notifyIndicators(DataRow dataRow) {
        super.notifyIndicators(Collections.singletonList(dataRow));
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(ProcDataProvider.class, (String)string);
    }

    static interface Engine
    extends ExecutionDescriptor.InputProcessorFactory {
        public String getCommand(int var1);
    }
}

