/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.core.UiUtils;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PHPCompletionItem;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelFactory;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntroduceHint
implements Rule.AstRule {
    public String getId() {
        return "Introduce.Hint";
    }

    public String getDescription() {
        return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintDesc");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintDispName");
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    public boolean showInTasklist() {
        return false;
    }

    void check(RuleContext ruleContext, List<Hint> list) {
        PHPParseResult pHPParseResult = (PHPParseResult)ruleContext.parserResult;
        if (pHPParseResult.getProgram() == null) {
            return;
        }
        BaseDocument baseDocument = ruleContext.doc;
        int n = ruleContext.caretOffset;
        int n2 = -1;
        int n3 = -1;
        try {
            n2 = n > 0 ? Utilities.getRowStart((BaseDocument)baseDocument, (int)n) : -1;
            n3 = n2 != -1 ? Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) : -1;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        if (n2 != -1 && n3 != -1 && n > n2) {
            Model model = ModelFactory.getModel(ruleContext.parserResult);
            IntroduceFixVisitor introduceFixVisitor = new IntroduceFixVisitor(model, baseDocument, n, n2, n3);
            pHPParseResult.getProgram().accept(introduceFixVisitor);
            IntroduceFix introduceFix = introduceFixVisitor.getIntroduceFix();
            if (introduceFix != null) {
                list.add(new Hint((Rule)this, this.getDisplayName(), ruleContext.parserResult.getSnapshot().getSource().getFileObject(), introduceFix.getOffsetRange(), Collections.singletonList(introduceFix), 500));
            }
        }
    }

    public Set<? extends Object> getKinds() {
        return Collections.singleton("introduce.hint");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.CURRENT_LINE_WARNING;
    }

    private static boolean isInside(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    private static boolean isBefore(int n, int n2) {
        return n <= n2;
    }

    private static String getParameters(List<Expression> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Expression expression = list.get(i);
            String string = null;
            if (expression instanceof Variable) {
                string = CodeUtils.extractVariableName((Variable)expression);
            }
            if (string == null) {
                string = String.format("$param%d", i);
            }
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static class MethodDeclarationItem
    extends PHPCompletionItem.FunctionDeclarationItem {
        MethodDeclarationItem(MethodInvocation methodInvocation, int n) {
            super(PredefinedSymbols.createMagicFunction(CodeUtils.extractFunctionName(methodInvocation.getMethod()), IntroduceHint.getParameters(methodInvocation.getMethod().getParameters()), 0), null, n, false);
        }

        MethodDeclarationItem(StaticMethodInvocation staticMethodInvocation, int n) {
            super(PredefinedSymbols.createMagicFunction(CodeUtils.extractFunctionName(staticMethodInvocation.getMethod()), IntroduceHint.getParameters(staticMethodInvocation.getMethod().getParameters()), n), null, 0, false);
        }

        protected String getFunctionBodyForTemplate() {
            return ";\n";
        }
    }

    static abstract class IntroduceFix
    implements HintFix {
        BaseDocument doc;
        ASTNode node;

        public IntroduceFix(BaseDocument baseDocument, ASTNode aSTNode) {
            this.doc = baseDocument;
            this.node = aSTNode;
        }

        OffsetRange getOffsetRange() {
            return new OffsetRange(this.node.getStartOffset(), this.node.getEndOffset());
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean isSafe() {
            return true;
        }
    }

    private static class IntroduceClassConstantFix
    extends IntroduceFix {
        private IndexedClass clz;
        private String templ;
        private String constantName;

        public IntroduceClassConstantFix(BaseDocument baseDocument, StaticConstantAccess staticConstantAccess, IndexedClass indexedClass) {
            super(baseDocument, staticConstantAccess);
            this.clz = indexedClass;
            this.constantName = staticConstantAccess.getConstant().getName();
            this.templ = String.format("const %s = \"\";", this.constantName);
        }

        public void implement() throws Exception {
            int n = Utilities.getRowEnd((BaseDocument)this.doc, (int)this.clz.getOffset());
            EditList editList = new EditList(this.doc);
            editList.replace(n, 0, "\n" + this.templ, true, 0);
            editList.apply();
            n = Utilities.getRowEnd((BaseDocument)this.doc, (int)(n + 1)) - 2;
            UiUtils.open((FileObject)this.clz.getFileObject(), (int)n);
        }

        public String getDescription() {
            String string = this.clz.getName();
            String string2 = this.clz.getFileObject().getNameExt();
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintClassConstDesc", (Object)this.constantName, (Object)string, (Object)string2);
        }
    }

    private static class IntroduceStaticFieldFix
    extends IntroduceFix {
        private IndexedClass clz;
        private String templ;
        private String fieldName;

        public IntroduceStaticFieldFix(BaseDocument baseDocument, StaticFieldAccess staticFieldAccess, IndexedClass indexedClass) {
            super(baseDocument, staticFieldAccess);
            this.clz = indexedClass;
            this.templ = this.createTemplate();
        }

        public void implement() throws Exception {
            int n = this.getOffset();
            EditList editList = new EditList(this.doc);
            editList.replace(n, 0, "\n" + this.templ, true, 0);
            editList.apply();
            n = Utilities.getRowEnd((BaseDocument)this.doc, (int)(n + 1)) - 2;
            UiUtils.open((FileObject)this.clz.getFileObject(), (int)n);
        }

        public String getDescription() {
            String string = this.clz.getName();
            String string2 = this.clz.getFileObject().getNameExt();
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintStaticFieldDesc", (Object)this.fieldName, (Object)string, (Object)string2);
        }

        int getOffset() throws BadLocationException {
            return Utilities.getRowEnd((BaseDocument)this.doc, (int)this.clz.getOffset());
        }

        private String createTemplate() {
            Variable variable = ((StaticFieldAccess)this.node).getField();
            this.fieldName = CodeUtils.extractVariableName(variable);
            if (!variable.isDollared()) {
                this.fieldName = "$" + this.fieldName;
            }
            return String.format("static %s = \"\";", this.fieldName);
        }
    }

    private static class IntroduceFieldFix
    extends IntroduceFix {
        private TypeScope type;
        private String templ;
        private String fieldName;

        public IntroduceFieldFix(BaseDocument baseDocument, FieldAccess fieldAccess, TypeScope typeScope) {
            super(baseDocument, fieldAccess);
            this.type = typeScope;
            this.templ = this.createTemplate();
        }

        public void implement() throws Exception {
            int n = this.getOffset();
            EditList editList = new EditList(this.doc);
            editList.replace(n, 0, "\n" + this.templ, true, 0);
            editList.apply();
            n = Utilities.getRowEnd((BaseDocument)this.doc, (int)(n + 1)) - 2;
            UiUtils.open((FileObject)this.type.getFileObject(), (int)n);
        }

        public String getDescription() {
            String string = this.type.getName();
            String string2 = this.type.getFileObject().getNameExt();
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintFieldDesc", (Object)this.templ, (Object)string, (Object)string2);
        }

        int getOffset() throws BadLocationException {
            return Utilities.getRowEnd((BaseDocument)this.doc, (int)this.type.getOffset());
        }

        private String createTemplate() {
            Variable variable = ((FieldAccess)this.node).getField();
            this.fieldName = CodeUtils.extractVariableName(variable);
            if (!variable.isDollared()) {
                this.fieldName = "$" + this.fieldName;
            }
            return String.format("public %s = \"\";", this.fieldName);
        }
    }

    private static class IntroduceStaticMethodFix
    extends IntroduceFix {
        private IndexedClass clz;
        private MethodDeclarationItem item;

        public IntroduceStaticMethodFix(BaseDocument baseDocument, StaticMethodInvocation staticMethodInvocation, IndexedClass indexedClass) {
            super(baseDocument, staticMethodInvocation);
            this.clz = indexedClass;
            this.item = IntroduceStaticMethodFix.createMethodDeclarationItem(staticMethodInvocation);
        }

        public void implement() throws Exception {
            int n = this.getOffset();
            EditList editList = new EditList(this.doc);
            editList.replace(n, 0, "\n" + this.item.getCustomInsertTemplate(), true, 0);
            editList.apply();
            n = Utilities.getRowEnd((BaseDocument)this.doc, (int)(n + 1));
            UiUtils.open((FileObject)this.clz.getFileObject(), (int)(Utilities.getRowEnd((BaseDocument)this.doc, (int)(n + 1)) - 1));
        }

        public String getDescription() {
            String string = this.clz.getName();
            String string2 = this.clz.getFileObject().getNameExt();
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintStaticMethodDesc", (Object)this.item.getFunction().getFunctionSignature(), (Object)string, (Object)string2);
        }

        static MethodDeclarationItem createMethodDeclarationItem(StaticMethodInvocation staticMethodInvocation) {
            return new MethodDeclarationItem(staticMethodInvocation, 8);
        }

        int getOffset() throws BadLocationException {
            return Utilities.getRowEnd((BaseDocument)this.doc, (int)this.clz.getOffset());
        }
    }

    private static class IntroduceMethodFix
    extends IntroduceFix {
        private TypeScope type;
        private MethodDeclarationItem item;

        public IntroduceMethodFix(BaseDocument baseDocument, MethodInvocation methodInvocation, TypeScope typeScope) {
            super(baseDocument, methodInvocation);
            this.type = typeScope;
            this.item = IntroduceMethodFix.createMethodDeclarationItem(methodInvocation);
        }

        public void implement() throws Exception {
            int n = this.getOffset();
            EditList editList = new EditList(this.doc);
            editList.replace(n, 0, "\n" + this.item.getCustomInsertTemplate(), true, 0);
            editList.apply();
            n = Utilities.getRowEnd((BaseDocument)this.doc, (int)(n + 1));
            UiUtils.open((FileObject)this.type.getFileObject(), (int)(Utilities.getRowEnd((BaseDocument)this.doc, (int)(n + 1)) - 1));
        }

        public String getDescription() {
            String string = this.type.getName();
            String string2 = this.type.getFileObject().getNameExt();
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintMethodDesc", (Object)this.item.getFunction().getFunctionSignature(), (Object)string, (Object)string2);
        }

        static MethodDeclarationItem createMethodDeclarationItem(MethodInvocation methodInvocation) {
            return new MethodDeclarationItem(methodInvocation, 0);
        }

        int getOffset() throws BadLocationException {
            return Utilities.getRowEnd((BaseDocument)this.doc, (int)this.type.getOffset());
        }
    }

    private static class IntroduceClassFix
    extends IntroduceFix {
        private Model model;
        private String clsName;
        private FileObject folder;
        private FileObject template;

        static IntroduceClassFix getInstance(String string, Model model, ClassInstanceCreation classInstanceCreation) {
            FileObject fileObject = model.getFileScope().getFileObject();
            FileObject fileObject2 = fileObject.getParent();
            String string2 = "Templates/Scripting/PHPClass";
            FileObject fileObject3 = FileUtil.getConfigFile((String)string2);
            return fileObject3 != null && fileObject2 != null && fileObject2.canWrite() ? new IntroduceClassFix(string, fileObject3, fileObject2, model, classInstanceCreation) : null;
        }

        IntroduceClassFix(String string, FileObject fileObject, FileObject fileObject2, Model model, ClassInstanceCreation classInstanceCreation) {
            super(null, classInstanceCreation);
            this.model = model;
            this.clsName = string;
            this.template = fileObject;
            this.folder = fileObject2;
        }

        public void implement() throws Exception {
            final DataFolder dataFolder = DataFolder.findFolder((FileObject)this.folder);
            final DataObject dataObject = DataObject.find((FileObject)this.template);
            final FileObject[] fileObjectArray = new FileObject[1];
            FileUtil.runAtomicAction((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, IntroduceClassFix.this.clsName);
                        fileObjectArray[0] = dataObject2.getPrimaryFile();
                        FileObject fileObject = fileObjectArray[0];
                        FileLock fileLock = fileObject.lock();
                        try {
                            fileObject.rename(fileLock, fileObject.getName(), "php");
                        }
                        finally {
                            fileLock.releaseLock();
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            });
            if (fileObjectArray[0] != null) {
                UiUtils.open((FileObject)fileObjectArray[0], (int)0);
            }
        }

        public String getDescription() {
            String string = FileUtil.getFileDisplayName((FileObject)this.folder);
            int n = string.length();
            if (n > 30) {
                int n2 = (string = string.substring(n - 30)).indexOf("/");
                if (n2 != -1) {
                    string = string.substring(n2);
                }
                string = String.format("...%s/%s.php", string, this.clsName);
            }
            return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintClassDesc", (Object)this.clsName, (Object)string);
        }
    }

    private class IntroduceFixVisitor
    extends DefaultTreePathVisitor {
        private int lineBegin;
        private int lineEnd;
        private BaseDocument doc;
        private IntroduceFix fix;
        private Model model;
        private int caretOffset;

        IntroduceFixVisitor(Model model, BaseDocument baseDocument, int n, int n2, int n3) {
            this.doc = baseDocument;
            this.lineBegin = n2;
            this.lineEnd = n3;
            this.model = model;
            this.caretOffset = n;
        }

        public void scan(ASTNode aSTNode) {
            if (aSTNode != null && IntroduceHint.isBefore(aSTNode.getStartOffset(), this.lineEnd)) {
                super.scan(aSTNode);
            }
        }

        public void visit(ClassInstanceCreation classInstanceCreation) {
            if (IntroduceHint.isInside(classInstanceCreation.getStartOffset(), this.lineBegin, this.lineEnd)) {
                String string = CodeUtils.extractClassName(classInstanceCreation.getClassName());
                string = string != null && string.trim().length() > 0 ? string : null;
                PHPIndex pHPIndex = this.model.getIndexScope().getIndex();
                Collection<Object> collection = Collections.emptyList();
                if (string != null) {
                    collection = pHPIndex.getClasses(null, string, QuerySupport.Kind.EXACT);
                }
                if (string != null && collection.isEmpty()) {
                    IndexedClass indexedClass;
                    IndexedClass indexedClass2 = indexedClass = string != null ? this.getIndexedClass(string) : null;
                    if (indexedClass == null && string != null) {
                        this.fix = IntroduceClassFix.getInstance(string, this.model, classInstanceCreation);
                    }
                }
            }
            super.visit(classInstanceCreation);
        }

        public void visit(MethodInvocation methodInvocation) {
            Collection<? extends TypeScope> collection;
            String string;
            if (IntroduceHint.isInside(methodInvocation.getStartOffset(), this.lineBegin, this.lineEnd) && (string = CodeUtils.extractFunctionName(methodInvocation.getMethod())) != null && (collection = ModelUtils.typeOfVariableBase(this.model, methodInvocation)).size() == 1) {
                TypeScope typeScope = ModelUtils.getFirst(collection);
                PHPIndex pHPIndex = this.model.getIndexScope().getIndex();
                Collection<IndexedFunction> collection2 = pHPIndex.getAllMethods(null, typeScope.getName(), string, QuerySupport.Kind.EXACT, -1);
                if (collection2.isEmpty()) {
                    BaseDocument baseDocument;
                    FileObject fileObject = typeScope.getFileObject();
                    BaseDocument baseDocument2 = baseDocument = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)true) : null;
                    if (baseDocument != null && fileObject.canWrite()) {
                        this.fix = new IntroduceMethodFix(baseDocument, methodInvocation, typeScope);
                    }
                }
            }
            super.visit(methodInvocation);
        }

        public void visit(StaticMethodInvocation staticMethodInvocation) {
            if (IntroduceHint.isInside(staticMethodInvocation.getStartOffset(), this.lineBegin, this.lineEnd)) {
                PHPIndex pHPIndex;
                Collection<IndexedFunction> collection;
                String string = CodeUtils.extractFunctionName(staticMethodInvocation.getMethod());
                String string2 = staticMethodInvocation.getClassName().getName();
                IndexedClass indexedClass = this.getIndexedClass(string2);
                if (indexedClass != null && string != null && (collection = (pHPIndex = this.model.getIndexScope().getIndex()).getAllMethods(null, indexedClass.getName(), string, QuerySupport.Kind.EXACT, -1)).isEmpty()) {
                    BaseDocument baseDocument;
                    FileObject fileObject = indexedClass.getFileObject();
                    BaseDocument baseDocument2 = baseDocument = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)true) : null;
                    if (baseDocument != null && fileObject.canWrite()) {
                        this.fix = new IntroduceStaticMethodFix(baseDocument, staticMethodInvocation, indexedClass);
                    }
                }
            }
            super.visit(staticMethodInvocation);
        }

        public void visit(FieldAccess fieldAccess) {
            Collection<? extends TypeScope> collection;
            String string;
            if (IntroduceHint.isInside(fieldAccess.getStartOffset(), this.lineBegin, this.lineEnd) && (string = CodeUtils.extractVariableName(fieldAccess.getField())) != null && (collection = ModelUtils.typeOfVariableBase(this.model, fieldAccess)).size() == 1) {
                TypeScope typeScope = ModelUtils.getFirst(collection);
                PHPIndex pHPIndex = this.model.getIndexScope().getIndex();
                Collection<IndexedConstant> collection2 = pHPIndex.getAllFields(null, typeScope.getName(), string, QuerySupport.Kind.EXACT, -1);
                if (collection2.isEmpty()) {
                    BaseDocument baseDocument;
                    FileObject fileObject = typeScope.getFileObject();
                    BaseDocument baseDocument2 = baseDocument = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)false) : null;
                    if (baseDocument != null && fileObject.canWrite()) {
                        this.fix = new IntroduceFieldFix(baseDocument, fieldAccess, typeScope);
                    }
                }
            }
            super.visit(fieldAccess);
        }

        public void visit(StaticFieldAccess staticFieldAccess) {
            if (IntroduceHint.isInside(staticFieldAccess.getStartOffset(), this.lineBegin, this.lineEnd)) {
                Variable variable = staticFieldAccess.getField();
                String string = CodeUtils.extractVariableName(variable);
                String string2 = staticFieldAccess.getClassName().getName();
                IndexedClass indexedClass = this.getIndexedClass(string2);
                if (indexedClass != null && string != null) {
                    PHPIndex pHPIndex;
                    Collection<IndexedConstant> collection;
                    if (string.startsWith("$")) {
                        string = string.substring(1);
                    }
                    if ((collection = (pHPIndex = this.model.getIndexScope().getIndex()).getAllFields(null, indexedClass.getName(), string, QuerySupport.Kind.EXACT, 8)).isEmpty()) {
                        BaseDocument baseDocument;
                        FileObject fileObject = indexedClass.getFileObject();
                        BaseDocument baseDocument2 = baseDocument = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)true) : null;
                        if (baseDocument != null && fileObject.canWrite()) {
                            this.fix = new IntroduceStaticFieldFix(baseDocument, staticFieldAccess, indexedClass);
                        }
                    }
                }
            }
            super.visit(staticFieldAccess);
        }

        public void visit(StaticConstantAccess staticConstantAccess) {
            if (IntroduceHint.isInside(staticConstantAccess.getStartOffset(), this.lineBegin, this.lineEnd)) {
                PHPIndex pHPIndex;
                Collection<IndexedConstant> collection;
                String string = staticConstantAccess.getConstant().getName();
                String string2 = staticConstantAccess.getClassName().getName();
                IndexedClass indexedClass = this.getIndexedClass(string2);
                if (indexedClass != null && string != null && (collection = (pHPIndex = this.model.getIndexScope().getIndex()).getAllClassConstants(null, indexedClass.getName(), string, QuerySupport.Kind.EXACT)).isEmpty()) {
                    BaseDocument baseDocument;
                    FileObject fileObject = indexedClass.getFileObject();
                    BaseDocument baseDocument2 = baseDocument = fileObject != null ? GsfUtilities.getDocument((FileObject)fileObject, (boolean)true) : null;
                    if (baseDocument != null && fileObject.canWrite()) {
                        this.fix = new IntroduceClassConstantFix(baseDocument, staticConstantAccess, indexedClass);
                    }
                }
            }
            super.visit(staticConstantAccess);
        }

        public IntroduceFix getIntroduceFix() {
            return this.fix;
        }

        private IndexedClass getIndexedClass(String string) {
            Object object;
            IndexedClass indexedClass = null;
            PHPIndex pHPIndex = this.model.getIndexScope().getIndex();
            Collection<Object> collection = Collections.emptyList();
            if ("self".equals(string) || "parent".equals(string)) {
                object = this.getPath();
                Iterator<ASTNode> iterator = object.iterator();
                while (iterator.hasNext()) {
                    ASTNode aSTNode = iterator.next();
                    if (!(aSTNode instanceof ClassDeclaration)) continue;
                    collection = pHPIndex.getClasses(null, CodeUtils.extractClassName((ClassDeclaration)aSTNode), QuerySupport.Kind.EXACT);
                    break;
                }
            } else {
                collection = pHPIndex.getClasses(null, string, QuerySupport.Kind.EXACT);
            }
            if (collection.size() == 1) {
                indexedClass = (IndexedClass)collection.iterator().next();
                if ("parent".equals(string)) {
                    object = indexedClass.getSuperClass();
                    collection = pHPIndex.getClasses(null, (String)object, QuerySupport.Kind.EXACT);
                    indexedClass = collection.size() == 1 ? (IndexedClass)collection.iterator().next() : null;
                }
            }
            return indexedClass;
        }
    }
}

