/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTNodeInfo<T extends ASTNode> {
    private T node;
    private Kind kind;

    ASTNodeInfo(T t) {
        this.node = t;
    }

    ASTNodeInfo(Kind kind, T t) {
        this.kind = kind;
        this.node = t;
    }

    public String getName() {
        return ASTNodeInfo.toName(this.getOriginalNode());
    }

    public Kind getKind() {
        return this.kind == null ? ASTNodeInfo.toKind(this.getOriginalNode()) : this.kind;
    }

    public PhpKind getPhpKind() {
        Kind kind = this.getKind();
        switch (kind) {
            case INCLUDE: {
                return PhpKind.INCLUDE;
            }
            case IFACE: {
                return PhpKind.IFACE;
            }
            case CLASS: {
                return PhpKind.CLASS;
            }
            case CLASS_INSTANCE_CREATION: {
                return PhpKind.CLASS;
            }
            case METHOD: {
                return PhpKind.METHOD;
            }
            case STATIC_METHOD: {
                return PhpKind.METHOD;
            }
            case FIELD: {
                return PhpKind.FIELD;
            }
            case STATIC_FIELD: {
                return PhpKind.FIELD;
            }
            case CLASS_CONSTANT: {
                return PhpKind.CLASS_CONSTANT;
            }
            case STATIC_CLASS_CONSTANT: {
                return PhpKind.CLASS_CONSTANT;
            }
            case VARIABLE: {
                return PhpKind.VARIABLE;
            }
            case CONSTANT: {
                return PhpKind.CONSTANT;
            }
            case FUNCTION: {
                return PhpKind.FUNCTION;
            }
        }
        throw new IllegalStateException();
    }

    public OffsetRange getRange() {
        return ASTNodeInfo.toOffsetRange(this.getOriginalNode());
    }

    public final T getOriginalNode() {
        return this.node;
    }

    public static ASTNodeInfo<FieldAccess> create(FieldAccess fieldAccess) {
        return new ASTNodeInfo<FieldAccess>(fieldAccess);
    }

    public static ASTNodeInfo<FunctionInvocation> create(FunctionInvocation functionInvocation) {
        return new ASTNodeInfo<FunctionInvocation>(functionInvocation);
    }

    public static ASTNodeInfo<Variable> create(Variable variable) {
        return new ASTNodeInfo<Variable>(variable);
    }

    public static ASTNodeInfo<StaticMethodInvocation> create(StaticMethodInvocation staticMethodInvocation) {
        return new ASTNodeInfo<StaticMethodInvocation>(staticMethodInvocation);
    }

    public static ASTNodeInfo<StaticFieldAccess> create(StaticFieldAccess staticFieldAccess) {
        return new ASTNodeInfo<StaticFieldAccess>(staticFieldAccess);
    }

    public static ASTNodeInfo<StaticConstantAccess> create(StaticConstantAccess staticConstantAccess) {
        return new ASTNodeInfo<StaticConstantAccess>(staticConstantAccess);
    }

    public static ASTNodeInfo<ClassInstanceCreation> create(ClassInstanceCreation classInstanceCreation) {
        return new ASTNodeInfo<ClassInstanceCreation>(classInstanceCreation);
    }

    public static ASTNodeInfo<ClassName> create(ClassName className) {
        return new ASTNodeInfo<ClassName>(className);
    }

    public static ASTNodeInfo<Identifier> create(Kind kind, Identifier identifier) {
        return new ASTNodeInfo<Identifier>(kind, identifier);
    }

    public static ASTNodeInfo<Scalar> create(Kind kind, Scalar scalar) {
        return new ASTNodeInfo<Scalar>(kind, scalar);
    }

    public static ASTNodeInfo<MethodInvocation> create(MethodInvocation methodInvocation) {
        return new ASTNodeInfo<MethodInvocation>(methodInvocation);
    }

    public static ASTNodeInfo<ReturnStatement> create(ReturnStatement returnStatement) {
        return new ASTNodeInfo<ReturnStatement>(returnStatement);
    }

    private static Kind toKind(ASTNode aSTNode) {
        if (aSTNode instanceof FunctionInvocation) {
            return Kind.FUNCTION;
        }
        if (aSTNode instanceof Variable) {
            return Kind.VARIABLE;
        }
        if (aSTNode instanceof StaticMethodInvocation) {
            return Kind.STATIC_METHOD;
        }
        if (aSTNode instanceof StaticFieldAccess) {
            return Kind.STATIC_FIELD;
        }
        if (aSTNode instanceof MethodInvocation) {
            return Kind.METHOD;
        }
        if (aSTNode instanceof StaticConstantAccess) {
            return Kind.STATIC_CLASS_CONSTANT;
        }
        if (aSTNode instanceof ClassName) {
            return Kind.CLASS;
        }
        if (aSTNode instanceof ClassInstanceCreation) {
            return Kind.CLASS_INSTANCE_CREATION;
        }
        if (aSTNode instanceof FieldAccess) {
            return Kind.FIELD;
        }
        if (aSTNode instanceof ReturnStatement) {
            return Kind.RETURN_MARKER;
        }
        throw new IllegalStateException();
    }

    private static String toName(ASTNode aSTNode) {
        if (aSTNode instanceof FunctionInvocation) {
            FunctionInvocation functionInvocation = (FunctionInvocation)aSTNode;
            return CodeUtils.extractFunctionName(functionInvocation);
        }
        if (aSTNode instanceof Variable) {
            Variable variable = (Variable)aSTNode;
            return ASTNodeInfo.toNameVar(variable);
        }
        if (aSTNode instanceof StaticMethodInvocation) {
            StaticMethodInvocation staticMethodInvocation = (StaticMethodInvocation)aSTNode;
            return ASTNodeInfo.toName(staticMethodInvocation.getMethod());
        }
        if (aSTNode instanceof StaticFieldAccess) {
            StaticFieldAccess staticFieldAccess = (StaticFieldAccess)aSTNode;
            return ASTNodeInfo.toNameField(staticFieldAccess.getField());
        }
        if (aSTNode instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)aSTNode;
            return ASTNodeInfo.toName(methodInvocation.getMethod());
        }
        if (aSTNode instanceof StaticConstantAccess) {
            StaticConstantAccess staticConstantAccess = (StaticConstantAccess)aSTNode;
            return staticConstantAccess.getConstant().getName();
        }
        if (aSTNode instanceof ClassName) {
            ClassName className = (ClassName)aSTNode;
            return CodeUtils.extractClassName(className);
        }
        if (aSTNode instanceof Identifier) {
            Identifier identifier = (Identifier)aSTNode;
            return identifier.getName();
        }
        if (aSTNode instanceof Scalar) {
            Scalar scalar = (Scalar)aSTNode;
            return NavUtils.isQuoted(scalar.getStringValue()) ? NavUtils.dequote(scalar.getStringValue()) : scalar.getStringValue();
        }
        if (aSTNode instanceof ClassInstanceCreation) {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)aSTNode;
            return ASTNodeInfo.toName(classInstanceCreation.getClassName());
        }
        if (aSTNode instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)aSTNode;
            return ASTNodeInfo.toNameField(fieldAccess.getField());
        }
        if (aSTNode instanceof ReturnStatement) {
            return "return";
        }
        throw new IllegalStateException();
    }

    private static OffsetRange toOffsetRange(ASTNode aSTNode) {
        if (aSTNode instanceof FunctionInvocation) {
            FunctionInvocation functionInvocation = (FunctionInvocation)aSTNode;
            FunctionName functionName = functionInvocation.getFunctionName();
            return new OffsetRange(functionName.getStartOffset(), functionName.getEndOffset());
        }
        if (aSTNode instanceof Variable) {
            Variable variable = (Variable)aSTNode;
            return ASTNodeInfo.toOffsetRangeVar(variable);
        }
        if (aSTNode instanceof StaticMethodInvocation) {
            StaticMethodInvocation staticMethodInvocation = (StaticMethodInvocation)aSTNode;
            return ASTNodeInfo.toOffsetRange(staticMethodInvocation.getMethod());
        }
        if (aSTNode instanceof StaticFieldAccess) {
            StaticFieldAccess staticFieldAccess = (StaticFieldAccess)aSTNode;
            return ASTNodeInfo.toOffsetRange(staticFieldAccess.getField());
        }
        if (aSTNode instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)aSTNode;
            return ASTNodeInfo.toOffsetRange(methodInvocation.getMethod());
        }
        if (aSTNode instanceof StaticConstantAccess) {
            StaticConstantAccess staticConstantAccess = (StaticConstantAccess)aSTNode;
            Identifier identifier = staticConstantAccess.getConstant();
            return new OffsetRange(identifier.getStartOffset(), identifier.getEndOffset());
        }
        if (aSTNode instanceof ClassName) {
            ClassName className = (ClassName)aSTNode;
            return new OffsetRange(className.getStartOffset(), className.getEndOffset());
        }
        if (aSTNode instanceof Identifier) {
            Identifier identifier = (Identifier)aSTNode;
            return new OffsetRange(identifier.getStartOffset(), identifier.getEndOffset());
        }
        if (aSTNode instanceof Scalar) {
            Scalar scalar = (Scalar)aSTNode;
            if (NavUtils.isQuoted(scalar.getStringValue())) {
                return new OffsetRange(aSTNode.getStartOffset() + 1, aSTNode.getEndOffset() - 1);
            }
            return new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset());
        }
        if (aSTNode instanceof ClassInstanceCreation) {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)aSTNode;
            return ASTNodeInfo.toOffsetRange(classInstanceCreation.getClassName());
        }
        if (aSTNode instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)aSTNode;
            return ASTNodeInfo.toOffsetRange(fieldAccess.getField());
        }
        if (aSTNode instanceof ReturnStatement) {
            ReturnStatement returnStatement = (ReturnStatement)aSTNode;
            return new OffsetRange(returnStatement.getStartOffset(), returnStatement.getEndOffset());
        }
        throw new IllegalStateException();
    }

    static String toNameVar(Variable variable) {
        return CodeUtils.extractVariableName(variable);
    }

    static String toNameField(Variable variable) {
        String string = CodeUtils.extractVariableName(variable);
        if (string != null && !string.startsWith("$")) {
            string = "$" + string;
        }
        return string;
    }

    static OffsetRange toOffsetRangeVar(Variable variable) {
        Expression expression = variable.getName();
        while (expression instanceof Variable) {
            Variable variable2;
            while (expression instanceof ArrayAccess) {
                variable2 = (ArrayAccess)expression;
                expression = ((ArrayAccess)variable2).getName();
            }
            if (!(expression instanceof Variable)) continue;
            variable2 = (Variable)expression;
            expression = variable2.getName();
        }
        return new OffsetRange(expression.getStartOffset(), expression.getEndOffset());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        IFACE,
        CLASS,
        CLASS_INSTANCE_CREATION,
        METHOD,
        STATIC_METHOD,
        FIELD,
        STATIC_FIELD,
        CLASS_CONSTANT,
        STATIC_CLASS_CONSTANT,
        VARIABLE,
        CONSTANT,
        FUNCTION,
        INCLUDE,
        RETURN_MARKER;

    }
}

