/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.CodeMarker;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.CodeMarkerBuilder;
import org.netbeans.modules.php.editor.model.impl.ConstantElementImpl;
import org.netbeans.modules.php.editor.model.impl.FieldAssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.model.impl.FileScopeImpl;
import org.netbeans.modules.php.editor.model.impl.FunctionScopeImpl;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelBuilder;
import org.netbeans.modules.php.editor.model.impl.ModelElementFactory;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.OccurenceBuilder;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VarAssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.VariableContainerImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.ClassConstantDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.PhpDocTypeTagInfo;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InstanceOfExpression;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPVarComment;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.ReflectionVariable;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelVisitor
extends DefaultTreePathVisitor {
    private final FileScopeImpl fileScope;
    private Map<VariableContainerImpl, Map<String, VariableNameImpl>> vars;
    private Map<String, List<PhpDocTypeTagInfo>> varTypeComments;
    private OccurenceBuilder occurencesBuilder;
    private CodeMarkerBuilder markerBuilder;
    private ModelBuilder modelBuilder;
    private ParserResult info;

    public ModelVisitor(ParserResult parserResult) {
        this(parserResult, -1);
    }

    public ModelVisitor(ParserResult parserResult, int n) {
        this.fileScope = new FileScopeImpl(parserResult);
        this.varTypeComments = new HashMap<String, List<PhpDocTypeTagInfo>>();
        this.occurencesBuilder = new OccurenceBuilder(n);
        this.markerBuilder = new CodeMarkerBuilder(n);
        this.modelBuilder = new ModelBuilder(this.fileScope);
        this.info = parserResult;
    }

    public ModelVisitor(ParserResult parserResult, ModelElement modelElement) {
        this.fileScope = new FileScopeImpl(parserResult);
        this.varTypeComments = new HashMap<String, List<PhpDocTypeTagInfo>>();
        this.occurencesBuilder = new OccurenceBuilder(modelElement);
        this.markerBuilder = new CodeMarkerBuilder(-1);
        this.modelBuilder = new ModelBuilder(this.fileScope);
        this.info = parserResult;
    }

    public ParserResult getCompilationInfo() {
        return this.info;
    }

    @Override
    public void scan(ASTNode aSTNode) {
        super.scan(aSTNode);
    }

    @Override
    public void visit(ReturnStatement returnStatement) {
        this.markerBuilder.prepare(returnStatement, (Scope)this.modelBuilder.getCurrentScope());
        super.visit(returnStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(Program program) {
        this.modelBuilder.setProgram(program);
        this.fileScope.setBlockRange(program);
        this.vars = new HashMap<VariableContainerImpl, Map<String, VariableNameImpl>>();
        try {
            this.prepareVarComments(program);
            super.visit(program);
            this.handleVarComments();
        }
        finally {
            program = null;
            this.vars = null;
            this.buildOccurences();
            this.buildCodeMarks();
        }
    }

    @Override
    public void visit(Include include) {
        this.modelBuilder.build(include, this.occurencesBuilder);
        super.visit(include);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(ClassDeclaration classDeclaration) {
        this.modelBuilder.build(classDeclaration, this.occurencesBuilder);
        this.checkComments(classDeclaration);
        try {
            super.visit(classDeclaration);
        }
        finally {
            this.modelBuilder.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(InterfaceDeclaration interfaceDeclaration) {
        this.modelBuilder.build(interfaceDeclaration, this.occurencesBuilder);
        try {
            super.visit(interfaceDeclaration);
        }
        finally {
            this.modelBuilder.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(MethodDeclaration methodDeclaration) {
        this.modelBuilder.build(methodDeclaration, this.occurencesBuilder);
        this.markerBuilder.prepare(methodDeclaration, (Scope)this.modelBuilder.getCurrentScope());
        this.checkComments(methodDeclaration);
        try {
            this.scan(methodDeclaration.getFunction().getFormalParameters());
            this.scan(methodDeclaration.getFunction().getBody());
        }
        finally {
            this.modelBuilder.reset();
        }
    }

    @Override
    public void visit(FieldsDeclaration fieldsDeclaration) {
        this.modelBuilder.build(fieldsDeclaration, this.occurencesBuilder);
        this.checkComments(fieldsDeclaration);
        super.visit(fieldsDeclaration);
    }

    @Override
    public void visit(ClassInstanceCreation classInstanceCreation) {
        this.occurencesBuilder.prepare(classInstanceCreation, (Scope)this.modelBuilder.getCurrentScope());
        this.scan(classInstanceCreation.ctorParams());
    }

    @Override
    public void visit(InstanceOfExpression instanceOfExpression) {
        Expression expression;
        this.occurencesBuilder.prepare(instanceOfExpression.getClassName(), (Scope)this.modelBuilder.getCurrentScope());
        String string = CodeUtils.extractClassName(instanceOfExpression.getClassName());
        if (string != null && (expression = instanceOfExpression.getExpression()) instanceof Variable) {
            Variable variable = (Variable)expression;
            ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
            VariableNameImpl variableNameImpl = this.findVariable(scopeImpl, variable);
            if (variableNameImpl != null) {
                variableNameImpl.addElement(new VarAssignmentImpl(variableNameImpl, (Scope)scopeImpl, this.getBlockRange(scopeImpl), ASTNodeInfo.create(variable).getRange(), string));
            }
        }
        super.visit(instanceOfExpression);
    }

    @Override
    public void visit(MethodInvocation methodInvocation) {
        this.occurencesBuilder.prepare(methodInvocation, (Scope)this.modelBuilder.getCurrentScope());
        this.scan(methodInvocation.getDispatcher());
        this.scan(methodInvocation.getMethod().getParameters());
    }

    @Override
    public void visit(Scalar scalar) {
        String string = scalar.getStringValue();
        if (scalar.getScalarType() == Scalar.Type.STRING && !NavUtils.isQuoted(string)) {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CONSTANT, scalar, (Scope)this.fileScope);
        }
        super.visit(scalar);
    }

    @Override
    public void visit(StaticMethodInvocation staticMethodInvocation) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(staticMethodInvocation, (Scope)scopeImpl);
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, staticMethodInvocation.getClassName(), (Scope)scopeImpl);
        this.scan(staticMethodInvocation.getMethod().getParameters());
    }

    @Override
    public void visit(ClassName className) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(className, (Scope)scopeImpl);
    }

    @Override
    public void visit(StaticConstantAccess staticConstantAccess) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(staticConstantAccess, (Scope)scopeImpl);
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, staticConstantAccess.getClassName(), (Scope)scopeImpl);
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.IFACE, staticConstantAccess.getClassName(), (Scope)scopeImpl);
    }

    @Override
    public void visit(ClassConstantDeclaration classConstantDeclaration) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        assert (scopeImpl != null && scopeImpl instanceof TypeScope);
        List<? extends ClassConstantDeclarationInfo> list = ClassConstantDeclarationInfo.create(classConstantDeclaration);
        for (ClassConstantDeclarationInfo classConstantDeclarationInfo : list) {
            this.occurencesBuilder.prepare(classConstantDeclarationInfo, ModelElementFactory.create(classConstantDeclarationInfo, this.modelBuilder));
        }
        super.visit(classConstantDeclaration);
    }

    @Override
    public void visit(SingleFieldDeclaration singleFieldDeclaration) {
    }

    @Override
    public void visit(ReflectionVariable reflectionVariable) {
        Expression expression = reflectionVariable.getName();
        while (expression instanceof ReflectionVariable) {
            ReflectionVariable reflectionVariable2 = (ReflectionVariable)expression;
            expression = reflectionVariable2.getName();
        }
        if (expression instanceof Variable) {
            this.scan(expression);
        }
    }

    @Override
    public void visit(Variable variable) {
        String string = CodeUtils.extractVariableName(variable);
        if (string == null) {
            return;
        }
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(variable, (Scope)scopeImpl);
        if (scopeImpl instanceof VariableContainerImpl) {
            String string2;
            VariableName variableName;
            this.findVariable(scopeImpl, variable);
            VariableContainerImpl variableContainerImpl = (VariableContainerImpl)((Object)scopeImpl);
            Map<String, VariableNameImpl> map = this.vars.get(variableContainerImpl);
            if (map == null) {
                map = new HashMap<String, VariableNameImpl>();
                this.vars.put(variableContainerImpl, map);
            }
            if ((variableName = (VariableName)map.get(string2 = VariableNameImpl.toName(variable))) == null && variableContainerImpl.getVariablesImpl(string2).isEmpty()) {
                VariableNameImpl variableNameImpl = variableContainerImpl.createElement(this.modelBuilder.getProgram(), variable);
                map.put(string2, variableNameImpl);
            }
        } else assert (scopeImpl instanceof ClassScope) : scopeImpl;
        super.visit(variable);
    }

    @Override
    public void visit(GlobalStatement globalStatement) {
        super.visit(globalStatement);
        List<Variable> list = globalStatement.getVariables();
        for (Variable variable : list) {
            ScopeImpl scopeImpl;
            String string = CodeUtils.extractVariableName(variable);
            if (string == null || !((scopeImpl = this.modelBuilder.getCurrentScope()) instanceof VariableContainerImpl)) continue;
            VariableContainerImpl variableContainerImpl = (VariableContainerImpl)((Object)scopeImpl);
            Collection<? extends VariableName> collection = variableContainerImpl.getVariablesImpl(string);
            VariableNameImpl variableNameImpl = (VariableNameImpl)ModelUtils.getFirst(collection);
            if (variableNameImpl != null) {
                variableNameImpl.setGloballyVisible(true);
                continue;
            }
            variableContainerImpl = this.modelBuilder.getFileScope();
            collection = variableContainerImpl.getVariablesImpl(string);
            variableNameImpl = (VariableNameImpl)ModelUtils.getFirst(collection);
            if (variableNameImpl == null) continue;
            variableNameImpl.setGloballyVisible(true);
        }
    }

    @Override
    public void visit(FieldAccess fieldAccess) {
        this.occurencesBuilder.prepare(fieldAccess, (Scope)this.modelBuilder.getCurrentScope());
        Variable variable = fieldAccess.getField();
        if (variable instanceof ArrayAccess) {
            ArrayAccess arrayAccess = (ArrayAccess)variable;
            this.scan(arrayAccess.getIndex());
            VariableBase variableBase = arrayAccess.getName();
            while (variableBase instanceof ArrayAccess) {
                ArrayAccess arrayAccess2 = (ArrayAccess)variableBase;
                this.scan(arrayAccess2.getIndex());
                variableBase = arrayAccess2.getName();
            }
        }
        this.scan(fieldAccess.getDispatcher());
    }

    @Override
    public void visit(FunctionName functionName) {
    }

    @Override
    public void visit(Assignment assignment) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        VariableBase variableBase = assignment.getLeftHandSide();
        Expression expression = assignment.getRightHandSide();
        super.scan(variableBase);
        if (variableBase instanceof Variable) {
            VariableNameImpl variableNameImpl = this.findVariable(scopeImpl, variableBase);
            if (variableNameImpl != null) {
                Variable variable = (Variable)variableBase;
                variableNameImpl.createElement(scopeImpl, this.getBlockRange(scopeImpl), new OffsetRange(variable.getStartOffset(), variable.getEndOffset()), assignment, Collections.<String, AssignmentImpl>emptyMap());
                this.occurencesBuilder.prepare((Variable)variableBase, (Scope)scopeImpl);
            }
        } else if (variableBase instanceof FieldAccess) {
            Collection<? extends TypeScope> collection;
            TypeScope typeScope;
            FieldAccess fieldAccess = (FieldAccess)variableBase;
            VariableNameImpl variableNameImpl = this.findVariable(this.modelBuilder.getCurrentScope(), fieldAccess.getDispatcher());
            if (variableNameImpl != null && (typeScope = ModelUtils.getFirst(collection = variableNameImpl.getTypes(fieldAccess.getStartOffset()))) instanceof ClassScope) {
                ClassScope classScope = (ClassScope)typeScope;
                String string = CodeUtils.extractVariableName(fieldAccess.getField());
                if (string != null) {
                    FieldElementImpl fieldElementImpl;
                    if (!string.startsWith("$")) {
                        string = "$" + string;
                    }
                    if ((fieldElementImpl = (FieldElementImpl)ModelUtils.getFirst(classScope.findDeclaredFields(string, -1))) != null) {
                        String string2 = VariousUtils.extractVariableTypeFromAssignment(assignment, Collections.<String, AssignmentImpl>emptyMap());
                        ASTNodeInfo<FieldAccess> aSTNodeInfo = ASTNodeInfo.create(fieldAccess);
                        FieldAssignmentImpl fieldAssignmentImpl = new FieldAssignmentImpl(fieldElementImpl, (Scope)scopeImpl, scopeImpl.getBlockRange(), aSTNodeInfo.getRange(), string2);
                        fieldElementImpl.addElement(fieldAssignmentImpl);
                    }
                }
            }
        }
        super.scan(expression);
    }

    @Override
    public void visit(FormalParameter formalParameter) {
        Object object;
        Expression expression = formalParameter.getParameterName();
        Identifier identifier = formalParameter.getParameterType();
        String string = identifier != null ? identifier.getName() : null;
        FunctionScopeImpl functionScopeImpl = (FunctionScopeImpl)this.modelBuilder.getCurrentScope();
        while (expression instanceof Reference) {
            object = (Reference)expression;
            Expression expression2 = ((Reference)object).getExpression();
            if (!(expression2 instanceof Variable) && !(expression2 instanceof Reference)) continue;
            expression = expression2;
        }
        if (string != null && expression instanceof Variable) {
            object = functionScopeImpl.createElement(this.modelBuilder.getProgram(), (Variable)expression);
            ((ScopeImpl)object).addElement(new VarAssignmentImpl((VariableNameImpl)object, (Scope)functionScopeImpl, functionScopeImpl.getBlockRange(), new OffsetRange(identifier.getStartOffset(), identifier.getEndOffset()), string));
        }
        if (expression instanceof Variable) {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, identifier, (Scope)functionScopeImpl);
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.IFACE, identifier, (Scope)functionScopeImpl);
            this.occurencesBuilder.prepare((Variable)expression, (Scope)functionScopeImpl);
        }
        super.visit(formalParameter);
    }

    @Override
    public void visit(CatchClause catchClause) {
        Identifier identifier = catchClause.getClassName();
        Variable variable = catchClause.getVariable();
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        VariableContainerImpl variableContainerImpl = (VariableContainerImpl)((Object)scopeImpl);
        if (variableContainerImpl instanceof VariableContainerImpl) {
            VariableContainerImpl variableContainerImpl2 = variableContainerImpl;
            Map<String, VariableNameImpl> map = this.vars.get(variableContainerImpl2);
            if (map == null) {
                map = new HashMap<String, VariableNameImpl>();
                this.vars.put(variableContainerImpl2, map);
            }
            VariableNameImpl variableNameImpl = variableContainerImpl.createElement(this.modelBuilder.getProgram(), variable);
            String string = variableNameImpl.getName();
            variableNameImpl.addElement(new VarAssignmentImpl(variableNameImpl, (Scope)scopeImpl, new OffsetRange(catchClause.getStartOffset(), catchClause.getEndOffset()), VariableNameImpl.toOffsetRange(variable), identifier.getName()));
            VariableName variableName = map.get(string);
            if (variableName == null) {
                map.put(string, variableNameImpl);
            }
        }
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, identifier, (Scope)scopeImpl);
        this.occurencesBuilder.prepare(variable, (Scope)scopeImpl);
        this.scan(catchClause.getBody());
    }

    @Override
    public void visit(FunctionDeclaration functionDeclaration) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        assert (scopeImpl != null && (scopeImpl instanceof FunctionScope || scopeImpl instanceof MethodScope || scopeImpl instanceof FileScopeImpl));
        if (scopeImpl instanceof FileScopeImpl) {
            FileScopeImpl fileScopeImpl = (FileScopeImpl)scopeImpl;
            FunctionScopeImpl functionScopeImpl = fileScopeImpl.createElement(this.modelBuilder.getProgram(), functionDeclaration);
            scopeImpl = functionScopeImpl;
            this.modelBuilder.setCurrentScope(scopeImpl);
            this.occurencesBuilder.prepare(functionDeclaration, functionScopeImpl);
            this.markerBuilder.prepare(functionDeclaration, (Scope)this.modelBuilder.getCurrentScope());
            this.checkComments(functionDeclaration);
        } else if (!(scopeImpl instanceof FileScope)) {
            Scope scope = scopeImpl;
            while (!(scope instanceof FileScope)) {
                scope = scope.getInScope();
            }
            if (scope instanceof FileScopeImpl) {
                FileScopeImpl fileScopeImpl = (FileScopeImpl)scope;
                FunctionScopeImpl functionScopeImpl = fileScopeImpl.createElement(this.modelBuilder.getProgram(), functionDeclaration);
                scopeImpl = functionScopeImpl;
                this.modelBuilder.setCurrentScope(scopeImpl);
                this.occurencesBuilder.prepare(functionDeclaration, functionScopeImpl);
                this.markerBuilder.prepare(functionDeclaration, (Scope)this.modelBuilder.getCurrentScope());
                this.checkComments(functionDeclaration);
            }
        }
        scopeImpl.setBlockRange(functionDeclaration.getBody());
        this.scan(functionDeclaration.getFormalParameters());
        this.scan(functionDeclaration.getBody());
        this.modelBuilder.reset();
    }

    @Override
    public void visit(FunctionInvocation functionInvocation) {
        Scalar scalar;
        Expression expression;
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(functionInvocation, (Scope)scopeImpl);
        ASTNodeInfo<FunctionInvocation> aSTNodeInfo = ASTNodeInfo.create(functionInvocation);
        String string = aSTNodeInfo.getName();
        if ("define".equals(string) && functionInvocation.getParameters().size() == 2) {
            Scalar scalar2;
            String string2;
            Expression expression2 = functionInvocation.getParameters().get(0);
            if (expression2 instanceof Scalar && ((Scalar)expression2).getScalarType() == Scalar.Type.STRING && NavUtils.isQuoted(string2 = (scalar2 = (Scalar)expression2).getStringValue())) {
                ASTNodeInfo<Scalar> aSTNodeInfo2 = ASTNodeInfo.create(ASTNodeInfo.Kind.CONSTANT, scalar2);
                ConstantElementImpl constantElementImpl = this.fileScope.createElement(aSTNodeInfo2);
                this.occurencesBuilder.prepare(aSTNodeInfo2, constantElementImpl);
            }
        } else if ("constant".equals(string) && functionInvocation.getParameters().size() == 1 && (expression = functionInvocation.getParameters().get(0)) instanceof Scalar && (scalar = (Scalar)expression).getScalarType() == Scalar.Type.STRING && NavUtils.isQuoted(scalar.getStringValue())) {
            this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CONSTANT, scalar, (Scope)this.fileScope);
        }
        super.visit(functionInvocation);
    }

    @Override
    public void visit(StaticFieldAccess staticFieldAccess) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        this.occurencesBuilder.prepare(staticFieldAccess, (Scope)scopeImpl);
        this.occurencesBuilder.prepare(ASTNodeInfo.Kind.CLASS, staticFieldAccess.getClassName(), (Scope)scopeImpl);
        Variable variable = staticFieldAccess.getField();
        if (variable instanceof ArrayAccess) {
            ArrayAccess arrayAccess = (ArrayAccess)variable;
            this.scan(arrayAccess.getIndex());
            VariableBase variableBase = arrayAccess.getName();
            while (variableBase instanceof ArrayAccess) {
                ArrayAccess arrayAccess2 = (ArrayAccess)variableBase;
                this.scan(arrayAccess2.getIndex());
                variableBase = arrayAccess2.getName();
            }
        }
    }

    @Override
    public void visit(PHPDocTypeTag pHPDocTypeTag) {
        this.occurencesBuilder.prepare(pHPDocTypeTag, (Scope)this.modelBuilder.getCurrentScope());
        super.visit(pHPDocTypeTag);
    }

    @Override
    public void visit(PHPDocVarTypeTag pHPDocVarTypeTag) {
        ScopeImpl scopeImpl = this.modelBuilder.getCurrentScope();
        List<? extends PhpDocTypeTagInfo> list = PhpDocTypeTagInfo.create(pHPDocVarTypeTag, scopeImpl);
        for (PhpDocTypeTagInfo phpDocTypeTagInfo : list) {
            if (!phpDocTypeTagInfo.getKind().equals((Object)ASTNodeInfo.Kind.FIELD)) continue;
            new FieldElementImpl((Scope)scopeImpl, phpDocTypeTagInfo.getTypeName(), phpDocTypeTagInfo);
        }
        this.occurencesBuilder.prepare(pHPDocVarTypeTag, (Scope)scopeImpl);
        super.visit(pHPDocVarTypeTag);
    }

    public FileScope getModelScope() {
        return this.fileScope;
    }

    @CheckForNull
    public CodeMarker getCodeMarker(int n) {
        return this.findStrictCodeMarker((FileScopeImpl)this.getModelScope(), n, null);
    }

    private void checkComments(ASTNode aSTNode) {
        block4: {
            Comment comment;
            block3: {
                Comment comment2 = comment = aSTNode instanceof Comment ? (Comment)aSTNode : Utils.getCommentForNode(this.modelBuilder.getProgram(), aSTNode);
                if (!(comment instanceof PHPDocBlock)) break block3;
                PHPDocBlock pHPDocBlock = (PHPDocBlock)comment;
                for (PHPDocTag pHPDocTag : pHPDocBlock.getTags()) {
                    this.scan(pHPDocTag);
                }
                break block4;
            }
            if (!(comment instanceof PHPVarComment)) break block4;
            PHPDocVarTypeTag pHPDocVarTypeTag = ((PHPVarComment)comment).getVariable();
            List<? extends PhpDocTypeTagInfo> list = PhpDocTypeTagInfo.create(pHPDocVarTypeTag, this.fileScope);
            for (PhpDocTypeTagInfo phpDocTypeTagInfo : list) {
                if (!phpDocTypeTagInfo.getKind().equals((Object)ASTNodeInfo.Kind.VARIABLE)) continue;
                String string = phpDocTypeTagInfo.getName();
                List<PhpDocTypeTagInfo> list2 = this.varTypeComments.get(string);
                if (list2 == null) {
                    list2 = new ArrayList<PhpDocTypeTagInfo>();
                    this.varTypeComments.put(string, list2);
                }
                list2.add(phpDocTypeTagInfo);
            }
        }
    }

    @CheckForNull
    private ASTNode findConditionalStatement(List<ASTNode> list) {
        for (ASTNode aSTNode : list) {
            if (aSTNode instanceof IfStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof WhileStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof DoStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof ForEachStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof ForStatement) {
                return aSTNode;
            }
            if (aSTNode instanceof CatchClause) {
                return aSTNode;
            }
            if (!(aSTNode instanceof SwitchStatement)) continue;
            return aSTNode;
        }
        return null;
    }

    private CodeMarker findStrictCodeMarker(FileScopeImpl fileScopeImpl, int n, CodeMarker codeMarker) {
        this.buildCodeMarks();
        List<? extends CodeMarker> list = fileScopeImpl.getMarkers();
        for (CodeMarker codeMarker2 : list) {
            assert (codeMarker2 != null);
            if (!codeMarker2.getOffsetRange().containsInclusive(n)) continue;
            codeMarker = codeMarker2;
        }
        return codeMarker;
    }

    @CheckForNull
    public Occurence getOccurence(int n) {
        return this.findStrictOccurence((FileScopeImpl)this.getModelScope(), n);
    }

    @CheckForNull
    public Occurence getOccurence(ModelElement modelElement) {
        return this.findStrictOccurence((FileScopeImpl)this.getModelScope(), modelElement);
    }

    public VariableScope getNearestVariableScope(int n) {
        return this.findNearestVarScope((FileScopeImpl)this.getModelScope(), n, null);
    }

    public VariableScope getVariableScope(int n) {
        Scope scope = null;
        ArrayList<? extends ModelElement> arrayList = new ArrayList<ModelElement>();
        arrayList.add(this.getModelScope());
        arrayList.addAll(this.getModelScope().getElements());
        for (ModelElement modelElement : arrayList) {
            Scope scope2;
            if (modelElement instanceof VariableScope) {
                scope2 = (VariableScope)modelElement;
                if (!scope2.getBlockRange().containsInclusive(n) || scope != null && !scope.getBlockRange().overlaps(scope2.getBlockRange())) continue;
                scope = scope2;
                continue;
            }
            if (!(modelElement instanceof ClassScope)) continue;
            scope2 = (ClassScope)modelElement;
            Collection<? extends MethodScope> collection = scope2.getDeclaredMethods();
            for (MethodScope methodScope : collection) {
                OffsetRange offsetRange = methodScope.getBlockRange();
                if (offsetRange == null || !offsetRange.containsInclusive(n) || scope != null && !scope.getBlockRange().overlaps(methodScope.getBlockRange())) continue;
                scope = methodScope;
            }
        }
        return scope;
    }

    static List<Occurence> getAllOccurences(FileScope fileScope, Occurence occurence) {
        Scope scope;
        ModelElementImpl modelElementImpl = (ModelElementImpl)occurence.getDeclaration();
        if (modelElementImpl instanceof MethodScope && (scope = (MethodScope)((Object)modelElementImpl)).isConstructor()) {
            modelElementImpl = (ModelElementImpl)((Object)scope.getInScope());
        }
        if (modelElementImpl instanceof VarAssignmentImpl) {
            scope = (VarAssignmentImpl)modelElementImpl;
            modelElementImpl = ((AssignmentImpl)scope).getContainer();
        }
        scope = (FileScopeImpl)fileScope;
        return ((FileScopeImpl)scope).getAllOccurences(modelElementImpl);
    }

    public static IndexScope getIndexScope(ParserResult parserResult) {
        return new IndexScopeImpl(parserResult);
    }

    public static IndexScope getIndexScope(PHPIndex pHPIndex) {
        return new IndexScopeImpl(pHPIndex);
    }

    private void buildCodeMarks() {
        if (this.markerBuilder != null) {
            this.markerBuilder.build(this.fileScope);
            this.markerBuilder = null;
        }
    }

    private void buildOccurences() {
        if (this.occurencesBuilder != null) {
            this.occurencesBuilder.build(this.fileScope);
            this.occurencesBuilder = null;
        }
    }

    private Occurence findStrictOccurence(FileScopeImpl fileScopeImpl, int n) {
        Occurence occurence = null;
        this.buildOccurences();
        List<Occurence> list = fileScopeImpl.getOccurences();
        for (Occurence occurence2 : list) {
            assert (occurence2 != null);
            if (!occurence2.getOccurenceRange().containsInclusive(n)) continue;
            occurence = occurence2;
        }
        return occurence;
    }

    private Occurence findStrictOccurence(FileScopeImpl fileScopeImpl, ModelElement modelElement) {
        Occurence occurence = null;
        this.buildOccurences();
        List<Occurence> list = fileScopeImpl.getOccurences();
        for (Occurence occurence2 : list) {
            assert (occurence2 != null);
            if (!occurence2.getDeclaration().equals(modelElement)) continue;
            occurence = occurence2;
        }
        return occurence;
    }

    private VariableScope findNearestVarScope(Scope scope, int n, VariableScope variableScope) {
        this.buildOccurences();
        List<? extends ModelElement> list = scope.getElements();
        for (ModelElement modelElement : list) {
            FileObject fileObject;
            if (modelElement instanceof ClassScope) {
                variableScope = this.findNearestVarScope((ClassScope)modelElement, n, variableScope);
            }
            if (!(modelElement instanceof VariableScope) || modelElement.getNameRange().getStart() > n || variableScope != null && variableScope.getOffset() >= modelElement.getOffset() || !(modelElement instanceof VariableScope) || (fileObject = modelElement.getFileObject()) != scope.getFileObject()) continue;
            variableScope = (VariableScope)modelElement;
        }
        if (variableScope == null) {
            while (scope != null && !(scope instanceof VariableScope)) {
                scope = scope.getInScope();
            }
            variableScope = (VariableScope)scope;
        }
        return variableScope;
    }

    private VariableNameImpl findVariable(Scope scope, VariableBase variableBase) {
        Map<String, VariableNameImpl> map = this.vars.get(scope);
        VariableNameImpl variableNameImpl = null;
        while (scope != null && map != null) {
            if (variableBase instanceof Variable) {
                variableNameImpl = map.get(VariableNameImpl.toName((Variable)variableBase));
            }
            if (variableNameImpl != null) break;
            scope = scope.getInScope();
            map = this.vars.get(scope);
        }
        return variableNameImpl;
    }

    private OffsetRange getBlockRange(Scope scope) {
        ASTNode aSTNode = this.findConditionalStatement(this.getPath());
        OffsetRange offsetRange = aSTNode != null ? new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset()) : scope.getBlockRange();
        return offsetRange;
    }

    private void handleVarComments() {
        Set<String> set = this.varTypeComments.keySet();
        for (String string : set) {
            List<PhpDocTypeTagInfo> list = this.varTypeComments.get(string);
            if (list == null) continue;
            for (PhpDocTypeTagInfo phpDocTypeTagInfo : list) {
                Scope scope;
                VariableScope variableScope = this.getVariableScope(phpDocTypeTagInfo.getRange().getStart());
                VariableNameImpl variableNameImpl = null;
                if (variableScope instanceof Scope) {
                    scope = variableScope;
                    variableNameImpl = (VariableNameImpl)ModelUtils.getFirst(ModelUtils.filter(variableScope.getDeclaredVariables(), string));
                    if (variableNameImpl == null) {
                        variableNameImpl = new VariableNameImpl(scope, string, scope.getFile(), phpDocTypeTagInfo.getRange(), scope instanceof FileScopeImpl);
                    }
                }
                if (variableNameImpl != null) {
                    scope = new VarAssignmentImpl(variableNameImpl, (Scope)variableScope, this.getBlockRange(variableScope), phpDocTypeTagInfo.getRange(), phpDocTypeTagInfo.getTypeName());
                    variableNameImpl.addElement((ModelElementImpl)((Object)scope));
                }
                this.occurencesBuilder.prepare(phpDocTypeTagInfo.getTypeTag(), (Scope)variableScope);
            }
        }
    }

    private void prepareVarComments(Program program) {
        List<Comment> list = program.getComments();
        for (Comment comment : list) {
            Comment.Type type = comment.getCommentType();
            if (!type.equals((Object)Comment.Type.TYPE_VARTYPE)) continue;
            this.checkComments(comment);
        }
    }
}

