/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateInsertRequest;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateParameter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessor;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.codegen.ASTNodeUtilities;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelFactory;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class PHPCodeTemplateProcessor
implements CodeTemplateProcessor {
    private static final String NEW_VAR_NAME = "newVarName";
    private static final String VARIABLE_FROM_NEXT_ASSIGNMENT_NAME = "variableFromNextAssignmentName";
    private static final String VARIABLE_FROM_NEXT_ASSIGNMENT_TYPE = "variableFromNextAssignmentType";
    private final CodeTemplateInsertRequest request;
    private ParserResult info;

    public PHPCodeTemplateProcessor(CodeTemplateInsertRequest codeTemplateInsertRequest) {
        this.request = codeTemplateInsertRequest;
    }

    public void updateDefaultValues() {
        for (CodeTemplateParameter codeTemplateParameter : this.request.getMasterParameters()) {
            String string = this.getProposedValue(codeTemplateParameter);
            if (string == null || string.equals(codeTemplateParameter.getValue())) continue;
            codeTemplateParameter.setValue(string);
        }
    }

    public void parameterValueChanged(CodeTemplateParameter codeTemplateParameter, boolean bl) {
    }

    public void release() {
    }

    private String getNextVariableType(String string) {
        List<? extends VariableName> list;
        VariableName variableName;
        int n = this.request.getComponent().getCaretPosition();
        Model model = ModelFactory.getModel(this.info);
        VariableScope variableScope = model.getVariableScope(n);
        String string2 = string;
        if (string2 == null) {
            string2 = this.getNextVariableName();
        }
        if (string2 == null || variableScope == null) {
            return null;
        }
        if (string2.charAt(0) != '$') {
            string2 = "$" + string2;
        }
        if ((variableName = ModelUtils.getFirst(list = ModelUtils.filter(variableScope.getDeclaredVariables(), string2))) != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TypeScope object : variableName.getTypes(n)) {
                if (arrayList.contains(object.getName())) continue;
                arrayList.add(object.getName());
            }
            Object object = "";
            for (String string3 : arrayList) {
                object = (String)object + "|" + string3;
            }
            object = ((String)object).length() > 0 ? ((String)object).substring(1) : "type";
            return object;
        }
        return null;
    }

    private String getProposedValue(CodeTemplateParameter codeTemplateParameter) {
        String string = null;
        for (Map.Entry entry : codeTemplateParameter.getHints().entrySet()) {
            String string2 = (String)entry.getKey();
            if (NEW_VAR_NAME.equals(string2)) {
                return this.newVarName(codeTemplateParameter.getValue());
            }
            if (VARIABLE_FROM_NEXT_ASSIGNMENT_NAME.equals(string2)) {
                string = this.getNextVariableName();
                return string;
            }
            if (!VARIABLE_FROM_NEXT_ASSIGNMENT_TYPE.equals(string2)) continue;
            return this.getNextVariableType(string);
        }
        return null;
    }

    private String getNextVariableName() {
        if (!this.initParsing()) {
            return null;
        }
        int n = this.request.getComponent().getCaretPosition();
        ModelElement modelElement = null;
        Model model = ModelFactory.getModel(this.info);
        VariableScope variableScope = model.getVariableScope(n);
        if (variableScope != null) {
            Collection<? extends VariableName> collection = variableScope.getDeclaredVariables();
            for (VariableName variableName : collection) {
                int n2;
                if (modelElement == null) {
                    modelElement = variableName;
                    continue;
                }
                int n3 = Math.abs(variableName.getNameRange().getStart() - n);
                if (n3 >= (n2 = Math.abs(modelElement.getNameRange().getStart() - n))) continue;
                modelElement = variableName;
            }
        }
        return modelElement != null ? modelElement.getName().substring(1) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String newVarName(String string) {
        if (!this.initParsing()) {
            return null;
        }
        int n = this.request.getComponent().getCaretPosition();
        int n2 = 0;
        final String[] stringArray = new String[]{null};
        PHPCodeTemplateProcessor pHPCodeTemplateProcessor = this;
        synchronized (pHPCodeTemplateProcessor) {
            while (true) {
                stringArray[0] = string + (n2 > 0 ? String.valueOf(n2) : "");
                Set<String> set = ASTNodeUtilities.getVariablesInScope(this.info, n, new ASTNodeUtilities.VariableAcceptor(){

                    public boolean acceptVariable(String string) {
                        return stringArray[0].equals(string);
                    }
                });
                if (set.isEmpty()) break;
                ++n2;
            }
        }
        return stringArray[0];
    }

    private synchronized boolean initParsing() {
        if (this.info != null) {
            return true;
        }
        Document document = this.request.getComponent().getDocument();
        FileObject fileObject = NavUtils.getFile(document);
        if (fileObject == null) {
            return false;
        }
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)document)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    PHPCodeTemplateProcessor.this.info = (PHPParseResult)resultIterator.getParserResult();
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
            this.info = null;
            return false;
        }
        return true;
    }

    private static final class AssignmentLocator
    extends DefaultVisitor {
        private int offset;
        protected Assignment node = null;

        private AssignmentLocator() {
        }

        public Assignment locate(ASTNode aSTNode, int n) {
            this.offset = n;
            this.scan(aSTNode);
            return this.node;
        }

        public void scan(ASTNode aSTNode) {
            if (this.node == null && aSTNode != null) {
                aSTNode.accept(this);
            }
        }

        public void visit(Assignment assignment) {
            if (assignment != null && assignment.getStartOffset() > this.offset) {
                this.node = assignment;
            }
        }
    }

    public static final class Factory
    implements CodeTemplateProcessorFactory {
        public CodeTemplateProcessor createProcessor(CodeTemplateInsertRequest codeTemplateInsertRequest) {
            return new PHPCodeTemplateProcessor(codeTemplateInsertRequest);
        }
    }
}

