/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PHPCompletionItem;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelFactory;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InstanceOfExpression;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VarTypeResolver {
    private final String varName;
    private final List<ASTNode> pathUnderCaret;
    private final ASTNode blockOfCaret;
    private int anchor;
    private PHPIndex index;
    private ParserResult info;
    private PHPParseResult result;

    private VarTypeResolver(PHPCompletionItem.CompletionRequest completionRequest, String string) {
        this(string, completionRequest.anchor, completionRequest.index, completionRequest.info, completionRequest.result);
    }

    private VarTypeResolver(String string, int n, PHPIndex pHPIndex, ParserResult parserResult, PHPParseResult pHPParseResult) {
        this.result = pHPParseResult;
        this.anchor = n;
        this.index = pHPIndex;
        this.info = parserResult;
        this.varName = string;
        this.pathUnderCaret = NavUtils.underCaret(parserResult, n);
        this.blockOfCaret = this.findNearestBlock(this.pathUnderCaret);
    }

    private VarTypeResolver(ParserResult parserResult, int n, String string) {
        this(string, n, PHPIndex.get(parserResult), parserResult, (PHPParseResult)parserResult);
    }

    public static VarTypeResolver getInstance(PHPCompletionItem.CompletionRequest completionRequest, String string) {
        return new VarTypeResolver(completionRequest, string);
    }

    public static VarTypeResolver getInstance(ParserResult parserResult, int n, String string) {
        return new VarTypeResolver(parserResult, n, string);
    }

    public String resolveType() {
        TypeScope typeScope;
        List<? extends VariableName> object5;
        Object object;
        Object object3;
        Object object4;
        final HashMap<String, Union2<? extends ASTNode, String>> hashMap = new HashMap<String, Union2<? extends ASTNode, String>>();
        final HashMap hashMap2 = new HashMap();
        final LinkedList linkedList = new LinkedList();
        new DefaultVisitor(){

            public void scan(ASTNode aSTNode) {
                linkedList.add(aSTNode);
                super.scan(aSTNode);
                linkedList.remove(aSTNode);
            }

            public void visit(ClassDeclaration classDeclaration) {
                hashMap.put("$this", Union2.createSecond((Object)CodeUtils.extractClassName(classDeclaration)));
                hashMap.put("self", Union2.createSecond((Object)CodeUtils.extractClassName(classDeclaration)));
                hashMap.put("parent", Union2.createSecond((Object)CodeUtils.extractSuperClassName(classDeclaration)));
                super.visit(classDeclaration);
            }

            public void visit(FunctionDeclaration functionDeclaration) {
                int n = VarTypeResolver.this.anchor;
                if (n != -1 && n >= functionDeclaration.getStartOffset() && VarTypeResolver.this.isValidBlock(linkedList)) {
                    List<FormalParameter> list = functionDeclaration.getFormalParameters();
                    for (FormalParameter formalParameter : list) {
                        Identifier identifier = formalParameter.getParameterType();
                        if (identifier == null) continue;
                        String string = identifier.getName();
                        String string2 = null;
                        Expression expression = formalParameter.getParameterName();
                        Variable variable = null;
                        if (expression instanceof Reference) {
                            Reference reference = (Reference)expression;
                            if ((expression = reference.getExpression()) instanceof Variable) {
                                variable = (Variable)expression;
                            }
                        } else if (expression instanceof Variable) {
                            variable = (Variable)expression;
                        }
                        if (variable != null) {
                            string2 = CodeUtils.extractVariableName((Variable)expression);
                        }
                        if (string2 == null || string == null || string.length() <= 0) continue;
                        hashMap.put(string2, Union2.createSecond((Object)string));
                    }
                }
                super.visit(functionDeclaration);
            }

            public void visit(InstanceOfExpression instanceOfExpression) {
                super.visit(instanceOfExpression);
            }

            public void visit(CatchClause catchClause) {
                int n = VarTypeResolver.this.anchor;
                if (n != -1 && n >= catchClause.getStartOffset() && n <= catchClause.getEndOffset() && VarTypeResolver.this.isValidBlock(linkedList)) {
                    String string = CodeUtils.extractVariableName(catchClause.getVariable());
                    String string2 = catchClause.getClassName().getName();
                    if (string != null && string2 != null && string2.length() > 0) {
                        hashMap.put(string, Union2.createSecond((Object)string2));
                    }
                }
                super.visit(catchClause);
            }

            public void visit(FieldAccess fieldAccess) {
                if (VarTypeResolver.this.blockOfCaret.getStartOffset() <= fieldAccess.getStartOffset() && VarTypeResolver.this.blockOfCaret.getEndOffset() >= fieldAccess.getEndOffset() && VarTypeResolver.this.isValidBlock(linkedList)) {
                    String string;
                    Variable variable;
                    String string2;
                    Variable variable2 = fieldAccess.getField();
                    VariableBase variableBase = fieldAccess.getDispatcher();
                    if (variableBase instanceof Variable && (string2 = CodeUtils.extractVariableName(variable = (Variable)variableBase)) != null && string2.equals(VarTypeResolver.this.varName) && (string = CodeUtils.extractVariableName(variable2)) != null) {
                        hashMap2.put(string, ElementKind.FIELD);
                    }
                }
                super.visit(fieldAccess);
            }

            public void visit(MethodInvocation methodInvocation) {
                String string;
                Variable variable;
                String string2;
                VariableBase variableBase;
                int n = VarTypeResolver.this.anchor;
                if (n != -1 && n >= methodInvocation.getStartOffset() && VarTypeResolver.this.isValidBlock(linkedList) && (variableBase = methodInvocation.getDispatcher()) instanceof Variable && (string2 = CodeUtils.extractVariableName(variable = (Variable)variableBase)) != null && string2.equals(VarTypeResolver.this.varName) && (string = CodeUtils.extractFunctionName(methodInvocation.getMethod())) != null) {
                    hashMap2.put(string, ElementKind.METHOD);
                }
                super.visit(methodInvocation);
            }

            public void visit(Assignment assignment) {
                int n = VarTypeResolver.this.anchor;
                if (n != -1 && n >= assignment.getStartOffset()) {
                    VariableBase variableBase = assignment.getLeftHandSide();
                    Expression expression = assignment.getRightHandSide();
                    if (variableBase instanceof Variable || variableBase instanceof FieldAccess) {
                        String string = null;
                        if (variableBase instanceof Variable) {
                            string = CodeUtils.extractVariableName((Variable)variableBase);
                        } else if (variableBase instanceof FieldAccess) {
                            string = VarTypeResolver.this.getInternalName((FieldAccess)variableBase, hashMap);
                        } else assert (false) : variableBase.getClass().getName();
                        if (string != null) {
                            if (VarTypeResolver.this.isValidBlock(linkedList)) {
                                if (expression instanceof Reference) {
                                    while (expression instanceof Reference) {
                                        expression = ((Reference)expression).getExpression();
                                    }
                                }
                                if (expression instanceof Variable || expression instanceof FieldAccess) {
                                    String string2 = null;
                                    if (expression instanceof Variable) {
                                        string2 = CodeUtils.extractVariableName((Variable)expression);
                                    } else if (expression instanceof FieldAccess) {
                                        string2 = VarTypeResolver.this.getInternalName((FieldAccess)expression, hashMap);
                                    } else assert (false) : expression.getClass().getName();
                                    Union2 union2 = (Union2)hashMap.get(string2);
                                    if (union2 != null) {
                                        hashMap.put(string, union2);
                                    } else if (expression instanceof Variable) {
                                        hashMap.put(string, Union2.createFirst((Object)((Variable)expression)));
                                    } else if (expression instanceof FieldAccess) {
                                        hashMap.put(string, Union2.createFirst((Object)((FieldAccess)expression)));
                                    } else assert (false) : expression.getClass().getName();
                                } else if (expression instanceof ClassInstanceCreation) {
                                    ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
                                    ClassName className = classInstanceCreation.getClassName();
                                    Expression expression2 = className.getName();
                                    if (expression2 instanceof Identifier) {
                                        hashMap.put(string, Union2.createSecond((Object)((Identifier)expression2).getName()));
                                    } else {
                                        hashMap.put(string, null);
                                    }
                                } else {
                                    String string3 = null;
                                    if (expression instanceof VariableBase) {
                                        string3 = VarTypeResolver.this.evaluateVariableBase((VariableBase)expression, hashMap);
                                    }
                                    if (string3 == null) {
                                        hashMap.put(string, null);
                                    } else {
                                        hashMap.put(string, Union2.createSecond(string3));
                                    }
                                }
                            } else {
                                hashMap.put(string, null);
                            }
                        }
                    }
                    super.visit(assignment);
                }
            }
        }.scan(Utils.getRoot(this.info));
        String string = VarTypeResolver.findPrecedingType(this.varName, hashMap);
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string == null && (object4 = ((Model)(object3 = ModelFactory.getModel(this.info))).getVariableScope(this.anchor)) != null && (object = ModelUtils.getFirst(object5 = ModelUtils.filter(object4.getDeclaredVariables(), this.varName))) != null && (typeScope = ModelUtils.getFirst(object.getTypes(this.anchor))) != null) {
            string = typeScope.getName();
        }
        if (string == null && !hashMap2.isEmpty()) {
            object3 = null;
            for (Map.Entry entry : hashMap2.entrySet()) {
                if (object3 == null) {
                    object3 = new HashSet<String>(this.index.typeNamesForIdentifier((String)entry.getKey(), (ElementKind)entry.getValue(), QuerySupport.Kind.CASE_INSENSITIVE_PREFIX));
                } else {
                    object = this.index.typeNamesForIdentifier((String)entry.getKey(), (ElementKind)entry.getValue(), QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
                    object3.retainAll((Collection<?>)object);
                }
                if (object3.size() > 1) continue;
                break;
            }
            if (object3.size() == 1) {
                string = (String)object3.iterator().next();
            }
        }
        return string;
    }

    private String getInternalName(FieldAccess fieldAccess, Map<String, Union2<? extends ASTNode, String>> map) {
        Variable variable;
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        VariableBase variableBase = fieldAccess.getDispatcher();
        String string2 = this.evaluateVariableBase(variableBase, map);
        if (string2 != null && (string = CodeUtils.extractVariableName(variable = fieldAccess.getField())) != null) {
            if (string.startsWith("$")) {
                string.substring(1);
            }
            stringBuffer.append(string2).append("::").append(string);
            return stringBuffer.toString();
        }
        return null;
    }

    private String evaluateVariableBase(VariableBase variableBase, Map<String, Union2<? extends ASTNode, String>> map) {
        String string = null;
        Stack<VariableBase> stack = new Stack<VariableBase>();
        VarTypeResolver.createVariableBaseChain(variableBase, stack);
        while (!stack.isEmpty() && stack.peek() != null) {
            VariableBase variableBase2 = stack.pop();
            if (string == null) {
                if (variableBase2 instanceof FunctionInvocation) {
                    string = VarTypeResolver.getReturnType((FunctionInvocation)variableBase2, this.result, this.index);
                } else if (variableBase2 instanceof Variable) {
                    string = VarTypeResolver.findPrecedingType((Variable)variableBase2, map);
                } else if (variableBase2 instanceof StaticFieldAccess) {
                    string = VarTypeResolver.getReturnType((StaticFieldAccess)variableBase2, this.result, this.index);
                } else if (variableBase2 instanceof StaticMethodInvocation) {
                    string = VarTypeResolver.getReturnType((StaticMethodInvocation)variableBase2, this.result, this.index);
                }
                if (string != null) continue;
                break;
            }
            if (variableBase2 instanceof MethodInvocation) {
                string = VarTypeResolver.getReturnType(string, (MethodInvocation)variableBase2, this.result, this.index);
                continue;
            }
            string = null;
            break;
        }
        return string;
    }

    private static void createVariableBaseChain(VariableBase variableBase, Stack<VariableBase> stack) {
        stack.push(variableBase);
        if (variableBase instanceof MethodInvocation) {
            VarTypeResolver.createVariableBaseChain(((MethodInvocation)variableBase).getDispatcher(), stack);
        }
    }

    private static String getReturnType(FunctionInvocation functionInvocation, PHPParseResult pHPParseResult, PHPIndex pHPIndex) {
        Collection<IndexedFunction> collection = pHPIndex.getFunctions(pHPParseResult, CodeUtils.extractFunctionName(functionInvocation), QuerySupport.Kind.EXACT);
        if (!collection.isEmpty()) {
            IndexedFunction indexedFunction = collection.iterator().next();
            return indexedFunction.getReturnType();
        }
        return null;
    }

    private static String getReturnType(StaticMethodInvocation staticMethodInvocation, PHPParseResult pHPParseResult, PHPIndex pHPIndex) {
        FunctionInvocation functionInvocation;
        String string;
        StaticMethodInvocation staticMethodInvocation2 = staticMethodInvocation;
        String string2 = staticMethodInvocation2.getClassName().getName();
        Collection<IndexedFunction> collection = pHPIndex.getAllMethods(pHPParseResult, string2, string = CodeUtils.extractFunctionName(functionInvocation = staticMethodInvocation2.getMethod()), QuerySupport.Kind.EXACT, -1);
        if (!collection.isEmpty()) {
            IndexedFunction indexedFunction = collection.iterator().next();
            return indexedFunction.getReturnType();
        }
        return null;
    }

    private static String getReturnType(StaticFieldAccess staticFieldAccess, PHPParseResult pHPParseResult, PHPIndex pHPIndex) {
        Collection<IndexedConstant> collection;
        StaticFieldAccess staticFieldAccess2 = staticFieldAccess;
        String string = staticFieldAccess2.getClassName().getName();
        Variable variable = staticFieldAccess2.getField();
        String string2 = CodeUtils.extractVariableName(variable);
        if (string2 != null && !(collection = pHPIndex.getAllFields(pHPParseResult, string, string2 = string2.startsWith("$") ? string2.substring(1) : string2, QuerySupport.Kind.EXACT, -1)).isEmpty()) {
            IndexedConstant indexedConstant = collection.iterator().next();
            return indexedConstant.getTypeName();
        }
        return null;
    }

    private static String getReturnType(String string, VariableBase variableBase, PHPParseResult pHPParseResult, PHPIndex pHPIndex) {
        return null;
    }

    private static String getReturnType(String string, MethodInvocation methodInvocation, PHPParseResult pHPParseResult, PHPIndex pHPIndex) {
        FunctionInvocation functionInvocation = methodInvocation.getMethod();
        String string2 = CodeUtils.extractFunctionName(functionInvocation);
        Collection<IndexedFunction> collection = pHPIndex.getAllMethods(pHPParseResult, string, string2, QuerySupport.Kind.EXACT, -1);
        if (!collection.isEmpty()) {
            IndexedFunction indexedFunction = collection.iterator().next();
            return indexedFunction.getReturnType();
        }
        return null;
    }

    private static String findPrecedingType(Variable variable, Map<String, Union2<? extends ASTNode, String>> map) {
        String string = CodeUtils.extractVariableName(variable);
        if (string == null) {
            return null;
        }
        return VarTypeResolver.findPrecedingType(string, map);
    }

    private static String findPrecedingType(String string, Map<String, Union2<? extends ASTNode, String>> map) {
        String string2 = null;
        Union2<? extends ASTNode, String> union2 = map.get(string);
        if (union2 != null && union2.hasSecond()) {
            string2 = (String)union2.second();
        }
        return string2;
    }

    private ASTNode findNearestBlock(List<ASTNode> list) {
        ASTNode aSTNode = null;
        int n = list.size();
        for (int i = n - 1; i >= 0; --i) {
            ASTNode aSTNode2 = list.get(i);
            if (!(aSTNode2 instanceof Program) && !(aSTNode2 instanceof Block) && !(aSTNode2 instanceof FunctionDeclaration)) continue;
            aSTNode = aSTNode2;
            break;
        }
        return aSTNode;
    }

    private boolean isValidBlock(List<ASTNode> list) {
        if (this.varName != null && this.varName.contains("::")) {
            return true;
        }
        ASTNode aSTNode = this.findNearestBlock(list);
        if (aSTNode == null) {
            return false;
        }
        if (this.blockOfCaret == aSTNode) {
            return true;
        }
        int n = this.pathUnderCaret.size();
        for (int i = n - 1; i >= 0; --i) {
            ASTNode aSTNode2 = this.pathUnderCaret.get(i);
            if (aSTNode2 instanceof FunctionDeclaration) {
                if (aSTNode instanceof FunctionDeclaration) {
                    String string = CodeUtils.extractFunctionName((FunctionDeclaration)aSTNode2);
                    String string2 = CodeUtils.extractFunctionName((FunctionDeclaration)aSTNode);
                    return string.equals(string2);
                }
                return false;
            }
            if (aSTNode2 != aSTNode) continue;
            return true;
        }
        return false;
    }
}

