/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.core.GsfTaskProvider;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.TaskProcessor;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TLIndexerFactory
extends EmbeddingIndexerFactory {
    private static final Logger LOG = Logger.getLogger(TLIndexerFactory.class.getName());
    public static final String INDEXER_NAME = "TLIndexer";
    public static final int INDEXER_VERSION = 2;
    public static final String FIELD_GROUP_NAME = "groupName";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_LINE_NUMBER = "lineNumber";
    private static Set<FileObject> karelPr = new HashSet<FileObject>();

    public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
        return new TLIndexer();
    }

    public void filesDeleted(Collection<? extends Indexable> collection, Context context) {
        try {
            IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
            for (Indexable indexable : collection) {
                indexingSupport.removeDocuments(indexable);
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
        }
    }

    public void filesDirty(Collection<? extends Indexable> collection, Context context) {
        try {
            IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
            for (Indexable indexable : collection) {
                indexingSupport.markDirtyDocuments(indexable);
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
        }
    }

    public String getIndexerName() {
        return INDEXER_NAME;
    }

    public int getIndexVersion() {
        return 2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TLIndexer
    extends EmbeddingIndexer {
        private TLIndexer() {
        }

        protected void index(Indexable indexable, Parser.Result result, Context context) {
            try {
                IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                ParserResult parserResult = (ParserResult)result;
                this.saveErrors(parserResult.getDiagnostics(), parserResult.getSnapshot(), indexingSupport, indexable);
                FileObject fileObject = result.getSnapshot().getSource().getFileObject();
                if (!karelPr.contains(fileObject)) {
                    karelPr.add(fileObject);
                    if (karelPr.size() == 1) {
                        try {
                            TaskProcessor.runWhenScanFinished((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                                public Void run() throws Exception {
                                    for (FileObject fileObject : karelPr) {
                                        GsfTaskProvider.refresh(fileObject);
                                    }
                                    karelPr = new HashSet();
                                    return null;
                                }
                            }, Collections.emptyList());
                        }
                        catch (ParseException parseException) {
                            Exceptions.printStackTrace((Throwable)parseException);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
        }

        private void saveErrors(List<? extends Error> list, Snapshot snapshot, IndexingSupport indexingSupport, Indexable indexable) {
            if (list == null || list.isEmpty()) {
                indexingSupport.addDocument(indexingSupport.createDocument(indexable));
                return;
            }
            List<Integer> list2 = TLIndexer.getLineStartOffsets(snapshot);
            for (Error error : list) {
                IndexDocument indexDocument = indexingSupport.createDocument(indexable);
                indexDocument.addPair(TLIndexerFactory.FIELD_GROUP_NAME, error.getSeverity() == Severity.ERROR ? "nb-tasklist-error" : "nb-tasklist-warning", false, true);
                indexDocument.addPair(TLIndexerFactory.FIELD_DESCRIPTION, error.getDisplayName(), false, true);
                int n = snapshot.getOriginalOffset(error.getStartPosition());
                int n2 = 1;
                if (n >= 0) {
                    int n3 = Collections.binarySearch(list2, n);
                    if (n3 < 0) {
                        int n4 = -n3 - 1;
                        assert (n4 >= 1 && n4 <= list2.size()) : "idx=" + n3 + ", lineNumber=" + n4 + ", lineStartOffsets.size()=" + list2.size();
                        if (n4 >= 1 && n4 <= list2.size()) {
                            n2 = n4;
                        }
                    } else {
                        n2 = n3 + 1;
                    }
                }
                indexDocument.addPair(TLIndexerFactory.FIELD_LINE_NUMBER, Integer.toString(n2), false, true);
                indexingSupport.addDocument(indexDocument);
            }
        }

        private static List<Integer> getLineStartOffsets(Snapshot snapshot) {
            Source source = snapshot.getSource();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(0);
            CharSequence charSequence = source.createSnapshot().getText();
            for (int i = 0; i < charSequence.length(); ++i) {
                if (charSequence.charAt(i) != '\n') continue;
                arrayList.add(i + 1);
            }
            return arrayList;
        }
    }
}

