/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.TaskListener;

public final class GsfTaskProvider
extends PushTaskScanner {
    private static final Logger LOG = Logger.getLogger(GsfTaskProvider.class.getName());
    private static GsfTaskProvider INSTANCE;
    private PushTaskScanner.Callback callback;
    private TaskScanningScope scope;
    private static final Set<RequestProcessor.Task> TASKS;
    private static boolean clearing;
    private static final RequestProcessor WORKER;

    public GsfTaskProvider() {
        this(GsfTaskProvider.getAllLanguageNames());
        INSTANCE = this;
    }

    private GsfTaskProvider(String string) {
        super(NbBundle.getMessage(GsfTaskProvider.class, (String)"GsfTasks", (Object)string), NbBundle.getMessage(GsfTaskProvider.class, (String)"GsfTasksDesc", (Object)string), null);
    }

    public synchronized void setScope(TaskScanningScope taskScanningScope, PushTaskScanner.Callback callback) {
        GsfTaskProvider.cancelAllCurrent();
        this.scope = taskScanningScope;
        this.callback = callback;
        if (taskScanningScope == null || callback == null) {
            return;
        }
        for (FileObject fileObject : taskScanningScope.getLookup().lookupAll(FileObject.class)) {
            GsfTaskProvider.enqueue(new Work(fileObject, callback));
        }
        for (FileObject fileObject : taskScanningScope.getLookup().lookupAll(Project.class)) {
            GsfTaskProvider.enqueue(new Work((Project)fileObject, callback));
        }
    }

    public static void refresh(FileObject fileObject) {
        if (INSTANCE != null) {
            INSTANCE.refreshImpl(fileObject);
        }
    }

    private synchronized void refreshImpl(FileObject fileObject) {
        LOG.log(Level.FINE, "refresh: {0}", fileObject);
        if (this.scope == null || this.callback == null) {
            return;
        }
        if (!this.scope.isInScope(fileObject)) {
            if (!fileObject.isFolder()) {
                return;
            }
            for (FileObject fileObject2 : this.scope.getLookup().lookupAll(FileObject.class)) {
                if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) continue;
                GsfTaskProvider.enqueue(new Work(fileObject2, this.callback));
            }
            return;
        }
        LOG.log(Level.FINE, "enqueing work for: {0}", fileObject);
        GsfTaskProvider.enqueue(new Work(fileObject, this.callback));
    }

    static String getAllLanguageNames() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Language language : LanguageRegistry.getInstance()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(language.getDisplayName());
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enqueue(Work work) {
        Set<RequestProcessor.Task> set = TASKS;
        synchronized (set) {
            RequestProcessor.Task task = WORKER.post((Runnable)work);
            TASKS.add(task);
            task.addTaskListener(new TaskListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void taskFinished(org.openide.util.Task task) {
                    Set set = TASKS;
                    synchronized (set) {
                        if (!clearing) {
                            TASKS.remove((RequestProcessor.Task)task);
                        }
                    }
                }
            });
            if (task.isFinished()) {
                TASKS.remove(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancelAllCurrent() {
        Set<RequestProcessor.Task> set = TASKS;
        synchronized (set) {
            clearing = true;
            try {
                for (RequestProcessor.Task task : TASKS) {
                    task.cancel();
                }
                TASKS.clear();
            }
            finally {
                clearing = false;
            }
        }
    }

    static {
        TASKS = new HashSet<RequestProcessor.Task>();
        WORKER = new RequestProcessor("CSL Task Provider");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Work
    implements Runnable {
        private final FileObject file;
        private final Project project;
        private final PushTaskScanner.Callback callback;

        public Work(FileObject fileObject, PushTaskScanner.Callback callback) {
            Parameters.notNull((CharSequence)"file", (Object)fileObject);
            Parameters.notNull((CharSequence)"callback", (Object)callback);
            this.file = fileObject;
            this.project = null;
            this.callback = callback;
        }

        public Work(Project project, PushTaskScanner.Callback callback) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"callback", (Object)callback);
            this.file = null;
            this.project = project;
            this.callback = callback;
        }

        @Override
        public void run() {
            Collection collection = null;
            if (this.file != null) {
                FileObject fileObject;
                Collection collection2 = QuerySupport.findRoots((FileObject)this.file, null, Collections.emptyList(), Collections.emptyList());
                String string = null;
                QuerySupport querySupport = collection2.iterator();
                while (querySupport.hasNext() && null == (string = FileUtil.getRelativePath((FileObject)(fileObject = (FileObject)querySupport.next()), (FileObject)this.file))) {
                }
                LOG.log(Level.FINE, "Querying TL index for {0}", string);
                assert (string != null) : "File " + this.file + " not under roots: " + collection2;
                if (string != null) {
                    try {
                        querySupport = QuerySupport.forRoots((String)"TLIndexer", (int)2, (FileObject[])collection2.toArray(new FileObject[collection2.size()]));
                        collection = querySupport.query("_sn", string, QuerySupport.Kind.EXACT, new String[0]);
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.WARNING, null, iOException);
                    }
                }
            } else {
                Collection collection3 = QuerySupport.findRoots((Project)this.project, null, Collections.emptyList(), Collections.emptyList());
                try {
                    QuerySupport querySupport = QuerySupport.forRoots((String)"TLIndexer", (int)2, (FileObject[])collection3.toArray(new FileObject[collection3.size()]));
                    collection = querySupport.query("_sn", "", QuerySupport.Kind.PREFIX, new String[0]);
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
            }
            if (collection != null) {
                Work.pushTasks(collection, this.callback);
            }
        }

        private static void pushTasks(Collection<? extends IndexResult> collection, PushTaskScanner.Callback callback) {
            Object object;
            HashMap hashMap = new HashMap();
            for (IndexResult indexResult : collection) {
                String string;
                object = indexResult.getFile();
                if (object == null || !object.isValid()) continue;
                ArrayList<Task> arrayList = (ArrayList<Task>)hashMap.get(object);
                if (arrayList == null) {
                    arrayList = new ArrayList<Task>();
                    hashMap.put((FileObject)object, arrayList);
                }
                if ((string = indexResult.getValue("description")) == null) continue;
                int n = 1;
                try {
                    n = Integer.parseInt(indexResult.getValue("lineNumber"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Task task = Task.create((FileObject)object, (String)indexResult.getValue("groupName"), (String)string, (int)n);
                arrayList.add(task);
            }
            for (FileObject fileObject : hashMap.keySet()) {
                object = (List)hashMap.get(fileObject);
                LOG.log(Level.FINE, "Refreshing TL for {0} with {1}", new Object[]{fileObject, object});
                callback.setTasks(fileObject, (List)object);
            }
        }
    }
}

