/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.io.IOException;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.completion.impl.xref.ReferenceImpl;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.UserQuestionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceResolverImpl
extends CsmReferenceResolver {
    public boolean isKindOf(CsmReference csmReference, Set<CsmReferenceKind> set) {
        return ((Object)set).equals(CsmReferenceKind.ALL) || set.contains(csmReference.getKind());
    }

    public CsmReference findReference(CsmFile csmFile, int n) {
        assert (csmFile != null);
        BaseDocument baseDocument = ReferencesSupport.getDocument(csmFile);
        if (baseDocument == null) {
            return null;
        }
        ReferenceImpl referenceImpl = ReferencesSupport.createReferenceImpl(csmFile, baseDocument, n);
        return referenceImpl;
    }

    public CsmReference findReference(CsmFile csmFile, int n, int n2) {
        assert (csmFile != null);
        BaseDocument baseDocument = ReferencesSupport.getDocument(csmFile);
        if (baseDocument == null) {
            return null;
        }
        int n3 = ReferencesSupport.getDocumentOffset(baseDocument, n, n2);
        ReferenceImpl referenceImpl = ReferencesSupport.createReferenceImpl(csmFile, baseDocument, n3);
        return referenceImpl;
    }

    public CsmReference findReference(Node node) {
        JEditorPane[] jEditorPaneArray;
        assert (node != null) : "activatedNode must be not null";
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie != null && (jEditorPaneArray = CsmUtilities.getOpenedPanesInEQ((EditorCookie)editorCookie)) != null && jEditorPaneArray.length > 0) {
            int n = jEditorPaneArray[0].getSelectionStart();
            StyledDocument styledDocument = null;
            try {
                try {
                    styledDocument = editorCookie.openDocument();
                }
                catch (UserQuestionException userQuestionException) {
                    userQuestionException.confirmed();
                    styledDocument = editorCookie.openDocument();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
            return this.findReferenceInDoc(styledDocument, n);
        }
        return null;
    }

    public CsmReference findReference(Document document, int n) {
        return this.findReferenceInDoc(document, n);
    }

    private CsmReference findReferenceInDoc(Document document, int n) {
        CsmFile csmFile;
        if (document instanceof BaseDocument && (csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)false)) != null) {
            return ReferencesSupport.createReferenceImpl(csmFile, (BaseDocument)document, n);
        }
        return null;
    }

    public CsmReferenceResolver.Scope fastCheckScope(CsmReference csmReference) {
        return ReferencesSupport.fastCheckScope(csmReference);
    }
}

