/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.utils.CndFileVisibilityQuery;
import org.netbeans.modules.cnd.api.utils.CndVisibilityQuery;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.MakeSources;
import org.netbeans.modules.cnd.makeproject.NativeProjectProvider;
import org.netbeans.modules.cnd.makeproject.api.SourceFolderInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configurations;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationMakefileWriter;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationXMLWriter;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.utils.PathPanel;
import org.netbeans.modules.cnd.ui.options.ToolsPanel;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeConfigurationDescriptor
extends ConfigurationDescriptor
implements ChangeListener {
    public static final String EXTERNAL_FILES_FOLDER = "ExternalFiles";
    public static final String SOURCE_FILES_FOLDER = "SourceFiles";
    public static final String HEADER_FILES_FOLDER = "HeaderFiles";
    public static final String RESOURCE_FILES_FOLDER = "ResourceFiles";
    public static final String ICONBASE = "org/netbeans/modules/cnd/makeproject/ui/resources/makeProject";
    public static final String ICON = "org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif";
    public static final Icon MAKEFILE_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif", (boolean)false);
    public static final String DEFAULT_IGNORE_FOLDERS_PATTERN = "^(nbproject|build|test)$";
    public static final String DEFAULT_NO_IGNORE_FOLDERS_PATTERN = "^$";
    private Project project = null;
    private String baseDir;
    private boolean modified = false;
    private Folder externalFileItems = null;
    private Folder rootFolder = null;
    private HashMap<String, Item> projectItems = null;
    private final List<String> sourceRoots = new ArrayList<String>();
    private final Set<ChangeListener> projectItemsChangeListeners = new HashSet<ChangeListener>();
    private NativeProject nativeProject = null;
    public static final String DEFAULT_PROJECT_MAKFILE_NAME = "Makefile";
    private String projectMakefileName = "Makefile";
    private RequestProcessor.Task initTask = null;
    private CndVisibilityQuery folderVisibilityQuery = null;

    public MakeConfigurationDescriptor(String string) {
        this.baseDir = string;
        this.rootFolder = new Folder(this, null, "root", "root", true);
        this.projectItems = new HashMap();
        this.setModified(true);
        ToolsPanel.addCompilerSetModifiedListener((ChangeListener)this);
    }

    @Override
    public void closed() {
        ToolsPanel.removeCompilerSetModifiedListener((ChangeListener)this);
        for (Item item : this.getProjectItems()) {
            DataObject dataObject = item.getDataObject();
            if (dataObject == null) continue;
            dataObject.removePropertyChangeListener((PropertyChangeListener)item);
        }
        this.closed(this.rootFolder);
    }

    private void closed(Folder folder) {
        if (folder != null) {
            for (Folder folder2 : folder.getAllFolders(false)) {
                folder2.detachListener();
            }
            folder.detachListener();
        }
    }

    public void clean() {
        Configurations configurations = this.getConfs();
        if (configurations != null) {
            for (Configuration configuration : configurations.getConfs()) {
                if (configuration == null) continue;
                configuration.setAuxObjects(Collections.<ConfigurationAuxObject>emptyList());
            }
        }
        this.projectItems.clear();
        this.rootFolder = null;
    }

    public static MakeConfigurationDescriptor getMakeConfigurationDescriptor(Project project) {
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (configurationDescriptorProvider != null) {
            MakeConfigurationDescriptor makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
            return makeConfigurationDescriptor;
        }
        return null;
    }

    public MakeConfiguration getActiveConfiguration() {
        Configurations configurations = this.getConfs();
        if (configurations != null) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)configurations.getActive();
            if (makeConfiguration == null && MakeProject.TRACE_MAKE_PROJECT_CREATION) {
                new Exception("There are no active configuration in the project descriptor MakeConfigurationDescriptor@" + System.identityHashCode(this) + " for project " + this.getBaseDir()).printStackTrace();
            }
            return makeConfiguration;
        }
        if (MakeProject.TRACE_MAKE_PROJECT_CREATION) {
            new Exception("There are no configurations in the project descriptor MakeConfigurationDescriptor@" + System.identityHashCode(this) + " for project " + this.getBaseDir()).printStackTrace();
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.setModified();
    }

    public Project getProject() {
        if (this.project == null) {
            String string = FilePathAdaptor.mapToLocal(this.getBaseDir());
            try {
                FileObject fileObject = FileUtil.toFileObject((File)new File(string));
                this.project = ProjectManager.getDefault().findProject(fileObject);
            }
            catch (Exception exception) {
                System.err.println("Cannot find project in '" + string + "' " + exception);
            }
        }
        return this.project;
    }

    public void init(Configuration configuration) {
        super.init(new Configuration[]{configuration}, 0);
        this.setModified(true);
    }

    public void setInitTask(RequestProcessor.Task task) {
        this.initTask = task;
    }

    synchronized void waitInitTask() {
        if (this.initTask == null) {
            return;
        }
        this.initTask.waitFinished();
        this.initTask = null;
    }

    public void initLogicalFolders(Iterator<SourceFolderInfo> iterator, boolean bl, Iterator<String> iterator2, String string) {
        Object object;
        if (bl) {
            this.rootFolder.addNewFolder(SOURCE_FILES_FOLDER, MakeConfigurationDescriptor.getString("SourceFilesTxt"), true);
            this.rootFolder.addNewFolder(HEADER_FILES_FOLDER, MakeConfigurationDescriptor.getString("HeaderFilesTxt"), true);
            this.rootFolder.addNewFolder(RESOURCE_FILES_FOLDER, MakeConfigurationDescriptor.getString("ResourceFilesTxt"), true);
        }
        this.externalFileItems = this.rootFolder.addNewFolder(EXTERNAL_FILES_FOLDER, MakeConfigurationDescriptor.getString("ImportantFilesTxt"), false);
        this.externalFileItems.addItem(new Item(this.getProjectMakefileName()));
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                this.externalFileItems.addItem(new Item(iterator2.next()));
            }
        }
        if (string != null && (object = this.rootFolder.findFolderByName(SOURCE_FILES_FOLDER)) != null) {
            ((Folder)object).addItem(new Item(string));
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = iterator.next();
                this.addSourceFilesFromRoot(this.getLogicalFolders(), object.getFile(), false, true);
            }
        }
        this.setModified(true);
    }

    public String getProjectMakefileName() {
        return this.projectMakefileName;
    }

    public void setProjectMakefileName(String string) {
        this.projectMakefileName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectItemsChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.projectItemsChangeListeners;
        synchronized (set) {
            this.projectItemsChangeListeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectItemsChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.projectItemsChangeListeners;
        synchronized (set) {
            this.projectItemsChangeListeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireProjectItemsChangeEvent(Item item, int n) {
        Iterator<ChangeListener> iterator;
        Object object = this.projectItemsChangeListeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.projectItemsChangeListeners).iterator();
        }
        object = new ProjectItemChangeEvent(this, item, n);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ChangeListener> getProjectItemsChangeListeners() {
        Set<ChangeListener> set = this.projectItemsChangeListeners;
        synchronized (set) {
            return new HashSet<ChangeListener>(this.projectItemsChangeListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectItemsChangeListeners(Set<ChangeListener> set) {
        Set<ChangeListener> set2 = this.projectItemsChangeListeners;
        synchronized (set2) {
            this.projectItemsChangeListeners.clear();
            this.projectItemsChangeListeners.addAll(set);
        }
    }

    @Override
    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String string) {
        this.baseDir = string;
    }

    public HashMap<String, Item> getProjectItemsMap() {
        return this.projectItems;
    }

    public void setProjectItemsMap(HashMap<String, Item> hashMap) {
        this.projectItems = hashMap;
    }

    public void init(Configuration[] configurationArray) {
        super.init(configurationArray, 0);
    }

    @Override
    public Icon getIcon() {
        return MAKEFILE_ICON;
    }

    @Override
    public Configuration defaultConf(String string, int n) {
        MakeConfiguration makeConfiguration = new MakeConfiguration(this, string, n);
        Item[] itemArray = this.getProjectItems();
        for (int i = 0; i < itemArray.length; ++i) {
            makeConfiguration.addAuxObject(new ItemConfiguration(makeConfiguration, itemArray[i]));
        }
        return makeConfiguration;
    }

    public void setExternalFileItems(Vector vector) {
        this.externalFileItems.reset();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.externalFileItems.addItem(new Item((String)enumeration.nextElement()));
        }
    }

    public void setExternalFileItems(Folder folder) {
        this.externalFileItems = folder;
    }

    public Folder getExternalFileItems() {
        return this.externalFileItems;
    }

    public Item[] getExternalFileItemsAsArray() {
        return this.externalFileItems.getItemsAsArray();
    }

    public Folder getExternalItemFolder() {
        return this.externalFileItems;
    }

    public Folder getLogicalFolders() {
        return this.rootFolder;
    }

    public void setLogicalFolders(Folder folder) {
        this.rootFolder = folder;
    }

    public Item[] getProjectItems() {
        Collection<Item> collection = this.projectItems.values();
        return collection.toArray(new Item[collection.size()]);
    }

    public Item findItemByFile(File file) {
        Collection<Item> collection = this.projectItems.values();
        Iterator<Item> iterator = collection.iterator();
        Item item = null;
        while (iterator.hasNext()) {
            File file2;
            Item item2 = iterator.next();
            File file3 = item2.getNormalizedFile();
            if (file3 == file || file3.getPath().equals(file.getPath())) {
                return item2;
            }
            if (item != null || (file2 = item2.getCanonicalFile()) != file && !file2.getPath().equals(file.getPath())) continue;
            item = item2;
        }
        return item;
    }

    public Item findProjectItemByPath(String string) {
        Item item = this.projectItems.get(string = FilePathAdaptor.normalize(string));
        if (item == null) {
            String string2 = IpeUtils.isPathAbsolute((String)string) ? IpeUtils.toRelativePath((String)this.getBaseDir(), (String)FilePathAdaptor.naturalize(string)) : IpeUtils.toAbsolutePath((String)this.getBaseDir(), (String)string);
            string2 = FilePathAdaptor.normalize(string2);
            item = this.projectItems.get(string2);
        }
        return item;
    }

    public Item findExternalItemByPath(String string) {
        if (this.externalFileItems == null) {
            return null;
        }
        Item item = this.externalFileItems.findItemByPath(string = FilePathAdaptor.normalize(string));
        if (item == null) {
            String string2 = IpeUtils.isPathAbsolute((String)string) ? IpeUtils.toRelativePath((String)this.getBaseDir(), (String)FilePathAdaptor.naturalize(string)) : IpeUtils.toAbsolutePath((String)this.getBaseDir(), (String)string);
            string2 = FilePathAdaptor.normalize(string2);
            item = this.externalFileItems.findItemByPath(string2);
        }
        return item;
    }

    public Folder findFolderByPath(String string) {
        return this.getLogicalFolders().findFolderByPath(string);
    }

    public void addProjectItem(Item item) {
        this.projectItems.put(item.getPath(), item);
        this.fireProjectItemsChangeEvent(item, 0);
        this.setModified(true);
    }

    public void fireFilesAdded(List<NativeFileItem> list) {
        this.getNativeProject().fireFilesAdded(list);
    }

    public void removeProjectItem(Item item) {
        this.projectItems.remove(item.getPath());
        this.fireProjectItemsChangeEvent(item, 1);
        this.setModified(true);
    }

    public void fireFilesRemoved(List<NativeFileItem> list) {
        if (this.getNativeProject() != null) {
            this.getNativeProject().fireFilesRemoved(list);
        }
    }

    public void fireFileRenamed(String string, NativeFileItem nativeFileItem) {
        this.getNativeProject().fireFileRenamed(string, nativeFileItem);
    }

    public void checkForChangedItems(Project project, Folder folder, Item item) {
        this.getNativeProject().checkForChangedItems(folder, item);
        MakeLogicalViewProvider.checkForChangedItems(project, folder, item);
    }

    @Override
    public void copyFromProjectDescriptor(ConfigurationDescriptor configurationDescriptor) {
        MakeConfigurationDescriptor makeConfigurationDescriptor = (MakeConfigurationDescriptor)configurationDescriptor;
        this.setConfs(makeConfigurationDescriptor.getConfs());
        this.setBaseDir(configurationDescriptor.getBaseDir());
        this.setProjectMakefileName(makeConfigurationDescriptor.getProjectMakefileName());
        this.setExternalFileItems(makeConfigurationDescriptor.getExternalFileItems());
        this.setLogicalFolders(makeConfigurationDescriptor.getLogicalFolders());
        this.setProjectItemsMap(((MakeConfigurationDescriptor)configurationDescriptor).getProjectItemsMap());
        this.setProjectItemsChangeListeners(((MakeConfigurationDescriptor)configurationDescriptor).getProjectItemsChangeListeners());
        this.setSourceRoots(((MakeConfigurationDescriptor)configurationDescriptor).getSourceRootsRaw());
    }

    @Override
    public void assign(ConfigurationDescriptor configurationDescriptor) {
        Configuration[] configurationArray = configurationDescriptor.getConfs().getConfs();
        Configuration[] configurationArray2 = new Configuration[configurationArray.length];
        this.setBaseDir(configurationDescriptor.getBaseDir());
        for (int i = 0; i < configurationArray.length; ++i) {
            if (configurationArray[i].getCloneOf() != null) {
                configurationArray[i].getCloneOf().assign(configurationArray[i]);
                configurationArray2[i] = configurationArray[i].getCloneOf();
                continue;
            }
            configurationArray2[i] = configurationArray[i];
        }
        this.init(configurationArray2, configurationDescriptor.getConfs().getActiveAsIndex());
        this.setProjectMakefileName(((MakeConfigurationDescriptor)configurationDescriptor).getProjectMakefileName());
        this.setExternalFileItems(((MakeConfigurationDescriptor)configurationDescriptor).getExternalFileItems());
        this.setLogicalFolders(((MakeConfigurationDescriptor)configurationDescriptor).getLogicalFolders());
        this.setProjectItemsMap(((MakeConfigurationDescriptor)configurationDescriptor).getProjectItemsMap());
        this.setProjectItemsChangeListeners(((MakeConfigurationDescriptor)configurationDescriptor).getProjectItemsChangeListeners());
        this.setSourceRoots(((MakeConfigurationDescriptor)configurationDescriptor).getSourceRootsRaw());
        this.setFolderVisibilityQuery(((MakeConfigurationDescriptor)configurationDescriptor).getFolderVisibilityQuery().getRegEx());
    }

    @Override
    public ConfigurationDescriptor cloneProjectDescriptor() {
        MakeConfigurationDescriptor makeConfigurationDescriptor = new MakeConfigurationDescriptor(this.getBaseDir());
        super.cloneProjectDescriptor(makeConfigurationDescriptor);
        makeConfigurationDescriptor.setProjectMakefileName(this.getProjectMakefileName());
        makeConfigurationDescriptor.setExternalFileItems(this.getExternalFileItems());
        makeConfigurationDescriptor.setLogicalFolders(this.getLogicalFolders());
        makeConfigurationDescriptor.setProjectItemsMap(this.getProjectItemsMap());
        makeConfigurationDescriptor.setProjectItemsChangeListeners(this.getProjectItemsChangeListeners());
        makeConfigurationDescriptor.setSourceRoots(this.getSourceRootsRaw());
        makeConfigurationDescriptor.setFolderVisibilityQuery(this.getFolderVisibilityQuery().getRegEx());
        return makeConfigurationDescriptor;
    }

    @Override
    public boolean getModified() {
        return this.modified;
    }

    @Override
    public void setModified() {
        this.setModified(true);
    }

    @Override
    public void setModified(boolean bl) {
        this.modified = bl;
        if (bl && this.getConfs() != null) {
            Configuration[] configurationArray = this.getConfs().getConfs();
            for (int i = 0; i < configurationArray.length; ++i) {
                ((MakeConfiguration)configurationArray[i]).setRequiredLanguagesDirty(true);
            }
        }
    }

    public void refreshRequiredLanguages() {
        if (this.getConfs() != null) {
            Configuration[] configurationArray = this.getConfs().getConfs();
            for (int i = 0; i < configurationArray.length; ++i) {
                ((MakeConfiguration)configurationArray[i]).reCountLanguages(this);
            }
        }
    }

    @Override
    public boolean save() {
        return this.save(null);
    }

    @Override
    public boolean save(String string) {
        SaveRunnable saveRunnable = new SaveRunnable(string);
        RequestProcessor.Task task = RequestProcessor.getDefault().post((Runnable)saveRunnable);
        task.waitFinished();
        return saveRunnable.ret;
    }

    public void addAdditionalHeaderExtensions(Collection<String> collection) {
        ((MakeProject)this.getProject()).addAdditionalHeaderExtensions(collection);
    }

    public CndVisibilityQuery getFolderVisibilityQuery() {
        if (this.folderVisibilityQuery == null) {
            this.folderVisibilityQuery = new CndVisibilityQuery(DEFAULT_IGNORE_FOLDERS_PATTERN);
        }
        return this.folderVisibilityQuery;
    }

    public void setFolderVisibilityQuery(String string) {
        if (this.folderVisibilityQuery == null) {
            this.folderVisibilityQuery = new CndVisibilityQuery(string);
        } else {
            this.folderVisibilityQuery.setPattern(string);
        }
    }

    private boolean saveWorker(String string) {
        Comparable<File> comparable;
        int n;
        Object[] objectArray;
        Object object;
        if (this.getState() != ConfigurationDescriptor.State.READY) {
            return false;
        }
        Configuration[] configurationArray = this.getConfs().getConfs();
        for (int i = 0; i < configurationArray.length; ++i) {
            object = configurationArray[i];
            objectArray = ((Configuration)object).getAuxObjects();
            for (n = 0; n < objectArray.length; n += 1) {
                if (objectArray[n].hasChanged()) {
                    this.setModified(true);
                }
                objectArray[n].clearChanged();
            }
        }
        this.updateExtensionList();
        if (!this.getModified()) {
            return true;
        }
        Vector<String> vector = new Vector<String>();
        object = new Vector();
        vector.add(this.getBaseDir() + File.separator + "nbproject" + File.separator + "project.xml");
        vector.add(this.getBaseDir() + File.separator + "nbproject" + File.separator + "configurations.xml");
        vector.add(this.getBaseDir() + File.separator + "nbproject" + File.separator + "Makefile-impl.mk");
        objectArray = this.getConfs().getConfs();
        for (n = 0; n < objectArray.length; n += 1) {
            vector.add(this.getBaseDir() + File.separator + "nbproject" + File.separator + "Makefile-" + ((Configuration)objectArray[n]).getName() + ".mk");
        }
        n = 1;
        for (int i = 0; i < vector.size(); ++i) {
            comparable = new File((String)vector.elementAt(i));
            if (!((File)comparable).exists() || ((File)comparable).canWrite()) continue;
            n = 0;
            ((Vector)object).add(vector.elementAt(i));
        }
        if (!n) {
            String string2 = IpeUtils.getBaseName((String)this.getBaseDir());
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append(MakeConfigurationDescriptor.getString("CannotSaveTxt", string2));
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                ((StringBuilder)comparable).append("\n").append((String)((Vector)object).elementAt(i));
            }
            if (string != null) {
                ((StringBuilder)comparable).append("\n\n").append(string);
            }
            NotifyDescriptor.Message message = new NotifyDescriptor.Message(comparable, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return n != 0;
        }
        FileObject fileObject = null;
        fileObject = FileUtil.toFileObject((File)new File(this.getBaseDir()));
        if (fileObject != null) {
            if (MakeProject.TRACE_MAKE_PROJECT_CREATION) {
                System.err.println("Start of writting project descriptor MakeConfigurationDescriptor@" + System.identityHashCode(this) + " for project " + fileObject.getName() + " @" + System.identityHashCode(this));
            }
            new ConfigurationXMLWriter(fileObject, this).write();
            new ConfigurationMakefileWriter(this).write();
            this.ConfigurationProjectXMLWriter();
            if (MakeProject.TRACE_MAKE_PROJECT_CREATION) {
                System.err.println("End of writting project descriptor MakeConfigurationDescriptor@" + System.identityHashCode(this) + " for project " + fileObject.getName() + " @" + System.identityHashCode(this));
            }
        }
        this.setModified(false);
        return n != 0;
    }

    private void ConfigurationProjectXMLWriter() {
        try {
            Object object;
            AntProjectHelper antProjectHelper = ((MakeProject)this.getProject()).getAntProjectHelper();
            Element element = antProjectHelper.getPrimaryConfigurationData(true);
            Document document = element.getOwnerDocument();
            NodeList nodeList = element.getElementsByTagName("make-dep-projects");
            if (nodeList != null && nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    object = nodeList.item(i);
                    element.removeChild((Node)object);
                }
            }
            Element element2 = document.createElementNS("http://www.netbeans.org/ns/make-project/1", "make-dep-projects");
            object = this.getSubprojectLocations();
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                String string = object2.next();
                Element element3 = document.createElement("make-dep-project");
                element3.appendChild(document.createTextNode(string));
                element2.appendChild(element3);
            }
            element.appendChild(element2);
            antProjectHelper.putPrimaryConfigurationData(element, true);
            nodeList = element.getElementsByTagName("sourceEncoding");
            if (nodeList != null && nodeList.getLength() > 0) {
                object2 = nodeList.item(0);
                object2.setTextContent(((MakeProject)this.getProject()).getSourceEncoding());
            } else {
                object2 = document.createElementNS("http://www.netbeans.org/ns/make-project/1", "sourceEncoding");
                object2.appendChild(document.createTextNode(((MakeProject)this.getProject()).getSourceEncoding()));
                element.appendChild((Node)object2);
            }
            antProjectHelper.putPrimaryConfigurationData(element, true);
            ProjectManager.getDefault().saveProject(this.project);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private void updateExtensionList() {
        Set<String> set = MakeProject.createExtensionSet();
        Set<String> set2 = MakeProject.createExtensionSet();
        Set<String> set3 = MakeProject.createExtensionSet();
        for (Item item : this.getProjectItems()) {
            String string = item.getPath();
            String string2 = FileUtil.getExtension((String)string);
            if (string2.length() <= 0 || set.contains(string2) || set2.contains(string2) || set3.contains(string2)) continue;
            if (MIMEExtensions.isRegistered((String)"text/x-h", (String)string2)) {
                set.add(string2);
                continue;
            }
            if (MIMEExtensions.isRegistered((String)"text/x-c", (String)string2)) {
                set2.add(string2);
                continue;
            }
            if (!MIMEExtensions.isRegistered((String)"text/x-c++", (String)string2)) continue;
            set3.add(string2);
        }
        MakeProject makeProject = (MakeProject)this.getProject();
        if (makeProject != null) {
            makeProject.updateExtensions(set2, set3, set);
        }
    }

    public Set<String> getSubprojectLocations() {
        HashSet<String> hashSet = new HashSet<String>();
        Configuration[] configurationArray = this.getConfs().getConfs();
        for (int i = 0; i < configurationArray.length; ++i) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)configurationArray[i];
            LibrariesConfiguration librariesConfiguration = null;
            if (((MakeConfiguration)configurationArray[i]).isLinkerConfiguration()) {
                librariesConfiguration = makeConfiguration.getLinkerConfiguration().getLibrariesConfiguration();
                for (LibraryItem libraryItem : librariesConfiguration.getValue()) {
                    if (!(libraryItem instanceof LibraryItem.ProjectItem)) continue;
                    LibraryItem libraryItem2 = libraryItem;
                    hashSet.add(((LibraryItem.ProjectItem)libraryItem2).getMakeArtifact().getProjectLocation());
                }
            }
            for (LibraryItem libraryItem : makeConfiguration.getRequiredProjectsConfiguration().getValue()) {
                hashSet.add(((LibraryItem.ProjectItem)libraryItem).getMakeArtifact().getProjectLocation());
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceRootRaw(String string) {
        List<String> list = this.sourceRoots;
        synchronized (list) {
            this.sourceRoots.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSourceRoot(String string) {
        String string2 = IpeUtils.toAbsolutePath((String)this.getBaseDir(), (String)string);
        String string3 = null;
        try {
            string3 = new File(string2).getCanonicalPath();
        }
        catch (IOException iOException) {
            string3 = null;
        }
        String string4 = FilePathAdaptor.normalize(IpeUtils.toRelativePath((String)this.getBaseDir(), (String)string));
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = this.sourceRoots;
        synchronized (list) {
            if (string3 != null) {
                int n = string3.length();
                for (String string5 : this.sourceRoots) {
                    String string6 = IpeUtils.toAbsolutePath((String)this.getBaseDir(), (String)string5);
                    String string7 = null;
                    try {
                        string7 = new File(string6).getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        string7 = null;
                    }
                    if (string7 == null) continue;
                    int n2 = string7.length();
                    if (string7.equals(string3)) {
                        bl = false;
                        break;
                    }
                    if (string7.startsWith(string3) && string7.charAt(n) == File.separatorChar) {
                        arrayList.add(string5);
                        continue;
                    }
                    if (!string3.startsWith(string7) || string3.charAt(n2) != File.separatorChar) continue;
                    bl = false;
                    break;
                }
            }
            if (arrayList.size() > 0) {
                for (String string8 : arrayList) {
                    this.sourceRoots.remove(string8);
                }
            }
            if (bl) {
                String string8 = PathPanel.getMode() == 0 ? FilePathAdaptor.normalize(IpeUtils.toAbsoluteOrRelativePath((String)this.getBaseDir(), (String)string)) : (PathPanel.getMode() == 1 ? string4 : string2);
                this.sourceRoots.add(string8);
                this.setModified();
            }
        }
    }

    private List<String> getSourceRootsRaw() {
        return this.sourceRoots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceRoots(List<String> list) {
        List<String> list2 = this.sourceRoots;
        synchronized (list2) {
            this.sourceRoots.clear();
            this.sourceRoots.addAll(list);
        }
    }

    private boolean inList(List<String> list, String string) {
        for (String string2 : list) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForChangedSourceRoots(List<String> list, List<String> list2) {
        List<String> list3 = this.sourceRoots;
        synchronized (list3) {
            MakeSources makeSources;
            Object object;
            Object object2;
            this.sourceRoots.clear();
            for (String object42 : list2) {
                this.addSourceRoot(object42);
            }
            MakeConfiguration makeConfiguration = (MakeConfiguration)this.getConfs().getActive();
            if (!makeConfiguration.isMakefileConfiguration()) {
                MakeSources makeSources2 = (MakeSources)this.getProject().getLookup().lookup(MakeSources.class);
                if (makeSources2 != null) {
                    makeSources2.sourceRootsChanged();
                }
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : this.sourceRoots) {
                if (this.inList(list, string)) continue;
                arrayList.add(string);
            }
            ArrayList arrayList2 = new ArrayList();
            for (String string : list) {
                if (this.inList(this.sourceRoots, string)) continue;
                arrayList2.add(string);
            }
            if (arrayList.size() > 0) {
                for (String string : arrayList) {
                    object2 = IpeUtils.toAbsolutePath((String)this.getBaseDir(), (String)string);
                    object = new File((String)object2);
                    this.addSourceFilesFromRoot(this.getLogicalFolders(), (File)object, true, true);
                }
                this.setModified();
            }
            if (arrayList2.size() > 0) {
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    String string;
                    string = (String)iterator.next();
                    object2 = this.getLogicalFolders().getAllFolders(this.modified);
                    object = ((Vector)object2).iterator();
                    while (object.hasNext()) {
                        Folder folder = (Folder)object.next();
                        if (folder.getRoot() == null || !folder.getRoot().equals(string)) continue;
                        this.getLogicalFolders().removeFolderAction(folder);
                    }
                }
                this.setModified();
            }
            if ((arrayList.size() > 0 || arrayList2.size() > 0) && (makeSources = (MakeSources)this.getProject().getLookup().lookup(MakeSources.class)) != null) {
                makeSources.sourceRootsChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSourceRoots() {
        ArrayList<String> arrayList;
        List<String> list = this.sourceRoots;
        synchronized (list) {
            arrayList = new ArrayList<String>(this.sourceRoots);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAbsoluteSourceRoots() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = this.sourceRoots;
        synchronized (list) {
            for (String string : this.sourceRoots) {
                arrayList.add(IpeUtils.toAbsolutePath((String)this.baseDir, (String)string));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSourceRootsAsArray() {
        List<String> list = this.sourceRoots;
        synchronized (list) {
            String[] stringArray = new String[this.sourceRoots.size()];
            int n = 0;
            for (String string : this.sourceRoots) {
                stringArray[n++] = string;
            }
            return stringArray;
        }
    }

    private NativeProjectProvider getNativeProject() {
        if (this.nativeProject == null) {
            FileObject fileObject = FileUtil.toFileObject((File)new File(this.baseDir));
            try {
                Project project = ProjectManager.getDefault().findProject(fileObject);
                this.nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class);
            }
            catch (Exception exception) {
                System.err.println("getNativeProject " + exception);
            }
        }
        return (NativeProjectProvider)this.nativeProject;
    }

    public Folder addSourceFilesFromRoot(Folder folder, File file, boolean bl, boolean bl2) {
        Object object;
        ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
        Folder folder2 = folder.findFolderByName(file.getName());
        if (folder2 == null) {
            folder2 = new Folder(folder.getConfigurationDescriptor(), folder, file.getName(), file.getName(), true);
            folder.addFolder(folder2);
        }
        if (bl2) {
            object = PathPanel.getMode() == 0 ? IpeUtils.toAbsoluteOrRelativePath((String)this.baseDir, (String)file.getPath()) : (PathPanel.getMode() == 1 ? IpeUtils.toRelativePath((String)this.baseDir, (String)file.getPath()) : IpeUtils.toAbsolutePath((String)this.baseDir, (String)file.getPath()));
            object = FilePathAdaptor.normalize((String)object);
            folder2.setRoot((String)object);
        }
        this.addFiles(folder2, file, null, arrayList, true);
        this.getNativeProject().fireFilesAdded(arrayList);
        if (bl) {
            folder2.attachListeners();
        }
        this.addSourceRoot(file.getPath());
        object = (MakeSources)this.getProject().getLookup().lookup(MakeSources.class);
        if (object != null) {
            ((MakeSources)object).sourceRootsChanged();
        }
        return folder2;
    }

    public Folder addSourceFilesFromFolder(Folder folder, File file, boolean bl) {
        ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
        Folder folder2 = new Folder(folder.getConfigurationDescriptor(), folder, file.getName(), file.getName(), true);
        folder.addFolder(folder2);
        this.addFiles(folder2, file, null, arrayList, true);
        this.getNativeProject().fireFilesAdded(arrayList);
        if (bl) {
            folder2.attachListeners();
        }
        return folder2;
    }

    private void addFiles(Folder folder, File file, ProgressHandle progressHandle, ArrayList<NativeFileItem> arrayList, boolean bl) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            Object object;
            if (!VisibilityQuery.getDefault().isVisible(fileArray[i]) || fileArray[i].isFile() && !CndFileVisibilityQuery.getDefault().isVisible(fileArray[i]) || fileArray[i].isDirectory() && this.getFolderVisibilityQuery().isVisible(fileArray[i])) continue;
            if (fileArray[i].isDirectory()) {
                object = folder;
                object = folder.findFolderByName(fileArray[i].getName());
                if (object == null) {
                    object = folder.addNewFolder(fileArray[i].getName(), fileArray[i].getName(), true);
                }
                this.addFiles((Folder)object, fileArray[i], progressHandle, arrayList, bl);
                continue;
            }
            object = PathPanel.getMode() == 0 ? IpeUtils.toAbsoluteOrRelativePath((String)this.baseDir, (String)fileArray[i].getPath()) : (PathPanel.getMode() == 1 ? IpeUtils.toRelativePath((String)this.baseDir, (String)fileArray[i].getPath()) : IpeUtils.toAbsolutePath((String)this.baseDir, (String)fileArray[i].getPath()));
            Item item = new Item(FilePathAdaptor.normalize((String)object));
            if (folder.addItem(item, bl) != null) {
                arrayList.add(item);
            }
            if (progressHandle == null) continue;
            progressHandle.progress((String)object);
        }
    }

    public boolean okToChange() {
        int n;
        int n2 = this.getVersion();
        if (n2 < (n = 62)) {
            String string = MakeConfigurationDescriptor.getString("UPGRADE_TXT");
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, MakeConfigurationDescriptor.getString("UPGRADE_DIALOG_TITLE"), 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) != NotifyDescriptor.YES_OPTION) {
                return false;
            }
            this.setVersion(n);
        }
        return true;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(MakeConfigurationDescriptor.class, (String)string);
    }

    private static String getString(String string, String string2) {
        return NbBundle.getMessage(MakeConfigurationDescriptor.class, (String)string, (Object)string2);
    }

    public static class ProjectItemChangeEvent
    extends ChangeEvent {
        public static final int ITEM_ADDED = 0;
        public static final int ITEM_REMOVED = 1;
        private Item item;
        private int action;

        public ProjectItemChangeEvent(Object object, Item item, int n) {
            super(object);
            this.item = item;
            this.action = n;
        }

        public Item getItem() {
            return this.item;
        }

        public int getAction() {
            return this.action;
        }
    }

    private class SaveRunnable
    implements Runnable {
        public boolean ret = false;
        private String extraMessage;

        public SaveRunnable(String string) {
            this.extraMessage = string;
        }

        public void run() {
            this.ret = MakeConfigurationDescriptor.this.saveWorker(this.extraMessage);
        }
    }
}

