/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.ArchiverConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.AssemblerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.DebuggerChooserConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.FortranCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.LinkerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakefileConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.QmakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.RequiredProjectsConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.configurations.ui.CompilerSetNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.DevelopmentHostNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.RequiredProjectsNodeProp;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeConfiguration
extends Configuration {
    public static final String MAKEFILE_IMPL = "Makefile-impl.mk";
    public static final String BUILD_FOLDER = "build";
    public static final String DIST_FOLDER = "dist";
    public static final String EXT_FOLDER = "_ext";
    public static final String OBJECTDIR_MACRO_NAME = "OBJECTDIR";
    public static final String OBJECTDIR_MACRO = "${OBJECTDIR}";
    private static String[] TYPE_NAMES = new String[]{MakeConfiguration.getString("MakefileName"), MakeConfiguration.getString("ApplicationName"), MakeConfiguration.getString("DynamicLibraryName"), MakeConfiguration.getString("StaticLibraryName"), MakeConfiguration.getString("QtApplicationName"), MakeConfiguration.getString("QtDynamicLibraryName"), MakeConfiguration.getString("QtStaticLibraryName")};
    public static final int TYPE_MAKEFILE = 0;
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_DYNAMIC_LIB = 2;
    public static final int TYPE_STATIC_LIB = 3;
    public static final int TYPE_QT_APPLICATION = 4;
    public static final int TYPE_QT_DYNAMIC_LIB = 5;
    public static final int TYPE_QT_STATIC_LIB = 6;
    private IntConfiguration configurationType;
    private MakefileConfiguration makefileConfiguration;
    private CompilerSet2Configuration compilerSet;
    private LanguageBooleanConfiguration cRequired;
    private LanguageBooleanConfiguration cppRequired;
    private LanguageBooleanConfiguration fortranRequired;
    private LanguageBooleanConfiguration assemblerRequired;
    private DevelopmentHostConfiguration developmentHost;
    private BooleanConfiguration dependencyChecking;
    private CCompilerConfiguration cCompilerConfiguration;
    private CCCompilerConfiguration ccCompilerConfiguration;
    private FortranCompilerConfiguration fortranCompilerConfiguration;
    private AssemblerConfiguration assemblerConfiguration;
    private LinkerConfiguration linkerConfiguration;
    private ArchiverConfiguration archiverConfiguration;
    private PackagingConfiguration packagingConfiguration;
    private RequiredProjectsConfiguration requiredProjectsConfiguration;
    private DebuggerChooserConfiguration debuggerChooserConfiguration;
    private QmakeConfiguration qmakeConfiguration;
    private boolean languagesDirty = true;

    public MakeConfiguration(MakeConfigurationDescriptor makeConfigurationDescriptor, String string, int n) {
        this(makeConfigurationDescriptor.getBaseDir(), string, n, CompilerSetManager.getDefaultDevelopmentHost());
    }

    public MakeConfiguration(String string, String string2, int n) {
        this(string, string2, n, CompilerSetManager.getDefaultDevelopmentHost());
    }

    public MakeConfiguration(String string, String string2, int n, String string3) {
        super(string, string2);
        this.configurationType = new IntConfiguration(null, n, TYPE_NAMES, null);
        this.developmentHost = new DevelopmentHostConfiguration(ExecutionEnvironmentFactory.fromUniqueID((String)string3));
        this.compilerSet = new CompilerSet2Configuration(this.developmentHost);
        this.cRequired = new LanguageBooleanConfiguration();
        this.cppRequired = new LanguageBooleanConfiguration();
        this.fortranRequired = new LanguageBooleanConfiguration();
        this.assemblerRequired = new LanguageBooleanConfiguration();
        this.makefileConfiguration = new MakefileConfiguration(this);
        this.dependencyChecking = new BooleanConfiguration(null, this.isMakefileConfiguration() ? false : MakeOptions.getInstance().getDepencyChecking());
        this.cCompilerConfiguration = new CCompilerConfiguration(string, null);
        this.ccCompilerConfiguration = new CCCompilerConfiguration(string, null);
        this.fortranCompilerConfiguration = new FortranCompilerConfiguration(string, null);
        this.assemblerConfiguration = new AssemblerConfiguration(string, null);
        this.linkerConfiguration = new LinkerConfiguration(this);
        this.archiverConfiguration = new ArchiverConfiguration(this);
        this.packagingConfiguration = new PackagingConfiguration(this);
        this.requiredProjectsConfiguration = new RequiredProjectsConfiguration();
        this.debuggerChooserConfiguration = new DebuggerChooserConfiguration();
        this.qmakeConfiguration = new QmakeConfiguration(this);
        this.developmentHost.addPropertyChangeListener(this.compilerSet);
    }

    public void setMakefileConfiguration(MakefileConfiguration makefileConfiguration) {
        this.makefileConfiguration = makefileConfiguration;
        this.makefileConfiguration.setMakeConfiguration(this);
    }

    public MakefileConfiguration getMakefileConfiguration() {
        return this.makefileConfiguration;
    }

    public IntConfiguration getConfigurationType() {
        return this.configurationType;
    }

    public void setConfigurationType(IntConfiguration intConfiguration) {
        this.configurationType = intConfiguration;
    }

    public BooleanConfiguration getDependencyChecking() {
        return this.dependencyChecking;
    }

    public void setDependencyChecking(BooleanConfiguration booleanConfiguration) {
        this.dependencyChecking = booleanConfiguration;
    }

    public CompilerSet2Configuration getCompilerSet() {
        return this.compilerSet;
    }

    public void setCompilerSet(CompilerSet2Configuration compilerSet2Configuration) {
        this.compilerSet = compilerSet2Configuration;
    }

    public LanguageBooleanConfiguration getCRequired() {
        return this.cRequired;
    }

    public LanguageBooleanConfiguration getCppRequired() {
        return this.cppRequired;
    }

    public LanguageBooleanConfiguration getFortranRequired() {
        return this.fortranRequired;
    }

    public void setCRequired(LanguageBooleanConfiguration languageBooleanConfiguration) {
        this.cRequired = languageBooleanConfiguration;
    }

    public void setCppRequired(LanguageBooleanConfiguration languageBooleanConfiguration) {
        this.cppRequired = languageBooleanConfiguration;
    }

    public void setFortranRequired(LanguageBooleanConfiguration languageBooleanConfiguration) {
        this.fortranRequired = languageBooleanConfiguration;
    }

    public LanguageBooleanConfiguration getAssemblerRequired() {
        return this.assemblerRequired;
    }

    public void setAssemblerRequired(LanguageBooleanConfiguration languageBooleanConfiguration) {
        this.assemblerRequired = languageBooleanConfiguration;
    }

    public PlatformInfo getPlatformInfo() {
        PlatformInfo platformInfo = PlatformInfo.getDefault((ExecutionEnvironment)this.getDevelopmentHost().getExecutionEnvironment());
        return platformInfo;
    }

    public DevelopmentHostConfiguration getDevelopmentHost() {
        return this.developmentHost;
    }

    public void setDevelopmentHost(DevelopmentHostConfiguration developmentHostConfiguration) {
        this.developmentHost = developmentHostConfiguration;
    }

    public boolean isApplicationConfiguration() {
        switch (this.getConfigurationType().getValue()) {
            case 1: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean isCompileConfiguration() {
        return this.getConfigurationType().getValue() == 1 || this.getConfigurationType().getValue() == 2 || this.getConfigurationType().getValue() == 3;
    }

    public boolean isLibraryConfiguration() {
        switch (this.getConfigurationType().getValue()) {
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean isLinkerConfiguration() {
        return this.getConfigurationType().getValue() == 1 || this.getConfigurationType().getValue() == 2;
    }

    public boolean isMakefileConfiguration() {
        return this.getConfigurationType().getValue() == 0;
    }

    public boolean isDynamicLibraryConfiguration() {
        switch (this.getConfigurationType().getValue()) {
            case 2: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public boolean isArchiverConfiguration() {
        return this.getConfigurationType().getValue() == 3;
    }

    public boolean isQmakeConfiguration() {
        switch (this.getConfigurationType().getValue()) {
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public void setCCompilerConfiguration(CCompilerConfiguration cCompilerConfiguration) {
        this.cCompilerConfiguration = cCompilerConfiguration;
    }

    public CCompilerConfiguration getCCompilerConfiguration() {
        return this.cCompilerConfiguration;
    }

    public void setCCCompilerConfiguration(CCCompilerConfiguration cCCompilerConfiguration) {
        this.ccCompilerConfiguration = cCCompilerConfiguration;
    }

    public CCCompilerConfiguration getCCCompilerConfiguration() {
        return this.ccCompilerConfiguration;
    }

    public void setFortranCompilerConfiguration(FortranCompilerConfiguration fortranCompilerConfiguration) {
        this.fortranCompilerConfiguration = fortranCompilerConfiguration;
    }

    public FortranCompilerConfiguration getFortranCompilerConfiguration() {
        return this.fortranCompilerConfiguration;
    }

    public void setAssemblerConfiguration(AssemblerConfiguration assemblerConfiguration) {
        this.assemblerConfiguration = assemblerConfiguration;
    }

    public AssemblerConfiguration getAssemblerConfiguration() {
        return this.assemblerConfiguration;
    }

    public void setLinkerConfiguration(LinkerConfiguration linkerConfiguration) {
        this.linkerConfiguration = linkerConfiguration;
        this.linkerConfiguration.setMakeConfiguration(this);
    }

    public LinkerConfiguration getLinkerConfiguration() {
        return this.linkerConfiguration;
    }

    public void setArchiverConfiguration(ArchiverConfiguration archiverConfiguration) {
        this.archiverConfiguration = archiverConfiguration;
        this.archiverConfiguration.setMakeConfiguration(this);
    }

    public ArchiverConfiguration getArchiverConfiguration() {
        return this.archiverConfiguration;
    }

    public void setPackagingConfiguration(PackagingConfiguration packagingConfiguration) {
        this.packagingConfiguration = packagingConfiguration;
        this.packagingConfiguration.setMakeConfiguration(this);
    }

    public PackagingConfiguration getPackagingConfiguration() {
        return this.packagingConfiguration;
    }

    public RequiredProjectsConfiguration getRequiredProjectsConfiguration() {
        return this.requiredProjectsConfiguration;
    }

    public void setRequiredProjectsConfiguration(RequiredProjectsConfiguration requiredProjectsConfiguration) {
        this.requiredProjectsConfiguration = requiredProjectsConfiguration;
    }

    public DebuggerChooserConfiguration getDebuggerChooserConfiguration() {
        return this.debuggerChooserConfiguration;
    }

    public void setDebuggerChooserConfiguration(DebuggerChooserConfiguration debuggerChooserConfiguration) {
        this.debuggerChooserConfiguration = debuggerChooserConfiguration;
    }

    public QmakeConfiguration getQmakeConfiguration() {
        return this.qmakeConfiguration;
    }

    public void setQmakeConfiguration(QmakeConfiguration qmakeConfiguration) {
        this.qmakeConfiguration = qmakeConfiguration;
    }

    @Override
    public void assign(Configuration configuration) {
        MakeConfiguration makeConfiguration = (MakeConfiguration)configuration;
        this.setName(makeConfiguration.getName());
        this.setBaseDir(makeConfiguration.getBaseDir());
        this.getConfigurationType().assign(makeConfiguration.getConfigurationType());
        this.getDevelopmentHost().assign(makeConfiguration.getDevelopmentHost());
        this.getCompilerSet().assign(makeConfiguration.getCompilerSet());
        this.getCRequired().assign(makeConfiguration.getCRequired());
        this.getCppRequired().assign(makeConfiguration.getCppRequired());
        this.getFortranRequired().assign(makeConfiguration.getFortranRequired());
        this.getAssemblerRequired().assign(makeConfiguration.getAssemblerRequired());
        this.getDependencyChecking().assign(makeConfiguration.getDependencyChecking());
        this.getMakefileConfiguration().assign(makeConfiguration.getMakefileConfiguration());
        this.getCCompilerConfiguration().assign(makeConfiguration.getCCompilerConfiguration());
        this.getCCCompilerConfiguration().assign(makeConfiguration.getCCCompilerConfiguration());
        this.getFortranCompilerConfiguration().assign(makeConfiguration.getFortranCompilerConfiguration());
        this.getAssemblerConfiguration().assign(makeConfiguration.getAssemblerConfiguration());
        this.getLinkerConfiguration().assign(makeConfiguration.getLinkerConfiguration());
        this.getArchiverConfiguration().assign(makeConfiguration.getArchiverConfiguration());
        this.getPackagingConfiguration().assign(makeConfiguration.getPackagingConfiguration());
        this.getRequiredProjectsConfiguration().assign(makeConfiguration.getRequiredProjectsConfiguration());
        this.getDebuggerChooserConfiguration().assign(makeConfiguration.getDebuggerChooserConfiguration());
        this.getQmakeConfiguration().assign(makeConfiguration.getQmakeConfiguration());
        ConfigurationAuxObject[] configurationAuxObjectArray = this.getAuxObjects();
        for (int i = 0; i < configurationAuxObjectArray.length; ++i) {
            String string = configurationAuxObjectArray[i].getId();
            ConfigurationAuxObject configurationAuxObject = configuration.getAuxObject(string);
            if (configurationAuxObject != null) {
                configurationAuxObjectArray[i].assign(configurationAuxObject);
                continue;
            }
            System.err.println("Configuration - assign: Object ID " + string + " do not found");
        }
    }

    @Override
    public Configuration cloneConf() {
        return (Configuration)this.clone();
    }

    @Override
    public Configuration copy() {
        MakeConfiguration makeConfiguration = new MakeConfiguration(this.getBaseDir(), this.getName(), this.getConfigurationType().getValue());
        makeConfiguration.assign(this);
        ConfigurationAuxObject[] configurationAuxObjectArray = this.getAuxObjects();
        Vector<ConfigurationAuxObject> vector = new Vector<ConfigurationAuxObject>();
        for (int i = 0; i < configurationAuxObjectArray.length; ++i) {
            if (configurationAuxObjectArray[i] instanceof ItemConfiguration) {
                vector.add(((ItemConfiguration)configurationAuxObjectArray[i]).copy(makeConfiguration));
                continue;
            }
            String string = configurationAuxObjectArray[i].getId();
            ConfigurationAuxObject configurationAuxObject = makeConfiguration.getAuxObject(string);
            if (configurationAuxObject != null) {
                configurationAuxObject.assign(configurationAuxObjectArray[i]);
                vector.add(configurationAuxObject);
                continue;
            }
            vector.add(configurationAuxObjectArray[i]);
        }
        makeConfiguration.setAuxObjects(vector);
        return makeConfiguration;
    }

    public Object clone() {
        MakeConfiguration makeConfiguration = new MakeConfiguration(this.getBaseDir(), this.getName(), this.getConfigurationType().getValue(), this.getDevelopmentHost().getHostKey());
        super.cloneConf(makeConfiguration);
        makeConfiguration.setCloneOf(this);
        DevelopmentHostConfiguration developmentHostConfiguration = this.getDevelopmentHost().clone();
        makeConfiguration.setDevelopmentHost(developmentHostConfiguration);
        CompilerSet2Configuration compilerSet2Configuration = this.getCompilerSet().clone();
        compilerSet2Configuration.setDevelopmentHostConfiguration(developmentHostConfiguration);
        makeConfiguration.setCompilerSet(compilerSet2Configuration);
        makeConfiguration.setCRequired(this.getCRequired().clone());
        makeConfiguration.setCppRequired(this.getCppRequired().clone());
        makeConfiguration.setFortranRequired(this.getFortranRequired().clone());
        makeConfiguration.setAssemblerRequired(this.getAssemblerRequired().clone());
        makeConfiguration.setMakefileConfiguration(this.getMakefileConfiguration().clone());
        makeConfiguration.setDependencyChecking(this.getDependencyChecking().clone());
        makeConfiguration.setCCompilerConfiguration(this.getCCompilerConfiguration().clone());
        makeConfiguration.setCCCompilerConfiguration(this.getCCCompilerConfiguration().clone());
        makeConfiguration.setFortranCompilerConfiguration(this.getFortranCompilerConfiguration().clone());
        makeConfiguration.setAssemblerConfiguration(this.getAssemblerConfiguration().clone());
        makeConfiguration.setLinkerConfiguration(this.getLinkerConfiguration().clone());
        makeConfiguration.setArchiverConfiguration(this.getArchiverConfiguration().clone());
        makeConfiguration.setPackagingConfiguration(this.getPackagingConfiguration().clone());
        makeConfiguration.setRequiredProjectsConfiguration(this.getRequiredProjectsConfiguration().clone());
        makeConfiguration.setDebuggerChooserConfiguration(this.getDebuggerChooserConfiguration().clone());
        makeConfiguration.setQmakeConfiguration(this.getQmakeConfiguration().clone());
        developmentHostConfiguration.addPropertyChangeListener(compilerSet2Configuration);
        ConfigurationAuxObject[] configurationAuxObjectArray = this.getAuxObjects();
        ArrayList<ConfigurationAuxObject> arrayList = new ArrayList<ConfigurationAuxObject>();
        for (int i = 0; i < configurationAuxObjectArray.length; ++i) {
            arrayList.add(configurationAuxObjectArray[i].clone(this));
        }
        makeConfiguration.setAuxObjects(arrayList);
        return makeConfiguration;
    }

    public Sheet getBuildSheet(Project project) {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("ProjectDefaults");
        set.setDisplayName(MakeConfiguration.getString("ProjectDefaultsTxt"));
        set.setShortDescription(MakeConfiguration.getString("ProjectDefaultsHint"));
        set.put((Node.Property)new DevelopmentHostNodeProp(this.getDevelopmentHost(), true, MakeConfiguration.getString("DevelopmentHostTxt"), MakeConfiguration.getString("DevelopmentHostHint")));
        set.put((Node.Property)new CompilerSetNodeProp(this.getCompilerSet(), true, "CompilerSCollection2", MakeConfiguration.getString("CompilerCollectionTxt"), MakeConfiguration.getString("CompilerCollectionHint")));
        set.put((Node.Property)new BooleanNodeProp(this.getCRequired(), true, "cRequired", MakeConfiguration.getString("CRequiredTxt"), MakeConfiguration.getString("CRequiredHint")));
        set.put((Node.Property)new BooleanNodeProp(this.getCppRequired(), true, "cppRequired", MakeConfiguration.getString("CppRequiredTxt"), MakeConfiguration.getString("CppRequiredHint")));
        set.put((Node.Property)new BooleanNodeProp(this.getFortranRequired(), true, "fortranRequired", MakeConfiguration.getString("FortranRequiredTxt"), MakeConfiguration.getString("FortranRequiredHint")));
        set.put((Node.Property)new BooleanNodeProp(this.getAssemblerRequired(), true, "assemblerRequired", MakeConfiguration.getString("AssemblerRequiredTxt"), MakeConfiguration.getString("AssemblerRequiredHint")));
        set.put((Node.Property)new IntNodeProp(this.getConfigurationType(), true, "ConfigurationType", MakeConfiguration.getString("ConfigurationTypeTxt"), MakeConfiguration.getString("ConfigurationTypeHint")));
        sheet.put(set);
        if (this.isCompileConfiguration()) {
            set = Sheet.createExpertSet();
            set.put((Node.Property)new BooleanNodeProp(this.getDependencyChecking(), true, "DependencyChecking", MakeConfiguration.getString("DependencyCheckingTxt"), MakeConfiguration.getString("DependencyCheckingHint")));
            sheet.put(set);
        }
        return sheet;
    }

    public Sheet getRequiredProjectsSheet(Project project, MakeConfiguration makeConfiguration) {
        Sheet sheet = new Sheet();
        String[] stringArray = new String[]{MakeConfiguration.getString("ProjectsTxt1"), MakeConfiguration.getString("ProjectsHint"), MakeConfiguration.getString("ProjectsTxt2"), MakeConfiguration.getString("AllOptionsTxt2")};
        Sheet.Set set = new Sheet.Set();
        set.setName("Projects");
        set.setDisplayName(MakeConfiguration.getString("ProjectsTxt1"));
        set.setShortDescription(MakeConfiguration.getString("ProjectsHint"));
        set.put((Node.Property)new RequiredProjectsNodeProp(this.getRequiredProjectsConfiguration(), project, makeConfiguration, this.getBaseDir(), stringArray));
        sheet.put(set);
        return sheet;
    }

    public void setRequiredLanguagesDirty(boolean bl) {
        this.languagesDirty = bl;
    }

    public boolean getRequiredLanguagesDirty() {
        return this.languagesDirty;
    }

    public boolean hasCFiles(MakeConfigurationDescriptor makeConfigurationDescriptor) {
        this.reCountLanguages(makeConfigurationDescriptor);
        return this.cRequired.getValue();
    }

    public boolean hasCPPFiles(MakeConfigurationDescriptor makeConfigurationDescriptor) {
        this.reCountLanguages(makeConfigurationDescriptor);
        return this.cppRequired.getValue();
    }

    public boolean hasFortranFiles(MakeConfigurationDescriptor makeConfigurationDescriptor) {
        this.reCountLanguages(makeConfigurationDescriptor);
        return this.fortranRequired.getValue();
    }

    public boolean hasAssemblerFiles(MakeConfigurationDescriptor makeConfigurationDescriptor) {
        this.reCountLanguages(makeConfigurationDescriptor);
        return this.assemblerRequired.getValue();
    }

    public void reCountLanguages(MakeConfigurationDescriptor makeConfigurationDescriptor) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!this.getRequiredLanguagesDirty()) {
            return;
        }
        Item[] itemArray = makeConfigurationDescriptor.getProjectItems();
        if (itemArray.length == 0 && this.isMakefileConfiguration()) {
            bl = true;
            bl2 = true;
        } else {
            for (int i = 0; i < itemArray.length; ++i) {
                ItemConfiguration itemConfiguration = itemArray[i].getItemConfiguration(this);
                if (itemConfiguration == null || itemConfiguration.getExcluded() == null || itemConfiguration.getExcluded().getValue()) continue;
                if (itemConfiguration.getTool() == 0) {
                    bl = true;
                }
                if (itemConfiguration.getTool() == 1) {
                    bl2 = true;
                }
                if (itemConfiguration.getTool() == 2) {
                    bl3 = true;
                }
                if (itemConfiguration.getTool() != 4) continue;
                bl4 = true;
            }
        }
        this.cRequired.setDefault(bl);
        this.cppRequired.setDefault(bl2);
        this.fortranRequired.setDefault(bl3);
        this.assemblerRequired.setDefault(bl4);
        this.languagesDirty = false;
    }

    public String getVariant() {
        String string = "";
        if (this.getCompilerSet().getCompilerSet() == null) {
            return string;
        }
        return MakeConfiguration.getVariant(this.getCompilerSet().getCompilerSet(), this.getDevelopmentHost().getBuildPlatform());
    }

    public static String getVariant(CompilerSet compilerSet, int n) {
        return compilerSet.getName() + "-" + Platforms.getPlatform(n).getName();
    }

    public Set<Project> getSubProjects() {
        LibraryItem.ProjectItem projectItem;
        HashSet<Project> hashSet = new HashSet<Project>();
        LibrariesConfiguration librariesConfiguration = this.getLinkerConfiguration().getLibrariesConfiguration();
        for (LibraryItem libraryItem : librariesConfiguration.getValue()) {
            Project project;
            if (!(libraryItem instanceof LibraryItem.ProjectItem) || (project = (projectItem = (LibraryItem.ProjectItem)libraryItem).getProject(this.getBaseDir())) == null) continue;
            hashSet.add(project);
        }
        for (LibraryItem libraryItem : this.getRequiredProjectsConfiguration().getValue()) {
            projectItem = ((LibraryItem.ProjectItem)libraryItem).getProject(this.getBaseDir());
            if (projectItem == null) continue;
            hashSet.add((Project)projectItem);
        }
        return hashSet;
    }

    public Set<String> getSubProjectLocations() {
        HashSet<String> hashSet = new HashSet<String>();
        LibrariesConfiguration librariesConfiguration = this.getLinkerConfiguration().getLibrariesConfiguration();
        for (LibraryItem libraryItem : librariesConfiguration.getValue()) {
            if (!(libraryItem instanceof LibraryItem.ProjectItem)) continue;
            LibraryItem.ProjectItem projectItem = (LibraryItem.ProjectItem)libraryItem;
            hashSet.add(projectItem.getMakeArtifact().getProjectLocation());
        }
        return hashSet;
    }

    public Set<String> getSubProjectOutputLocations() {
        HashSet<String> hashSet = new HashSet<String>();
        LibrariesConfiguration librariesConfiguration = this.getLinkerConfiguration().getLibrariesConfiguration();
        for (LibraryItem libraryItem : librariesConfiguration.getValue()) {
            if (!(libraryItem instanceof LibraryItem.ProjectItem)) continue;
            LibraryItem.ProjectItem projectItem = (LibraryItem.ProjectItem)libraryItem;
            String string = IpeUtils.getDirName((String)projectItem.getMakeArtifact().getOutput());
            if (IpeUtils.isPathAbsolute((String)string)) {
                hashSet.add(string);
                continue;
            }
            hashSet.add(projectItem.getMakeArtifact().getProjectLocation() + "/" + string);
        }
        return hashSet;
    }

    public String getOutputValue() {
        String string = null;
        if (this.isLinkerConfiguration()) {
            string = this.getLinkerConfiguration().getOutputValue();
        } else if (this.isArchiverConfiguration()) {
            string = this.getArchiverConfiguration().getOutputValue();
        } else if (this.isMakefileConfiguration()) {
            string = this.getMakefileConfiguration().getOutput().getValue();
        } else if (this.isQmakeConfiguration()) {
            string = this.getQmakeConfiguration().getOutputValue();
        } else assert (false);
        return string;
    }

    public String getAbsoluteOutputValue() {
        String string = this.getOutputValue();
        if (string == null) {
            return string;
        }
        if (!IpeUtils.isPathAbsolute((String)string)) {
            string = this.getBaseDir() + "/" + string;
            string = FilePathAdaptor.normalize(string);
        }
        return this.expandMacros(string);
    }

    public boolean hasDebugger() {
        return ProjectActionSupport.getInstance().canHandle(this, ProjectActionEvent.Type.DEBUG);
    }

    public String expandMacros(String string) {
        string = IpeUtils.expandMacro((String)string, (String)"${OUTPUT_PATH}", (String)this.getOutputValue());
        string = IpeUtils.expandMacro((String)string, (String)"${OUTPUT_BASENAME}", (String)IpeUtils.getBaseName((String)this.getOutputValue()));
        string = IpeUtils.expandMacro((String)string, (String)"${PLATFORM}", (String)this.getVariant());
        string = IpeUtils.expandMacro((String)string, (String)"${CND_PLATFORM}", (String)this.getVariant());
        string = IpeUtils.expandMacro((String)string, (String)"${CND_CONF}", (String)this.getName());
        string = IpeUtils.expandMacro((String)string, (String)"${CND_DISTDIR}", (String)DIST_FOLDER);
        return string;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(MakeConfiguration.class, (String)string);
    }

    public class LanguageBooleanConfiguration
    extends BooleanConfiguration {
        private boolean notYetSet;

        LanguageBooleanConfiguration() {
            super(null, false);
            this.notYetSet = true;
        }

        public void setValue(boolean bl) {
            if (this.notYetSet) {
                this.setValue(bl, bl);
            } else {
                super.setValue(bl);
            }
            this.notYetSet = false;
        }

        public void setDefault(boolean bl) {
            if (this.getValue() == this.getDefault()) {
                this.setValue(bl, bl);
            } else {
                super.setDefault(bl);
            }
            this.notYetSet = false;
        }

        public void setValue(boolean bl, boolean bl2) {
            super.setValue(bl);
            super.setDefault(bl2);
            this.notYetSet = false;
        }

        public LanguageBooleanConfiguration clone() {
            LanguageBooleanConfiguration languageBooleanConfiguration = new LanguageBooleanConfiguration();
            languageBooleanConfiguration.setValue(this.getValue(), this.getDefault());
            languageBooleanConfiguration.setModified(this.getModified());
            return languageBooleanConfiguration;
        }

        public void assign(LanguageBooleanConfiguration languageBooleanConfiguration) {
            this.setValue(languageBooleanConfiguration.getValue(), languageBooleanConfiguration.getDefault());
            this.setModified(languageBooleanConfiguration.getModified());
        }
    }
}

