/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.execution.ExecutionListener;
import org.netbeans.modules.cnd.api.remote.CommandProvider;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.BuildActionsProvider;
import org.netbeans.modules.cnd.makeproject.api.DefaultProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandlerFactory;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.DebuggerChooserConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.SelectExecutablePanel;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class ProjectActionSupport {
    private static ProjectActionSupport instance;
    private final List<ProjectActionHandlerFactory> handlerFactories;
    private InputOutput mainTab = null;
    private HandleEvents mainTabHandler = null;
    private ArrayList<String> tabNames = new ArrayList();

    private ProjectActionSupport() {
        this.handlerFactories = new ArrayList<ProjectActionHandlerFactory>(Lookup.getDefault().lookupAll(ProjectActionHandlerFactory.class));
    }

    public static synchronized ProjectActionSupport getInstance() {
        if (instance == null) {
            instance = new ProjectActionSupport();
        }
        return instance;
    }

    public boolean canHandle(MakeConfiguration makeConfiguration, ProjectActionEvent.Type type) {
        Object object;
        CustomizerNode object22;
        if (makeConfiguration != null && (object22 = ((DebuggerChooserConfiguration)(object = makeConfiguration.getDebuggerChooserConfiguration())).getNode()) instanceof ProjectActionHandlerFactory && ((ProjectActionHandlerFactory)((Object)object22)).canHandle(type, makeConfiguration)) {
            return true;
        }
        for (ProjectActionHandlerFactory projectActionHandlerFactory : this.handlerFactories) {
            if (!projectActionHandlerFactory.canHandle(type, makeConfiguration)) continue;
            return true;
        }
        return false;
    }

    public void fireActionPerformed(ProjectActionEvent[] projectActionEventArray) {
        new HandleEvents(projectActionEventArray, null).go();
    }

    public void fireActionPerformed(ProjectActionEvent[] projectActionEventArray, ProjectActionHandler projectActionHandler) {
        new HandleEvents(projectActionEventArray, projectActionHandler).go();
    }

    private static String getString(String string) {
        return NbBundle.getBundle(ProjectActionSupport.class).getString(string);
    }

    private static String getString(String string, String string2) {
        return NbBundle.getMessage(ProjectActionSupport.class, (String)string, (Object)string2);
    }

    private static final class RerunAction
    extends AbstractAction {
        HandleEvents handleEvents;

        public RerunAction(HandleEvents handleEvents) {
            this.handleEvents = handleEvents;
        }

        public Object getValue(String string) {
            if (string.equals("SmallIcon")) {
                return new ImageIcon(DefaultProjectActionHandler.class.getResource("/org/netbeans/modules/cnd/makeproject/ui/resources/rerun.png"));
            }
            if (string.equals("ShortDescription")) {
                return ProjectActionSupport.getString("TargetExecutor.RerunAction.rerun");
            }
            return super.getValue(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            this.handleEvents.reRun();
        }
    }

    private static final class StopAction
    extends AbstractAction {
        HandleEvents handleEvents;

        public StopAction(HandleEvents handleEvents) {
            this.handleEvents = handleEvents;
        }

        public Object getValue(String string) {
            if (string.equals("SmallIcon")) {
                return new ImageIcon(DefaultProjectActionHandler.class.getResource("/org/netbeans/modules/cnd/makeproject/ui/resources/stop.png"));
            }
            if (string.equals("ShortDescription")) {
                return ProjectActionSupport.getString("TargetExecutor.StopAction.stop");
            }
            return super.getValue(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setEnabled(false);
            if (this.handleEvents.getCurrentHandler() != null) {
                this.handleEvents.getCurrentHandler().cancel();
            }
        }
    }

    private class HandleEvents
    implements ExecutionListener {
        private InputOutput ioTab = null;
        private ProjectActionEvent[] paes;
        private String tabName;
        private String tabNameSeq;
        int currentAction = 0;
        private StopAction sa = null;
        private RerunAction ra = null;
        List<BuildActionsProvider.BuildAction> additional;
        private ProgressHandle progressHandle = null;
        private final Object lock = new Object();
        private ProjectActionHandler customHandler = null;
        private ProjectActionHandler currentHandler = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HandleEvents(ProjectActionEvent[] projectActionEventArray, ProjectActionHandler projectActionHandler) {
            this.paes = projectActionEventArray;
            this.customHandler = projectActionHandler;
            this.currentAction = 0;
            if (MakeOptions.getInstance().getReuse()) {
                Object object = this.lock;
                synchronized (object) {
                    if (ProjectActionSupport.this.mainTabHandler == null && ProjectActionSupport.this.mainTab != null) {
                        ProjectActionSupport.this.mainTab.closeInputOutput();
                        ProjectActionSupport.this.mainTab = null;
                    }
                    this.tabNameSeq = this.tabName = this.getTabName(projectActionEventArray);
                    if (ProjectActionSupport.this.tabNames.contains(this.tabName)) {
                        int n = 2;
                        while (true) {
                            this.tabNameSeq = this.tabName + " #" + n;
                            if (!ProjectActionSupport.this.tabNames.contains(this.tabNameSeq)) break;
                            ++n;
                        }
                    }
                    ProjectActionSupport.this.tabNames.add(this.tabNameSeq);
                    this.ioTab = this.getIOTab(this.tabNameSeq, true);
                    if (ProjectActionSupport.this.mainTabHandler == null) {
                        ProjectActionSupport.this.mainTab = this.ioTab;
                        ProjectActionSupport.this.mainTabHandler = this;
                    }
                }
            } else {
                this.tabNameSeq = this.tabName = this.getTabName(projectActionEventArray);
                this.ioTab = this.getIOTab(this.tabName, false);
            }
        }

        private String getTabName(ProjectActionEvent[] projectActionEventArray) {
            MakeConfiguration makeConfiguration;
            String string = ProjectUtils.getInformation((Project)projectActionEventArray[0].getProject()).getDisplayName();
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(" (");
            for (int i = 0; i < projectActionEventArray.length; ++i) {
                if (i >= 2) {
                    stringBuilder.append("...");
                    break;
                }
                stringBuilder.append(projectActionEventArray[i].getActionName());
                if (i >= projectActionEventArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(")");
            if (projectActionEventArray.length > 0 && !(makeConfiguration = projectActionEventArray[0].getConfiguration()).getDevelopmentHost().isLocalhost()) {
                String string2 = makeConfiguration.getDevelopmentHost().getHostKey();
                stringBuilder.append(" - ").append(string2);
            }
            return stringBuilder.toString();
        }

        private InputOutput getTab() {
            return this.ioTab;
        }

        private ProgressHandle createProgressHandle() {
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)this.tabNameSeq, (Cancellable)new Cancellable(){

                public boolean cancel() {
                    HandleEvents.this.sa.actionPerformed(null);
                    return true;
                }
            }, (Action)new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HandleEvents.this.getTab().select();
                }
            });
            progressHandle.setInitialDelay(0);
            return progressHandle;
        }

        private ProgressHandle createProgressHandleNoCancel() {
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)this.tabNameSeq, (Action)new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HandleEvents.this.getTab().select();
                }
            });
            progressHandle.setInitialDelay(0);
            return progressHandle;
        }

        private InputOutput getIOTab(String string, boolean bl) {
            InputOutput inputOutput;
            this.sa = new StopAction(this);
            this.ra = new RerunAction(this);
            ArrayList<Action> arrayList = new ArrayList<Action>();
            arrayList.add(this.sa);
            arrayList.add(this.ra);
            this.additional = BuildActionsProvider.getDefault().getActions(string, this.paes);
            arrayList.addAll(this.additional);
            if (bl) {
                inputOutput = IOProvider.getDefault().getIO(string, false);
                inputOutput.closeInputOutput();
            }
            inputOutput = IOProvider.getDefault().getIO(string, arrayList.toArray(new Action[arrayList.size()]));
            try {
                inputOutput.getOut().reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.progressHandle = this.createProgressHandle();
            this.progressHandle.start();
            return inputOutput;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reRun() {
            this.currentAction = 0;
            this.getTab().closeInputOutput();
            Object object = this.lock;
            synchronized (object) {
                ProjectActionSupport.this.tabNames.add(this.tabNameSeq);
            }
            try {
                this.getTab().getOut().reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.progressHandle = this.createProgressHandle();
            this.progressHandle.start();
            this.go();
        }

        private void go() {
            this.currentHandler = null;
            this.sa.setEnabled(false);
            this.ra.setEnabled(false);
            if (this.currentAction >= this.paes.length) {
                return;
            }
            ProjectActionEvent projectActionEvent = this.paes[this.currentAction];
            switch (projectActionEvent.getType()) {
                case RUN: 
                case DEBUG: 
                case DEBUG_LOAD_ONLY: 
                case DEBUG_STEPINTO: 
                case CHECK_EXECUTABLE: 
                case CUSTOM_ACTION: {
                    if (this.checkExecutable(projectActionEvent) && projectActionEvent.getType() != ProjectActionEvent.Type.CHECK_EXECUTABLE) break;
                    this.progressHandle.finish();
                    return;
                }
            }
            if (projectActionEvent.getType() == ProjectActionEvent.Type.CUSTOM_ACTION && this.customHandler != null) {
                this.initHandler(this.customHandler, projectActionEvent);
                this.customHandler.execute(this.ioTab);
            } else {
                if (this.currentAction == 0 && !this.checkRemotePath(projectActionEvent)) {
                    this.progressHandle.finish();
                    return;
                }
                for (ProjectActionHandlerFactory projectActionHandlerFactory : ProjectActionSupport.this.handlerFactories) {
                    if (!projectActionHandlerFactory.canHandle(projectActionEvent.getType(), projectActionEvent.getConfiguration())) continue;
                    ProjectActionHandler projectActionHandler = this.currentHandler = projectActionHandlerFactory.createHandler();
                    this.initHandler(projectActionHandler, projectActionEvent);
                    projectActionHandler.execute(this.ioTab);
                    break;
                }
            }
        }

        private boolean checkRemotePath(ProjectActionEvent projectActionEvent) {
            boolean bl = true;
            MakeConfiguration makeConfiguration = projectActionEvent.getConfiguration();
            if (!makeConfiguration.getDevelopmentHost().isLocalhost()) {
                InputOutput inputOutput;
                String string = projectActionEvent.getProfile().getBaseDir();
                ExecutionEnvironment executionEnvironment = makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
                for (String string2 : makeConfiguration.getSubProjectLocations()) {
                    string2 = IpeUtils.toAbsolutePath((String)string, (String)string2);
                    inputOutput = ServerList.get((ExecutionEnvironment)executionEnvironment).getSyncFactory().createNew(new File(string2), executionEnvironment, null, null);
                    if (bl &= inputOutput.synchronize()) continue;
                    break;
                }
                if (bl) {
                    String string2;
                    OutputWriter outputWriter = null;
                    string2 = null;
                    inputOutput = this.getTab();
                    if (inputOutput != null) {
                        string2 = this.ioTab.getOut();
                        outputWriter = this.ioTab.getErr();
                    }
                    RemoteSyncWorker remoteSyncWorker = ServerList.get((ExecutionEnvironment)executionEnvironment).getSyncFactory().createNew(new File(string), executionEnvironment, (PrintWriter)((Object)string2), (PrintWriter)outputWriter);
                    bl &= remoteSyncWorker.synchronize();
                }
            }
            return bl;
        }

        private void initHandler(ProjectActionHandler projectActionHandler, ProjectActionEvent projectActionEvent) {
            projectActionHandler.init(projectActionEvent);
            this.progressHandle.finish();
            this.progressHandle = projectActionHandler.canCancel() ? this.createProgressHandle() : this.createProgressHandleNoCancel();
            this.progressHandle.start();
            this.sa.setEnabled(projectActionHandler.canCancel());
            projectActionHandler.addExecutionListener(this);
        }

        public ProjectActionHandler getCurrentHandler() {
            return this.currentHandler;
        }

        public void executionStarted() {
            if (this.additional != null) {
                for (BuildActionsProvider.BuildAction buildAction : this.additional) {
                    buildAction.setStep(this.currentAction);
                    buildAction.executionStarted();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executionFinished(int n) {
            Object object;
            if (this.additional != null) {
                for (BuildActionsProvider.BuildAction buildAction : this.additional) {
                    ((ExecutionListener)buildAction).executionFinished(n);
                }
            }
            if (this.paes[this.currentAction].getType() == ProjectActionEvent.Type.BUILD || this.paes[this.currentAction].getType() == ProjectActionEvent.Type.CLEAN) {
                try {
                    object = this.paes[this.currentAction].getProject().getProjectDirectory();
                    object.getFileSystem().refresh(false);
                    MakeLogicalViewProvider.refreshBrokenItems(this.paes[this.currentAction].getProject());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.currentAction >= this.paes.length - 1 || n != 0) {
                object = this.lock;
                synchronized (object) {
                    if (ProjectActionSupport.this.mainTabHandler == this) {
                        ProjectActionSupport.this.mainTabHandler = null;
                    }
                    ProjectActionSupport.this.tabNames.remove(this.tabNameSeq);
                }
                this.sa.setEnabled(false);
                this.ra.setEnabled(true);
                this.progressHandle.finish();
                return;
            }
            if (n == 0) {
                ++this.currentAction;
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        HandleEvents.this.go();
                    }
                });
            }
        }

        private boolean checkExecutable(ProjectActionEvent projectActionEvent) {
            Object object;
            Object object2;
            Object object3;
            String string = projectActionEvent.getExecutable();
            if (string.length() == 0) {
                object3 = new SelectExecutablePanel(projectActionEvent.getConfiguration());
                DialogDescriptor dialogDescriptor = new DialogDescriptor(object3, ProjectActionSupport.getString("SELECT_EXECUTABLE"));
                ((SelectExecutablePanel)object3).setDialogDescriptor(dialogDescriptor);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                    object2 = projectActionEvent.getConfiguration();
                    string = ((SelectExecutablePanel)object3).getExecutable();
                    string = FilePathAdaptor.naturalize(string);
                    string = IpeUtils.toRelativePath((String)((Configuration)object2).getBaseDir(), (String)string);
                    string = FilePathAdaptor.normalize(string);
                    ((MakeConfiguration)object2).getMakefileConfiguration().getOutput().setValue(string);
                    object = (ConfigurationDescriptorProvider)projectActionEvent.getProject().getLookup().lookup(ConfigurationDescriptorProvider.class);
                    if (object != null) {
                        ((ConfigurationDescriptorProvider)object).getConfigurationDescriptor().setModified();
                    }
                    if (projectActionEvent.getType() == ProjectActionEvent.Type.RUN) {
                        projectActionEvent.setExecutable(string);
                    } else {
                        projectActionEvent.setExecutable(((MakeConfiguration)object2).getMakefileConfiguration().getAbsOutput());
                    }
                } else {
                    return false;
                }
            }
            if (!IpeUtils.isPathAbsolute((String)string) && (string.startsWith(".") || string.indexOf(File.separatorChar) > 0)) {
                object3 = projectActionEvent.getProfile().getRunDir();
                if (object3 == null || ((String)object3).length() == 0) {
                    string = IpeUtils.toAbsolutePath((String)projectActionEvent.getConfiguration().getBaseDir(), (String)string);
                } else {
                    object3 = IpeUtils.toAbsolutePath((String)projectActionEvent.getConfiguration().getBaseDir(), (String)object3);
                    string = IpeUtils.toAbsolutePath((String)object3, (String)string);
                }
                string = FilePathAdaptor.normalize(string);
            }
            if (IpeUtils.isPathAbsolute((String)string)) {
                object3 = projectActionEvent.getConfiguration();
                boolean bl = true;
                if (object3 instanceof MakeConfiguration && !((MakeConfiguration)object3).getDevelopmentHost().isLocalhost()) {
                    object2 = ((MakeConfiguration)object3).getDevelopmentHost().getExecutionEnvironment();
                    object = HostInfoProvider.getMapper((ExecutionEnvironment)object2);
                    string = object.getRemotePath(string, true);
                    CommandProvider commandProvider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
                    if (commandProvider != null) {
                        bl = commandProvider.run((ExecutionEnvironment)object2, "test", null, new String[]{"-x", string, "-a", "-f", string}) == 0;
                    }
                } else {
                    object2 = new File(string);
                    if (!((File)object2).exists()) {
                        object2 = new File(string + ".exe");
                    }
                    if (!((File)object2).exists() || ((File)object2).isDirectory()) {
                        bl = false;
                    }
                }
                if (!bl) {
                    object2 = ProjectActionSupport.getString("EXECUTABLE_DOESNT_EXISTS", string);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message(object2, 0));
                    return false;
                }
            }
            projectActionEvent.setExecutable(string);
            return true;
        }
    }
}

