/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.SharedClassObject;

public class MakeOptions
extends SharedClassObject
implements PropertyChangeListener {
    private static MakeOptions instance = null;
    public static final String MAKE_OPTIONS = "makeOptions";
    private static String defaultMakeOptions = "";
    public static final int PATH_REL_OR_ABS = 0;
    public static final int PATH_REL = 1;
    public static final int PATH_ABS = 2;
    public static final String[] PathModeNames = new String[]{MakeOptions.getString("TXT_Auto"), MakeOptions.getString("TXT_AlwaysRelative"), MakeOptions.getString("TXT_AlwaysAbsolute")};
    public static final String PATH_MODE = "pathMode";
    public static final String DEPENDENCY_CHECKING = "dependencyChecking";
    public static final String SAVE = "save";
    public static final String REUSE = "reuse";
    public static final String VIEW_BINARY_FILES = "viewBinaryFiles";
    static final String DEF_EXE_PERM = "defexeperm";
    static final String DEF_FILE_PERM = "deffileperm";
    static final String DEF_OWNER = "defowner";
    static final String DEF_GROUP = "defgroup";
    static final String PREF_APP_LANGUAGE = "prefAppLanguage";

    public static MakeOptions getInstance() {
        if (instance == null) {
            instance = (MakeOptions)SharedClassObject.findObject(MakeOptions.class, (boolean)true);
        }
        return instance;
    }

    public static void setDefaultMakeOptions(String string) {
        defaultMakeOptions = string;
    }

    public static String getDefaultMakeOptions() {
        return defaultMakeOptions;
    }

    public MakeOptions() {
        this.addPropertyChangeListener(this);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(MakeOptions.class);
    }

    public String getMakeOptions() {
        return this.getPreferences().get(MAKE_OPTIONS, MakeOptions.getDefaultMakeOptions());
    }

    public void setMakeOptions(String string) {
        String string2 = this.getMakeOptions();
        this.getPreferences().put(MAKE_OPTIONS, string);
        if (!string2.equals(string)) {
            this.firePropertyChange(MAKE_OPTIONS, string2, string);
        }
    }

    public int getPathMode() {
        return this.getPreferences().getInt(PATH_MODE, 1);
    }

    public void setPathMode(int n) {
        int n2 = this.getPathMode();
        this.getPreferences().putInt(PATH_MODE, n);
        if (n2 != n) {
            this.firePropertyChange(PATH_MODE, n2, n);
        }
    }

    public boolean getDepencyChecking() {
        return this.getPreferences().getBoolean(DEPENDENCY_CHECKING, true);
    }

    public void setDepencyChecking(boolean bl) {
        boolean bl2 = this.getDepencyChecking();
        this.getPreferences().putBoolean(DEPENDENCY_CHECKING, bl);
        if (bl2 != bl) {
            this.firePropertyChange(DEPENDENCY_CHECKING, bl2, bl);
        }
    }

    public boolean getViewBinaryFiles() {
        return this.getPreferences().getBoolean(VIEW_BINARY_FILES, false);
    }

    public void setViewBinaryFiles(boolean bl) {
        boolean bl2 = this.getViewBinaryFiles();
        this.getPreferences().putBoolean(VIEW_BINARY_FILES, bl);
        if (bl2 != bl) {
            this.firePropertyChange(VIEW_BINARY_FILES, bl2, bl);
        }
    }

    public boolean getSave() {
        return this.getPreferences().getBoolean(SAVE, true);
    }

    public void setSave(boolean bl) {
        boolean bl2 = this.getSave();
        this.getPreferences().putBoolean(SAVE, bl);
        if (bl2 != bl) {
            this.firePropertyChange(SAVE, bl2, bl);
        }
    }

    public boolean getReuse() {
        return this.getPreferences().getBoolean(REUSE, true);
    }

    public void setReuse(boolean bl) {
        boolean bl2 = this.getReuse();
        this.getPreferences().putBoolean(REUSE, bl);
        if (bl2 != bl) {
            this.firePropertyChange(REUSE, bl2, bl);
        }
    }

    public String getDefExePerm() {
        return this.getPreferences().get(DEF_EXE_PERM, "755");
    }

    public void setDefExePerm(String string) {
        String string2 = this.getDefExePerm();
        this.getPreferences().put(DEF_EXE_PERM, string);
        if (!string2.equals(string)) {
            this.firePropertyChange(DEF_EXE_PERM, string2, string);
        }
    }

    public String getDefFilePerm() {
        return this.getPreferences().get(DEF_FILE_PERM, "644");
    }

    public void setDefFilePerm(String string) {
        String string2 = this.getDefFilePerm();
        this.getPreferences().put(DEF_FILE_PERM, string);
        if (!string2.equals(string)) {
            this.firePropertyChange(DEF_FILE_PERM, string2, string);
        }
    }

    public String getDefOwner() {
        return this.getPreferences().get(DEF_OWNER, "root");
    }

    public void setDefOwner(String string) {
        String string2 = this.getDefOwner();
        this.getPreferences().put(DEF_OWNER, string);
        if (!string2.equals(string)) {
            this.firePropertyChange(DEF_OWNER, string2, string);
        }
    }

    public String getDefGroup() {
        return this.getPreferences().get(DEF_GROUP, "bin");
    }

    public void setDefGroup(String string) {
        String string2 = this.getDefGroup();
        this.getPreferences().put(DEF_GROUP, string);
        if (!string2.equals(string)) {
            this.firePropertyChange(DEF_GROUP, string2, string);
        }
    }

    public String getPrefApplicationLanguage() {
        return this.getPreferences().get(PREF_APP_LANGUAGE, "C++");
    }

    public void setPrefApplicationLanguage(String string) {
        String string2 = this.getPrefApplicationLanguage();
        this.getPreferences().put(PREF_APP_LANGUAGE, string);
        if (!string2.equals(string)) {
            this.firePropertyChange(PREF_APP_LANGUAGE, string2, string);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private static String getString(String string) {
        return NbBundle.getMessage(MakeOptions.class, (String)string);
    }
}

