/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Color;
import java.io.CharConversionException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.autoupdate.ui.ColorHighlighter;
import org.netbeans.modules.autoupdate.ui.DetailsPanel;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public class UnitDetails
extends DetailsPanel {
    private final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.ui.UnitDetails");

    public UnitDetails() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UnitTable.class, (String)"ACN_UnitDetails"));
    }

    public void setUnit(Unit unit) {
        this.setUnit(unit, null);
    }

    public void setUnit(Unit unit, Action action) {
        if (unit == null) {
            this.getDetails().setText("<i>" + UnitDetails.getBundle("UnitDetails_Category_NoDescription") + "</i>");
            this.setTitle(null);
        } else {
            Object object;
            Object object2;
            String string;
            try {
                string = XMLUtil.toElementContent((String)unit.getDisplayName());
                this.setTitle(string);
                string = "";
                this.setActionListener(action);
                if (unit instanceof Unit.Available) {
                    object2 = (Unit.Available)unit;
                    object = ((Unit.Available)object2).getSourceCategory();
                    String string2 = Utilities.getCategoryName((UpdateUnitProvider.CATEGORY)object);
                    URL uRL = Utilities.getCategoryIcon((UpdateUnitProvider.CATEGORY)object);
                    string = string + "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>";
                    string = string + "<td><img src=\"" + uRL.toExternalForm() + "\"></img></td>";
                    string = string + "<td>&nbsp;&nbsp;</td>";
                    string = string + "<td><b>" + string2 + "</b></td>";
                    string = string + "</tr></table><br>";
                }
                if (Utilities.modulesOnly() || Utilities.showExtendedDescription()) {
                    string = string + "<b>" + UnitDetails.getBundle("UnitDetails_Plugin_CodeName") + "</b>" + unit.updateUnit.getCodeName();
                    string = string + "<br>";
                }
                if (unit instanceof Unit.Update) {
                    object2 = (Unit.Update)unit;
                    string = string + "<b>" + UnitDetails.getBundle("UnitDetails_Plugin_InstalledVersion") + "</b>" + ((Unit.Update)object2).getInstalledVersion() + "<br>";
                    string = string + "<b>" + UnitDetails.getBundle("UnitDetails_Plugin_AvailableVersion") + "</b>" + ((Unit.Update)object2).getAvailableVersion() + "<br>";
                } else {
                    string = string + "<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Version") + "</b>" + unit.getDisplayVersion() + "<br>";
                }
                if (unit.getAuthor() != null && unit.getAuthor().length() > 0) {
                    string = string + "<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Author") + "</b>" + unit.getAuthor() + "<br>";
                }
                if (unit.getDisplayDate() != null && unit.getDisplayDate().length() > 0) {
                    string = string + "<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Date") + "</b>" + unit.getDisplayDate() + "<br>";
                }
                string = string + "<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Source") + "</b>" + unit.getSource() + "<br>";
                if (unit.getHomepage() != null && unit.getHomepage().length() > 0) {
                    string = string + "<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Homepage") + "</b><a href=\"" + unit.getHomepage() + "\">" + unit.getHomepage() + "</a><br>";
                }
                if (unit.getNotification() != null && unit.getNotification().length() > 0) {
                    string = string + "<br><h3>" + UnitDetails.getBundle("UnitDetails_Plugin_Notification") + "</h3>";
                    string = string + "<font color=\"red\">";
                    string = string + unit.getNotification();
                    string = string + "</font><br>";
                }
                if (unit.getDescription() != null && unit.getDescription().length() > 0) {
                    string = string + "<br><h3>" + UnitDetails.getBundle("UnitDetails_Plugin_Description") + "</h3>";
                    string = string + unit.getDescription();
                }
            }
            catch (CharConversionException charConversionException) {
                this.err.log(Level.INFO, null, charConversionException);
                return;
            }
            object2 = Color.YELLOW;
            object = new ColorHighlighter(this.getDetails(), (Color)object2);
            this.getDetails().setText(string);
            int n = ((ColorHighlighter)object).highlight(unit.getFilter());
            this.getDetails().setCaretPosition(n > 0 ? n : 0);
        }
    }

    private static String getBundle(String string) {
        return NbBundle.getMessage(UnitDetails.class, (String)string);
    }
}

