/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.storage.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.perfan.spi.datafilter.SunStudioFiltersProvider;
import org.netbeans.modules.dlight.perfan.storage.impl.ErprintSession;
import org.netbeans.modules.dlight.perfan.storage.impl.ExperimentStatistics;
import org.netbeans.modules.dlight.perfan.storage.impl.FunctionStatistic;
import org.netbeans.modules.dlight.perfan.storage.impl.Metrics;
import org.netbeans.modules.dlight.perfan.storage.impl.PerfanDataStorageFactory;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PerfanDataStorage
extends DataStorage {
    private static final Logger log = DLightLogger.getLogger(PerfanDataStorage.class);
    private final Map<String, String> serviceInfoMap = new ConcurrentHashMap<String, String>();
    private ErprintSession er_print;
    private String experimentDirectory = null;
    private ExecutionEnvironment env;

    public final Map<String, String> getInfo() {
        return this.serviceInfoMap;
    }

    public final String getValue(String string) {
        return this.serviceInfoMap.get(string);
    }

    public boolean shutdown() {
        if (this.er_print != null) {
            this.er_print.close();
        }
        if (this.experimentDirectory != null) {
            StringWriter stringWriter = new StringWriter();
            CommonTasksSupport.rmDir((ExecutionEnvironment)this.env, (String)this.experimentDirectory, (boolean)true, (Writer)stringWriter);
            return stringWriter.toString().trim().equals("");
        }
        return true;
    }

    public final String put(String string, String string2) {
        return this.serviceInfoMap.put(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ExecutionEnvironment executionEnvironment, String string, String string2, SunStudioFiltersProvider sunStudioFiltersProvider) {
        PerfanDataStorage perfanDataStorage = this;
        synchronized (perfanDataStorage) {
            if (this.er_print != null) {
                this.er_print.close();
            }
            this.er_print = new ErprintSession(executionEnvironment, string, string2, sunStudioFiltersProvider);
        }
    }

    public Object[] getCallees(long l) {
        return null;
    }

    public Object[] getCallers(long l) {
        return null;
    }

    public String[] getTopFunctions(Metrics metrics, int n) {
        String[] stringArray = null;
        try {
            stringArray = this.er_print.getHotFunctions(metrics, n, 0, true);
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            log.log(Level.FINEST, "getTopFunctions: " + iOException.toString());
        }
        return stringArray == null ? new String[]{} : stringArray;
    }

    public String[] getTopFunctions(String string, Metrics metrics, int n) throws InterruptedException {
        String[] stringArray = null;
        try {
            stringArray = this.er_print.getHotFunctions(string, metrics, n, true);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException();
        }
        catch (IOException iOException) {
            log.log(Level.FINEST, "getTopFunctions: " + iOException.toString());
        }
        return stringArray;
    }

    public FunctionStatistic getFunctionStatistic(String string) {
        FunctionStatistic functionStatistic = null;
        try {
            functionStatistic = this.er_print.getFunctionStatistic(string, true);
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, null, iOException);
        }
        return functionStatistic;
    }

    public FunctionStatistic getFunctionStatistic(FunctionCall functionCall) {
        FunctionStatistic functionStatistic = null;
        try {
            functionStatistic = this.er_print.getFunctionStatistic(functionCall, true);
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, null, iOException);
        }
        return functionStatistic;
    }

    public ExperimentStatistics fetchSummaryData() {
        ExperimentStatistics experimentStatistics = null;
        try {
            experimentStatistics = this.er_print.getExperimentStatistics(0, true);
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, null, iOException);
        }
        return experimentStatistics;
    }

    public Collection<DataStorageType> getStorageTypes() {
        return PerfanDataStorageFactory.supportedTypes;
    }

    protected boolean createTablesImpl(List<DataTableMetadata> list) {
        return true;
    }

    public void addData(String string, List<DataRow> list) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

