/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.spi;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.perfan.spi.SunStudioDataCollector;
import org.netbeans.modules.dlight.perfan.storage.impl.ErprintSession;
import org.netbeans.modules.dlight.perfan.storage.impl.Metrics;
import org.netbeans.modules.dlight.perfan.storage.impl.ThreadsStatistic;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorsUpdateService {
    private static final Pattern METRIC_LINE_PATTERN = Pattern.compile("^ *([0-9]+(?:,[0-9]*)?) [^<]*$");
    private static final DecimalFormat METRIC_FORMAT = new DecimalFormat();
    private static final Metrics LEAK_METRICS;
    private static final Metrics SYNC_METRICS;
    private static final Logger log;
    private static final List<String> syncColNames;
    private static final List<String> leaksColNames;
    private final SunStudioDataCollector ssdc;
    private final ExecutionEnvironment execEnv;
    private final String sproHome;
    private final String experimentDir;
    private final boolean isSyncMonitor;
    private final boolean isMemoryMonitor;
    private final Object updaterLock = new String(MonitorsUpdateService.class.getName() + " UpdaterLock");
    private Updater updater = null;
    private BlockingQueue<Object> requestsQueue = new LinkedBlockingQueue<Object>(1);

    MonitorsUpdateService(SunStudioDataCollector sunStudioDataCollector, ExecutionEnvironment executionEnvironment, String string, String string2, Collection<SunStudioDCConfiguration.CollectedInfo> collection) {
        this.ssdc = sunStudioDataCollector;
        this.sproHome = string;
        this.execEnv = executionEnvironment;
        this.experimentDir = string2;
        this.isSyncMonitor = collection.contains((Object)SunStudioDCConfiguration.CollectedInfo.SYNCSUMMARY);
        this.isMemoryMonitor = collection.contains((Object)SunStudioDCConfiguration.CollectedInfo.MEMSUMMARY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        boolean bl;
        if (this.isBlank()) {
            return;
        }
        try {
            bl = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv).getOSFamily() == HostInfo.OSFamily.LINUX;
        }
        catch (CancellationException cancellationException) {
            bl = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        Object object = this.updaterLock;
        synchronized (object) {
            if (this.updater != null) {
                return;
            }
            this.updater = new Updater(bl);
            DLightExecutorService.submit((Runnable)this.updater, (String)MonitorsUpdateService.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.updaterLock;
        synchronized (object) {
            if (this.updater == null) {
                return;
            }
            this.updater.stop();
            this.updater = null;
        }
    }

    boolean isBlank() {
        return !this.isMemoryMonitor && !this.isSyncMonitor;
    }

    static {
        METRIC_FORMAT.getDecimalFormatSymbols().setDecimalSeparator(',');
        LEAK_METRICS = Metrics.constructFrom(Arrays.asList(SunStudioDCConfiguration.c_leakSize), Arrays.asList(SunStudioDCConfiguration.c_leakSize));
        SYNC_METRICS = Metrics.constructFrom(Arrays.asList(SunStudioDCConfiguration.c_eSync), Arrays.asList(SunStudioDCConfiguration.c_eSync));
        log = DLightLogger.getLogger(MonitorsUpdateService.class);
        syncColNames = Collections.unmodifiableList(Arrays.asList(SunStudioDCConfiguration.c_ulockSummary.getColumnName(), SunStudioDCConfiguration.c_threadsCount.getColumnName()));
        leaksColNames = Collections.unmodifiableList(Arrays.asList(SunStudioDCConfiguration.c_leakSize.getColumnName()));
    }

    private class Updater
    implements Runnable {
        private volatile boolean isStopped = false;
        private volatile ErprintSession erprintSession;
        private boolean linuxMode;

        public Updater(boolean bl) {
            this.linuxMode = bl;
        }

        public void stop() {
            this.isStopped = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.erprintSession != null) {
                throw new IllegalStateException("Updater can be started only once!");
            }
            this.erprintSession = new ErprintSession(MonitorsUpdateService.this.execEnv, MonitorsUpdateService.this.sproHome, MonitorsUpdateService.this.experimentDir, MonitorsUpdateService.this.ssdc);
            Future future = DLightExecutorService.scheduleAtFixedRate((Runnable)new Runnable(){

                public void run() {
                    if (MonitorsUpdateService.this.requestsQueue.remainingCapacity() == 0) {
                        return;
                    }
                    try {
                        MonitorsUpdateService.this.requestsQueue.put(new Object());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }, (long)1L, (TimeUnit)TimeUnit.SECONDS, (String)"SunStudio monitors update task");
            try {
                double d = 0.0;
                double d2 = 0.0;
                while (!this.isStopped) {
                    try {
                        MonitorsUpdateService.this.requestsQueue.take();
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    boolean bl = false;
                    ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
                    try {
                        String[] stringArray;
                        if (MonitorsUpdateService.this.isSyncMonitor) {
                            double d3;
                            String[] stringArray2;
                            double d4;
                            stringArray = this.erprintSession.getExperimentStatistics(5, !bl);
                            ThreadsStatistic threadsStatistic = this.erprintSession.getThreadsStatistic(5, false);
                            bl = true;
                            int n = threadsStatistic.getThreadsCount();
                            Double d5 = stringArray.getDuration();
                            double d6 = d4 = d5 == null ? 0.0 : d5;
                            if (this.linuxMode) {
                                stringArray2 = this.erprintSession.getHotFunctions(SYNC_METRICS, Integer.MAX_VALUE, 5, false);
                                d3 = stringArray2 == null || stringArray2.length == 0 ? d2 : this.sumMetrics(stringArray2);
                            } else {
                                stringArray2 = stringArray.getULock();
                                double d7 = d3 = stringArray2 == null ? 0.0 : stringArray2.doubleValue();
                            }
                            if (0.1 < d4 - d) {
                                arrayList.add(new DataRow(syncColNames, Arrays.asList(100.0 * (d3 - d2) / (d4 - d) / (double)n, n)));
                                d = d4;
                                d2 = d3;
                            }
                        }
                        if (!MonitorsUpdateService.this.isMemoryMonitor) continue;
                        stringArray = this.erprintSession.getHotFunctions(LEAK_METRICS, Integer.MAX_VALUE, 5, !bl);
                        bl = true;
                        long l = stringArray == null || stringArray.length == 0 ? 0L : (long)this.sumMetrics(stringArray);
                        arrayList.add(new DataRow(leaksColNames, Arrays.asList(l)));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        log.log(Level.FINEST, "Exception while updateIndicators in MonitorUpdateService: " + throwable.toString());
                    }
                    finally {
                        MonitorsUpdateService.this.ssdc.updateIndicators(arrayList);
                    }
                }
            }
            finally {
                if (future != null) {
                    future.cancel(false);
                }
                if (this.erprintSession != null) {
                    this.erprintSession.close();
                }
            }
        }

        private double sumMetrics(String[] stringArray) {
            double d = 0.0;
            for (String string : stringArray) {
                Matcher matcher = METRIC_LINE_PATTERN.matcher(string);
                if (!matcher.matches()) continue;
                String string2 = matcher.group(1);
                try {
                    d += METRIC_FORMAT.parse(string2).doubleValue();
                }
                catch (ParseException parseException) {
                    log.log(Level.WARNING, null, parseException);
                }
            }
            return d;
        }
    }
}

