/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.StringTokenizer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public class CopyOnSave
extends FileChangeAdapter
implements PropertyChangeListener {
    private FileObject docBase = null;
    private Project project;
    private WebModuleProviderImpl provider;
    boolean active = false;
    private NbMavenProject mavenproject;

    public CopyOnSave(Project project, WebModuleProviderImpl webModuleProviderImpl) {
        this.project = project;
        this.provider = webModuleProviderImpl;
        this.mavenproject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySrcToDest(FileObject fileObject, FileObject fileObject2) throws IOException {
        if (fileObject2 != null && !fileObject.isFolder()) {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            FileLock fileLock = null;
            try {
                inputStream = fileObject.getInputStream();
                fileLock = fileObject2.lock();
                outputStream = fileObject2.getOutputStream(fileLock);
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }
    }

    private WebModule getWebModule() {
        return this.provider.findWebModule(this.project.getProjectDirectory());
    }

    private J2eeModule getJ2eeModule() {
        return this.provider.getJ2eeModule();
    }

    private boolean isInPlace() throws IOException {
        FileObject fileObject = this.getJ2eeModule().getContentDirectory();
        return fileObject != null && fileObject.equals(this.getWebModule().getDocumentBase());
    }

    public void initialize() throws FileStateInvalidException {
        this.smallinitialize();
        NbMavenProject.addPropertyChangeListener((Project)this.project, (PropertyChangeListener)this);
        this.active = true;
    }

    public void cleanup() throws FileStateInvalidException {
        this.smallcleanup();
        NbMavenProject.removePropertyChangeListener((Project)this.project, (PropertyChangeListener)this);
        this.active = false;
    }

    public void smallinitialize() throws FileStateInvalidException {
        this.docBase = this.getWebModule().getDocumentBase();
        if (this.docBase != null) {
            this.docBase.getFileSystem().addFileChangeListener((FileChangeListener)this);
        }
    }

    public void smallcleanup() throws FileStateInvalidException {
        if (this.docBase != null) {
            this.docBase.getFileSystem().removeFileChangeListener((FileChangeListener)this);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
            try {
                if (this.active) {
                    this.smallcleanup();
                    this.smallinitialize();
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        try {
            if (!this.isInPlace()) {
                this.handleCopyFileToDestDir(fileEvent.getFile());
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        try {
            if (!this.isInPlace()) {
                this.handleCopyFileToDestDir(fileEvent.getFile());
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        try {
            if (this.isInPlace()) {
                return;
            }
            FileObject fileObject = fileRenameEvent.getFile();
            FileObject fileObject2 = this.findAppropriateResourceRoots(fileObject);
            if (fileObject2 != null) {
                this.handleCopyFileToDestDir(fileObject);
                FileObject fileObject3 = fileObject.getParent();
                String string = FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject3) ? FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject.getParent()) + "/" + fileRenameEvent.getName() + "." + fileRenameEvent.getExt() : fileRenameEvent.getName() + "." + fileRenameEvent.getExt();
                if (!this.isSynchronizationAppropriate(string)) {
                    return;
                }
                this.handleDeleteFileInDestDir(fileObject, string);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        try {
            if (this.isInPlace()) {
                return;
            }
            FileObject fileObject = fileEvent.getFile();
            this.handleDeleteFileInDestDir(fileObject, null);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    private boolean isSynchronizationAppropriate(String string) {
        if (string.startsWith("WEB-INF/classes")) {
            return false;
        }
        if (string.startsWith("WEB-INF/src")) {
            return false;
        }
        return !string.startsWith("WEB-INF/lib");
    }

    private void handleDeleteFileInDestDir(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = this.findAppropriateResourceRoots(fileObject);
        if (fileObject2 != null) {
            String string2 = string = string != null ? string : FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
            if (!this.isSynchronizationAppropriate(string)) {
                return;
            }
            FileObject fileObject3 = this.getJ2eeModule().getContentDirectory();
            if (fileObject3 != null) {
                FileObject fileObject4;
                FileObject fileObject5;
                FileObject fileObject6 = fileObject5 = this.comesFromWebappRoot(fileObject) ? fileObject3 : fileObject3.getFileObject("WEB-INF/classes");
                if (fileObject5 != null && (fileObject4 = fileObject5.getFileObject(string)) != null) {
                    fileObject4.delete();
                }
            }
        }
    }

    private void handleCopyFileToDestDir(FileObject fileObject) throws IOException {
        FileObject fileObject2;
        if (!fileObject.isVirtual() && (fileObject2 = this.findAppropriateResourceRoots(fileObject)) != null) {
            String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
            if (!this.isSynchronizationAppropriate(string)) {
                return;
            }
            FileObject fileObject3 = this.getJ2eeModule().getContentDirectory();
            if (fileObject3 != null) {
                if (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject3) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject2)) {
                    return;
                }
                FileObject fileObject4 = this.comesFromWebappRoot(fileObject) ? fileObject3 : fileObject3.getFileObject("WEB-INF/classes");
                FileObject fileObject5 = this.ensureDestinationFileExists(fileObject4, string, fileObject.isFolder());
                this.copySrcToDest(fileObject, fileObject5);
            }
        }
    }

    private boolean comesFromWebappRoot(FileObject fileObject) {
        FileObject fileObject2 = this.getWebModule().getDocumentBase();
        return fileObject2 != null && FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject);
    }

    private FileObject findAppropriateResourceRoots(FileObject fileObject) {
        URI[] uRIArray;
        FileObject fileObject2 = this.getWebModule().getDocumentBase();
        if (fileObject2 != null && FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) {
            return fileObject2;
        }
        for (URI uRI : uRIArray = this.mavenproject.getResources(false)) {
            FileObject fileObject3 = FileUtil.toFileObject((File)new File(uRI));
            if (fileObject3 == null || !FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject)) continue;
            return fileObject3;
        }
        return null;
    }

    private FileObject ensureDestinationFileExists(FileObject fileObject, String string, boolean bl) throws IOException {
        FileObject fileObject2 = fileObject;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            FileObject fileObject3 = fileObject2.getFileObject(string2);
            if (fileObject3 == null) {
                fileObject3 = bl || stringTokenizer.hasMoreTokens() ? FileUtil.createFolder((FileObject)fileObject2, (String)string2) : FileUtil.createData((FileObject)fileObject2, (String)string2);
            }
            fileObject2 = fileObject3;
        }
        return fileObject2;
    }
}

