/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.api.problem.ProblemReporter;
import org.netbeans.modules.maven.j2ee.J2eeLookupProvider;
import org.netbeans.modules.maven.j2ee.SessionContent;
import org.netbeans.modules.maven.j2ee.Wrapper;
import org.netbeans.modules.maven.j2ee.ear.EarModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.ejb.EjbModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.web.CopyOnSave;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.maven.model.profile.Properties;
import org.netbeans.modules.maven.spi.customizer.ModelHandleUtils;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class POHImpl
extends ProjectOpenedHook {
    private Project project;
    private J2eeLookupProvider.Provider provider;
    private PropertyChangeListener refreshListener;
    private J2eeModuleProvider lastJ2eeProvider;
    private String contextPath;
    public static final String USG_LOGGER_NAME = "org.netbeans.ui.metrics.maven";
    public static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.maven");

    public POHImpl(Project project, J2eeLookupProvider.Provider provider) {
        this.project = project;
        this.provider = provider;
    }

    public void hackModuleServerChange() {
        ProjectManager.mutex().postReadRequest(new Runnable(){

            public void run() {
                POHImpl.this.refreshAppServerAssignment();
            }
        });
    }

    public void setContextPath(String string) {
        this.contextPath = string;
    }

    protected void projectOpened() {
        Object object;
        String string;
        this.refreshAppServerAssignment();
        if (this.refreshListener == null) {
            string = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            this.refreshListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                        POHImpl.this.hackModuleServerChange();
                    }
                }
            };
            string.addPropertyChangeListener(this.refreshListener);
        }
        if ((string = POHImpl.obtainServerName(this.project)) == null) {
            string = NbBundle.getMessage(POHImpl.class, (String)"MSG_No_Server");
        }
        String string2 = null;
        NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        if (nbMavenProject != null) {
            EjbJar ejbJar;
            object = nbMavenProject.getPackagingType();
            if ("ear".equals(object)) {
                Ear ear = Ear.getEar((FileObject)this.project.getProjectDirectory());
                if (ear != null) {
                    string2 = ear.getJ2eePlatformVersion();
                }
            } else if ("war".equals(object)) {
                WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
                if (webModule != null) {
                    string2 = webModule.getJ2eePlatformVersion();
                }
            } else if ("ejb".equals(object) && (ejbJar = EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory())) != null) {
                string2 = ejbJar.getJ2eePlatformVersion();
            }
        }
        if (string2 == null) {
            string2 = NbBundle.getMessage(POHImpl.class, (String)"TXT_UnknownEEVersion");
        }
        object = new LogRecord(Level.INFO, "USG_PROJECT_OPEN_MAVEN_EE");
        ((LogRecord)object).setLoggerName(USG_LOGGER_NAME);
        ((LogRecord)object).setParameters(new Object[]{string, string2});
        USG_LOGGER.log((LogRecord)object);
    }

    protected synchronized void refreshAppServerAssignment() {
        WebModuleProviderImpl webModuleProviderImpl;
        this.provider.hackModuleServerChange();
        String[] stringArray = POHImpl.obtainServerIds(this.project);
        String string = stringArray[0];
        String string2 = stringArray[1];
        if (string != null) {
            EarModuleProviderImpl earModuleProviderImpl;
            EjbModuleProviderImpl ejbModuleProviderImpl;
            webModuleProviderImpl = (WebModuleProviderImpl)((Object)this.project.getLookup().lookup(WebModuleProviderImpl.class));
            if (webModuleProviderImpl != null) {
                webModuleProviderImpl.setServerInstanceID(string);
                webModuleProviderImpl.getConfigSupport().ensureConfigurationReady();
                if (this.contextPath != null) {
                    webModuleProviderImpl.getWebModuleImplementation().setContextPath(this.contextPath);
                }
            }
            if ((ejbModuleProviderImpl = (EjbModuleProviderImpl)((Object)this.project.getLookup().lookup(EjbModuleProviderImpl.class))) != null) {
                ejbModuleProviderImpl.setServerInstanceID(string);
                ejbModuleProviderImpl.getConfigSupport().ensureConfigurationReady();
            }
            if ((earModuleProviderImpl = (EarModuleProviderImpl)((Object)this.project.getLookup().lookup(EarModuleProviderImpl.class))) != null) {
                earModuleProviderImpl.setServerInstanceID(string);
                earModuleProviderImpl.getConfigSupport().ensureConfigurationReady();
            }
        } else if (string2 != null) {
            webModuleProviderImpl = (ProblemReporter)this.project.getLookup().lookup(ProblemReporter.class);
            String string3 = Deployment.getDefault().getServerDisplayName(string2);
            if (string3 == null) {
                string3 = string2;
            }
            ProblemReport problemReport = new ProblemReport(0, NbBundle.getMessage(POHImpl.class, (String)"MSG_AppServer", (Object)string3), NbBundle.getMessage(POHImpl.class, (String)"HINT_AppServer"), (Action)new AddServerAction(this.project));
            webModuleProviderImpl.addReport(problemReport);
        }
        webModuleProviderImpl = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (webModuleProviderImpl != null) {
            this.lastJ2eeProvider = webModuleProviderImpl;
            if (RunUtils.hasApplicationCompileOnSaveEnabled((Project)this.project)) {
                Deployment.getDefault().enableCompileOnSaveSupport((J2eeModuleProvider)webModuleProviderImpl);
            } else {
                Deployment.getDefault().disableCompileOnSaveSupport((J2eeModuleProvider)webModuleProviderImpl);
            }
        } else if (this.lastJ2eeProvider != null) {
            Deployment.getDefault().disableCompileOnSaveSupport(this.lastJ2eeProvider);
            this.lastJ2eeProvider = null;
        }
    }

    protected void projectClosed() {
        Object object;
        if (this.refreshListener != null) {
            object = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            object.removePropertyChangeListener(this.refreshListener);
            this.refreshListener = null;
        }
        if (this.lastJ2eeProvider != null) {
            Deployment.getDefault().disableCompileOnSaveSupport(this.lastJ2eeProvider);
            this.lastJ2eeProvider = null;
        }
        if ((object = (CopyOnSave)this.project.getLookup().lookup(CopyOnSave.class)) != null) {
            try {
                ((CopyOnSave)object).cleanup();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                fileStateInvalidException.printStackTrace();
            }
        }
    }

    private static String[] obtainServerIds(Project project) {
        String[] stringArray = new String[2];
        SessionContent sessionContent = (SessionContent)project.getLookup().lookup(SessionContent.class);
        if (sessionContent.getServerInstanceId() != null) {
            stringArray[0] = sessionContent.getServerInstanceId();
        }
        if (stringArray[0] == null) {
            AuxiliaryProperties auxiliaryProperties = (AuxiliaryProperties)project.getLookup().lookup(AuxiliaryProperties.class);
            String string = auxiliaryProperties.get("netbeans.deployment.server.id", true);
            stringArray[1] = auxiliaryProperties.get("netbeans.hint.deploy.server", true);
            if (stringArray[1] == null) {
                stringArray[1] = auxiliaryProperties.get("netbeans.deployment.server.type", true);
            }
            if (stringArray[1] != null) {
                String[] stringArray2 = Deployment.getDefault().getInstancesOfServer(stringArray[1]);
                String string2 = null;
                if (stringArray2 != null && stringArray2.length > 0) {
                    string2 = stringArray2[0];
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (string == null || !string.equals(stringArray2[i])) continue;
                        string2 = stringArray2[i];
                        break;
                    }
                    stringArray[0] = string2;
                }
            }
        }
        return stringArray;
    }

    public static String obtainServerName(Project project) {
        ServerInstance serverInstance;
        String string = POHImpl.obtainServerIds(project)[0];
        if (string != null && (serverInstance = Deployment.getDefault().getServerInstance(string)) != null) {
            try {
                return serverInstance.getDisplayName();
            }
            catch (InstanceRemovedException instanceRemovedException) {
                Logger.getLogger(Wrapper.class.getName()).log(Level.FINE, "", instanceRemovedException);
            }
        }
        return null;
    }

    public static String privateGetServerId(String string) {
        ServerInstance serverInstance = Deployment.getDefault().getServerInstance(string);
        try {
            return serverInstance.getServerID();
        }
        catch (InstanceRemovedException instanceRemovedException) {
            return null;
        }
    }

    private static class AddServerAction
    extends AbstractAction {
        private Project prj;

        private AddServerAction(Project project) {
            this.prj = project;
            this.putValue("Name", NbBundle.getMessage(POHImpl.class, (String)"TXT_Add_Server"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ServerManager.showAddServerInstanceWizard();
            String string2 = null;
            if (string != null) {
                string2 = POHImpl.privateGetServerId(string);
            }
            try {
                org.netbeans.modules.maven.model.pom.Properties properties;
                ModelHandle modelHandle = ModelHandleUtils.createModelHandle((Project)this.prj);
                POMModel pOMModel = modelHandle.getPOMModel();
                Profile profile = modelHandle.getNetbeansPublicProfile(false);
                if (profile != null && (properties = profile.getProperties()) != null) {
                    properties.setProperty("netbeans.deployment.server.type", null);
                }
                if (string != null) {
                    properties = pOMModel.getProject().getProperties();
                    if (properties == null) {
                        properties = pOMModel.getFactory().createProperties();
                        pOMModel.getProject().setProperties(properties);
                    }
                    properties.setProperty("netbeans.hint.deploy.server", string2);
                    org.netbeans.modules.maven.model.profile.Profile profile2 = modelHandle.getNetbeansPrivateProfile();
                    Properties properties2 = profile2.getProperties();
                    if (properties2 == null) {
                        properties2 = modelHandle.getProfileModel().getFactory().createProperties();
                        profile2.setProperties(properties2);
                    }
                    properties2.setProperty("netbeans.deployment.server.id", string);
                    modelHandle.markAsModified((Object)modelHandle.getProfileModel());
                } else {
                    org.netbeans.modules.maven.model.profile.Profile profile3;
                    properties = pOMModel.getProject().getProperties();
                    if (properties != null) {
                        properties.setProperty("netbeans.hint.deploy.server", null);
                    }
                    if ((profile3 = modelHandle.getNetbeansPrivateProfile(false)) != null && profile3.getProperties() != null) {
                        profile3.getProperties().setProperty("netbeans.deployment.server.id", null);
                        modelHandle.markAsModified((Object)modelHandle.getProfileModel());
                    }
                }
                modelHandle.markAsModified((Object)modelHandle.getPOMModel());
                ModelHandleUtils.writeModelHandle((ModelHandle)modelHandle, (Project)this.prj);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (XmlPullParserException xmlPullParserException) {
                Exceptions.printStackTrace((Throwable)xmlPullParserException);
            }
        }
    }
}

