/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.maven.model.Build;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.j2ee.POHImpl;
import org.netbeans.modules.maven.j2ee.SelectAppServerPanel;
import org.netbeans.modules.maven.j2ee.SessionContent;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.modules.maven.spi.debug.MavenDebugger;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.OutputWriter;

public class ExecutionChecker
implements ExecutionResultChecker,
PrerequisitesChecker {
    private Project project;
    public static final String DEV_NULL = "DEV-NULL";
    public static final String MODULEURI = "netbeans.deploy.clientModuleUri";
    public static final String CLIENTURLPART = "netbeans.deploy.clientUrlPart";
    private static final String NB_COS = ".netbeans_automatic_build";

    ExecutionChecker(Project project) {
        this.project = project;
    }

    public void executionResult(RunConfig runConfig, ExecutionContext executionContext, int n) {
        boolean bl = Boolean.parseBoolean(runConfig.getProperties().getProperty("netbeans.deploy"));
        if (bl && n == 0) {
            if (RunUtils.hasApplicationCompileOnSaveEnabled((RunConfig)runConfig)) {
                this.touchCoSTimeStamp(runConfig, System.currentTimeMillis());
            }
            String string = runConfig.getProperties().getProperty(MODULEURI);
            String string2 = runConfig.getProperties().getProperty(CLIENTURLPART, "");
            boolean bl2 = Boolean.parseBoolean(runConfig.getProperties().getProperty("netbeans.deploy.forceRedeploy", "true"));
            boolean bl3 = Boolean.parseBoolean(runConfig.getProperties().getProperty("netbeans.deploy.debugmode"));
            boolean bl4 = Boolean.parseBoolean(runConfig.getProperties().getProperty("netbeans.deploy.profilemode"));
            this.performDeploy(executionContext, bl3, bl4, string, string2, bl2);
        }
    }

    private void performDeploy(ExecutionContext executionContext, boolean bl, boolean bl2, String string, String string2, boolean bl3) {
        FileUtil.refreshFor((File[])new File[]{FileUtil.toFile((FileObject)this.project.getProjectDirectory())});
        OutputWriter outputWriter = executionContext.getInputOutput().getErr();
        OutputWriter outputWriter2 = executionContext.getInputOutput().getOut();
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            outputWriter.println();
            outputWriter.println();
            outputWriter.println("NetBeans: Application Server deployment not available for Maven project '" + ProjectUtils.getInformation((Project)this.project).getDisplayName() + "'");
            return;
        }
        String string3 = j2eeModuleProvider.getServerInstanceID();
        if (DEV_NULL.equals(string3)) {
            outputWriter.println();
            outputWriter.println();
            outputWriter.println("NetBeans: No suitable Deployment Server is defined for the project or globally.");
            return;
        }
        ServerInstance serverInstance = Deployment.getDefault().getServerInstance(string3);
        try {
            outputWriter2.println("NetBeans: Deploying on " + (serverInstance != null ? serverInstance.getDisplayName() : string3));
        }
        catch (InstanceRemovedException instanceRemovedException) {
            outputWriter2.println("NetBeans: Deploying on " + string3);
        }
        try {
            String string4;
            FileObject fileObject;
            outputWriter2.println("    profile mode: " + bl2);
            outputWriter2.println("    debug mode: " + bl);
            outputWriter2.println("    force redeploy: " + bl3);
            Deployment.Mode mode = Deployment.Mode.RUN;
            if (bl) {
                mode = Deployment.Mode.DEBUG;
            } else if (bl2) {
                mode = Deployment.Mode.PROFILE;
            }
            String string5 = Deployment.getDefault().deploy(j2eeModuleProvider, mode, string, string2, bl3, (Deployment.Logger)new DLogger(outputWriter2));
            if (string5 != null) {
                fileObject = this.project.getProjectDirectory();
                boolean bl4 = true;
                if (fileObject != null) {
                    string4 = (String)fileObject.getAttribute("netbeans.deploy.showBrowser");
                    boolean bl5 = bl4 = string4 != null ? Boolean.parseBoolean(string4) : true;
                }
                if (bl4) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(string5));
                }
            }
            if (bl && (fileObject = j2eeModuleProvider.getServerDebugInfo()) != null) {
                String string6 = fileObject.getHost();
                string4 = fileObject.getTransport();
                String string7 = "";
                string7 = string4.equals("dt_shmem") ? fileObject.getShmemName() : Integer.toString(fileObject.getPort());
                MavenDebugger mavenDebugger = (MavenDebugger)this.project.getLookup().lookup(MavenDebugger.class);
                mavenDebugger.attachDebugger(executionContext.getInputOutput(), "Debug Deployed app", string4, string6, string7);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(ExecutionChecker.class.getName()).log(Level.FINE, "Exception occured wile deploying to Application Server.", exception);
        }
    }

    public boolean checkRunConfig(RunConfig runConfig) {
        J2eeModuleProvider j2eeModuleProvider;
        boolean bl = Boolean.parseBoolean(runConfig.getProperties().getProperty("netbeans.deploy"));
        if (bl && (j2eeModuleProvider = (J2eeModuleProvider)runConfig.getProject().getLookup().lookup(J2eeModuleProvider.class)) != null && DEV_NULL.equals(j2eeModuleProvider.getServerInstanceID())) {
            SelectAppServerPanel selectAppServerPanel = new SelectAppServerPanel();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)selectAppServerPanel, NbBundle.getMessage(ExecutionChecker.class, (String)"TIT_Select"));
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (object == NotifyDescriptor.OK_OPTION) {
                String string = selectAppServerPanel.getSelectedServerInstance();
                String string2 = selectAppServerPanel.getSelectedServerType();
                if (!DEV_NULL.equals(string)) {
                    Object object2;
                    boolean bl2 = selectAppServerPanel.isPermanent();
                    if (bl2) {
                        this.persistServer(string, string2);
                    } else {
                        object2 = (SessionContent)this.project.getLookup().lookup(SessionContent.class);
                        ((SessionContent)object2).setServerInstanceId(string);
                        WebModuleProviderImpl webModuleProviderImpl = (WebModuleProviderImpl)((Object)this.project.getLookup().lookup(WebModuleProviderImpl.class));
                        POHImpl pOHImpl = (POHImpl)((Object)this.project.getLookup().lookup(POHImpl.class));
                        if (webModuleProviderImpl != null) {
                            pOHImpl.setContextPath(webModuleProviderImpl.getWebModuleImplementation().getContextPath());
                        }
                        pOHImpl.hackModuleServerChange();
                        j2eeModuleProvider = null;
                    }
                    object2 = new LogRecord(Level.INFO, "USG_PROJECT_CONFIG_MAVEN_SERVER");
                    ((LogRecord)object2).setLoggerName("org.netbeans.ui.metrics.maven");
                    ((LogRecord)object2).setParameters(new Object[]{POHImpl.obtainServerName(this.project)});
                    POHImpl.USG_LOGGER.log((LogRecord)object2);
                    return true;
                }
            }
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ExecutionChecker.class, (String)"ERR_Action_without_deployment_server"));
            return false;
        }
        return true;
    }

    private boolean touchCoSTimeStamp(RunConfig runConfig, long l) {
        if (runConfig.getProject() == null) {
            return false;
        }
        Build build = runConfig.getMavenProject().getBuild();
        if (build == null || build.getOutputDirectory() == null) {
            return false;
        }
        File file = new File(build.getOutputDirectory());
        if (!(file = FileUtil.normalizeFile((File)file)).exists()) {
            return false;
        }
        File file2 = new File(file, NB_COS);
        if (!file2.exists()) {
            try {
                return file2.createNewFile();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return file2.setLastModified(l);
    }

    public static boolean hasCoSTimeStamp(Project project) {
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        if (nbMavenProject == null) {
            return false;
        }
        Build build = nbMavenProject.getMavenProject().getBuild();
        if (build == null || build.getOutputDirectory() == null) {
            return false;
        }
        File file = new File(build.getOutputDirectory());
        file = FileUtil.normalizeFile((File)file);
        File file2 = new File(file, NB_COS);
        return file2.exists();
    }

    private void persistServer(String string, final String string2) {
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("pom.xml");
        ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel pOMModel) {
                Properties properties = pOMModel.getProject().getProperties();
                if (properties == null) {
                    properties = pOMModel.getFactory().createProperties();
                    pOMModel.getProject().setProperties(properties);
                }
                properties.setProperty("netbeans.hint.deploy.server", string2);
            }
        };
        Utilities.performPOMModelOperations((FileObject)fileObject, Collections.singletonList(modelOperation));
        POHImpl pOHImpl = (POHImpl)((Object)this.project.getLookup().lookup(POHImpl.class));
        pOHImpl.hackModuleServerChange();
    }

    private static class DLogger
    implements Deployment.Logger {
        private OutputWriter logger;

        public DLogger(OutputWriter outputWriter) {
            this.logger = outputWriter;
        }

        public void log(String string) {
            this.logger.println(string);
        }
    }
}

