/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.issue.AttachmentsPanel;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.CommentsPanel;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssuePanel
extends JPanel {
    private static final DateFormat creationFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final DateFormat modificationFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Color HIGHLIGHT_COLOR = new Color(217, 255, 217);
    private BugzillaIssue issue;
    private CommentsPanel commentsPanel;
    private AttachmentsPanel attachmentsPanel;
    private int resolvedIndex;
    private Map<BugzillaIssue.IssueField, String> initialValues = new HashMap<BugzillaIssue.IssueField, String>();
    private List<String> keywords = new LinkedList<String>();
    private boolean reloading;
    private boolean skipReload;
    private boolean usingTargetMilestones;
    private int oldCommentCount;
    private boolean noSummary = false;
    private boolean invalidKeyword = false;
    private boolean cyclicDependency = false;
    private List<String> fieldErrors = new LinkedList<String>();
    private List<String> fieldWarnings = new LinkedList<String>();
    private Map<Component, Boolean> enableMap = new HashMap<Component, Boolean>();
    private JTextArea addCommentArea;
    private JLabel addCommentLabel;
    private JTextField assignedField;
    private JLabel assignedLabel;
    private JLabel assignedToWarning;
    private JLabel attachmentsLabel;
    private JButton blocksButton;
    private JTextField blocksField;
    private JLabel blocksLabel;
    private JLabel blocksWarning;
    private JButton cancelButton;
    private JTextField ccField;
    private JLabel ccLabel;
    private JLabel ccWarning;
    private JComboBox componentCombo;
    private JLabel componentLabel;
    private JLabel componentWarning;
    private JTextField dependsField;
    private JLabel dependsLabel;
    private JButton dependsOnButton;
    private JLabel dependsOnWarning;
    private JPanel dummyAttachmentsPanel;
    private JPanel dummyCommentsPanel;
    private JLabel dummyLabel1;
    private JLabel dummyLabel2;
    private JLabel dummyWarning;
    private JButton duplicateButton;
    private JTextField duplicateField;
    private JLabel duplicateLabel;
    private JLabel headerLabel;
    private JButton keywordsButton;
    private JTextField keywordsField;
    private JLabel keywordsLabel;
    private JLabel keywordsWarning;
    private JPanel messagePanel;
    private JLabel milestoneWarning;
    private JTextField modifiedField;
    private JLabel modifiedLabel;
    private JComboBox osCombo;
    private JLabel osLabel;
    private JLabel osWarning;
    private JComboBox platformCombo;
    private JLabel platformLabel;
    private JLabel platformWarning;
    private JComboBox priorityCombo;
    private JLabel priorityLabel;
    private JLabel priorityWarning;
    private JComboBox productCombo;
    private JTextField productField;
    private JLabel productLabel;
    private JLabel productWarning;
    private JTextField qaContactField;
    private JLabel qaContactLabel;
    private JLabel qaContactWarning;
    private LinkButton refreshButton;
    private LinkButton reloadButton;
    private JTextField reportedField;
    private JLabel reportedLabel;
    private JComboBox resolutionCombo;
    private JTextField resolutionField;
    private JLabel resolutionLabel;
    private JLabel resolutionWarning;
    private JScrollPane scrollPane1;
    private JSeparator separator;
    private JLabel separatorLabel;
    private JComboBox severityCombo;
    private JLabel severityLabel;
    private JLabel severityWarning;
    private JComboBox statusCombo;
    private JLabel statusLabel;
    private JLabel statusWarning;
    private JButton submitButton;
    private JTextField summaryField;
    private JLabel summaryLabel;
    private JLabel summaryWarning;
    private JComboBox targetMilestoneCombo;
    private JLabel targetMilestoneLabel;
    private JTextField urlField;
    private JLabel urlLabel;
    private JLabel urlWarning;
    private JComboBox versionCombo;
    private JLabel versionLabel;
    private JLabel versionWarning;

    public IssuePanel() {
        this.initComponents();
        this.reportedField.setBackground(this.getBackground());
        this.modifiedField.setBackground(this.getBackground());
        this.resolutionField.setBackground(this.getBackground());
        this.productField.setBackground(this.getBackground());
        this.messagePanel.setBackground(this.getBackground());
        Font font = this.headerLabel.getFont();
        this.headerLabel.setFont(font.deriveFont((float)((double)font.getSize() * 1.7)));
        this.duplicateLabel.setVisible(false);
        this.duplicateField.setVisible(false);
        this.duplicateButton.setVisible(false);
        this.attachDocumentListeners();
        BugtrackingUtil.fixFocusTraversalKeys((JComponent)this.addCommentArea);
        this.commentsPanel = new CommentsPanel();
        this.commentsPanel.setNewCommentHandler(new CommentsPanel.NewCommentHandler(){

            public void append(String string) {
                IssuePanel.this.addCommentArea.append(string);
                IssuePanel.this.addCommentArea.requestFocus();
                IssuePanel.this.scrollRectToVisible(IssuePanel.this.scrollPane1.getBounds());
            }
        });
        this.attachmentsPanel = new AttachmentsPanel();
        GroupLayout groupLayout = (GroupLayout)this.getLayout();
        groupLayout.replace((Component)this.dummyCommentsPanel, (Component)this.commentsPanel);
        groupLayout.replace((Component)this.dummyAttachmentsPanel, (Component)this.attachmentsPanel);
        this.attachmentsLabel.setLabelFor(this.attachmentsPanel);
        BugtrackingUtil.issue163946Hack((JScrollPane)this.scrollPane1);
    }

    void reloadFormInAWT(final boolean bl) {
        if (EventQueue.isDispatchThread()) {
            this.reloadForm(bl);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    IssuePanel.this.reloadForm(bl);
                }
            });
        }
    }

    public void setIssue(BugzillaIssue bugzillaIssue) {
        boolean bl;
        if (this.issue == null) {
            bugzillaIssue.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("issue.data_changed".equals(propertyChangeEvent.getPropertyName())) {
                        IssuePanel.this.reloadFormInAWT(false);
                    } else if ("issue.seen_changed".equals(propertyChangeEvent.getPropertyName())) {
                        IssuePanel.this.updateFieldStatuses();
                    }
                }
            });
            this.summaryField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    IssuePanel.this.updateNoSummary();
                }
            });
            this.keywordsField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    IssuePanel.this.updateInvalidKeyword();
                }
            });
        }
        this.issue = bugzillaIssue;
        this.initCombos();
        List<String> list = bugzillaIssue.getRepository().getConfiguration().getKeywords();
        this.keywords.clear();
        for (String string : list) {
            this.keywords.add(string.toUpperCase());
        }
        boolean bl2 = bl = !(bugzillaIssue.getRepository() instanceof KenaiRepository);
        if (this.qaContactLabel.isVisible() != bl) {
            String string;
            string = (GroupLayout)this.getLayout();
            JLabel jLabel = new JLabel();
            IssuePanel.swap((GroupLayout)string, this.ccLabel, this.qaContactLabel, jLabel);
            IssuePanel.swap((GroupLayout)string, this.ccField, this.qaContactField, jLabel);
            this.qaContactLabel.setVisible(bl);
            this.qaContactField.setVisible(bl);
        }
        this.reloadForm(true);
    }

    private static void swap(GroupLayout groupLayout, JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
        groupLayout.replace((Component)jComponent, (Component)jComponent3);
        groupLayout.replace((Component)jComponent2, (Component)jComponent);
        groupLayout.replace((Component)jComponent3, (Component)jComponent2);
    }

    private void reloadForm(boolean bl) {
        String string;
        if (this.skipReload) {
            return;
        }
        int n = this.fieldWarnings.size();
        int n2 = this.fieldErrors.size();
        if (bl) {
            this.fieldWarnings.clear();
            this.fieldErrors.clear();
        }
        this.reloading = true;
        boolean bl2 = this.issue.getTaskData().isNew();
        GroupLayout groupLayout = (GroupLayout)this.getLayout();
        if (bl2) {
            if (this.productCombo.getParent() == null) {
                groupLayout.replace((Component)this.productField, (Component)this.productCombo);
            }
        } else if (this.productField.getParent() == null) {
            groupLayout.replace((Component)this.productCombo, (Component)this.productField);
        }
        this.productLabel.setLabelFor(bl2 ? this.productCombo : this.productField);
        this.headerLabel.setVisible(!bl2);
        this.statusCombo.setEnabled(!bl2);
        Mnemonics.setLocalizedText((JLabel)this.addCommentLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)(bl2 ? "IssuePanel.description" : "IssuePanel.addCommentLabel.text")));
        this.reportedLabel.setVisible(!bl2);
        this.reportedField.setVisible(!bl2);
        this.modifiedLabel.setVisible(!bl2);
        this.modifiedField.setVisible(!bl2);
        this.separator.setVisible(!bl2);
        this.commentsPanel.setVisible(!bl2);
        this.attachmentsLabel.setVisible(!bl2);
        this.attachmentsPanel.setVisible(!bl2);
        this.refreshButton.setVisible(!bl2);
        this.separatorLabel.setVisible(!bl2);
        this.cancelButton.setVisible(!bl2);
        Mnemonics.setLocalizedText((AbstractButton)this.submitButton, (String)NbBundle.getMessage(IssuePanel.class, (String)(bl2 ? "IssuePanel.submitButton.text.new" : "IssuePanel.submitButton.text")));
        if (bl2 && bl) {
            this.productCombo.setSelectedIndex(0);
            this.initStatusCombo("NEW");
        } else {
            Object object;
            String string2 = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.headerLabel.format");
            string = MessageFormat.format(string2, this.issue.getID(), this.issue.getSummary());
            this.headerLabel.setText(string);
            this.reloadField(bl, this.summaryField, BugzillaIssue.IssueField.SUMMARY, this.summaryWarning, this.summaryLabel);
            this.reloadField(bl, this.productCombo, BugzillaIssue.IssueField.PRODUCT, this.productWarning, this.productLabel);
            this.reloadField(bl, this.productField, BugzillaIssue.IssueField.PRODUCT, null, null);
            this.reloadField(bl, this.componentCombo, BugzillaIssue.IssueField.COMPONENT, this.componentWarning, this.componentLabel);
            this.reloadField(bl, this.versionCombo, BugzillaIssue.IssueField.VERSION, this.versionWarning, this.versionLabel);
            this.reloadField(bl, this.platformCombo, BugzillaIssue.IssueField.PLATFORM, this.platformWarning, this.platformLabel);
            this.reloadField(bl, this.osCombo, BugzillaIssue.IssueField.OS, this.osWarning, this.osLabel);
            this.reloadField(bl, this.resolutionField, BugzillaIssue.IssueField.RESOLUTION, null, null);
            String string3 = this.reloadField(bl, this.statusCombo, BugzillaIssue.IssueField.STATUS, this.statusWarning, this.statusLabel);
            this.initStatusCombo(string3);
            this.reloadField(bl, this.resolutionCombo, BugzillaIssue.IssueField.RESOLUTION, this.resolutionWarning, this.resolutionLabel);
            String string4 = this.initialValues.get((Object)BugzillaIssue.IssueField.RESOLUTION);
            if ("DUPLICATE".equals(string4)) {
                this.duplicateField.setEditable(false);
                this.duplicateField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.duplicateField.setBackground(this.getBackground());
            } else {
                object = new JTextField();
                this.duplicateField.setEditable(true);
                this.duplicateField.setBorder(((JComponent)object).getBorder());
                this.duplicateField.setBackground(((Component)object).getBackground());
            }
            this.reloadField(bl, this.priorityCombo, BugzillaIssue.IssueField.PRIORITY, this.priorityWarning, this.priorityLabel);
            this.reloadField(bl, this.severityCombo, BugzillaIssue.IssueField.SEVERITY, this.severityWarning, this.severityLabel);
            if (this.usingTargetMilestones) {
                this.reloadField(bl, this.targetMilestoneCombo, BugzillaIssue.IssueField.MILESTONE, this.milestoneWarning, this.targetMilestoneLabel);
            }
            this.reloadField(bl, this.urlField, BugzillaIssue.IssueField.URL, this.urlWarning, this.urlLabel);
            this.reloadField(bl, this.keywordsField, BugzillaIssue.IssueField.KEYWORDS, this.keywordsWarning, this.keywordsLabel);
            if (!bl2) {
                Object object2;
                string2 = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reportedLabel.format");
                object = this.issue.getFieldValue(BugzillaIssue.IssueField.CREATION);
                try {
                    object2 = creationFormat.parse((String)object);
                    object = DateFormat.getDateTimeInstance(2, 3).format((Date)object2);
                }
                catch (ParseException parseException) {
                    Bugzilla.LOG.log(Level.INFO, null, parseException);
                }
                object2 = MessageFormat.format(string2, object, this.issue.getFieldValue(BugzillaIssue.IssueField.REPORTER_NAME));
                this.reportedField.setText((String)object2);
                IssuePanel.fixPrefSize(this.reportedField);
                String string5 = this.issue.getFieldValue(BugzillaIssue.IssueField.MODIFICATION);
                try {
                    Date date = modificationFormat.parse(string5);
                    string5 = DateFormat.getDateTimeInstance().format(date);
                }
                catch (ParseException parseException) {
                    Bugzilla.LOG.log(Level.INFO, null, parseException);
                }
                this.modifiedField.setText(string5);
                IssuePanel.fixPrefSize(this.modifiedField);
            }
            this.reloadField(bl, this.assignedField, BugzillaIssue.IssueField.ASSIGNED_TO, this.assignedToWarning, this.assignedLabel);
            this.reloadField(bl, this.qaContactField, BugzillaIssue.IssueField.QA_CONTACT, this.qaContactWarning, this.qaContactLabel);
            this.reloadField(bl, this.ccField, BugzillaIssue.IssueField.CC, this.ccWarning, this.ccLabel);
            this.reloadField(bl, this.dependsField, BugzillaIssue.IssueField.DEPENDS_ON, this.dependsOnWarning, this.dependsLabel);
            this.reloadField(bl, this.blocksField, BugzillaIssue.IssueField.BLOCKS, this.blocksWarning, this.blocksLabel);
        }
        int n3 = this.issue.getComments().length;
        if (!bl && this.oldCommentCount != n3 && !this.fieldWarnings.contains(string = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.commentAddedWarning"))) {
            this.fieldWarnings.add(0, string);
        }
        this.oldCommentCount = n3;
        if (!bl2) {
            this.commentsPanel.setIssue(this.issue);
        }
        this.attachmentsPanel.setIssue(this.issue);
        BugtrackingUtil.keepFocusedComponentVisible((Component)this.commentsPanel);
        BugtrackingUtil.keepFocusedComponentVisible((Component)this.attachmentsPanel);
        if (bl) {
            this.addCommentArea.setText("");
        }
        this.updateFieldStatuses();
        this.updateNoSummary();
        if (this.fieldWarnings.size() != n || this.fieldErrors.size() != n2) {
            this.updateMessagePanel();
        }
        this.reloading = false;
    }

    private static void fixPrefSize(JTextField jTextField) {
        jTextField.setPreferredSize(null);
        Dimension dimension = jTextField.getPreferredSize();
        Dimension dimension2 = new Dimension(dimension.width + 1, dimension.height);
        jTextField.setPreferredSize(dimension2);
    }

    private String reloadField(boolean bl, JComponent jComponent, BugzillaIssue.IssueField issueField, JLabel jLabel, JLabel jLabel2) {
        boolean bl2;
        Object object;
        String string = null;
        if (this.issue.getTaskData().isNew()) {
            bl = true;
        }
        if (!bl) {
            if (jComponent instanceof JComboBox) {
                object = ((JComboBox)jComponent).getSelectedItem();
                string = object == null ? "" : object.toString();
            } else if (jComponent instanceof JTextField) {
                string = ((JTextField)jComponent).getText();
            }
        }
        object = this.initialValues.get((Object)issueField);
        String string2 = this.issue.getFieldValue(issueField);
        boolean bl3 = string != null && object != null && !string.equals(object);
        boolean bl4 = bl2 = object != null && string2 != null && !((String)object).equals(string2);
        if (bl || !bl3) {
            Object object2;
            if (jComponent instanceof JComboBox) {
                object2 = (JComboBox)jComponent;
                this.selectInCombo((JComboBox)object2, string2, true);
            } else if (jComponent instanceof JTextField) {
                ((JTextField)jComponent).setText(string2);
            }
            if (bl) {
                if (jLabel != null) {
                    jLabel.setIcon(null);
                }
            } else if (bl2 && jLabel != null) {
                jLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/warning.gif", (boolean)true));
                object2 = this.fieldName(jLabel2);
                String string3 = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.fieldModifiedWarning");
                String string4 = MessageFormat.format(string3, object2, string, string2);
                this.fieldWarnings.add(string4);
                jLabel.setToolTipText(string4);
            }
            string = string2;
        } else if (bl2 && jLabel != null) {
            jLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/error.gif", (boolean)true));
            String string5 = this.fieldName(jLabel2);
            String string6 = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.fieldModifiedError");
            String string7 = MessageFormat.format(string6, string5, string2);
            this.fieldErrors.add(string7);
            jLabel.setToolTipText(string7);
        }
        if (BugzillaIssue.IssueField.SUMMARY == issueField) {
            jLabel.setVisible(jLabel.getIcon() != null);
        }
        this.initialValues.put(issueField, string2);
        return string;
    }

    private void selectInCombo(JComboBox jComboBox, Object object, boolean bl) {
        ComboBoxModel comboBoxModel;
        if (object == null) {
            return;
        }
        jComboBox.setSelectedItem(object);
        if (bl && !object.equals("") && !object.equals(jComboBox.getSelectedItem()) && (comboBoxModel = jComboBox.getModel()) instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)comboBoxModel).insertElementAt(object, 0);
            jComboBox.setSelectedIndex(0);
        }
    }

    private String fieldName(JLabel jLabel) {
        String string = jLabel.getText().trim();
        if (string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private void initCombos() {
        BugzillaRepository bugzillaRepository = this.issue.getRepository();
        BugzillaConfiguration bugzillaConfiguration = bugzillaRepository.getConfiguration();
        if (bugzillaConfiguration == null || !bugzillaConfiguration.isValid()) {
            return;
        }
        this.productCombo.setModel(this.toComboModel(bugzillaConfiguration.getProducts()));
        this.platformCombo.setModel(this.toComboModel(bugzillaConfiguration.getPlatforms()));
        this.osCombo.setModel(this.toComboModel(bugzillaConfiguration.getOSs()));
        LinkedList<String> linkedList = new LinkedList<String>(bugzillaConfiguration.getResolutions());
        linkedList.remove("MOVED");
        this.resolutionCombo.setModel(this.toComboModel(linkedList));
        this.priorityCombo.setModel(this.toComboModel(bugzillaConfiguration.getPriorities()));
        this.severityCombo.setModel(this.toComboModel(bugzillaConfiguration.getSeverities()));
    }

    private void initStatusCombo(String string) {
        BugzillaRepository bugzillaRepository = this.issue.getRepository();
        BugzillaConfiguration bugzillaConfiguration = bugzillaRepository.getConfiguration();
        if (bugzillaConfiguration == null || !bugzillaConfiguration.isValid()) {
            return;
        }
        List<String> list = bugzillaConfiguration.getStatusValues();
        List<String> list2 = bugzillaConfiguration.getOpenStatusValues();
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = "UNCONFIRMED";
        String string3 = "REOPENED";
        String string4 = "RESOLVED";
        if (list2.contains(string)) {
            linkedList.addAll(list2);
            if (!string2.equals(string)) {
                linkedList.remove(string2);
            }
            if (!string3.equals(string)) {
                linkedList.remove(string3);
            }
            linkedList.add(string4);
        } else {
            if (list.contains(string3)) {
                linkedList.add(string3);
            } else {
                linkedList.addAll(list2);
                linkedList.remove(string2);
            }
            if (string4.equals(string)) {
                LinkedList<String> linkedList2 = new LinkedList<String>(list);
                linkedList2.removeAll(list2);
                linkedList.addAll(linkedList2);
            } else {
                linkedList.add(string4);
                if (!string.equals("")) {
                    for (int i = list.indexOf(string); i < list.size(); ++i) {
                        String string5 = list.get(i);
                        if (list2.contains(string5)) continue;
                        linkedList.add(string5);
                    }
                }
            }
            this.resolvedIndex = linkedList.indexOf(string4);
        }
        this.statusCombo.setModel(this.toComboModel(linkedList));
        this.statusCombo.setSelectedItem(string);
    }

    private ComboBoxModel toComboModel(List<String> list) {
        return new DefaultComboBoxModel<Object>(list.toArray());
    }

    private void updateFieldStatuses() {
        this.updateFieldStatus(BugzillaIssue.IssueField.PRODUCT, this.productLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.COMPONENT, this.componentLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.VERSION, this.versionLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.PLATFORM, this.platformLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.OS, this.osLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.STATUS, this.statusLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.RESOLUTION, this.resolutionLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.PRIORITY, this.priorityLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.SEVERITY, this.severityLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.MILESTONE, this.targetMilestoneLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.URL, this.urlLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.KEYWORDS, this.keywordsLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.ASSIGNED_TO, this.assignedLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.QA_CONTACT, this.qaContactLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.CC, this.ccLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.DEPENDS_ON, this.dependsLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.BLOCKS, this.blocksLabel);
    }

    private void updateFieldStatus(BugzillaIssue.IssueField issueField, JLabel jLabel) {
        boolean bl = !this.issue.getTaskData().isNew() && this.issue.getFieldStatus(issueField) != 1;
        jLabel.setOpaque(bl);
        if (bl) {
            jLabel.setBackground(HIGHLIGHT_COLOR);
        }
    }

    private void cancelHighlight(JLabel jLabel) {
        if (!this.reloading) {
            jLabel.setOpaque(false);
            jLabel.getParent().repaint();
        }
    }

    private void storeFieldValue(BugzillaIssue.IssueField issueField, JComboBox jComboBox) {
        Object object = jComboBox.getSelectedItem();
        if (object != null) {
            this.storeFieldValue(issueField, object.toString());
        }
    }

    private void storeFieldValue(BugzillaIssue.IssueField issueField, JTextComponent jTextComponent) {
        this.storeFieldValue(issueField, jTextComponent.getText());
    }

    private void storeFieldValue(BugzillaIssue.IssueField issueField, String string) {
        if (this.issue.getTaskData().isNew() || !string.equals(this.initialValues.get((Object)issueField))) {
            this.issue.setFieldValue(issueField, string);
        }
    }

    private void attachDocumentListeners() {
        this.urlField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.urlLabel));
        this.keywordsField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.keywordsLabel));
        this.assignedField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.assignedLabel));
        this.qaContactField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.qaContactLabel));
        this.ccField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.ccLabel));
        this.blocksField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.blocksLabel));
        this.dependsField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.dependsLabel));
        CyclicDependencyDocumentListener cyclicDependencyDocumentListener = new CyclicDependencyDocumentListener();
        this.blocksField.getDocument().addDocumentListener(cyclicDependencyDocumentListener);
        this.dependsField.getDocument().addDocumentListener(cyclicDependencyDocumentListener);
        this.addCommentArea.getDocument().addDocumentListener(new RevalidatingListener());
    }

    private void updateNoSummary() {
        if (this.summaryField.getText().trim().length() == 0) {
            if (!this.noSummary) {
                this.noSummary = true;
                this.updateMessagePanel();
            }
        } else if (this.noSummary) {
            this.noSummary = false;
            this.updateMessagePanel();
        }
    }

    private void updateInvalidKeyword() {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(this.keywordsField.getText(), ", \t\n\r\f");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (this.keywords.contains(string.toUpperCase())) continue;
            bl = true;
            break;
        }
        if (bl != this.invalidKeyword) {
            this.invalidKeyword = bl;
            this.updateMessagePanel();
        }
    }

    private void updateMessagePanel() {
        JLabel jLabel;
        Iterator<String> iterator;
        this.messagePanel.removeAll();
        if (this.noSummary) {
            iterator = new JLabel();
            ((JLabel)((Object)iterator)).setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.noSummary"));
            String string = this.issue.getTaskData().isNew() ? "org/netbeans/modules/bugzilla/resources/info.png" : "org/netbeans/modules/bugzilla/resources/error.gif";
            ((JLabel)((Object)iterator)).setIcon(new ImageIcon(ImageUtilities.loadImage((String)string)));
            this.messagePanel.add((Component)((Object)iterator));
        }
        if (this.cyclicDependency) {
            iterator = new JLabel();
            ((JLabel)((Object)iterator)).setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.cyclicDependency"));
            ((JLabel)((Object)iterator)).setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugzilla/resources/error.gif")));
            this.messagePanel.add((Component)((Object)iterator));
        }
        if (this.invalidKeyword) {
            iterator = new JLabel();
            ((JLabel)((Object)iterator)).setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.invalidKeyword"));
            ((JLabel)((Object)iterator)).setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugzilla/resources/error.gif")));
            this.messagePanel.add((Component)((Object)iterator));
        }
        if (this.noSummary || this.cyclicDependency || this.invalidKeyword) {
            this.submitButton.setEnabled(false);
        } else {
            this.submitButton.setEnabled(true);
        }
        for (String string : this.fieldErrors) {
            jLabel = new JLabel(string);
            jLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/error.gif", (boolean)true));
            this.messagePanel.add(jLabel);
        }
        for (String string : this.fieldWarnings) {
            jLabel = new JLabel(string);
            jLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/warning.gif", (boolean)true));
            this.messagePanel.add(jLabel);
        }
        if (this.noSummary || this.cyclicDependency || this.invalidKeyword || this.fieldErrors.size() + this.fieldWarnings.size() > 0) {
            this.messagePanel.setVisible(true);
            this.messagePanel.revalidate();
        } else {
            this.messagePanel.setVisible(false);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.issue != null) {
            this.reloadForm(true);
            this.issue.opened();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.issue != null) {
            this.issue.closed();
        }
    }

    private void enableComponents(boolean bl) {
        this.enableComponents(this, bl);
        if (bl) {
            this.enableMap.clear();
        }
    }

    private void enableComponents(Component component, boolean bl) {
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                this.enableComponents(component2, bl);
            }
        }
        if (component instanceof JComboBox || component instanceof JTextComponent && ((JTextComponent)component).isEditable() || component instanceof AbstractButton) {
            if (bl) {
                Boolean bl2 = this.enableMap.get(component);
                if (bl2 != null) {
                    component.setEnabled(bl2);
                }
            } else {
                this.enableMap.put(component, component.isEnabled());
                component.setEnabled(false);
            }
        }
    }

    private void initComponents() {
        this.resolutionField = new JTextField();
        this.productField = new JTextField();
        this.productLabel = new JLabel();
        this.componentLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.duplicateButton = new JButton();
        this.platformLabel = new JLabel();
        this.productCombo = new JComboBox();
        this.componentCombo = new JComboBox();
        this.versionCombo = new JComboBox();
        this.platformCombo = new JComboBox();
        this.statusLabel = new JLabel();
        this.statusCombo = new JComboBox();
        this.resolutionLabel = new JLabel();
        this.resolutionCombo = new JComboBox();
        this.priorityLabel = new JLabel();
        this.priorityCombo = new JComboBox();
        this.severityLabel = new JLabel();
        this.severityCombo = new JComboBox();
        this.targetMilestoneLabel = new JLabel();
        this.targetMilestoneCombo = new JComboBox();
        this.urlLabel = new JLabel();
        this.urlField = new JTextField();
        this.keywordsLabel = new JLabel();
        this.keywordsField = new JTextField();
        this.reportedLabel = new JLabel();
        this.reportedField = new JTextField();
        this.modifiedLabel = new JLabel();
        this.modifiedField = new JTextField();
        this.assignedLabel = new JLabel();
        this.assignedField = new JTextField();
        this.qaContactLabel = new JLabel();
        this.qaContactField = new JTextField();
        this.ccLabel = new JLabel();
        this.ccField = new JTextField();
        this.dependsLabel = new JLabel();
        this.dependsField = new JTextField();
        this.blocksLabel = new JLabel();
        this.blocksField = new JTextField();
        this.dummyLabel1 = new JLabel();
        this.dummyLabel2 = new JLabel();
        this.addCommentLabel = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.addCommentArea = new JTextArea(){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension dimension = super.getPreferredScrollableViewportSize();
                JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
                int n = 0;
                if (jScrollPane != null) {
                    JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
                    n = jScrollBar.isVisible() ? ((Component)jScrollBar).getHeight() : 0;
                }
                dimension = new Dimension(dimension.width, n + (dimension.height < 100 ? 100 : dimension.height));
                return dimension;
            }
        };
        this.submitButton = new JButton();
        this.cancelButton = new JButton();
        this.dummyCommentsPanel = new JPanel();
        this.attachmentsLabel = new JLabel();
        this.dummyAttachmentsPanel = new JPanel();
        this.separator = new JSeparator();
        this.headerLabel = new JLabel();
        this.refreshButton = new LinkButton();
        this.duplicateField = new JTextField();
        this.duplicateLabel = new JLabel();
        this.keywordsButton = new JButton();
        this.blocksButton = new JButton();
        this.dependsOnButton = new JButton();
        this.osLabel = new JLabel();
        this.osCombo = new JComboBox();
        this.summaryField = new JTextField();
        this.summaryLabel = new JLabel();
        this.messagePanel = new JPanel();
        this.productWarning = new JLabel();
        this.urlWarning = new JLabel();
        this.componentWarning = new JLabel();
        this.versionWarning = new JLabel();
        this.platformWarning = new JLabel();
        this.osWarning = new JLabel();
        this.statusWarning = new JLabel();
        this.resolutionWarning = new JLabel();
        this.priorityWarning = new JLabel();
        this.severityWarning = new JLabel();
        this.milestoneWarning = new JLabel();
        this.keywordsWarning = new JLabel();
        this.assignedToWarning = new JLabel();
        this.qaContactWarning = new JLabel();
        this.ccWarning = new JLabel();
        this.dependsOnWarning = new JLabel();
        this.blocksWarning = new JLabel();
        this.dummyWarning = new JLabel();
        this.summaryWarning = new JLabel();
        this.reloadButton = new LinkButton();
        this.separatorLabel = new JLabel();
        FormListener formListener = new FormListener();
        this.resolutionField.setEditable(false);
        this.resolutionField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.resolutionField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.resolutionField.AccessibleContext.accessibleDescription"));
        this.productField.setEditable(false);
        this.productField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.productField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.productField.AccessibleContext.accessibleDescription"));
        this.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        Mnemonics.setLocalizedText((JLabel)this.productLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.productLabel.text"));
        this.componentLabel.setLabelFor(this.componentCombo);
        Mnemonics.setLocalizedText((JLabel)this.componentLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.componentLabel.text"));
        this.versionLabel.setLabelFor(this.versionCombo);
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.versionLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.duplicateButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateButton.text"));
        this.duplicateButton.setFocusPainted(false);
        this.duplicateButton.setMargin(new Insets(0, 0, 0, 0));
        this.duplicateButton.addActionListener(formListener);
        this.platformLabel.setLabelFor(this.platformCombo);
        Mnemonics.setLocalizedText((JLabel)this.platformLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.platformLabel.text"));
        this.productCombo.addActionListener(formListener);
        this.componentCombo.addActionListener(formListener);
        this.versionCombo.addActionListener(formListener);
        this.platformCombo.addActionListener(formListener);
        this.statusLabel.setLabelFor(this.statusCombo);
        Mnemonics.setLocalizedText((JLabel)this.statusLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.statusLabel.text"));
        this.statusCombo.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.resolutionLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.resolutionLabel.text"));
        this.resolutionCombo.addActionListener(formListener);
        this.priorityLabel.setLabelFor(this.priorityCombo);
        Mnemonics.setLocalizedText((JLabel)this.priorityLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.priorityLabel.text"));
        this.priorityCombo.addActionListener(formListener);
        this.severityLabel.setLabelFor(this.severityCombo);
        Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.severityLabel.text"));
        this.severityCombo.addActionListener(formListener);
        this.targetMilestoneLabel.setLabelFor(this.targetMilestoneCombo);
        Mnemonics.setLocalizedText((JLabel)this.targetMilestoneLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.targetMilestoneLabel.text"));
        this.targetMilestoneCombo.addActionListener(formListener);
        this.urlLabel.setLabelFor(this.urlField);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.urlLabel.text"));
        this.urlField.setColumns(15);
        this.keywordsLabel.setLabelFor(this.keywordsField);
        Mnemonics.setLocalizedText((JLabel)this.keywordsLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsLabel.text"));
        this.keywordsField.setColumns(15);
        this.reportedLabel.setLabelFor(this.reportedField);
        Mnemonics.setLocalizedText((JLabel)this.reportedLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reportedLabel.text"));
        this.reportedField.setEditable(false);
        this.reportedField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.modifiedLabel.setLabelFor(this.modifiedField);
        Mnemonics.setLocalizedText((JLabel)this.modifiedLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.modifiedLabel.text"));
        this.modifiedField.setEditable(false);
        this.modifiedField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.assignedLabel.setLabelFor(this.assignedField);
        Mnemonics.setLocalizedText((JLabel)this.assignedLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.assignedLabel.text"));
        this.assignedField.setColumns(15);
        this.qaContactLabel.setLabelFor(this.qaContactField);
        Mnemonics.setLocalizedText((JLabel)this.qaContactLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.qaContactLabel.text"));
        this.qaContactField.setColumns(15);
        this.ccLabel.setLabelFor(this.ccField);
        Mnemonics.setLocalizedText((JLabel)this.ccLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.ccLabel.text"));
        this.ccField.setColumns(15);
        this.dependsLabel.setLabelFor(this.dependsField);
        Mnemonics.setLocalizedText((JLabel)this.dependsLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsLabel.text"));
        this.dependsField.setColumns(15);
        this.blocksLabel.setLabelFor(this.blocksField);
        Mnemonics.setLocalizedText((JLabel)this.blocksLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksLabel.text"));
        this.blocksField.setColumns(15);
        this.addCommentLabel.setLabelFor(this.addCommentArea);
        Mnemonics.setLocalizedText((JLabel)this.addCommentLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.addCommentLabel.text"));
        this.scrollPane1.setVerticalScrollBarPolicy(21);
        this.scrollPane1.setViewportView(this.addCommentArea);
        this.addCommentArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.addCommentArea.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.submitButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.submitButton.text"));
        this.submitButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.cancelButton.text"));
        this.cancelButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.attachmentsLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.attachmentsLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this.dummyAttachmentsPanel);
        this.dummyAttachmentsPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 459, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.refreshButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.refreshButton.text"));
        this.refreshButton.setToolTipText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.refreshButton.toolTipText"));
        this.refreshButton.addActionListener((ActionListener)formListener);
        this.duplicateLabel.setLabelFor(this.duplicateField);
        Mnemonics.setLocalizedText((JLabel)this.duplicateLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.keywordsButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsButton.text"));
        this.keywordsButton.setFocusPainted(false);
        this.keywordsButton.setMargin(new Insets(0, 0, 0, 0));
        this.keywordsButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.blocksButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksButton.text"));
        this.blocksButton.setFocusPainted(false);
        this.blocksButton.setMargin(new Insets(0, 0, 0, 0));
        this.blocksButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.dependsOnButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsOnButton.text"));
        this.dependsOnButton.setFocusPainted(false);
        this.dependsOnButton.setMargin(new Insets(0, 0, 0, 0));
        this.dependsOnButton.addActionListener(formListener);
        this.osLabel.setLabelFor(this.osCombo);
        Mnemonics.setLocalizedText((JLabel)this.osLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.osLabel.text"));
        this.osCombo.addActionListener(formListener);
        this.summaryLabel.setLabelFor(this.summaryField);
        Mnemonics.setLocalizedText((JLabel)this.summaryLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.summaryLabel.text"));
        this.messagePanel.setLayout(new BoxLayout(this.messagePanel, 3));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reloadButton.text"));
        this.reloadButton.setToolTipText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reloadButton.toolTipText"));
        this.reloadButton.addActionListener((ActionListener)formListener);
        this.separatorLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (Component)this.separator, -1, 577, Short.MAX_VALUE).add((Component)this.dummyCommentsPanel, -1, 577, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.headerLabel).addContainerGap()).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap(402, Short.MAX_VALUE).add((Component)this.refreshButton, -2, -1, -2).addPreferredGap(0).add((Component)this.separatorLabel).addPreferredGap(0).add((Component)this.reloadButton, -2, -1, -2).addContainerGap()).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((Component)this.attachmentsLabel).add((Component)this.productLabel).add((Component)this.componentLabel).add((Component)this.versionLabel).add((Component)this.platformLabel).add((Component)this.statusLabel).add((Component)this.resolutionLabel).add((Component)this.priorityLabel).add((Component)this.severityLabel).add((Component)this.targetMilestoneLabel).add((Component)this.dummyLabel1).add((Component)this.urlLabel).add((Component)this.keywordsLabel).add((Component)this.dummyLabel2).add((Component)this.addCommentLabel).add((Component)this.osLabel).add((Component)this.summaryLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.messagePanel, -1, 459, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.submitButton).addPreferredGap(0).add((Component)this.cancelButton)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.dummyAttachmentsPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1, false).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.osCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.osWarning, -2, 16, -2)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.keywordsField).add(0, 0, 0).add((Component)this.keywordsButton).addPreferredGap(0).add((Component)this.keywordsWarning, -2, 16, -2)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.urlField).addPreferredGap(0).add((Component)this.urlWarning, -2, 16, -2)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.targetMilestoneCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.milestoneWarning, -2, 16, -2)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.severityCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.severityWarning, -2, 16, -2)).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.priorityCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.priorityWarning, -2, 16, -2)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.resolutionCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.resolutionWarning, -2, 16, -2)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.statusCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.statusWarning, -2, 16, -2)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.productCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.productWarning, -2, 16, -2)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.componentCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.componentWarning, -2, 16, -2)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.versionCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.versionWarning, -2, 16, -2)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.platformCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.platformWarning, -2, 16, -2))).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((Component)this.reportedLabel).add((Component)this.modifiedLabel).add((Component)this.assignedLabel).add((Component)this.qaContactLabel).add((Component)this.ccLabel).add((Component)this.dependsLabel).add((Component)this.blocksLabel).add((Component)this.duplicateLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.reportedField, -2, -1, -2).add((GroupLayout.Group)groupLayout2.createParallelGroup(1, false).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.blocksField).add(0, 0, 0).add((Component)this.blocksButton).addPreferredGap(0).add((Component)this.blocksWarning, -2, 16, -2).addPreferredGap(0)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.dependsField).add(0, 0, 0).add((Component)this.dependsOnButton).addPreferredGap(0).add((Component)this.dependsOnWarning, -2, 16, -2).addPreferredGap(0)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.ccField).addPreferredGap(0).add((Component)this.ccWarning, -2, 16, -2).addPreferredGap(0)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.assignedField).addPreferredGap(0).add((Component)this.assignedToWarning, -2, 16, -2).addPreferredGap(0)).add((Component)this.modifiedField, -2, -1, -2).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.qaContactField).addPreferredGap(0).add((Component)this.qaContactWarning, -2, 16, -2).addPreferredGap(0)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.duplicateField).add(0, 0, 0).add((Component)this.duplicateButton).addPreferredGap(0).add((Component)this.dummyWarning, -2, 16, -2).addPreferredGap(0))))).add((Component)this.scrollPane1, -1, 459, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.summaryField, -1, 439, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.summaryWarning, -2, 16, -2).addPreferredGap(0))).add(10, 10, 10)))));
        groupLayout2.linkSize(new Component[]{this.cancelButton, this.submitButton}, 1);
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.headerLabel).add(18, 18, 18).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.productLabel).add((Component)this.productCombo, -2, -1, -2).add((Component)this.reportedLabel).add((Component)this.reportedField, -2, -1, -2).add((Component)this.productWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.componentLabel).add((Component)this.componentCombo, -2, -1, -2).add((Component)this.modifiedLabel).add((Component)this.modifiedField, -2, -1, -2).add((Component)this.componentWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.versionLabel).add((Component)this.versionCombo, -2, -1, -2).add((Component)this.versionWarning, -2, 16, -2))).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.refreshButton, -2, -1, -2).add((Component)this.reloadButton, -2, -1, -2).add((Component)this.separatorLabel))).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.platformLabel).add((Component)this.platformCombo, -2, -1, -2).add((Component)this.assignedLabel).add((Component)this.assignedField, -2, -1, -2).add((Component)this.platformWarning, -2, 16, -2).add((Component)this.assignedToWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.qaContactLabel).add((Component)this.qaContactField, -2, -1, -2).add((Component)this.osLabel).add((Component)this.osCombo, -2, -1, -2).add((Component)this.osWarning, -2, 16, -2).add((Component)this.qaContactWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.ccLabel).add((Component)this.statusCombo, -2, -1, -2).add((Component)this.statusLabel).add((Component)this.ccField, -2, -1, -2).add((Component)this.statusWarning, -2, 16, -2)).add((Component)this.ccWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.resolutionLabel).add((Component)this.resolutionCombo, -2, -1, -2).add((Component)this.duplicateField, -2, -1, -2).add((Component)this.duplicateLabel).add((Component)this.resolutionWarning, -2, 16, -2).add((Component)this.dummyWarning, -2, 16, -2).add((Component)this.duplicateButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.dependsField, -2, -1, -2).add((Component)this.dependsLabel).add((Component)this.dependsOnButton).add((Component)this.dependsOnWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.blocksLabel).add((Component)this.priorityCombo, -2, -1, -2).add((Component)this.priorityLabel).add((Component)this.blocksField, -2, -1, -2).add((Component)this.blocksButton).add((Component)this.priorityWarning, -2, 16, -2).add((Component)this.blocksWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.severityLabel).add((Component)this.severityCombo, -2, -1, -2)).add((Component)this.severityWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.targetMilestoneLabel).add((Component)this.targetMilestoneCombo, -2, -1, -2).add((Component)this.milestoneWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.dummyLabel1).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.urlLabel).add((Component)this.urlField, -2, -1, -2))).add((Component)this.urlWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.keywordsLabel).add((Component)this.keywordsField, -2, -1, -2).add((Component)this.keywordsButton).add((Component)this.keywordsWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.attachmentsLabel).addPreferredGap(0).add((Component)this.dummyLabel2)).add((Component)this.dummyAttachmentsPanel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.summaryField, -2, -1, -2).add((Component)this.summaryLabel).add((Component)this.summaryWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.addCommentLabel).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.scrollPane1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.submitButton).add((Component)this.cancelButton)).addPreferredGap(0).add((Component)this.messagePanel, -2, -1, -2))).add(7, 7, 7).add((Component)this.separator, -2, -1, -2).addPreferredGap(0).add((Component)this.dummyCommentsPanel, -1, -1, Short.MAX_VALUE)));
        groupLayout2.linkSize(new Component[]{this.dummyLabel1, this.dummyLabel2, this.severityCombo}, 2);
        groupLayout2.linkSize(new Component[]{this.reloadButton, this.separatorLabel}, 2);
        groupLayout2.linkSize(new Component[]{this.assignedLabel, this.blocksLabel, this.ccLabel, this.componentLabel, this.dependsLabel, this.keywordsLabel, this.osLabel, this.platformLabel, this.priorityLabel, this.productLabel, this.qaContactLabel, this.resolutionLabel, this.severityLabel, this.statusCombo, this.statusLabel, this.targetMilestoneLabel, this.urlLabel, this.versionLabel}, 2);
        this.duplicateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateButton.AccessibleContext.accessibleDescription"));
        this.productCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.productCombo.AccessibleContext.accessibleDescription"));
        this.componentCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.componentCombo.AccessibleContext.accessibleDescription"));
        this.versionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.versionCombo.AccessibleContext.accessibleDescription"));
        this.platformCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.platformCombo.AccessibleContext.accessibleDescription"));
        this.statusCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.statusCombo.AccessibleContext.accessibleDescription"));
        this.resolutionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.resolutionCombo.AccessibleContext.accessibleDescription"));
        this.priorityCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.priorityCombo.AccessibleContext.accessibleDescription"));
        this.severityCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.severityCombo.AccessibleContext.accessibleDescription"));
        this.targetMilestoneCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.targetMilestoneCombo.AccessibleContext.accessibleDescription"));
        this.urlField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.urlField.AccessibleContext.accessibleDescription"));
        this.keywordsField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsField.AccessibleContext.accessibleDescription"));
        this.reportedField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reportedField.AccessibleContext.accessibleDescription"));
        this.modifiedField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.modifiedField.AccessibleContext.accessibleDescription"));
        this.assignedField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.assignedField.AccessibleContext.accessibleDescription"));
        this.qaContactField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.qaContactField.AccessibleContext.accessibleDescription"));
        this.ccField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.ccField.AccessibleContext.accessibleDescription"));
        this.dependsField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsField.AccessibleContext.accessibleDescription"));
        this.blocksField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksField.AccessibleContext.accessibleDescription"));
        this.submitButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.submitButton.AccessibleContext.accessibleDescription"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.cancelButton.AccessibleContext.accessibleDescription"));
        this.refreshButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.refreshButton.AccessibleContext.accessibleDescription"));
        this.duplicateField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateField.AccessibleContext.accessibleDescription"));
        this.keywordsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsButton.AccessibleContext.accessibleDescription"));
        this.blocksButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksButton.AccessibleContext.accessibleDescription"));
        this.dependsOnButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsOnButton.AccessibleContext.accessibleDescription"));
        this.osCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.osCombo.AccessibleContext.accessibleDescription"));
        this.summaryField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.summaryField.AccessibleContext.accessibleDescription"));
    }

    private void productComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.productLabel);
        BugzillaRepository bugzillaRepository = this.issue.getRepository();
        BugzillaConfiguration bugzillaConfiguration = bugzillaRepository.getConfiguration();
        if (bugzillaConfiguration == null || !bugzillaConfiguration.isValid()) {
            return;
        }
        String string = this.productCombo.getSelectedItem().toString();
        Object object = this.componentCombo.getSelectedItem();
        Object object2 = this.versionCombo.getSelectedItem();
        Object object3 = this.targetMilestoneCombo.getSelectedItem();
        this.componentCombo.setModel(this.toComboModel(bugzillaConfiguration.getComponents(string)));
        this.versionCombo.setModel(this.toComboModel(bugzillaConfiguration.getVersions(string)));
        List<String> list = bugzillaConfiguration.getTargetMilestones(string);
        this.usingTargetMilestones = list.size() != 0;
        this.targetMilestoneCombo.setModel(this.toComboModel(list));
        boolean bl = this.issue.getTaskData().isNew();
        this.selectInCombo(this.componentCombo, object, !bl);
        this.selectInCombo(this.versionCombo, object2, !bl);
        if (this.usingTargetMilestones) {
            this.selectInCombo(this.targetMilestoneCombo, object3, !bl);
        }
        this.targetMilestoneLabel.setVisible(this.usingTargetMilestones);
        this.targetMilestoneCombo.setVisible(this.usingTargetMilestones);
        this.milestoneWarning.setVisible(this.usingTargetMilestones);
        TaskData taskData = this.issue.getTaskData();
        if (taskData.isNew()) {
            String string2 = this.summaryField.getText();
            this.issue.setFieldValue(BugzillaIssue.IssueField.PRODUCT, string);
            BugzillaRepositoryConnector bugzillaRepositoryConnector = Bugzilla.getInstance().getRepositoryConnector();
            try {
                bugzillaRepositoryConnector.getTaskDataHandler().initializeTaskData(this.issue.getRepository().getTaskRepository(), taskData, bugzillaRepositoryConnector.getTaskMapping(taskData), (IProgressMonitor)new NullProgressMonitor());
                this.reloadForm(false);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            this.summaryField.setText(string2);
        }
    }

    private void statusComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.statusLabel);
        this.cancelHighlight(this.resolutionLabel);
        String string = this.initialValues.get((Object)BugzillaIssue.IssueField.STATUS);
        boolean bl = "RESOLVED".equals(string);
        if (!bl) {
            if ("RESOLVED".equals(this.statusCombo.getSelectedItem())) {
                if (this.resolutionCombo.getParent() == null) {
                    ((GroupLayout)this.getLayout()).replace((Component)this.resolutionField, (Component)this.resolutionCombo);
                }
                this.resolutionCombo.setSelectedItem("FIXED");
                this.resolutionCombo.setVisible(true);
            } else {
                this.resolutionCombo.setVisible(false);
                this.duplicateLabel.setVisible(false);
                this.duplicateField.setVisible(false);
                this.duplicateButton.setVisible(false);
            }
        }
        if (!this.resolutionField.getText().trim().equals("")) {
            if (this.statusCombo.getSelectedIndex() >= this.resolvedIndex) {
                if (this.resolutionField.getParent() == null) {
                    ((GroupLayout)this.getLayout()).replace((Component)this.resolutionCombo, (Component)this.resolutionField);
                }
                this.resolutionField.setVisible(true);
            } else {
                this.resolutionField.setVisible(false);
            }
            this.duplicateLabel.setVisible(false);
            this.duplicateField.setVisible(false);
            this.duplicateButton.setVisible(false);
        }
        this.resolutionLabel.setLabelFor(this.resolutionCombo.isVisible() ? this.resolutionCombo : this.resolutionField);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.reloadForm(true);
    }

    private void submitButtonActionPerformed(ActionEvent actionEvent) {
        BugzillaRepository bugzillaRepository;
        String string;
        String string2;
        boolean bl = this.issue.getTaskData().isNew();
        if (bl) {
            this.storeFieldValue(BugzillaIssue.IssueField.DESCRIPTION, this.addCommentArea);
        }
        this.storeFieldValue(BugzillaIssue.IssueField.SUMMARY, this.summaryField);
        this.storeFieldValue(BugzillaIssue.IssueField.PRODUCT, this.productCombo);
        this.storeFieldValue(BugzillaIssue.IssueField.COMPONENT, this.componentCombo);
        this.storeFieldValue(BugzillaIssue.IssueField.VERSION, this.versionCombo);
        this.storeFieldValue(BugzillaIssue.IssueField.PLATFORM, this.platformCombo);
        this.storeFieldValue(BugzillaIssue.IssueField.OS, this.osCombo);
        this.storeFieldValue(BugzillaIssue.IssueField.STATUS, this.statusCombo);
        if (this.resolutionCombo.isVisible()) {
            this.storeFieldValue(BugzillaIssue.IssueField.RESOLUTION, this.resolutionCombo);
        } else if (!this.resolutionField.isVisible()) {
            this.storeFieldValue(BugzillaIssue.IssueField.RESOLUTION, "");
        }
        if (this.duplicateField.isVisible() && this.duplicateField.isEditable()) {
            this.issue.duplicate(this.duplicateField.getText());
        }
        this.storeFieldValue(BugzillaIssue.IssueField.PRIORITY, this.priorityCombo);
        this.storeFieldValue(BugzillaIssue.IssueField.SEVERITY, this.severityCombo);
        if (this.usingTargetMilestones) {
            this.storeFieldValue(BugzillaIssue.IssueField.MILESTONE, this.targetMilestoneCombo);
        }
        this.storeFieldValue(BugzillaIssue.IssueField.URL, this.urlField);
        this.storeFieldValue(BugzillaIssue.IssueField.KEYWORDS, this.keywordsField);
        this.storeFieldValue(BugzillaIssue.IssueField.ASSIGNED_TO, this.assignedField);
        this.storeFieldValue(BugzillaIssue.IssueField.QA_CONTACT, this.qaContactField);
        this.storeCCValue();
        this.storeFieldValue(BugzillaIssue.IssueField.DEPENDS_ON, this.dependsField);
        this.storeFieldValue(BugzillaIssue.IssueField.BLOCKS, this.blocksField);
        if (!bl && !"".equals(this.addCommentArea.getText().trim())) {
            this.issue.addComment(this.addCommentArea.getText());
        }
        if (bl) {
            string2 = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.submitNewMessage");
        } else {
            string = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.submitMessage");
            string2 = MessageFormat.format(string, this.issue.getID());
        }
        string = ProgressHandleFactory.createHandle((String)string2);
        string.start();
        string.switchToIndeterminate();
        this.skipReload = true;
        this.enableComponents(false);
        RequestProcessor.getDefault().post(new Runnable((ProgressHandle)string){
            final /* synthetic */ ProgressHandle val$handle;
            {
                this.val$handle = progressHandle;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean bl = false;
                try {
                    bl = IssuePanel.this.issue.submitAndRefresh();
                    for (AttachmentsPanel.AttachmentInfo attachmentInfo : IssuePanel.this.attachmentsPanel.getNewAttachments()) {
                        if (!attachmentInfo.file.exists()) continue;
                        if (attachmentInfo.description.trim().length() == 0) {
                            attachmentInfo.description = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.attachment.noDescription");
                        }
                        IssuePanel.this.issue.addAttachment(attachmentInfo.file, null, attachmentInfo.description, attachmentInfo.contentType, attachmentInfo.isPatch);
                    }
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            IssuePanel.this.enableComponents(true);
                            IssuePanel.this.skipReload = false;
                        }
                    });
                    this.val$handle.finish();
                    if (bl) {
                        IssuePanel.this.reloadFormInAWT(true);
                    }
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                this.val$handle.finish();
                if (bl) {
                    IssuePanel.this.reloadFormInAWT(true);
                }
            }
        });
        if (bl && (bugzillaRepository = this.issue.getRepository()) != null) {
            BugtrackingOwnerSupport.getInstance().setLooseAssociation(BugtrackingOwnerSupport.ContextType.SELECTED_FILE_AND_ALL_PROJECTS, (Repository)bugzillaRepository);
        }
    }

    private void storeCCValue() {
        Set<String> set = this.ccs(this.issue.getFieldValue(BugzillaIssue.IssueField.CC));
        Set<String> set2 = this.ccs(this.ccField.getText());
        String string = this.getMissingCCs(set, set2);
        String string2 = this.getMissingCCs(set2, set);
        this.storeFieldValue(BugzillaIssue.IssueField.REMOVECC, string);
        this.storeFieldValue(BugzillaIssue.IssueField.NEWCC, string2);
    }

    private Set<String> ccs(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\n\r\f");
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    private String getMissingCCs(Set<String> set, Set<String> set2) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.trim().equals("") || set2.contains(string)) continue;
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    private void refreshButtonActionPerformed(ActionEvent actionEvent) {
        String string = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.refreshMessage");
        String string2 = MessageFormat.format(string, this.issue.getID());
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string2);
        progressHandle.start();
        progressHandle.switchToIndeterminate();
        this.skipReload = true;
        this.enableComponents(false);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    IssuePanel.this.issue.refresh();
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            IssuePanel.this.enableComponents(true);
                            IssuePanel.this.skipReload = false;
                        }
                    });
                    progressHandle.finish();
                    IssuePanel.this.reloadFormInAWT(true);
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                progressHandle.finish();
                IssuePanel.this.reloadFormInAWT(true);
            }
        });
    }

    private void resolutionComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.resolutionLabel);
        if (this.resolutionCombo.getParent() == null) {
            return;
        }
        boolean bl = "DUPLICATE".equals(this.resolutionCombo.getSelectedItem());
        this.duplicateLabel.setVisible(bl);
        this.duplicateField.setVisible(bl);
        this.duplicateButton.setVisible(bl && this.duplicateField.isEditable());
    }

    private void keywordsButtonActionPerformed(ActionEvent actionEvent) {
        String string = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsButton.message");
        String string2 = BugzillaUtil.getKeywords(string, this.keywordsField.getText(), this.issue.getRepository());
        this.keywordsField.setText(string2);
    }

    private void blocksButtonActionPerformed(ActionEvent actionEvent) {
        Issue issue = BugtrackingUtil.selectIssue((String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksButton.message"), (Repository)this.issue.getRepository(), (JPanel)this);
        if (issue != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.blocksField.getText().trim().equals("")) {
                stringBuilder.append(this.blocksField.getText()).append(',').append(' ');
            }
            stringBuilder.append(issue.getID());
            this.blocksField.setText(stringBuilder.toString());
        }
    }

    private void dependsOnButtonActionPerformed(ActionEvent actionEvent) {
        Issue issue = BugtrackingUtil.selectIssue((String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsOnButton.message"), (Repository)this.issue.getRepository(), (JPanel)this);
        if (issue != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.dependsField.getText().trim().equals("")) {
                stringBuilder.append(this.dependsField.getText()).append(',').append(' ');
            }
            stringBuilder.append(issue.getID());
            this.dependsField.setText(stringBuilder.toString());
        }
    }

    private void componentComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.componentLabel);
    }

    private void versionComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.versionLabel);
    }

    private void platformComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.platformLabel);
    }

    private void priorityComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.priorityLabel);
    }

    private void severityComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.severityLabel);
    }

    private void targetMilestoneComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.targetMilestoneLabel);
    }

    private void osComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.osLabel);
    }

    private void reloadButtonActionPerformed(ActionEvent actionEvent) {
        String string = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reloadMessage");
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string);
        progressHandle.start();
        progressHandle.switchToIndeterminate();
        this.skipReload = true;
        this.enableComponents(false);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                IssuePanel.this.issue.getRepository().refreshConfiguration();
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            IssuePanel.this.reloading = true;
                            Object object = IssuePanel.this.productCombo.getSelectedItem();
                            Object object2 = IssuePanel.this.platformCombo.getSelectedItem();
                            Object object3 = IssuePanel.this.osCombo.getSelectedItem();
                            Object object4 = IssuePanel.this.priorityCombo.getSelectedItem();
                            Object object5 = IssuePanel.this.severityCombo.getSelectedItem();
                            Object object6 = IssuePanel.this.resolutionCombo.getSelectedItem();
                            IssuePanel.this.initCombos();
                            IssuePanel.this.selectInCombo(IssuePanel.this.productCombo, object, false);
                            IssuePanel.this.selectInCombo(IssuePanel.this.platformCombo, object2, false);
                            IssuePanel.this.selectInCombo(IssuePanel.this.osCombo, object3, false);
                            IssuePanel.this.selectInCombo(IssuePanel.this.priorityCombo, object4, false);
                            IssuePanel.this.selectInCombo(IssuePanel.this.severityCombo, object5, false);
                            IssuePanel.this.initStatusCombo(IssuePanel.this.statusCombo.getSelectedItem().toString());
                            IssuePanel.this.selectInCombo(IssuePanel.this.resolutionCombo, object6, false);
                        }
                        finally {
                            IssuePanel.this.reloading = false;
                            IssuePanel.this.enableComponents(true);
                            IssuePanel.this.skipReload = false;
                        }
                    }
                });
                progressHandle.finish();
            }
        });
    }

    private void duplicateButtonActionPerformed(ActionEvent actionEvent) {
        Issue issue = BugtrackingUtil.selectIssue((String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateButton.message"), (Repository)this.issue.getRepository(), (JPanel)this);
        if (issue != null) {
            this.duplicateField.setText(issue.getID());
        }
    }

    class RevalidatingListener
    implements DocumentListener,
    Runnable {
        private boolean ignoreUpdate;

        RevalidatingListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.ignoreUpdate) {
                return;
            }
            this.ignoreUpdate = true;
            EventQueue.invokeLater(this);
        }

        public void run() {
            IssuePanel.this.revalidate();
            IssuePanel.this.repaint();
            this.ignoreUpdate = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CyclicDependencyDocumentListener
    implements DocumentListener {
        CyclicDependencyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            Set<Integer> set = this.bugs(IssuePanel.this.blocksField.getText());
            Set<Integer> set2 = this.bugs(IssuePanel.this.dependsField.getText());
            set.retainAll(set2);
            if (set.isEmpty()) {
                if (IssuePanel.this.cyclicDependency) {
                    IssuePanel.this.cyclicDependency = false;
                    IssuePanel.this.updateMessagePanel();
                }
            } else if (!IssuePanel.this.cyclicDependency) {
                IssuePanel.this.cyclicDependency = true;
                IssuePanel.this.updateMessagePanel();
            }
        }

        private Set<Integer> bugs(String string) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\n\r\f");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    hashSet.add(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return hashSet;
        }
    }

    class CancelHighlightDocumentListener
    implements DocumentListener {
        private JLabel label;

        CancelHighlightDocumentListener(JLabel jLabel) {
            this.label = jLabel;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            IssuePanel.this.cancelHighlight(this.label);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            IssuePanel.this.cancelHighlight(this.label);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            IssuePanel.this.cancelHighlight(this.label);
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == IssuePanel.this.duplicateButton) {
                IssuePanel.this.duplicateButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.productCombo) {
                IssuePanel.this.productComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.componentCombo) {
                IssuePanel.this.componentComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.versionCombo) {
                IssuePanel.this.versionComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.platformCombo) {
                IssuePanel.this.platformComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.statusCombo) {
                IssuePanel.this.statusComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.resolutionCombo) {
                IssuePanel.this.resolutionComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.priorityCombo) {
                IssuePanel.this.priorityComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.severityCombo) {
                IssuePanel.this.severityComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.targetMilestoneCombo) {
                IssuePanel.this.targetMilestoneComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.submitButton) {
                IssuePanel.this.submitButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.cancelButton) {
                IssuePanel.this.cancelButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.refreshButton) {
                IssuePanel.this.refreshButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.keywordsButton) {
                IssuePanel.this.keywordsButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.blocksButton) {
                IssuePanel.this.blocksButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.dependsOnButton) {
                IssuePanel.this.dependsOnButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.osCombo) {
                IssuePanel.this.osComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.reloadButton) {
                IssuePanel.this.reloadButtonActionPerformed(actionEvent);
            }
        }
    }
}

