/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugtracking.util.StackTraceSupport;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.BugzillaIssueFinder;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CommentsPanel
extends JPanel {
    private static final DateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final String ISSUE_ATTRIBUTE = "issue";
    private static final String REPLY_TO_PROPERTY = "replyTo";
    private static final String QUOTE_PREFIX = "> ";
    private final BugzillaIssueFinder issueFinder;
    private BugzillaIssue issue;
    private MouseAdapter listener;
    private NewCommentHandler newCommentHandler;
    private ActionListener replyListener;

    public CommentsPanel() {
        this.setBackground(UIManager.getColor("EditorPane.background"));
        this.listener = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    JTextPane jTextPane;
                    StyledDocument styledDocument;
                    Element element;
                    AttributeSet attributeSet;
                    IssueAction issueAction;
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && (issueAction = (IssueAction)(attributeSet = (element = (styledDocument = (jTextPane = (JTextPane)mouseEvent.getSource()).getStyledDocument()).getCharacterElement(jTextPane.viewToModel(mouseEvent.getPoint()))).getAttributes()).getAttribute(CommentsPanel.ISSUE_ATTRIBUTE)) != null) {
                        int n = element.getStartOffset();
                        int n2 = element.getEndOffset();
                        int n3 = n2 - n;
                        String string = styledDocument.getText(n, n3);
                        issueAction.openIssue(string);
                    }
                }
                catch (Exception exception) {
                    Bugzilla.LOG.log(Level.SEVERE, null, exception);
                }
            }
        };
        this.issueFinder = (BugzillaIssueFinder)((Object)Lookup.getDefault().lookup(BugzillaIssueFinder.class));
        assert (this.issueFinder != null);
    }

    public void setIssue(BugzillaIssue bugzillaIssue) {
        this.removeAll();
        this.issue = bugzillaIssue;
        GroupLayout groupLayout = new GroupLayout((Container)this);
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(1);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)parallelGroup).addContainerGap());
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        sequentialGroup.addContainerGap();
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)sequentialGroup));
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
        String string = bugzillaIssue.getFieldValue(BugzillaIssue.IssueField.CREATION);
        try {
            BugzillaIssue.Comment[] commentArray = dateTimeFormat.parse(string);
            string = dateFormat.format((Date)commentArray);
        }
        catch (ParseException parseException) {
            Bugzilla.LOG.log(Level.INFO, null, parseException);
        }
        this.addSection(groupLayout, bugzillaIssue.getFieldValue(BugzillaIssue.IssueField.DESCRIPTION), bugzillaIssue.getFieldValue(BugzillaIssue.IssueField.REPORTER_NAME), string, parallelGroup, sequentialGroup, true);
        for (BugzillaIssue.Comment comment : bugzillaIssue.getComments()) {
            String string2 = dateFormat.format(comment.getWhen());
            this.addSection(groupLayout, comment.getText(), comment.getWho(), string2, parallelGroup, sequentialGroup, false);
        }
        sequentialGroup.addContainerGap();
        this.setLayout((LayoutManager)groupLayout);
    }

    public void setNewCommentHandler(NewCommentHandler newCommentHandler) {
        this.newCommentHandler = newCommentHandler;
    }

    private void addSection(GroupLayout groupLayout, String string, String string2, String string3, GroupLayout.ParallelGroup parallelGroup, GroupLayout.SequentialGroup sequentialGroup, boolean bl) {
        String string4;
        Object object;
        JTextPane jTextPane = new JTextPane();
        JLabel jLabel = new JLabel();
        ResourceBundle resourceBundle = NbBundle.getBundle(CommentsPanel.class);
        if (bl) {
            object = resourceBundle.getString("CommentsPanel.leftLabel.format");
            string4 = MessageFormat.format((String)object, this.issue.getSummary());
        } else {
            string4 = resourceBundle.getString("CommentsPanel.leftLabel.text");
        }
        jLabel.setText(string4);
        object = new JLabel();
        String string5 = resourceBundle.getString("CommentsPanel.rightLabel.format");
        String string6 = MessageFormat.format(string5, string3, string2);
        ((JLabel)object).setText(string6);
        ((JLabel)object).setLabelFor(jTextPane);
        LinkButton linkButton = new LinkButton(resourceBundle.getString("Comments.replyButton.text"));
        linkButton.addActionListener(this.getReplyListener());
        linkButton.putClientProperty((Object)REPLY_TO_PROPERTY, (Object)jTextPane);
        linkButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommentsPanel.class, (String)"CommentsPanel.replyButton.AccessibleContext.accessibleDescription"));
        this.setupTextPane(jTextPane, string);
        parallelGroup.add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jLabel, -2, -1, -2).addPreferredGap(0).add((Component)linkButton).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)object)).add((Component)jTextPane, -1, -1, Short.MAX_VALUE);
        if (!bl) {
            sequentialGroup.addPreferredGap(1);
        }
        sequentialGroup.add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel).add((Component)linkButton).add((Component)object)).addPreferredGap(0).add((Component)jTextPane, -2, -1, -2);
    }

    private void setupTextPane(JTextPane jTextPane, String string) {
        StyledDocument styledDocument = jTextPane.getStyledDocument();
        Caret caret = jTextPane.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(1);
        }
        jTextPane.setText(string);
        StackTraceSupport.addHyperlinks((JTextPane)jTextPane);
        int[] nArray = this.issueFinder.getIssueSpans(string);
        if (nArray.length > 0) {
            Style style = StyleContext.getDefaultStyleContext().getStyle("default");
            Style style2 = styledDocument.addStyle("bugBlue", style);
            style2.addAttribute(ISSUE_ATTRIBUTE, new IssueAction());
            StyleConstants.setForeground(style2, Color.BLUE);
            StyleConstants.setUnderline(style2, true);
            for (int i = 0; i < nArray.length; i += 2) {
                int n = nArray[i];
                int n2 = nArray[i + 1] - nArray[i];
                try {
                    styledDocument.remove(n, n2);
                    styledDocument.insertString(n, string.substring(nArray[i], nArray[i + 1]), style2);
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
        jTextPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("Label.foreground")), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        jTextPane.setEditable(false);
        jTextPane.addMouseListener(this.listener);
        jTextPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommentsPanel.class, (String)"CommentsPanel.textPane.AccessibleContext.accessibleName"));
        jTextPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommentsPanel.class, (String)"CommentsPanel.textPane.AccessibleContext.accessibleDescription"));
    }

    private ActionListener getReplyListener() {
        if (this.replyListener == null) {
            this.replyListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JComponent jComponent;
                    Object object;
                    Object object2 = actionEvent.getSource();
                    if (object2 instanceof JComponent && (object = (jComponent = (JComponent)object2).getClientProperty(CommentsPanel.REPLY_TO_PROPERTY)) instanceof JTextPane) {
                        JTextPane jTextPane = (JTextPane)object;
                        String string = jTextPane.getText();
                        StringBuilder stringBuilder = new StringBuilder();
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                        while (stringTokenizer.hasMoreElements()) {
                            String string2 = stringTokenizer.nextToken();
                            stringBuilder.append(CommentsPanel.QUOTE_PREFIX).append(string2).append('\n');
                        }
                        CommentsPanel.this.newCommentHandler.append(stringBuilder.toString());
                    }
                }
            };
        }
        return this.replyListener;
    }

    public static interface NewCommentHandler {
        public void append(String var1);
    }

    private class IssueAction {
        private IssueAction() {
        }

        void openIssue(String string) {
            final String string2 = CommentsPanel.this.issueFinder.getIssueId(string);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    Issue issue = CommentsPanel.this.issue.getRepository().getIssue(string2);
                    if (issue != null) {
                        issue.open();
                    }
                }
            });
        }
    }
}

