/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import org.netbeans.modules.bugtracking.spi.IssueFinder;

public class BugzillaIssueFinder
extends IssueFinder {
    private static final int[] EMPTY_INT_ARR = new int[0];

    public int[] getIssueSpans(String string) {
        int[] nArray = BugzillaIssueFinder.findBoundaries(string);
        return nArray != null ? nArray : EMPTY_INT_ARR;
    }

    public String getIssueId(String string) {
        int n;
        for (n = string.length() - 1; n >= 0 && Impl.isDigit(string.charAt(n)); --n) {
        }
        return string.substring(n + 1);
    }

    private static int[] findBoundaries(String string) {
        return BugzillaIssueFinder.getImpl().findBoundaries(string);
    }

    private static Impl getImpl() {
        return new Impl();
    }

    static BugzillaIssueFinder getTestInstance() {
        return new BugzillaIssueFinder();
    }

    private static final class Impl {
        private static final String[] BUGWORDS = new String[]{"bug", "issue", "Bug", "Issue", "BUG", "ISSUE"};
        private static final String PUNCT_CHARS = ",:;()[]{}";
        private static final int INIT = 0;
        private static final int CHARS = 1;
        private static final int HASH = 2;
        private static final int HASH_SPC = 3;
        private static final int NUM = 4;
        private static final int BUGWORD = 5;
        private static final int BUGWORD_NL = 6;
        private static final int STAR = 7;
        private static final int GARBAGE = 8;
        private String str;
        private int pos;
        private int state;
        int start;
        int end;
        int[] result;

        private Impl() {
        }

        private int[] findBoundaries(String string) {
            this.reset();
            this.str = string;
            this.pos = 0;
            while (this.pos < string.length()) {
                this.handleChar(string.charAt(this.pos));
                ++this.pos;
            }
            if (this.state == 4) {
                this.storeResult(this.start, this.pos);
            }
            return this.result;
        }

        private void reset() {
            this.str = null;
            this.pos = 0;
            this.state = 0;
            this.start = -1;
            this.end = -1;
            this.result = null;
        }

        private void handleChar(int n) {
            int n2;
            switch (this.state) {
                case 0: {
                    if (n == 35) {
                        this.rememberIsStart();
                        n2 = 2;
                        break;
                    }
                    if (Character.isLetter(n)) {
                        this.rememberIsStart();
                        n2 = 1;
                        break;
                    }
                    n2 = this.getInitialState(n);
                    break;
                }
                case 1: {
                    if (Character.isLetter(n)) {
                        n2 = 1;
                        break;
                    }
                    if (n == 32 || n == 9 || n == 13 || n == 10) {
                        if (this.isBugword()) {
                            n2 = n == 32 || n == 9 ? 5 : 6;
                            break;
                        }
                        n2 = this.getInitialState(n);
                        break;
                    }
                    n2 = this.getInitialState(n);
                    break;
                }
                case 2: {
                    if (n == 32 || n == 9) {
                        n2 = 3;
                        break;
                    }
                    if (Impl.isDigit(n)) {
                        n2 = 4;
                        break;
                    }
                    n2 = this.getInitialState(n);
                    break;
                }
                case 3: {
                    if (n == 32 || n == 9) {
                        n2 = 3;
                        break;
                    }
                    if (Impl.isDigit(n)) {
                        n2 = 4;
                        break;
                    }
                    n2 = this.getInitialState(n);
                    break;
                }
                case 4: {
                    if (Impl.isDigit(n)) {
                        n2 = 4;
                        break;
                    }
                    n2 = this.getInitialState(n);
                    break;
                }
                case 5: {
                    if (n == 32 || n == 9) {
                        n2 = 5;
                        break;
                    }
                    if (n == 13 || n == 10) {
                        n2 = 6;
                        break;
                    }
                    if (n == 35) {
                        n2 = 2;
                        break;
                    }
                    if (Impl.isDigit(n)) {
                        n2 = 4;
                        break;
                    }
                    n2 = this.getInitialState(n);
                    break;
                }
                case 6: {
                    if (n == 13 || n == 10 || n == 32 || n == 9) {
                        n2 = 6;
                        break;
                    }
                    if (n == 42) {
                        n2 = 7;
                        break;
                    }
                    if (n == 35) {
                        n2 = 2;
                        break;
                    }
                    if (Impl.isDigit(n)) {
                        n2 = 4;
                        break;
                    }
                    n2 = this.getInitialState(n);
                    break;
                }
                case 7: {
                    if (n == 32 || n == 9) {
                        n2 = 5;
                        break;
                    }
                    if (n == 13 || n == 10) {
                        n2 = 6;
                        break;
                    }
                    n2 = this.getInitialState(n);
                    break;
                }
                case 8: {
                    n2 = this.getInitialState(n);
                    break;
                }
                default: {
                    assert (false);
                    n2 = this.getInitialState(n);
                }
            }
            if (this.state == 4 && n2 != 4 && Impl.isSpaceOrPunct(n)) {
                this.storeResult(this.start, this.pos);
            }
            if (n2 == 0 || n2 == 8) {
                this.start = -1;
            }
            this.state = n2;
        }

        private int getInitialState(int n) {
            return Impl.isSpaceOrPunct(n) ? 0 : 8;
        }

        private void rememberIsStart() {
            assert (this.start == -1);
            this.start = this.pos;
        }

        private void storeResult(int n, int n2) {
            assert (n != -1);
            if (this.result == null) {
                this.result = new int[]{n, n2};
            } else {
                int[] nArray = new int[this.result.length + 2];
                System.arraycopy(this.result, 0, nArray, 0, this.result.length);
                nArray[this.result.length] = n;
                nArray[this.result.length + 1] = n2;
                this.result = nArray;
            }
        }

        private static boolean isDigit(int n) {
            return n >= 48 && n <= 57;
        }

        private static boolean isSpaceOrPunct(int n) {
            return n == 13 || n == 10 || Character.isSpaceChar(n) || Impl.isPunct(n);
        }

        private static boolean isPunct(int n) {
            return PUNCT_CHARS.indexOf(n) != -1;
        }

        private boolean isBugword() {
            String string = this.str.substring(this.start, this.pos);
            for (int i = 0; i < BUGWORDS.length; ++i) {
                if (!string.equals(BUGWORDS[i])) continue;
                return true;
            }
            return false;
        }
    }
}

