/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.openide.util.NbPreferences;

public class BugzillaConfig {
    private static BugzillaConfig instance = null;
    private static final String LAST_CHANGE_FROM = "bugzilla.last_change_from";
    private static final String REPO_NAME = "bugzilla.repository_";
    private static final String QUERY_NAME = "bugzilla.query_";
    private static final String QUERY_REFRESH_INT = "bugzilla.query_refresh";
    private static final String QUERY_AUTO_REFRESH = "bugzilla.query_auto_refresh_";
    private static final String ISSUE_REFRESH_INT = "bugzilla.issue_refresh";
    private static final String DELIMITER = "<=>";
    public static final int DEFAULT_QUERY_REFRESH = 30;
    public static final int DEFAULT_ISSUE_REFRESH = 15;

    private BugzillaConfig() {
    }

    public static BugzillaConfig getInstance() {
        if (instance == null) {
            instance = new BugzillaConfig();
        }
        return instance;
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(BugzillaConfig.class);
    }

    public void setQueryRefreshInterval(int n) {
        this.getPreferences().putInt(QUERY_REFRESH_INT, n);
    }

    public void setIssueRefreshInterval(int n) {
        this.getPreferences().putInt(ISSUE_REFRESH_INT, n);
    }

    public void setQueryAutoRefresh(String string, boolean bl) {
        this.getPreferences().putBoolean(QUERY_AUTO_REFRESH + string, bl);
    }

    public int getQueryRefreshInterval() {
        return this.getPreferences().getInt(QUERY_REFRESH_INT, 30);
    }

    public int getIssueRefreshInterval() {
        return this.getPreferences().getInt(ISSUE_REFRESH_INT, 15);
    }

    public boolean getQueryAutoRefresh(String string) {
        return this.getPreferences().getBoolean(QUERY_AUTO_REFRESH + string, false);
    }

    public void putQuery(BugzillaRepository bugzillaRepository, BugzillaQuery bugzillaQuery) {
        this.getPreferences().put(this.getQueryKey(bugzillaRepository.getDisplayName(), bugzillaQuery.getDisplayName()), bugzillaQuery.getUrlParameters() + DELIMITER + bugzillaQuery.getLastRefresh() + DELIMITER + bugzillaQuery.isUrlDefined());
    }

    public void removeQuery(BugzillaRepository bugzillaRepository, BugzillaQuery bugzillaQuery) {
        this.getPreferences().remove(this.getQueryKey(bugzillaRepository.getDisplayName(), bugzillaQuery.getDisplayName()));
    }

    public BugzillaQuery getQuery(BugzillaRepository bugzillaRepository, String string) {
        String string2 = this.getStoredQuery(bugzillaRepository, string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split(DELIMITER);
        assert (stringArray.length >= 2);
        String string3 = stringArray[0];
        long l = Long.parseLong(stringArray[1]);
        boolean bl = stringArray.length > 2 ? Boolean.parseBoolean(stringArray[2]) : false;
        return new BugzillaQuery(string, bugzillaRepository, string3, l, bl);
    }

    public String getUrlParams(BugzillaRepository bugzillaRepository, String string) {
        String string2 = this.getStoredQuery(bugzillaRepository, string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split(DELIMITER);
        assert (stringArray.length >= 2);
        return stringArray[0];
    }

    public String[] getQueries(String string) {
        return this.getKeysWithPrefix(QUERY_NAME + string + DELIMITER);
    }

    public void putRepository(String string, BugzillaRepository bugzillaRepository) {
        String string2 = bugzillaRepository.getUsername();
        String string3 = BugtrackingUtil.scramble((String)bugzillaRepository.getPassword());
        String string4 = bugzillaRepository.getHttpUsername();
        String string5 = BugtrackingUtil.scramble((String)bugzillaRepository.getHttpPassword());
        String string6 = bugzillaRepository.getUrl();
        String string7 = Boolean.toString(bugzillaRepository.isShortUsernamesEnabled());
        this.getPreferences().put(REPO_NAME + string, string6 + DELIMITER + string2 + DELIMITER + string3 + DELIMITER + string4 + DELIMITER + string5 + DELIMITER + string7);
    }

    public BugzillaRepository getRepository(String string) {
        String string2 = this.getPreferences().get(REPO_NAME + string, "");
        if (string2.equals("")) {
            return null;
        }
        String[] stringArray = string2.split(DELIMITER);
        assert (stringArray.length == 3 || stringArray.length == 5 || stringArray.length == 6);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = BugtrackingUtil.descramble((String)stringArray[2]);
        String string6 = stringArray.length > 3 ? stringArray[3] : null;
        String string7 = stringArray.length > 3 ? BugtrackingUtil.descramble((String)stringArray[4]) : null;
        boolean bl = false;
        if (stringArray.length > 5) {
            bl = Boolean.parseBoolean(stringArray[5]);
        }
        return new BugzillaRepository(string, string3, string4, string5, string6, string7, bl);
    }

    public String[] getRepositories() {
        return this.getKeysWithPrefix(REPO_NAME);
    }

    public void removeRepository(String string) {
        this.getPreferences().remove(REPO_NAME + string);
    }

    private String[] getKeysWithPrefix(String string) {
        String[] stringArray = null;
        try {
            stringArray = this.getPreferences().keys();
        }
        catch (BackingStoreException backingStoreException) {
            Bugzilla.LOG.log(Level.SEVERE, null, backingStoreException);
        }
        if (stringArray == null || stringArray.length == 0) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2.substring(string.length()));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getQueryKey(String string, String string2) {
        return QUERY_NAME + string + DELIMITER + string2;
    }

    private String getStoredQuery(BugzillaRepository bugzillaRepository, String string) {
        String string2 = this.getPreferences().get(this.getQueryKey(bugzillaRepository.getDisplayName(), string), null);
        return string2;
    }

    public void setLastChangeFrom(String string) {
        this.getPreferences().put(LAST_CHANGE_FROM, string);
    }

    public String getLastChangeFrom() {
        return this.getPreferences().get(LAST_CHANGE_FROM, "");
    }
}

