/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui.preview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.css.visual.api.CssRuleContext;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewGenerator;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewPanel;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class CssPreviewTopComponent
extends TopComponent {
    private static CssPreviewTopComponent instance;
    private static final Logger LOGGER;
    static final String ICON_PATH = "org/netbeans/modules/css/resources/style_sheet_16.png";
    private static final String PREFERRED_ID = "CssPreviewTC";
    CssPreviewPanel previewPanel = new CssPreviewPanel();
    private CssPreviewable lastSelectedPreviewable;
    private static final String DEFAULT_TC_NAME;
    private JPanel NO_PREVIEW_PANEL;
    private JPanel PREVIEW_ERROR_PANEL;
    private boolean previewing;
    private boolean error;
    private SAXParser parser = null;

    public void activate(final CssRuleContext cssRuleContext) {
        LOGGER.log(Level.FINE, "Previewable activated - POSTING activate task " + cssRuleContext);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CssPreviewTopComponent.this.preview(cssRuleContext);
                LOGGER.log(Level.FINE, "Previewable activated - " + cssRuleContext);
            }
        });
    }

    public void deactivate() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CssPreviewTopComponent.this.setNoSelectedRule();
                LOGGER.log(Level.FINE, "Preview deactivated");
            }
        });
    }

    private CssPreviewTopComponent() {
        this.initComponents();
        this.setToolTipText(NbBundle.getMessage(CssPreviewTopComponent.class, (String)"HINT_CssPreviewTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.NO_PREVIEW_PANEL = this.makeMsgPanel(NbBundle.getBundle((String)"org/netbeans/modules/css/visual/ui/preview/Bundle").getString("No_Preview"));
        this.add(this.NO_PREVIEW_PANEL, "Center");
        this.previewing = false;
        this.error = false;
        this.PREVIEW_ERROR_PANEL = this.makeMsgPanel(NbBundle.getBundle((String)"org/netbeans/modules/css/visual/ui/preview/Bundle").getString("Preview_Error"));
        this.setName(DEFAULT_TC_NAME);
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            this.parser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Exceptions.printStackTrace((Throwable)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Exceptions.printStackTrace((Throwable)sAXException);
        }
    }

    private JPanel makeMsgPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.WHITE);
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(string);
        jPanel.add((Component)jLabel, "Center");
        jLabel.setHorizontalAlignment(0);
        return jPanel;
    }

    private void setNoSelectedRule() {
        if (this.previewing || this.error) {
            this.setName(DEFAULT_TC_NAME);
            LOGGER.log(Level.FINE, "Previewable deactivated");
            this.removeAll();
            this.add(this.NO_PREVIEW_PANEL, "Center");
            this.previewing = false;
            this.error = false;
            this.revalidate();
            this.repaint();
        }
    }

    void setError() {
        if (!this.error) {
            this.setName(DEFAULT_TC_NAME);
            LOGGER.log(Level.FINE, "Previewable error occured.");
            this.removeAll();
            this.add(this.PREVIEW_ERROR_PANEL, "Center");
            this.previewing = false;
            this.error = true;
            this.revalidate();
            this.repaint();
        }
    }

    private void setPreviewing(String string) {
        this.setName(string);
        this.removeAll();
        this.add(this.previewPanel, "Center");
        this.previewing = true;
        this.error = false;
        this.revalidate();
        this.repaint();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized CssPreviewTopComponent getDefault() {
        if (instance == null) {
            instance = new CssPreviewTopComponent();
        }
        return instance;
    }

    public static synchronized CssPreviewTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(CssPreviewTopComponent.class.getName()).warning("Cannot find CssPreviewTC component. It will not be located properly in the window system.");
            return CssPreviewTopComponent.getDefault();
        }
        if (topComponent instanceof CssPreviewTopComponent) {
            return (CssPreviewTopComponent)topComponent;
        }
        Logger.getLogger(CssPreviewTopComponent.class.getName()).warning("There seem to be multiple components with the 'CssPreviewTC' ID. That is a potential source of errors and unexpected behavior.");
        return CssPreviewTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    private String getTitle(CssRuleContext cssRuleContext) {
        if (cssRuleContext != null && cssRuleContext.selectedRuleContent() != null) {
            return cssRuleContext.selectedRuleContent().rule().name() + " - " + DEFAULT_TC_NAME;
        }
        return DEFAULT_TC_NAME;
    }

    private void preview(CssRuleContext cssRuleContext) {
        Object object;
        assert (SwingUtilities.isEventDispatchThread()) : "Must be run in event dispatch thread!";
        CharSequence charSequence = CssPreviewGenerator.getPreviewCode(cssRuleContext);
        if (this.parser != null) {
            try {
                object = new DefaultHandler();
                this.parser.parse((InputStream)new ByteArrayInputStream(((Object)charSequence).toString().getBytes()), (DefaultHandler)object);
            }
            catch (SAXException sAXException) {
                LOGGER.log(Level.INFO, "There is an error in the generated sample document.", sAXException);
                LOGGER.log(Level.INFO, "Errorneous preview sample code:\n---------------------------------\n" + charSequence);
                this.setError();
                return;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
            }
        }
        this.setPreviewing(this.getTitle(cssRuleContext));
        try {
            object = null;
            File file = cssRuleContext.base();
            if (file != null) {
                object = file.toURL().toExternalForm();
            }
            LOGGER.log(Level.FINE, "preview - setting content " + charSequence);
            this.previewPanel.panel().setDocument((InputStream)new ByteArrayInputStream(((Object)charSequence).toString().getBytes()), (String)object);
        }
        catch (Throwable throwable) {
            this.setError();
            LOGGER.log(Level.INFO, "An error occured in the preview component.", throwable);
            LOGGER.log(Level.INFO, "Errorneous preview sample code:\n---------------------------------\n" + charSequence);
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static {
        LOGGER = Logger.getLogger("css.visual");
        DEFAULT_TC_NAME = NbBundle.getMessage(CssPreviewTopComponent.class, (String)"CTL_CssPreviewTopComponent");
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return CssPreviewTopComponent.getDefault();
        }
    }
}

