/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.css.editor.model.CssRuleContent;
import org.netbeans.modules.css.visual.api.CssRuleContext;

public abstract class StyleEditor
extends JPanel {
    private PropertyChangeSupport cssPropertyChangeSupport;
    CssPropertyChangeListener cssPropertyChangeListener = new CssPropertyChangeListener();
    boolean listenerAdded = false;
    private CssRuleContext content;
    private String displayName;
    private Icon icon;

    public void setContent(CssRuleContext cssRuleContext) {
        this.content = cssRuleContext;
        this.setCssPropertyValues(cssRuleContext.selectedRuleContent());
    }

    protected CssRuleContext content() {
        return this.content;
    }

    protected abstract void setCssPropertyValues(CssRuleContent var1);

    PropertyChangeSupport cssPropertyChangeSupport() {
        if (this.cssPropertyChangeSupport == null) {
            this.cssPropertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.cssPropertyChangeSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCssPropertyChangeListener(CssRuleContent cssRuleContent) {
        Class<StyleEditor> clazz = StyleEditor.class;
        synchronized (StyleEditor.class) {
            if (!this.listenerAdded) {
                this.listenerAdded = true;
                this.cssPropertyChangeListener.setCssStyleData(cssRuleContent);
                this.cssPropertyChangeSupport().addPropertyChangeListener(this.cssPropertyChangeListener);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCssPropertyChangeListener() {
        Class<StyleEditor> clazz = StyleEditor.class;
        synchronized (StyleEditor.class) {
            if (this.listenerAdded) {
                this.listenerAdded = false;
                this.cssPropertyChangeSupport().removePropertyChangeListener(this.cssPropertyChangeListener);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    static class CssPropertyChangeListener
    implements PropertyChangeListener {
        CssRuleContent cssStyleData;

        public CssPropertyChangeListener() {
        }

        public CssPropertyChangeListener(CssRuleContent cssRuleContent) {
            this.cssStyleData = cssRuleContent;
        }

        public void setCssStyleData(CssRuleContent cssRuleContent) {
            this.cssStyleData = cssRuleContent;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            try {
                this.cssStyleData.modifyProperty(propertyChangeEvent.getPropertyName(), (String)propertyChangeEvent.getNewValue());
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger("global").log(Level.WARNING, "CssModel inconsistency!", badLocationException);
            }
        }
    }
}

