/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.dataprovider.DataModelScheme;
import org.netbeans.modules.dlight.spi.dataprovider.DataProvider;
import org.netbeans.modules.dlight.spi.dataprovider.DataProviderFactory;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerDataProvider;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerDataProviderFactory;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.util.Lookup;

public final class DataProvidersManager {
    private static DataProvidersManager instance = null;
    private Collection<? extends VisualizerDataProviderFactory> allVisualizerDataProviders = Lookup.getDefault().lookupAll(VisualizerDataProviderFactory.class);
    private Collection<VisualizerDataProvider> activeVisualizerDataProviders = new ArrayList<VisualizerDataProvider>();
    private static final Logger log = DLightLogger.getLogger(DataProvidersManager.class);

    private DataProvidersManager() {
        log.fine(this.allVisualizerDataProviders.size() + " data provider(s) found!");
    }

    public static DataProvidersManager getInstance() {
        if (instance == null) {
            instance = new DataProvidersManager();
        }
        return instance;
    }

    public VisualizerDataProvider getDataProviderFor(DataModelScheme dataModelScheme) {
        for (VisualizerDataProviderFactory visualizerDataProviderFactory : this.allVisualizerDataProviders) {
            if (!visualizerDataProviderFactory.provides(dataModelScheme)) continue;
            VisualizerDataProvider visualizerDataProvider = visualizerDataProviderFactory.create();
            this.activeVisualizerDataProviders.add(visualizerDataProvider);
            return visualizerDataProvider;
        }
        return null;
    }

    public DataProvider getDataProviderFor(DataStorageType dataStorageType, DataModelScheme dataModelScheme) {
        Collection collection = Lookup.getDefault().lookupAll(DataProviderFactory.class);
        for (DataProviderFactory dataProviderFactory : collection) {
            if (!dataProviderFactory.provides(dataModelScheme) || !dataProviderFactory.getSupportedDataStorageTypes().contains(dataStorageType)) continue;
            DataProvider dataProvider = dataProviderFactory.create();
            this.activeVisualizerDataProviders.add((VisualizerDataProvider)dataProvider);
            return dataProvider;
        }
        return null;
    }
}

