/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.impl.DLightToolAccessor;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.management.api.ExecutionContextEvent;
import org.netbeans.modules.dlight.management.api.ExecutionContextListener;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.impl.DataCollectorProvider;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExecutionContext {
    private static final Object lock = new Object();
    private static final Logger log = DLightLogger.getLogger(ExecutionContext.class);
    private final DLightTarget target;
    private final DLightTargetExecutionEnvProviderCollection envProvider;
    private final List<DLightTool> tools;
    private List<ExecutionContextListener> listeners = null;
    private volatile boolean validationInProgress = false;
    private DLightConfiguration dlightConfiguration;

    ExecutionContext(DLightTarget dLightTarget, DLightConfiguration dLightConfiguration) {
        this.target = dLightTarget;
        this.dlightConfiguration = dLightConfiguration;
        this.tools = Collections.unmodifiableList(dLightConfiguration.getToolsSet());
        DataCollectorProvider.getInstance().reset();
        this.envProvider = new DLightTargetExecutionEnvProviderCollection();
    }

    void clear() {
        this.envProvider.clear();
    }

    DLightTarget getTarget() {
        return this.target;
    }

    DLightConfiguration getDLightConfiguration() {
        return this.dlightConfiguration;
    }

    void addDLightTargetExecutionEnviromentProvider(DLightTarget.ExecutionEnvVariablesProvider executionEnvVariablesProvider) {
        this.envProvider.add(executionEnvVariablesProvider);
    }

    DLightTarget.ExecutionEnvVariablesProvider getDLightTargetExecutionEnvProvider() {
        return this.envProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setListeners(List<ExecutionContextListener> list) {
        Object object = lock;
        synchronized (object) {
            this.listeners = list;
        }
    }

    void validateTools() {
        this.validateTools(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateTools(boolean bl) {
        boolean bl2;
        boolean bl3;
        ArrayList arrayList;
        DLightLogger.assertNonUiThread();
        HashMap<Object, Future> hashMap = lock;
        synchronized (hashMap) {
            if (this.validationInProgress) {
                return;
            }
            this.validationInProgress = true;
        }
        hashMap = new HashMap<Object, Future>();
        HashMap<Object, ArrayList<Object>> hashMap2 = new HashMap<Object, ArrayList<Object>>();
        ArrayList<DataCollector> arrayList2 = new ArrayList<DataCollector>();
        if (this.getDLightConfiguration().getConfigurationOptions(false).areCollectorsTurnedOn()) {
            for (DLightTool object22 : this.tools) {
                List list = this.getDLightConfiguration().getConfigurationOptions(false).getCollectors(object22);
                for (Object object : list) {
                    if (arrayList2.contains(object)) continue;
                    arrayList2.add((DataCollector)object);
                }
            }
        }
        ArrayList arrayList3 = new ArrayList();
        for (DLightTool dLightTool : this.tools) {
            arrayList = this.getDLightConfiguration().getConfigurationOptions(false).getIndicatorDataProviders(dLightTool);
            for (IndicatorDataProvider indicatorDataProvider : arrayList) {
                if (arrayList2.contains(indicatorDataProvider) || arrayList3.contains(arrayList3)) continue;
                arrayList3.add(indicatorDataProvider);
            }
        }
        for (final DataCollector dataCollector : arrayList2) {
            arrayList = dataCollector.getValidationStatus();
            hashMap2.put(dataCollector, arrayList);
            hashMap.put(dataCollector, DLightExecutorService.submit((Callable)new Callable<ValidationStatus>(){

                @Override
                public ValidationStatus call() throws Exception {
                    return dataCollector.validate((Object)ExecutionContext.this.target);
                }
            }, (String)("Data Collector " + dataCollector.getName() + " validation")));
        }
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            final IndicatorDataProvider indicatorDataProvider = (IndicatorDataProvider)iterator.next();
            arrayList = indicatorDataProvider.getValidationStatus();
            hashMap2.put(indicatorDataProvider, arrayList);
            hashMap.put(indicatorDataProvider, DLightExecutorService.submit((Callable)new Callable<ValidationStatus>(){

                @Override
                public ValidationStatus call() throws Exception {
                    return indicatorDataProvider.validate((Object)ExecutionContext.this.target);
                }
            }, (String)("Indicator Data Provider " + indicatorDataProvider.getName() + " validation")));
        }
        boolean bl4 = false;
        boolean bl5 = true;
        while (bl3) {
            arrayList = new ArrayList(hashMap.keySet());
            bl3 = false;
            for (IndicatorDataProvider indicatorDataProvider : arrayList) {
                Future future = (Future)hashMap.get(indicatorDataProvider);
                try {
                    boolean bl6;
                    ValidationStatus validationStatus = (ValidationStatus)future.get();
                    boolean bl7 = bl6 = !validationStatus.equals(hashMap2.get(indicatorDataProvider));
                    if (bl) {
                        if (!validationStatus.isKnown()) {
                            Collection collection = validationStatus.getRequiredActions();
                            if (collection != null) {
                                for (AsynchronousAction asynchronousAction : collection) {
                                    try {
                                        asynchronousAction.invoke();
                                    }
                                    catch (Exception exception) {
                                        Exceptions.printStackTrace((Throwable)exception);
                                    }
                                }
                            }
                            boolean bl8 = bl6 = !(validationStatus = (ValidationStatus)(future = DLightExecutorService.submit((Callable)new Callable<ValidationStatus>((Validateable)indicatorDataProvider){
                                final /* synthetic */ Validateable val$validatable;
                                {
                                    this.val$validatable = validateable;
                                }

                                @Override
                                public ValidationStatus call() throws Exception {
                                    return this.val$validatable.validate((Object)ExecutionContext.this.target);
                                }
                            }, (String)(indicatorDataProvider + " validation"))).get()).equals(hashMap2.get(indicatorDataProvider));
                        }
                        if (!validationStatus.isKnown() && bl6) {
                            hashMap2.put(indicatorDataProvider, (ArrayList<Object>)validationStatus);
                            hashMap.put(indicatorDataProvider, future);
                            bl3 = true;
                        } else {
                            hashMap.remove(indicatorDataProvider);
                            hashMap2.remove(indicatorDataProvider);
                        }
                    }
                    if (bl2 || !bl6) continue;
                    bl2 = true;
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    Exceptions.printStackTrace((Throwable)executionException);
                }
            }
        }
        if (bl2) {
            this.notifyListeners(new ExecutionContextEvent(this, ExecutionContextEvent.Type.TOOLS_CHANGED_EVENT, this));
        }
        this.validationInProgress = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(ExecutionContextEvent executionContextEvent) {
        ExecutionContextListener[] executionContextListenerArray = null;
        ExecutionContextListener[] executionContextListenerArray2 = lock;
        synchronized (lock) {
            if (this.listeners == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            executionContextListenerArray = this.listeners.toArray(new ExecutionContextListener[0]);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (ExecutionContextListener executionContextListener : executionContextListenerArray) {
                executionContextListener.contextChanged(executionContextEvent);
            }
            return;
        }
    }

    List<Indicator> getIndicators() {
        ArrayList<Indicator> arrayList = new ArrayList<Indicator>();
        Collection collection = this.getDLightConfiguration().getConfigurationOptions(false).getActiveToolNames();
        for (DLightTool dLightTool : this.tools) {
            if (collection != null && !collection.contains(dLightTool.getName())) continue;
            arrayList.addAll(DLightToolAccessor.getDefault().getIndicators(dLightTool));
        }
        return arrayList;
    }

    DLightTool getToolByName(String string) {
        Collection collection = this.getDLightConfiguration().getConfigurationOptions(false).getActiveToolNames();
        for (DLightTool dLightTool : this.tools) {
            if (collection != null && (!collection.contains(dLightTool.getName()) || !dLightTool.getName().equals(string))) continue;
            return dLightTool;
        }
        return null;
    }

    List<DLightTool> getTools() {
        ArrayList<DLightTool> arrayList = new ArrayList<DLightTool>();
        Collection collection = this.getDLightConfiguration().getConfigurationOptions(false).getActiveToolNames();
        for (DLightTool dLightTool : this.tools) {
            if (collection != null && !collection.contains(dLightTool.getName())) continue;
            arrayList.add(dLightTool);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class DLightTargetExecutionEnvProviderCollection
    implements DLightTarget.ExecutionEnvVariablesProvider {
        private List<DLightTarget.ExecutionEnvVariablesProvider> providers = new ArrayList<DLightTarget.ExecutionEnvVariablesProvider>();

        DLightTargetExecutionEnvProviderCollection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            DLightTargetExecutionEnvProviderCollection dLightTargetExecutionEnvProviderCollection = this;
            synchronized (dLightTargetExecutionEnvProviderCollection) {
                this.providers.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(DLightTarget.ExecutionEnvVariablesProvider executionEnvVariablesProvider) {
            DLightTargetExecutionEnvProviderCollection dLightTargetExecutionEnvProviderCollection = this;
            synchronized (dLightTargetExecutionEnvProviderCollection) {
                this.providers.add(executionEnvVariablesProvider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, String> getExecutionEnv(DLightTarget dLightTarget) throws ConnectException {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            DLightTarget.ExecutionEnvVariablesProvider[] executionEnvVariablesProviderArray = null;
            DLightTarget.ExecutionEnvVariablesProvider[] executionEnvVariablesProviderArray2 = this;
            synchronized (this) {
                executionEnvVariablesProviderArray = this.providers.toArray(new DLightTarget.ExecutionEnvVariablesProvider[0]);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                for (DLightTarget.ExecutionEnvVariablesProvider executionEnvVariablesProvider : executionEnvVariablesProviderArray) {
                    hashMap.putAll(executionEnvVariablesProvider.getExecutionEnv(dLightTarget));
                }
                return hashMap;
            }
        }
    }
}

