/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.execution.DLightSessionContext;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.DLightTargetListener;
import org.netbeans.modules.dlight.api.execution.SubstitutableTarget;
import org.netbeans.modules.dlight.api.impl.DLightSessionContextAccessor;
import org.netbeans.modules.dlight.api.impl.DLightSessionInternalReference;
import org.netbeans.modules.dlight.api.impl.DLightTargetAccessor;
import org.netbeans.modules.dlight.api.impl.DLightToolAccessor;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.management.api.ExecutionContext;
import org.netbeans.modules.dlight.management.api.ExecutionContextListener;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.management.api.impl.DataFiltersManager;
import org.netbeans.modules.dlight.management.api.impl.DataStorageManager;
import org.netbeans.modules.dlight.management.api.impl.SessionDataFiltersSupport;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.impl.IndicatorAccessor;
import org.netbeans.modules.dlight.spi.impl.IndicatorRepairActionProviderAccessor;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DLightSession
implements DLightTargetListener,
DLightSessionInternalReference {
    private static int sessionCount = 0;
    private static final Logger log = DLightLogger.getLogger(DLightSession.class);
    private List<ExecutionContext> contexts = new ArrayList<ExecutionContext>();
    private List<SessionStateListener> sessionStateListeners = null;
    private List<DataStorage> storages = null;
    private List<ServiceInfoDataStorage> serviceInfoDataStorages = null;
    private List<DataCollector> collectors = null;
    private Map<String, Map<String, Visualizer>> visualizers = null;
    private SessionState state = SessionState.CONFIGURATION;
    private final int sessionID;
    private String description = null;
    private List<ExecutionContextListener> contextListeners;
    private boolean isActive;
    private final DLightSessionContext sessionContext;
    private final String name;
    private boolean closeOnExit = false;
    private final SessionDataFiltersSupport dataFiltersSupport;

    public void targetStateChanged(DLightTargetChangeEvent dLightTargetChangeEvent) {
        switch (dLightTargetChangeEvent.state) {
            case RUNNING: {
                this.targetStarted(dLightTargetChangeEvent.target);
                break;
            }
            case FAILED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case TERMINATED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case DONE: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case STOPPED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
        }
    }

    DLightSession(String string) {
        this.name = string;
        this.sessionID = sessionCount++;
        this.sessionContext = DLightSessionContextAccessor.getDefault().newContext();
        this.dataFiltersSupport = new SessionDataFiltersSupport();
    }

    public DLightSessionContext getSessionContext() {
        return this.sessionContext;
    }

    void cleanVisualizers() {
        if (this.visualizers == null) {
            return;
        }
        this.visualizers.clear();
        this.visualizers = null;
    }

    List<ExecutionContext> getExecutionContexts() {
        return this.contexts;
    }

    void addExecutionContext(ExecutionContext executionContext) {
        this.contexts.add(executionContext);
        executionContext.validateTools();
    }

    void setExecutionContext(ExecutionContext executionContext) {
        this.clearExecutionContext();
        this.addExecutionContext(executionContext);
    }

    void clearExecutionContext() {
        this.assertState(SessionState.CONFIGURATION);
        for (ExecutionContext executionContext : this.contexts) {
            executionContext.clear();
        }
        this.contexts.clear();
    }

    public void addSessionStateListener(SessionStateListener sessionStateListener) {
        if (this.sessionStateListeners == null) {
            this.sessionStateListeners = new ArrayList<SessionStateListener>();
        }
        if (!this.sessionStateListeners.contains(sessionStateListener)) {
            this.sessionStateListeners.add(sessionStateListener);
        }
    }

    public void removeSessionStateListener(SessionStateListener sessionStateListener) {
        if (this.sessionStateListeners == null) {
            return;
        }
        this.sessionStateListeners.remove(sessionStateListener);
    }

    public SessionState getState() {
        return this.state;
    }

    public String getDescription() {
        if (this.description == null) {
            String string = "";
            if (this.contexts.isEmpty()) {
                string = "no targets";
            } else {
                for (ExecutionContext executionContext : this.contexts) {
                    string = string + executionContext.getTarget().toString() + "; ";
                }
            }
            this.description = "Session #" + this.sessionID + " (" + string + ")";
        }
        return this.description;
    }

    public String getDisplayName() {
        return this.name == null ? this.getDescription() : this.name;
    }

    boolean isRunning() {
        return this.state == SessionState.RUNNING;
    }

    boolean hasVisualizer(String string, String string2) {
        if (this.visualizers == null || !this.visualizers.containsKey(string)) {
            return false;
        }
        Map<String, Visualizer> map = this.visualizers.get(string);
        return map.containsKey(string2);
    }

    List<Visualizer> getVisualizers() {
        if (this.visualizers == null) {
            return null;
        }
        ArrayList<Visualizer> arrayList = new ArrayList<Visualizer>();
        for (String string : this.visualizers.keySet()) {
            Map<String, Visualizer> map = this.visualizers.get(string);
            for (String string2 : map.keySet()) {
                arrayList.add(map.get(string2));
            }
        }
        return arrayList;
    }

    Visualizer getVisualizer(String string, String string2) {
        if (this.visualizers == null || !this.visualizers.containsKey(string)) {
            return null;
        }
        Map<String, Visualizer> map = this.visualizers.get(string);
        return map.get(string2);
    }

    Visualizer putVisualizer(String string, String string2, Visualizer visualizer) {
        Map<String, Visualizer> map;
        if (this.visualizers == null) {
            this.visualizers = new HashMap<String, Map<String, Visualizer>>();
        }
        if ((map = this.visualizers.get(string)) == null) {
            map = new HashMap<String, Visualizer>();
            this.visualizers.put(string, map);
        }
        Visualizer visualizer2 = map.put(string2, visualizer);
        return visualizer2;
    }

    public void revalidate() {
        for (ExecutionContext executionContext : this.contexts) {
            executionContext.validateTools();
        }
    }

    void closeOnExit() {
        this.closeOnExit = true;
    }

    synchronized void stop() {
        if (this.state == SessionState.ANALYZE) {
            return;
        }
        this.setState(SessionState.ANALYZE);
        for (ExecutionContext executionContext : this.contexts) {
            final DLightTarget dLightTarget = executionContext.getTarget();
            dLightTarget.removeTargetListener((DLightTargetListener)this);
            DLightExecutorService.submit((Runnable)new Runnable(){

                public void run() {
                    DLightTargetAccessor.getDefault().getDLightTargetExecution(dLightTarget).terminate(dLightTarget);
                }
            }, (String)("Stop DLight session's target " + dLightTarget.toString()));
        }
    }

    void start() {
        Runnable runnable = new Runnable(){

            public void run() {
                ExecutionContext executionContext2;
                DataStorageManager.getInstance().clearActiveStorages(DLightSession.this);
                if (DLightSession.this.storages != null) {
                    DLightSession.this.storages.clear();
                }
                if (DLightSession.this.serviceInfoDataStorages != null) {
                    DLightSession.this.serviceInfoDataStorages.clear();
                }
                if (DLightSession.this.collectors != null) {
                    DLightSession.this.collectors.clear();
                }
                for (ExecutionContext executionContext2 : DLightSession.this.contexts) {
                    DLightSession.this.prepareContext(executionContext2);
                }
                DLightSession.this.setState(SessionState.STARTING);
                boolean bl = false;
                executionContext2 = DLightTargetAccessor.getDefault();
                for (ExecutionContext executionContext3 : DLightSession.this.contexts) {
                    DLightTarget dLightTarget = executionContext3.getTarget();
                    if (!bl) {
                        dLightTarget.addTargetListener((DLightTargetListener)DLightSession.this);
                        bl = true;
                    }
                    DLightTarget.ExecutionEnvVariablesProvider executionEnvVariablesProvider = executionContext3.getDLightTargetExecutionEnvProvider();
                    executionContext2.getDLightTargetExecution(dLightTarget).start(dLightTarget, executionEnvVariablesProvider);
                }
            }
        };
        DLightExecutorService.submit((Runnable)runnable, (String)"DLight session");
    }

    void addDataFilterListener(DataFilterListener dataFilterListener) {
        this.dataFiltersSupport.addDataFilterListener(dataFilterListener);
    }

    private boolean prepareContext(ExecutionContext executionContext) {
        Object object7;
        Object object22;
        Object object3;
        Object object4;
        Object object5;
        DLightTarget dLightTarget = executionContext.getTarget();
        executionContext.validateTools(executionContext.getDLightConfiguration().getConfigurationOptions(false).validateToolsRequiredUserInteraction());
        ArrayList<DLightTool> arrayList = new ArrayList<DLightTool>();
        StringBuilder stringBuilder = new StringBuilder();
        for (DLightTool object92 : executionContext.getTools()) {
            arrayList.add(object92);
            stringBuilder.append(object92.getName() + ":");
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        DataCollector object10 = null;
        if (this.collectors == null) {
            this.collectors = new ArrayList<DataCollector>();
        }
        if (executionContext.getDLightConfiguration().getConfigurationOptions(false).areCollectorsTurnedOn()) {
            for (DLightTool dLightTool : arrayList) {
                object5 = executionContext.getDLightConfiguration().getConfigurationOptions(false).getCollectors(dLightTool);
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    DataCollector dataCollector = (DataCollector)object4.next();
                    if (this.collectors.contains(dataCollector) || !dataCollector.getValidationStatus().isValid()) continue;
                    this.collectors.add(dataCollector);
                }
            }
        } else {
            this.collectors.clear();
        }
        ArrayList<IndicatorDataProvider> arrayList2 = new ArrayList<IndicatorDataProvider>();
        StringBuilder stringBuilder2 = new StringBuilder();
        object5 = new StringBuilder();
        for (DLightTool dLightTool : arrayList) {
            Object object6;
            ArrayList<Indicator> arrayList3 = new ArrayList<Indicator>();
            object3 = executionContext.getDLightConfiguration().getConfigurationOptions(false).getIndicatorDataProviders(dLightTool);
            if (object3 != null) {
                for (Object object22 : object3) {
                    if (!object22.getValidationStatus().isValid()) continue;
                    if (object22 instanceof DLightTarget.ExecutionEnvVariablesProvider) {
                        executionContext.addDLightTargetExecutionEnviromentProvider((DLightTarget.ExecutionEnvVariablesProvider)object22);
                    }
                    if (object22 instanceof DataCollector) {
                        if (!this.collectors.contains(object22)) {
                            this.collectors.add((DataCollector)object22);
                        }
                        if (object10 == null && !((DataCollector)object22).isAttachable()) {
                            object10 = (DataCollector)object22;
                        }
                    } else {
                        arrayList2.add((IndicatorDataProvider)object22);
                    }
                    stringBuilder2.append(object22.getName() + ":");
                    object6 = DLightToolAccessor.getDefault().getIndicators(dLightTool);
                    Iterator iterator = object6.iterator();
                    while (iterator.hasNext()) {
                        Indicator indicator = (Indicator)iterator.next();
                        dLightTarget.addTargetListener((DLightTargetListener)indicator);
                        boolean bl = object22.subscribe(indicator);
                        if (!bl) continue;
                        if (!arrayList3.contains(indicator)) {
                            arrayList3.add(indicator);
                        }
                        dLightTarget.addTargetListener((DLightTargetListener)object22);
                        log.fine("I have subscribed indicator " + indicator + " to indicatorDataProvider " + object22);
                    }
                }
            }
            object7 = DLightToolAccessor.getDefault().getIndicators(dLightTool);
            object22 = object7.iterator();
            while (object22.hasNext()) {
                object6 = (Indicator)object22.next();
                if (arrayList3.contains(object6)) continue;
                IndicatorAccessor.getDefault().setRepairActionProviderFor((Indicator)object6, IndicatorRepairActionProviderAccessor.getDefault().createNew(executionContext.getDLightConfiguration(), dLightTool, dLightTarget));
            }
        }
        if (this.collectors != null && this.collectors.size() > 0) {
            for (DataCollector dataCollector : this.collectors) {
                ((StringBuilder)object5).append(dataCollector.getName() + ":");
                DataStorage dataStorage = DataStorageManager.getInstance().getDataStorageFor(this, dataCollector);
                if (dataCollector instanceof DLightTarget.ExecutionEnvVariablesProvider) {
                    executionContext.addDLightTargetExecutionEnviromentProvider((DLightTarget.ExecutionEnvVariablesProvider)dataCollector);
                }
                if (dataStorage != null) {
                    if (object10 == null && !dataCollector.isAttachable()) {
                        object10 = dataCollector;
                    }
                    object3 = DLightTargetAccessor.getDefault().getDLightTargetInfo(dLightTarget);
                    object7 = object3.getInfo();
                    for (Object object6 : object7.keySet()) {
                        dataStorage.put((String)object6, (String)object7.get(object6));
                    }
                    dataCollector.init(dataStorage, dLightTarget);
                    this.addDataFilterListener((DataFilterListener)dataCollector);
                    if (dataCollector instanceof IndicatorDataProvider) {
                        object22 = (IndicatorDataProvider)dataCollector;
                        object22.init((ServiceInfoDataStorage)dataStorage);
                    }
                    if (this.storages == null) {
                        this.storages = new ArrayList<DataStorage>();
                    }
                    if (!this.storages.contains(dataStorage)) {
                        this.storages.add(dataStorage);
                    }
                } else {
                    log.severe("Cannot find storage for collector " + dataCollector);
                }
                dLightTarget.addTargetListener((DLightTargetListener)dataCollector);
            }
        } else {
            object4 = DataStorageManager.getInstance().getServiceInfoDataStorage(this);
            DLightTarget.Info info = DLightTargetAccessor.getDefault().getDLightTargetInfo(dLightTarget);
            Map map = info.getInfo();
            for (Object object7 : map.keySet()) {
                object4.put((String)object7, (String)map.get(object7));
            }
            if (this.serviceInfoDataStorages == null) {
                this.serviceInfoDataStorages = new ArrayList<ServiceInfoDataStorage>();
            }
            if (!this.serviceInfoDataStorages.contains(object4)) {
                this.serviceInfoDataStorages.add((ServiceInfoDataStorage)object4);
            }
        }
        object4 = null;
        if (this.storages != null && !this.storages.isEmpty()) {
            for (DataStorage dataStorage : this.storages) {
                dataStorage.put("service.storage.tools", stringBuilder.toString());
                dataStorage.put("service.storage.configuration.name", executionContext.getDLightConfiguration().getConfigurationName());
                dataStorage.put("service.storage.idp.names", stringBuilder2.toString());
                dataStorage.put("service.storage.collector.names", ((StringBuilder)object5).toString());
            }
            object4 = (ServiceInfoDataStorage)this.storages.get(0);
        } else if (this.serviceInfoDataStorages != null && !this.serviceInfoDataStorages.isEmpty()) {
            for (ServiceInfoDataStorage serviceInfoDataStorage : this.serviceInfoDataStorages) {
                serviceInfoDataStorage.put("service.storage.tools", stringBuilder.toString());
                serviceInfoDataStorage.put("service.storage.configuration.name", executionContext.getDLightConfiguration().getConfigurationName());
                serviceInfoDataStorage.put("service.storage.idp.names", stringBuilder2.toString());
                serviceInfoDataStorage.put("service.storage.collector.names", ((StringBuilder)object5).toString());
            }
            object4 = this.serviceInfoDataStorages.get(0);
        }
        if (object4 != null) {
            for (IndicatorDataProvider indicatorDataProvider : arrayList2) {
                indicatorDataProvider.init((ServiceInfoDataStorage)object4);
                this.addDataFilterListener((DataFilterListener)indicatorDataProvider);
            }
        }
        if (object10 != null && dLightTarget instanceof SubstitutableTarget) {
            ((SubstitutableTarget)dLightTarget).substitute(object10.getCmd(), object10.getArgs());
        }
        DLightTarget.Info info = DLightTargetAccessor.getDefault().getDLightTargetInfo(dLightTarget);
        Map map = info.getInfo();
        for (Object object7 : map.keySet()) {
            object22 = DataFiltersManager.getInstance().createFilter((String)object7, (String)map.get(object7));
            if (object22 == null) continue;
            this.dataFiltersSupport.addFilter((DataFilter)object22);
        }
        return true;
    }

    public List<DataStorage> getStorages() {
        return this.storages == null ? Collections.emptyList() : this.storages;
    }

    public List<ServiceInfoDataStorage> getServiceInfoDataStorages() {
        return this.serviceInfoDataStorages == null ? Collections.emptyList() : this.serviceInfoDataStorages;
    }

    void close() {
        this.setState(SessionState.CLOSED);
        if (this.sessionStateListeners != null) {
            this.sessionStateListeners.clear();
            this.sessionStateListeners = null;
        }
        this.dataFiltersSupport.removeAllListeners();
        if (!EventQueue.isDispatchThread()) {
            DataStorageManager.getInstance().closeSession(this);
            this.cleanVisualizers();
        } else {
            DLightExecutorService.submit((Runnable)new Runnable(){

                public void run() {
                    DataStorageManager.getInstance().closeSession(DLightSession.this);
                    DLightSession.this.cleanVisualizers();
                }
            }, (String)("DLight Session " + this.getDisplayName() + " is closing.."));
        }
    }

    private void targetStarted(DLightTarget dLightTarget) {
        this.setState(SessionState.RUNNING);
    }

    private void targetFinished(DLightTarget dLightTarget) {
        this.setState(SessionState.ANALYZE);
        dLightTarget.removeTargetListener((DLightTargetListener)this);
        if (this.closeOnExit) {
            this.close();
        }
    }

    private void setState(SessionState sessionState) {
        SessionState sessionState2 = this.state;
        this.state = sessionState;
        if (this.sessionStateListeners != null) {
            for (SessionStateListener sessionStateListener : this.sessionStateListeners.toArray(new SessionStateListener[0])) {
                sessionStateListener.sessionStateChanged(this, sessionState2, sessionState);
            }
        }
    }

    public void addExecutionContextListener(ExecutionContextListener executionContextListener) {
        if (this.contextListeners == null) {
            this.contextListeners = new ArrayList<ExecutionContextListener>();
        }
        if (!this.contextListeners.contains(executionContextListener)) {
            this.contextListeners.add(executionContextListener);
        }
        this.updateContextListeners();
    }

    public void removeExecutionContextListener(ExecutionContextListener executionContextListener) {
        if (this.contextListeners == null) {
            return;
        }
        this.contextListeners.remove(executionContextListener);
        this.updateContextListeners();
    }

    private void updateContextListeners() {
        for (ExecutionContext executionContext : this.contexts) {
            executionContext.setListeners(this.contextListeners);
        }
    }

    public List<DLightTool> getTools() {
        ArrayList<DLightTool> arrayList = new ArrayList<DLightTool>();
        for (ExecutionContext executionContext : this.contexts) {
            arrayList.addAll(executionContext.getTools());
        }
        return arrayList;
    }

    DLightTool getToolByName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot use NULL as a tool name ");
        }
        for (ExecutionContext executionContext : this.contexts) {
            DLightTool dLightTool = executionContext.getToolByName(string);
            if (dLightTool == null) continue;
            return dLightTool;
        }
        return null;
    }

    public List<Indicator> getIndicators() {
        ArrayList<Indicator> arrayList = new ArrayList<Indicator>();
        for (ExecutionContext executionContext : this.contexts) {
            arrayList.addAll(executionContext.getIndicators());
        }
        return arrayList;
    }

    boolean containsIndicator(Indicator indicator) {
        return this.getIndicators().contains(indicator);
    }

    private void assertState(SessionState sessionState) {
        if (this.state != sessionState) {
            throw new IllegalStateException("Session is in illegal state " + (Object)((Object)this.state) + "; Must be in " + (Object)((Object)sessionState));
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    void setActive(boolean bl) {
        this.isActive = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SessionState {
        CONFIGURATION,
        STARTING,
        RUNNING,
        PAUSED,
        ANALYZE,
        CLOSED;

    }
}

