/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectapi;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.projectapi.MetaLookupMerger;
import org.netbeans.spi.project.LookupMerger;
import org.netbeans.spi.project.LookupProvider;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyLookupProviders {
    private LazyLookupProviders() {
    }

    public static LookupProvider forProjectServiceProvider(final Map<String, Object> map) throws ClassNotFoundException {
        return new LookupProvider(){

            public Lookup createAdditionalLookup(final Lookup lookup) {
                return new ProxyLookup(){
                    Collection<String> serviceNames;
                    {
                        this.serviceNames = Arrays.asList(((String)map.get("service")).split(","));
                    }

                    protected void beforeLookup(Lookup.Template<?> template) {
                        if (this.serviceNames != null && this.serviceNames.contains(template.getType().getName())) {
                            Class clazz = template.getType();
                            try {
                                Object object = LazyLookupProviders.loadPSPInstance((String)map.get("class"), (String)map.get("method"), lookup);
                                if (!clazz.isInstance(object)) {
                                    throw new ClassCastException("Instance of " + object.getClass() + " unassignable to " + clazz);
                                }
                                this.setLookups(new Lookup[]{Lookups.singleton((Object)object)});
                                this.serviceNames = null;
                            }
                            catch (Exception exception) {
                                Exceptions.attachMessage((Throwable)exception, (String)("while loading from " + map));
                                Exceptions.printStackTrace((Throwable)exception);
                            }
                        }
                    }
                };
            }
        };
    }

    private static Object loadPSPInstance(String string, String string2, Lookup lookup) throws Exception {
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
        if (string2 == null) {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                Object[] objectArray = LazyLookupProviders.valuesFor(constructor.getParameterTypes(), lookup);
                if (objectArray == null) continue;
                return constructor.newInstance(objectArray);
            }
        } else {
            for (Method method : clazz.getMethods()) {
                Object[] objectArray;
                if (!method.getName().equals(string2) || (objectArray = LazyLookupProviders.valuesFor(method.getParameterTypes(), lookup)) == null) continue;
                return method.invoke(null, objectArray);
            }
        }
        throw new RuntimeException(string + "." + string2);
    }

    private static Object[] valuesFor(Class[] classArray, Lookup lookup) {
        if (classArray.length > 2) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Class clazz : classArray) {
            if (clazz == Lookup.class) {
                arrayList.add(lookup);
                continue;
            }
            if (clazz == Project.class) {
                Project project = (Project)lookup.lookup(Project.class);
                if (project == null) {
                    throw new IllegalArgumentException("Lookup " + lookup + " did not contain any Project instance");
                }
                arrayList.add(project);
                continue;
            }
            return null;
        }
        return arrayList.toArray();
    }

    public static MetaLookupMerger forLookupMerger(final Map<String, Object> map) throws ClassNotFoundException {
        return new MetaLookupMerger(){
            private LookupMerger<?> delegate;

            @Override
            public boolean canNowMerge(Class<?> clazz) {
                if (this.delegate == null && clazz.getName().equals((String)map.get("service"))) {
                    try {
                        LookupMerger lookupMerger = (LookupMerger)map.get("lookupMergerInstance");
                        if (clazz != lookupMerger.getMergeableClass()) {
                            throw new ClassCastException(clazz + " vs. " + lookupMerger.getMergeableClass());
                        }
                        this.delegate = lookupMerger;
                        return true;
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                }
                return false;
            }

            @Override
            public LookupMerger merger() {
                return this.delegate;
            }
        };
    }
}

