/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project;

import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.projectapi.AuxiliaryConfigBasedPreferencesProvider;
import org.netbeans.modules.projectapi.AuxiliaryConfigImpl;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUtils {
    private ProjectUtils() {
    }

    public static ProjectInformation getInformation(Project project) {
        ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        if (projectInformation != null) {
            return projectInformation;
        }
        return new BasicInformation(project);
    }

    public static Sources getSources(Project project) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        if (sources != null) {
            return sources;
        }
        return GenericSources.genericOnly(project);
    }

    public static boolean hasSubprojectCycles(final Project project, final Project project2) {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                return ProjectUtils.visit(new HashSet(), new HashMap(), project, project, project2);
            }
        });
    }

    public static Preferences getPreferences(Project project, Class clazz, boolean bl) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"clazz", (Object)clazz);
        return AuxiliaryConfigBasedPreferencesProvider.getPreferences(project, clazz, bl);
    }

    private static boolean visit(Set<Project> set, Map<Project, Set<? extends Project>> map, Project project, Project project2, Project project3) {
        if (!set.add(project)) {
            return true;
        }
        Set<Project> set2 = map.get(project);
        if (set2 == null) {
            SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
            set2 = subprojectProvider != null ? subprojectProvider.getSubprojects() : Collections.emptySet();
            map.put(project, set2);
        }
        for (Project project4 : set2) {
            if (project3 == project4) {
                project3 = null;
            }
            if (!ProjectUtils.visit(set, map, project4, project2, project3)) continue;
            return true;
        }
        if (project3 != null && project == project2 && ProjectUtils.visit(set, map, project3, project2, project3)) {
            return true;
        }
        assert (set.contains(project));
        set.remove(project);
        return false;
    }

    public static AuxiliaryConfiguration getAuxiliaryConfiguration(Project project) {
        return new AuxiliaryConfigImpl(project);
    }

    private static final class BasicInformation
    implements ProjectInformation {
        private final Project p;

        public BasicInformation(Project project) {
            this.p = project;
        }

        public String getName() {
            try {
                return this.p.getProjectDirectory().getURL().toExternalForm();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return fileStateInvalidException.toString();
            }
        }

        public String getDisplayName() {
            return this.p.getProjectDirectory().getNameExt();
        }

        public Icon getIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/projectapi/resources/empty.gif", (boolean)false);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public Project getProject() {
            return this.p;
        }
    }
}

