/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import java.io.IOException;
import java.io.InputStream;
import sun.net.httpserver.ExchangeImpl;
import sun.net.httpserver.LeftOverInputStream;

class ChunkedInputStream
extends LeftOverInputStream {
    private int remaining;
    private boolean needToReadHeader = true;
    static char CR = (char)13;
    static char LF = (char)10;

    ChunkedInputStream(ExchangeImpl t, InputStream src) {
        super(t, src);
    }

    private int numeric(char[] arr, int nchars) throws IOException {
        assert (arr.length >= nchars);
        int len = 0;
        for (int i = 0; i < nchars; ++i) {
            char c = arr[i];
            int val = 0;
            if (c >= '0' && c <= '9') {
                val = c - 48;
            } else if (c >= 'a' && c <= 'f') {
                val = c - 97 + 10;
            } else if (c >= 'A' && c <= 'F') {
                val = c - 65 + 10;
            } else {
                throw new IOException("invalid chunk length");
            }
            len = len * 16 + val;
        }
        return len;
    }

    private int readChunkHeader() throws IOException {
        char c;
        boolean gotCR = false;
        char[] len_arr = new char[16];
        int len_size = 0;
        boolean end_of_len = false;
        while ((c = (char)this.in.read()) != '\uffffffff') {
            if (len_size == len_arr.length - 1) {
                throw new IOException("invalid chunk header");
            }
            if (gotCR) {
                if (c == LF) {
                    int l = this.numeric(len_arr, len_size);
                    return l;
                }
                gotCR = false;
                if (end_of_len) continue;
                len_arr[len_size++] = c;
                continue;
            }
            if (c == CR) {
                gotCR = true;
                continue;
            }
            if (c == ';') {
                end_of_len = true;
                continue;
            }
            if (end_of_len) continue;
            len_arr[len_size++] = c;
        }
        throw new IOException("end of stream reading chunk header");
    }

    protected int readImpl(byte[] b, int off, int len) throws IOException {
        int n;
        if (this.eof) {
            return -1;
        }
        if (this.needToReadHeader) {
            this.remaining = this.readChunkHeader();
            if (this.remaining == 0) {
                this.eof = true;
                this.consumeCRLF();
                this.t.getServerImpl().requestCompleted(this.t.getConnection());
                return -1;
            }
            this.needToReadHeader = false;
        }
        if (len > this.remaining) {
            len = this.remaining;
        }
        if ((n = this.in.read(b, off, len)) > -1) {
            this.remaining -= n;
        }
        if (this.remaining == 0) {
            this.needToReadHeader = true;
            this.consumeCRLF();
        }
        return n;
    }

    private void consumeCRLF() throws IOException {
        char c = (char)this.in.read();
        if (c != CR) {
            throw new IOException("invalid chunk end");
        }
        c = (char)this.in.read();
        if (c != LF) {
            throw new IOException("invalid chunk end");
        }
    }

    public int available() throws IOException {
        if (this.eof || this.closed) {
            return 0;
        }
        int n = this.in.available();
        return n > this.remaining ? this.remaining : n;
    }

    public boolean isDataBuffered() throws IOException {
        assert (this.eof);
        return this.in.available() > 0;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int l) {
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

