/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.netbeans.modules.kenai.ui.dashboard.ProjectNode;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public abstract class SectionNode
extends TreeListNode
implements PropertyChangeListener {
    private final String displayName;
    private final String propertyName;
    private JLabel lblName;
    private JLabel lblStatus;
    private JLabel lblError;
    private JPanel panel;
    protected final ProjectHandle project;

    public SectionNode(String string, ProjectNode projectNode, String string2) {
        super(true, projectNode);
        this.displayName = string;
        this.propertyName = string2;
        this.project = projectNode.getProject();
        this.project.addPropertyChangeListener(this);
    }

    protected JComponent getComponent(Color color, Color color2, boolean bl, boolean bl2) {
        if (null == this.panel) {
            this.panel = new JPanel(new GridBagLayout());
            this.panel.setOpaque(false);
            this.lblName = new TreeLabel(this.displayName);
            this.lblStatus = this.createProgressLabel(NbBundle.getMessage(SectionNode.class, (String)"LBL_LoadingInProgress"));
            this.lblError = new TreeLabel();
            this.lblStatus.setVisible(false);
            this.lblError.setVisible(false);
            Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/ui/resources/error.png");
            this.lblError.setIcon(new ImageIcon(image));
            this.panel.add((Component)this.lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.lblStatus, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            this.panel.add((Component)this.lblError, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.lblName.setForeground(color);
        if (bl) {
            this.lblStatus.setForeground(color);
        } else {
            this.lblStatus.setForeground(ColorManager.getDefault().getDisabledColor());
        }
        if (bl) {
            this.lblError.setForeground(color);
        } else {
            this.lblError.setForeground(ColorManager.getDefault().getErrorColor());
        }
        return this.panel;
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.propertyName.equals(propertyChangeEvent.getPropertyName())) {
            this.refreshChildren();
        }
    }

    protected void childrenLoadingFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SectionNode.this.lblStatus.setVisible(false);
                SectionNode.this.lblError.setVisible(false);
                SectionNode.this.fireContentChanged();
            }
        });
    }

    protected void childrenLoadingStarted() {
        this.lblStatus.setVisible(true);
        this.lblError.setVisible(false);
        this.fireContentChanged();
    }

    protected void childrenLoadingTimedout() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SectionNode.this.lblError.setText(NbBundle.getMessage(SectionNode.class, (String)"LBL_NotResponding"));
                SectionNode.this.lblError.setVisible(true);
                SectionNode.this.lblStatus.setVisible(false);
                SectionNode.this.fireContentChanged();
            }
        });
    }

    protected void dispose() {
        super.dispose();
        this.project.removePropertyChangeListener(this);
    }
}

