/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.kenai.ui.dashboard.BuildListNode;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.netbeans.modules.kenai.ui.dashboard.MessagingNode;
import org.netbeans.modules.kenai.ui.dashboard.QueryListNode;
import org.netbeans.modules.kenai.ui.dashboard.SourceListNode;
import org.netbeans.modules.kenai.ui.spi.BuildAccessor;
import org.netbeans.modules.kenai.ui.spi.MessagingAccessor;
import org.netbeans.modules.kenai.ui.spi.ProjectAccessor;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.QueryAccessor;
import org.netbeans.modules.kenai.ui.spi.SourceAccessor;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectNode
extends TreeListNode {
    private final ProjectHandle project;
    private final ProjectAccessor accessor;
    private JPanel component = null;
    private JLabel lbl = null;
    private LinkButton btnDetails = null;
    private boolean isMemberProject = false;
    private final Font regFont;
    private final Font boldFont;
    private final Object LOCK = new Object();
    private final PropertyChangeListener projectListener;

    public ProjectNode(final ProjectHandle projectHandle) {
        super(true, null);
        if (projectHandle == null) {
            throw new IllegalArgumentException("project cannot be null");
        }
        this.projectListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("content".equals(propertyChangeEvent.getPropertyName())) {
                    ProjectNode.this.refreshChildren();
                    if (null != ProjectNode.this.lbl) {
                        ProjectNode.this.lbl.setText(projectHandle.getDisplayName());
                    }
                }
            }
        };
        this.project = projectHandle;
        this.project.addPropertyChangeListener(this.projectListener);
        this.accessor = ProjectAccessor.getDefault();
        this.regFont = new TreeLabel().getFont();
        this.boldFont = this.regFont.deriveFont(1);
    }

    ProjectHandle getProject() {
        return this.project;
    }

    ProjectAccessor getAccessor() {
        return this.accessor;
    }

    @Override
    protected List<TreeListNode> createChildren() {
        BuildAccessor buildAccessor;
        ArrayList<TreeListNode> arrayList = new ArrayList<TreeListNode>();
        if (null != MessagingAccessor.getDefault()) {
            arrayList.add(new MessagingNode((TreeListNode)this, this.project));
        }
        if ((buildAccessor = BuildAccessor.getDefault()).isEnabled(this.project)) {
            arrayList.add(new BuildListNode(this, buildAccessor));
        }
        if (null != QueryAccessor.getDefault()) {
            arrayList.add(new QueryListNode(this));
        }
        if (null != SourceAccessor.getDefault()) {
            arrayList.add(new SourceListNode(this));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JComponent getComponent(Color color, Color color2, boolean bl, boolean bl2) {
        Object object = this.LOCK;
        synchronized (object) {
            if (null == this.component) {
                this.component = new JPanel(new GridBagLayout());
                this.component.setOpaque(false);
                this.lbl = new TreeLabel(this.project.getDisplayName());
                this.component.add((Component)this.lbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
                this.component.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.btnDetails = new LinkButton(NbBundle.getMessage(ProjectNode.class, (String)"LBL_ProjectDetails"), this.accessor.getDetailsAction(this.project));
                this.component.add((Component)this.btnDetails, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 0, 0), 0, 0));
            }
            this.lbl.setForeground(color);
            this.lbl.setFont(this.isMemberProject ? this.boldFont : this.regFont);
            this.btnDetails.setForeground(color, bl);
            return this.component;
        }
    }

    @Override
    public ActionListener getDefaultAction() {
        return this.accessor.getDefaultAction(this.project);
    }

    @Override
    public Action[] getPopupActions() {
        return this.accessor.getPopupActions(this.project);
    }

    void setMemberProject(boolean bl) {
        if (bl == this.isMemberProject) {
            return;
        }
        this.isMemberProject = bl;
        this.fireContentChanged();
        this.refreshChildren();
    }

    @Override
    protected void dispose() {
        super.dispose();
        if (null != this.project) {
            this.project.removePropertyChangeListener(this.projectListener);
        }
    }
}

